/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.Filterable;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMDateTime;

public class LogFilter
implements Filterable,
Serializable {
    public static final int REVERSE = 0;
    public static final int FORWARD = 1;
    private static final String MARKER = "@#@";
    private Vector appNames;
    private int[] category = new int[3];
    private int[] severity = new int[3];
    private Date start_date = null;
    private Date end_date = null;
    private String start_date_str = null;
    private String end_date_str = null;
    private String user = null;
    private String clientHostName = null;
    private String agentHostName = null;
    private String fileName = null;
    private int reverse;

    public LogFilter() {
        this.appNames = new Vector();
        this.category[0] = -1;
        this.category[1] = -1;
        this.category[2] = -1;
        this.severity[0] = -1;
        this.severity[1] = -1;
        this.severity[2] = -1;
        this.start_date_str = null;
        this.end_date_str = null;
        this.user = null;
        this.clientHostName = null;
        this.agentHostName = null;
        this.reverse = 0;
    }

    public LogFilter(String application_name, int categ, int sev, String start_date, String start_time, String end_date, String end_time, String user_name, String clientHostName, String agentHostName, int direction) {
        this.appNames = new Vector();
        if (application_name != null) {
            this.appNames.addElement(application_name);
        }
        this.category[0] = categ;
        this.severity[0] = sev;
        SimpleDateFormat form = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        form.applyPattern("MM/dd/yyyy 'at' hh:mm:ss a");
        SimpleDateFormat form2 = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        form2.applyPattern("MM/dd/yyyy 'at' HH:mm:ss");
        if (start_date != null && start_time != null) {
            this.start_date_str = start_date + " at " + start_time;
            try {
                this.start_date = form.parse(this.start_date_str);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.start_date == null) {
                try {
                    this.start_date = form2.parse(this.start_date_str);
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
        }
        if (end_date != null && end_time != null) {
            this.end_date_str = end_date + " at " + end_time;
            try {
                this.end_date = form.parse(this.end_date_str);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.end_date == null) {
                try {
                    this.end_date = form2.parse(this.end_date_str);
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
        }
        this.user = user_name;
        this.clientHostName = clientHostName;
        this.agentHostName = agentHostName;
        this.reverse = direction;
    }

    public LogFilter(String formattedString) {
        this.category[0] = -1;
        this.category[1] = -1;
        this.category[2] = -1;
        this.severity[0] = -1;
        this.severity[1] = -1;
        this.severity[2] = -1;
        this.start_date_str = null;
        this.end_date_str = null;
        this.user = null;
        this.clientHostName = null;
        this.agentHostName = null;
        this.reverse = 0;
        StringTokenizer tok = new StringTokenizer(formattedString, MARKER);
        int i = 0;
        int j = 0;
        if (formattedString == null) {
            return;
        }
        try {
            long milli;
            i = Integer.parseInt(tok.nextToken());
            for (j = 0; j < i; ++j) {
                this.category[j] = Integer.parseInt(tok.nextToken());
            }
            i = Integer.parseInt(tok.nextToken());
            for (j = 0; j < i; ++j) {
                this.severity[j] = Integer.parseInt(tok.nextToken());
            }
            String tokStr = tok.nextToken();
            if (tokStr.equalsIgnoreCase("dateErr")) {
                this.start_date = null;
            } else {
                milli = Long.parseLong(tokStr);
                this.start_date = new Date(milli);
            }
            tokStr = tok.nextToken();
            if (tokStr.equalsIgnoreCase("dateErr")) {
                this.end_date = null;
            } else {
                milli = Long.parseLong(tokStr);
                this.end_date = new Date(milli);
            }
            this.user = tok.nextToken();
            if (this.user.equalsIgnoreCase("userUnknown")) {
                this.user = null;
            }
            this.clientHostName = tok.nextToken();
            if (this.clientHostName.equalsIgnoreCase("clientUnknown")) {
                this.clientHostName = null;
            }
            this.agentHostName = tok.nextToken();
            if (this.agentHostName.equalsIgnoreCase("agentUnknown")) {
                this.agentHostName = null;
            }
            this.reverse = Integer.parseInt(tok.nextToken());
            this.fileName = tok.nextToken();
            if (this.fileName.equalsIgnoreCase("fileUnknown")) {
                this.fileName = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String flattenFilter() {
        long milli;
        String retStr = "";
        int i = 0;
        boolean j = false;
        retStr = retStr + String.valueOf(this.category.length) + MARKER;
        for (i = 0; i < this.category.length; ++i) {
            retStr = retStr + String.valueOf(this.category[i]) + MARKER;
        }
        retStr = retStr + String.valueOf(this.severity.length) + MARKER;
        for (i = 0; i < this.severity.length; ++i) {
            retStr = retStr + String.valueOf(this.severity[i]) + MARKER;
        }
        if (this.start_date != null) {
            milli = this.start_date.getTime();
            retStr = retStr + String.valueOf(milli);
        } else {
            retStr = retStr + "dateErr";
        }
        retStr = retStr + MARKER;
        if (this.end_date != null) {
            milli = this.end_date.getTime();
            retStr = retStr + String.valueOf(milli);
        } else {
            retStr = retStr + "dateErr";
        }
        retStr = retStr + MARKER;
        retStr = this.user != null ? retStr + this.user : retStr + "userUnknown";
        retStr = retStr + MARKER;
        retStr = this.clientHostName != null ? retStr + this.clientHostName : retStr + "clientUnknown";
        retStr = retStr + MARKER;
        retStr = this.agentHostName != null ? retStr + this.agentHostName : retStr + "agentUnknown";
        retStr = retStr + MARKER;
        retStr = retStr + String.valueOf(this.reverse) + MARKER;
        retStr = retStr + MARKER;
        retStr = this.fileName != null ? retStr + this.fileName : retStr + "fileUnknown";
        return retStr;
    }

    public int[] getCategory() {
        return this.category;
    }

    public int[] getSeverity() {
        return this.severity;
    }

    public String getStartDate() {
        if (this.start_date_str != null) {
            return this.start_date_str;
        }
        return null;
    }

    public String getEndDate() {
        if (this.end_date_str != null) {
            return this.end_date_str;
        }
        return null;
    }

    public String getUser() {
        return this.user;
    }

    public String getclientHostName() {
        return this.clientHostName;
    }

    public String getAgentHostName() {
        return this.agentHostName;
    }

    public int getSortDirection() {
        return this.reverse;
    }

    public void setCategory(int categ1, int categ2, int categ3) {
        this.category[0] = categ1;
        this.category[1] = categ2;
        this.category[2] = categ3;
        this.category = this.makeFirstValid(this.category);
    }

    public void setSeverity(int sev1, int sev2, int sev3) {
        this.severity[0] = sev1;
        this.severity[1] = sev2;
        this.severity[2] = sev3;
        this.severity = this.makeFirstValid(this.severity);
    }

    public void setStartDate(String start_date, String start_time) {
        SimpleDateFormat form = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        SimpleDateFormat form2 = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        form.applyPattern("MM/dd/yyyy 'at' hh:mm:ss a");
        form2.applyPattern("MM/dd/yyyy 'at' HH:mm:ss");
        if (start_date == null || start_date.length() == 0) {
            return;
        }
        if (start_time == null || start_time.length() == 0) {
            start_time = "00:00:00 AM";
        }
        this.start_date_str = start_date + " at " + start_time;
        try {
            this.start_date = form.parse(this.start_date_str);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.start_date == null) {
            try {
                this.start_date = form2.parse(this.start_date_str);
            }
            catch (Exception x) {
                // empty catch block
            }
        }
    }

    public void setEndDate(String end_date, String end_time) {
        SimpleDateFormat form = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        SimpleDateFormat form2 = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        form.applyPattern("MM/dd/yyyy 'at' hh:mm:ss a");
        form2.applyPattern("MM/dd/yyyy 'at' HH:mm:ss");
        if (end_date == null || end_date.length() == 0) {
            return;
        }
        if (end_time == null || end_time.length() == 0) {
            end_time = "11:59:59 PM";
        }
        this.end_date_str = end_date + " at " + end_time;
        try {
            this.end_date = form.parse(this.end_date_str);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.end_date == null) {
            try {
                this.end_date = form2.parse(this.end_date_str);
            }
            catch (Exception x) {
                // empty catch block
            }
        }
    }

    public void setUser(String user_name) {
        if (user_name != null && user_name.length() != 0) {
            this.user = user_name;
        }
    }

    public void setClientHostName(String clientHostName) {
        if (clientHostName != null && clientHostName.length() != 0) {
            this.clientHostName = clientHostName;
        }
    }

    public void setAgentHostName(String agentHostName) {
        if (agentHostName != null && agentHostName.length() != 0) {
            this.agentHostName = agentHostName;
        }
    }

    public void setDirection(int direction) {
        this.reverse = direction;
    }

    public boolean checkConstraints(LogRecord rec) {
        if ((this.category[0] != -1 || this.category[1] != -1 || this.category[2] != -1) && this.category[0] != rec.getCategory() && this.category[1] != rec.getCategory() && this.category[2] != rec.getCategory()) {
            return false;
        }
        if ((this.severity[0] != -1 || this.severity[1] != -1 || this.severity[2] != -1) && this.severity[0] != rec.getSeverity() && this.severity[1] != rec.getSeverity() && this.severity[2] != rec.getSeverity()) {
            return false;
        }
        if (this.start_date != null && this.end_date != null && (this.start_date.after(rec.getDate()) || this.end_date.before(rec.getDate()))) {
            return false;
        }
        if (this.start_date == null && this.end_date != null && this.end_date.before(rec.getDate())) {
            return false;
        }
        if (this.start_date != null && this.end_date == null && this.start_date.after(rec.getDate())) {
            return false;
        }
        if (this.user != null && !this.user.equalsIgnoreCase(rec.getUserName())) {
            return false;
        }
        if (this.clientHostName != null && !this.clientHostName.equalsIgnoreCase(rec.getClientHostName())) {
            return false;
        }
        if (this.agentHostName != null && !this.agentHostName.equalsIgnoreCase(rec.getAgentHostName())) {
            return false;
        }
        return this.fileName == null || this.fileName.equalsIgnoreCase(rec.getFileName());
    }

    public void setFileName(String fName) {
        this.fileName = fName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String createQueryString() {
        int i;
        String query = "select * from Solaris_LogEntry where ";
        if (this.fileName != null) {
            query = query + "( FileName = '" + this.fileName + "' )";
        }
        if (this.category.length > 0 && this.category[0] != -1) {
            query = query + " AND (  category = " + this.category[0];
            for (i = 1; i < this.category.length; ++i) {
                if (this.category[i] == -1) continue;
                query = query + " OR category = " + this.category[i];
            }
            query = query + " )";
        }
        if (this.severity.length > 0 && this.severity[0] != -1) {
            query = query + " AND (  severity =" + this.severity[0];
            for (i = 1; i < this.severity.length; ++i) {
                if (this.severity[i] == -1) continue;
                query = query + " OR severity = " + this.severity[i];
            }
            query = query + " )";
        }
        if (this.start_date != null || this.end_date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS000");
            CIMDateTime cdt = null;
            formatter.setLenient(false);
            try {
                String dateStr;
                if (this.start_date != null) {
                    cdt = new CIMDateTime(this.start_date);
                    dateStr = cdt.toString();
                    query = query + " AND ( RecordDate >= '" + dateStr + "' ) ";
                }
                if (this.end_date != null) {
                    cdt = new CIMDateTime(this.end_date);
                    dateStr = cdt.toString();
                    query = query + " AND ( RecordDate <= '" + dateStr + "' ) ";
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.user != null) {
            query = query + " AND (  UserName = '" + this.user + "' ) ";
        }
        if (this.clientHostName != null) {
            query = query + " AND (  ClientMachineName = '" + this.clientHostName + "' ) ";
        }
        if (this.agentHostName != null) {
            query = query + " AND (  ServerMachineName = '" + this.agentHostName + "' ) ";
        }
        return query;
    }

    private int[] makeFirstValid(int[] arr) {
        if (arr[0] == -1) {
            for (int i = 1; i < arr.length; ++i) {
                if (arr[i] == -1) continue;
                int temp_var = arr[0];
                arr[0] = arr[i];
                arr[i] = temp_var;
                break;
            }
        }
        return arr;
    }
}

