/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.CorruptDataException;
import com.sun.wbem.solarisprovider.logsvc.LabelValuePairs;
import com.sun.wbem.solarisprovider.logsvc.LogRecordHeader;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMException;

public class LogRecord
implements Serializable {
    public static final int CATEGORY_INVALID = -1;
    public static final int APPLICATION_LOG = 0;
    public static final int SECURITY_LOG = 1;
    public static final int SYSTEM_LOG = 2;
    public static final int SEVERITY_INVALID = -1;
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final String HOST_APP_NAME = "LM_HOST_APP_NAME";
    public static final String USER_APP_NAME = "LM_USER_APP_NAME";
    public static final String FSMGR_APP_NAME = "LM_FSMGR_APP_NAME";
    public static final String CIS_APP_NAME = "LM_SYS_APP_NAME";
    public static final String SECURITY_APP_NAME = "LM_SECURITY_APP_NAME";
    public static final String DIRTABLE_APP_NAME = "LM_DIRTABLE_APP_NAME";
    public static final String SERIAL_APP_NAME = "LM_SERIAL_APP_NAME";
    public static final String LOGSVC_APP_NAME = "LM_LOGSVC_APP_NAME";
    public static final String EXM_STR = "EXM_STR";
    private static final String MARKER = "@#@";
    private static final int LABEL_SIZE = 25;
    private LogRecordHeader logHeader;
    private String detailedMesgId = "LM_DETAIL";
    private Vector substArgs;
    private LabelValuePairs data;
    private String logdata = "";
    private boolean was_syslogged = false;
    private String version_str = "";
    private String fileName = "";

    public LogRecord(String appName, int category, int severity, String userName, String clientHostName, String agentHostName, String summaryMesgId, String detailedMesgId, Vector substArgs) {
        String event_id = "";
        if (detailedMesgId != null) {
            this.detailedMesgId = detailedMesgId;
            event_id = this.parseEventId(detailedMesgId);
        } else if (summaryMesgId != null) {
            event_id = this.parseEventId(summaryMesgId);
        }
        this.logHeader = new LogRecordHeader(appName, category, severity, userName, event_id, clientHostName, agentHostName, summaryMesgId);
        this.substArgs = substArgs != null ? substArgs : new Vector();
        this.data = new LabelValuePairs();
    }

    public LogRecord() {
        this.logHeader = new LogRecordHeader();
        this.data = new LabelValuePairs();
        this.substArgs = new Vector();
    }

    public LogRecord(String formattedString, String version) throws CorruptDataException {
        this.version_str = version;
        this.data = new LabelValuePairs();
        this.substArgs = new Vector();
        String event_id = "";
        String app_name = "";
        int categ = -1;
        int sev = -1;
        String user_name = "";
        String host_name = "";
        String server_name = "";
        String summary_mesg_id = "";
        String substr = "";
        Date recDate = null;
        int i = 0;
        int j = 0;
        int k = 0;
        int index = 0;
        if (formattedString == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        i = formattedString.indexOf(MARKER, j);
        app_name = formattedString.substring(j, i);
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        try {
            categ = Integer.parseInt(formattedString.substring(j, i));
        }
        catch (NumberFormatException e) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        try {
            sev = Integer.parseInt(formattedString.substring(j, i));
        }
        catch (NumberFormatException e) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        user_name = formattedString.substring(j, i);
        if (user_name == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        host_name = formattedString.substring(j, i = formattedString.indexOf(MARKER, j));
        if (host_name == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        server_name = formattedString.substring(j, i = formattedString.indexOf(MARKER, j));
        if (server_name == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        String dateStr = formattedString.substring(j, i);
        j = i + MARKER.length();
        if (dateStr == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        long milli = Long.parseLong(dateStr);
        recDate = new Date(milli);
        i = formattedString.indexOf(MARKER, j);
        summary_mesg_id = formattedString.substring(j, i);
        if (summary_mesg_id == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        this.detailedMesgId = formattedString.substring(j, i);
        if (this.detailedMesgId == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        this.logdata = formattedString.substring(j, i);
        if (this.logdata == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        try {
            index = Integer.parseInt(formattedString.substring(j, i));
        }
        catch (NumberFormatException e) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        for (k = 0; k < index; ++k) {
            i = formattedString.indexOf(MARKER, j);
            substr = formattedString.substring(j, i);
            if (substr == null) {
                substr = "  ";
            }
            j = i + MARKER.length();
            this.addSubstArg(substr);
        }
        i = formattedString.indexOf(MARKER, j);
        try {
            index = Integer.parseInt(formattedString.substring(j, i));
        }
        catch (NumberFormatException e) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        for (k = 0; k < index; ++k) {
            i = formattedString.indexOf(MARKER, j);
            substr = formattedString.substring(j, i);
            if (substr == null) {
                substr = "  ";
            }
            j = i + MARKER.length();
            this.data.addLabel(substr);
            i = formattedString.indexOf(MARKER, j);
            substr = formattedString.substring(j, i);
            if (substr == null) {
                substr = "  ";
            }
            j = i + MARKER.length();
            this.data.addValue(substr);
        }
        i = formattedString.indexOf(MARKER, j);
        String syslog_str = formattedString.substring(j, i);
        this.was_syslogged = syslog_str != null && !syslog_str.equalsIgnoreCase("off");
        j = i + MARKER.length();
        if (this.detailedMesgId != null && this.detailedMesgId.compareTo("LM_DETAIL") != 0) {
            event_id = this.parseEventId(this.detailedMesgId);
        } else if (summary_mesg_id != null) {
            event_id = this.parseEventId(summary_mesg_id);
        }
        this.logHeader = new LogRecordHeader(app_name, categ, sev, user_name, event_id, host_name, server_name, summary_mesg_id);
        this.logHeader.setDate(recDate);
    }

    public void setBasicLogInfo(String appName, int category, int severity, String userName, String clientHostName, String agentHostName, String summaryMesgId) {
        String event_id = "";
        if (summaryMesgId != null || summaryMesgId.length() > 0 || this.detailedMesgId.length() == 0) {
            event_id = this.parseEventId(summaryMesgId);
        }
        this.logHeader.setBasicInfo(appName, category, severity, event_id, userName, clientHostName, agentHostName, summaryMesgId);
    }

    public void setDetailedMesgId(String detailedMesgId) {
        if (detailedMesgId != null || detailedMesgId.length() > 0) {
            this.detailedMesgId = detailedMesgId;
            this.logHeader.setEventId(this.parseEventId(detailedMesgId));
        }
    }

    public void setSubstArgs(Vector substArgs) {
        if (substArgs != null) {
            this.substArgs = substArgs;
        }
    }

    public String[] getSubstArgs() {
        String[] args = null;
        if (this.substArgs != null) {
            args = new String[this.substArgs.size()];
            for (int i = 0; i < this.substArgs.size(); ++i) {
                args[i] = (String)this.substArgs.elementAt(i);
            }
        }
        return args;
    }

    public void setData(Vector labels, Vector values) {
        if (labels != null) {
            this.data = new LabelValuePairs(labels, values);
        }
    }

    public void setCategory(int category) {
        this.logHeader.setCategory(category);
    }

    public void setSeverity(int severity) {
        this.logHeader.setSeverity(severity);
    }

    public void setUserName(String userName) {
        if (userName != null) {
            // empty if block
        }
        this.logHeader.setUserName(userName);
    }

    public void setAppName(String appName) {
        if (appName != null) {
            this.logHeader.setAppName(appName);
        }
    }

    public void setClientHostName(String clientHostName) {
        if (clientHostName != null) {
            this.logHeader.setClientHostName(clientHostName);
        }
    }

    public void setAgentHostName(String agentHostName) {
        if (agentHostName != null) {
            this.logHeader.setAgentHostName(agentHostName);
        }
    }

    public void setSummaryMesgId(String summaryMesgId) {
        if (summaryMesgId != null) {
            this.logHeader.setSummaryMesgId(summaryMesgId);
        }
    }

    public void setRecordId(long recordId) {
        this.logHeader.setRecordId(recordId);
    }

    public long getRecordId() {
        return this.logHeader.getRecordId();
    }

    public void setHashCode(int hash) {
        this.logHeader.setHashCode(hash);
    }

    public long getHashCode() {
        return this.logHeader.getHashCode();
    }

    public void addSubstArg(String arg1) {
        if (arg1 == null) {
            return;
        }
        this.substArgs.addElement(arg1);
    }

    public void addSubstArg(String arg1, String arg2) {
        if (arg1 == null) {
            return;
        }
        this.substArgs.addElement(arg1);
        if (arg2 == null) {
            return;
        }
        this.substArgs.addElement(arg2);
    }

    public void addSubstArg(String arg1, String arg2, String arg3) {
        if (arg1 == null) {
            return;
        }
        this.substArgs.addElement(arg1);
        if (arg2 == null) {
            return;
        }
        this.substArgs.addElement(arg2);
        if (arg3 == null) {
            return;
        }
        this.substArgs.addElement(arg3);
    }

    public void addSubstArg(String arg1, String arg2, String arg3, String arg4) {
        if (arg1 == null) {
            return;
        }
        this.substArgs.addElement(arg1);
        if (arg2 == null) {
            return;
        }
        this.substArgs.addElement(arg2);
        if (arg3 == null) {
            return;
        }
        this.substArgs.addElement(arg3);
        if (arg4 == null) {
            return;
        }
        this.substArgs.addElement(arg4);
    }

    public void addData(String label, String value) {
        if (label != null) {
            this.data.addLabel(label);
            this.data.addValue(value);
        }
    }

    public void addData(Vector labels, Vector values) {
        if (labels != null) {
            this.data.addLabel(labels);
            this.data.addValue(values);
        }
    }

    public void addExceptionToLog(CIMException ex) {
        String valueStr = "";
        Object[] params = ex.getParams();
        valueStr = valueStr + "DUMMY";
        valueStr = valueStr + "&!$";
        valueStr = valueStr + ex.getID();
        for (int i = 0; i < params.length; ++i) {
            valueStr = valueStr + "&!$";
            valueStr = valueStr + params[i].toString();
        }
        if (valueStr != null) {
            this.addData(EXM_STR, valueStr);
        }
    }

    public int getCategory() {
        return this.logHeader.getCategory();
    }

    public String getCategoryString() {
        return this.logHeader.getCategoryString();
    }

    public int getSeverity() {
        return this.logHeader.getSeverity();
    }

    public String getSeverityString() {
        return this.logHeader.getSeverityString();
    }

    public Date getDate() {
        return this.logHeader.getDate();
    }

    public void setDate(Date dat) {
        this.logHeader.setDate(dat);
    }

    public void setFileName(String fName) {
        this.fileName = fName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDateString() {
        return this.logHeader.getDateString();
    }

    public String getTimeString() {
        return this.logHeader.getTimeString();
    }

    public String getAppName() {
        return this.logHeader.getAppName();
    }

    public String getAppKey() {
        return this.logHeader.getAppKey();
    }

    public String getUserName() {
        return this.logHeader.getUserName();
    }

    public String getEventId() {
        return this.logHeader.getEventId();
    }

    public String getClientHostName() {
        return this.logHeader.getClientHostName();
    }

    public String getAgentHostName() {
        return this.logHeader.getAgentHostName();
    }

    public String getSummaryMesg(boolean locale_flag) {
        return this.logHeader.getSummaryMesg(locale_flag);
    }

    public String getSummaryMesgId() {
        return this.logHeader.getSummaryMesgId();
    }

    public String getDetailedMesgId() {
        return this.detailedMesgId;
    }

    public void addData(String data) {
        this.logdata = data;
    }

    public String getData() {
        String retStr = "";
        String[] data_labels = this.getLabelStrings(true);
        String[] data_values = this.getValueStrings();
        for (int i = 0; i < data_labels.length; ++i) {
            if (data_values[i] == null) {
                data_values[i] = new String(" ");
            }
            retStr = retStr + "      " + data_labels[i] + " " + data_values[i] + "\n";
        }
        retStr = retStr + this.logdata;
        return retStr;
    }

    public void setSyslog(boolean flag) {
        this.was_syslogged = flag;
    }

    public boolean getSyslog() {
        return this.was_syslogged;
    }

    public String getDetailedMesg(boolean locale_flag) {
        Locale loc = locale_flag ? Locale.getDefault() : new Locale("", "");
        return this.getLocalizedMessage(this.detailedMesgId, this.substArgs, loc);
    }

    public String[] getLabelStrings(boolean locale_flag) {
        String[] labelStr = null;
        Vector labels = this.data.getLabels();
        int i = 0;
        int j = 0;
        String temp_str = null;
        Locale loc = locale_flag ? Locale.getDefault() : new Locale("", "");
        if (labels != null) {
            j = labels.size();
            labelStr = new String[j];
            for (i = 0; i < j; ++i) {
                CIMException ex;
                Vector values;
                String exception_str;
                if (((String)labels.elementAt(i)).compareTo(EXM_STR) == 0 && (exception_str = (String)(values = this.data.getValues()).elementAt(i)) != null && (ex = this.parseLogStr(exception_str)) != null) {
                    exception_str = ex.toString();
                    this.data.setValueAt(exception_str, i);
                }
                labelStr[i] = (temp_str = this.getPattern((String)labels.elementAt(i), loc)) == null ? "" : (temp_str.length() > 25 ? temp_str.substring(0, 25) : temp_str);
            }
        }
        return labelStr;
    }

    public CIMException parseLogStr(String logVal) {
        StringTokenizer strtok = null;
        if (logVal != null) {
            strtok = new StringTokenizer(logVal, "&!$", false);
        }
        if (strtok != null) {
            String mesgKey;
            Object[] params = new Object[strtok.countTokens() - 2];
            try {
                String bundle = strtok.nextToken();
                mesgKey = strtok.nextToken();
            }
            catch (NoSuchElementException e) {
                return null;
            }
            CIMException ex = new CIMException(mesgKey);
            int i = 0;
            while (strtok.hasMoreTokens()) {
                try {
                    params[i++] = strtok.nextToken();
                }
                catch (NoSuchElementException e) {
                    ex.setParams(params);
                    return ex;
                }
            }
            if (i > 0) {
                ex.setParams(params);
            }
            return ex;
        }
        return null;
    }

    public String[] getValueStrings() {
        String[] valStr = null;
        Vector values = this.data.getValues();
        boolean i = false;
        if (values != null) {
            valStr = new String[values.size()];
            values.copyInto(valStr);
        }
        return valStr;
    }

    public LogRecordHeader getLogHeader() {
        return this.logHeader;
    }

    public void clearSubstArgs() {
        this.substArgs.removeAllElements();
    }

    public void clearData() {
        this.data.clearData();
    }

    public String toString() {
        String retStr = "";
        int i = 0;
        int j = 0;
        retStr = retStr + this.logHeader.toString() + "\n";
        retStr = retStr + "    Detail:\t " + this.getDetailedMesg(true) + "\n";
        retStr = retStr + "    Data:\t \n";
        String[] data_labels = this.getLabelStrings(true);
        String[] data_values = this.getValueStrings();
        j = data_labels.length;
        for (i = 0; i < j; ++i) {
            retStr = retStr + "      " + data_labels[i] + " " + data_values[i] + "\n";
        }
        retStr = retStr + "\t " + this.getData() + "\n\n";
        return retStr;
    }

    public String formatRecord() {
        int i = 0;
        boolean j = false;
        Date recDate = this.getDate();
        long milli = recDate.getTime();
        String retStr = this.logHeader.getAppKey() + MARKER + String.valueOf(this.logHeader.getCategory()) + MARKER + String.valueOf(this.logHeader.getSeverity()) + MARKER + this.logHeader.getUserName() + MARKER + this.logHeader.getClientHostName() + MARKER + this.logHeader.getAgentHostName() + MARKER + String.valueOf(milli) + MARKER + this.logHeader.getSummaryMesgId() + MARKER + this.detailedMesgId + MARKER + this.logdata + MARKER + String.valueOf(this.substArgs.size()) + MARKER;
        for (i = 0; i < this.substArgs.size(); ++i) {
            retStr = retStr + (String)this.substArgs.elementAt(i) + MARKER;
        }
        Vector labels = this.data.getLabels();
        Vector values = this.data.getValues();
        retStr = retStr + String.valueOf(labels.size()) + MARKER;
        for (i = 0; i < labels.size(); ++i) {
            retStr = retStr + (String)labels.elementAt(i) + MARKER + (String)values.elementAt(i) + MARKER;
        }
        retStr = this.was_syslogged ? retStr + "on@#@" : retStr + "off@#@";
        return retStr;
    }

    public String getMessage(String key, String[] substArgs) {
        Locale loc = new Locale("", "");
        return this.getLocalizedMessage(key, substArgs, loc);
    }

    public String getLocalizedMessage(String key, String[] substArgs) {
        Locale loc = Locale.getDefault();
        return this.getLocalizedMessage(key, substArgs, loc);
    }

    public String getLocalizedMessage(String key, String[] substArgs, Locale loc) {
        boolean i = false;
        String retStr = key;
        if (substArgs == null) {
            return retStr;
        }
        try {
            retStr = MessageFormat.format(this.getPattern(retStr, loc), substArgs);
        }
        catch (Exception x) {
            // empty catch block
        }
        return retStr;
    }

    private String getLocalizedMessage(String key, Vector substArgs, Locale loc) {
        boolean i = false;
        String retStr = key;
        Object[] oargs = null;
        if (substArgs == null) {
            return retStr;
        }
        oargs = new Object[substArgs.size()];
        substArgs.copyInto(oargs);
        try {
            retStr = MessageFormat.format(this.getPattern(retStr, loc), oargs);
        }
        catch (Exception x) {
            // empty catch block
        }
        return retStr;
    }

    private String getPattern(String key, Locale loc) {
        PropertyResourceBundle prb = null;
        String ptrn = null;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String str1 = this.getBundleName();
        try {
            prb = (PropertyResourceBundle)ResourceBundle.getBundle(str1, loc);
            ptrn = prb.getString(key);
        }
        catch (Exception x) {
            ptrn = key;
        }
        return ptrn;
    }

    private String parseEventId(String key) {
        String retStr = "";
        if (key == null) {
            return null;
        }
        if (key.length() == 0) {
            return "";
        }
        int last_index = key.lastIndexOf(95);
        try {
            retStr = key.substring(last_index + 1);
        }
        catch (Exception x) {
            // empty catch block
        }
        return retStr;
    }

    protected String getBundleName() {
        return "com.sun.wbem.utility.log.LogMessages";
    }
}

