/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.CorruptDataException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

class LogRecordHeader
implements Serializable {
    private static final String MARKER = "@#@";
    private int category = -1;
    private int severity = -1;
    private Date date = null;
    private String appName = "";
    private String eventId = "";
    private String userName = "";
    private String clientHostName = "";
    private String agentHostName = "";
    private String summaryMesgId = "";
    private long recordId = -1L;
    private int hashCode = -1;

    public LogRecordHeader(String appName, int category, int severity, String userName, String eventId, String clientHostName, String agentHostName, String summaryMesgId) {
        this.category = category;
        this.severity = severity;
        this.date = new Date();
        if (appName != null) {
            this.appName = appName;
        }
        if (eventId != null) {
            this.eventId = eventId;
        }
        if (userName != null) {
            this.userName = userName;
        }
        if (clientHostName != null) {
            this.clientHostName = clientHostName;
        }
        if (agentHostName != null) {
            this.agentHostName = agentHostName;
        }
        if (summaryMesgId != null) {
            this.summaryMesgId = summaryMesgId;
        }
    }

    public LogRecordHeader(String formattedString) throws CorruptDataException {
        String substr = "";
        Object recDate = null;
        int i = 0;
        int j = 0;
        boolean k = false;
        boolean index = false;
        if (formattedString == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        i = formattedString.indexOf(MARKER, j);
        this.appName = formattedString.substring(j, i);
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        try {
            this.category = Integer.parseInt(formattedString.substring(j, i));
        }
        catch (NumberFormatException e) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        try {
            this.severity = Integer.parseInt(formattedString.substring(j, i));
        }
        catch (NumberFormatException e) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        this.userName = formattedString.substring(j, i);
        if (this.userName == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        this.clientHostName = formattedString.substring(j, i);
        if (this.clientHostName == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        this.agentHostName = formattedString.substring(j, i);
        if (this.agentHostName == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        String dateStr = formattedString.substring(j, i);
        j = i + MARKER.length();
        if (dateStr == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        long milli = Long.parseLong(dateStr);
        this.date = new Date(milli);
        i = formattedString.indexOf(MARKER, j);
        this.summaryMesgId = formattedString.substring(j, i);
        if (this.summaryMesgId == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        this.eventId = formattedString.substring(j, i);
        if (this.eventId == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        try {
            this.recordId = Long.parseLong(formattedString.substring(j, i));
        }
        catch (NumberFormatException e) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
        i = formattedString.indexOf(MARKER, j);
        try {
            this.hashCode = Integer.parseInt(formattedString.substring(j, i));
        }
        catch (NumberFormatException e) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        j = i + MARKER.length();
    }

    public LogRecordHeader() {
        this.date = new Date();
    }

    protected void setBasicInfo(String appName, int category, int severity, String eventId, String userName, String clientHostName, String agentHostName, String summaryMesgId) {
        this.category = category;
        this.severity = severity;
        this.date = new Date();
        if (appName != null) {
            this.appName = appName;
        }
        if (eventId != null) {
            this.eventId = eventId;
        }
        if (userName != null) {
            this.userName = userName;
        }
        if (clientHostName != null) {
            this.clientHostName = clientHostName;
        }
        if (agentHostName != null) {
            this.agentHostName = agentHostName;
        }
        if (summaryMesgId != null) {
            this.summaryMesgId = summaryMesgId;
        }
    }

    protected void setCategory(int category) {
        this.category = category;
    }

    protected void setSeverity(int severity) {
        this.severity = severity;
    }

    protected void setEventId(String eventId) {
        if (eventId != null) {
            this.eventId = eventId;
        }
    }

    protected void setUserName(String userName) {
        if (userName != null) {
            this.userName = userName;
        }
    }

    protected void setAppName(String appName) {
        if (appName != null) {
            this.appName = appName;
        }
    }

    protected void setClientHostName(String clientHostName) {
        if (clientHostName != null) {
            this.clientHostName = clientHostName;
        }
    }

    protected void setAgentHostName(String agentHostName) {
        if (agentHostName != null) {
            this.agentHostName = agentHostName;
        }
    }

    protected void setSummaryMesgId(String summaryMesgId) {
        if (summaryMesgId != null) {
            this.summaryMesgId = summaryMesgId;
        }
    }

    protected void setDate(Date recDate) {
        if (recDate != null) {
            this.date = recDate;
        }
    }

    public int getCategory() {
        return this.category;
    }

    public String getCategoryString() {
        String catStr = "N/A";
        switch (this.category) {
            case -1: {
                catStr = LogRecordHeader.getPattern("LM_CAT_INV", null);
                break;
            }
            case 0: {
                catStr = LogRecordHeader.getPattern("LM_CAT_APP", null);
                break;
            }
            case 1: {
                catStr = LogRecordHeader.getPattern("LM_CAT_SEC", null);
                break;
            }
            case 2: {
                catStr = LogRecordHeader.getPattern("LM_CAT_SYS", null);
            }
        }
        return catStr;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getSeverityString() {
        String sevStr = "N/A";
        switch (this.severity) {
            case -1: {
                sevStr = LogRecordHeader.getPattern("LM_SEV_INV", null);
                break;
            }
            case 0: {
                sevStr = LogRecordHeader.getPattern("LM_SEV_INF", null);
                break;
            }
            case 1: {
                sevStr = LogRecordHeader.getPattern("LM_SEV_WAR", null);
                break;
            }
            case 2: {
                sevStr = LogRecordHeader.getPattern("LM_SEV_ERR", null);
            }
        }
        return sevStr;
    }

    public static String getSeverityString(int severity) {
        String sevStr = "N/A";
        switch (severity) {
            case -1: {
                sevStr = LogRecordHeader.getPattern("LM_SEV_INV", null);
                break;
            }
            case 0: {
                sevStr = LogRecordHeader.getPattern("LM_SEV_INF", null);
                break;
            }
            case 1: {
                sevStr = LogRecordHeader.getPattern("LM_SEV_WAR", null);
                break;
            }
            case 2: {
                sevStr = LogRecordHeader.getPattern("LM_SEV_ERR", null);
            }
        }
        return sevStr;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDateString() {
        SimpleDateFormat form = (SimpleDateFormat)DateFormat.getDateInstance(1);
        form.applyPattern("MM/dd/yyyy");
        return form.format(this.date);
    }

    public String getTimeString() {
        return DateFormat.getTimeInstance().format(this.date);
    }

    public String getAppName() {
        return LogRecordHeader.getPattern(this.appName, null);
    }

    public String getAppKey() {
        return this.appName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getClientHostName() {
        return this.clientHostName;
    }

    public String getAgentHostName() {
        return this.agentHostName;
    }

    protected String getSummaryMesgId() {
        return this.summaryMesgId;
    }

    public String getSummaryMesg(boolean locale_flag) {
        String retStr = "";
        Locale loc = locale_flag ? Locale.getDefault() : new Locale("", "");
        retStr = LogRecordHeader.getPattern(this.summaryMesgId, loc);
        if (retStr != null) {
            return retStr;
        }
        return "";
    }

    public void setRecordId(long recordId) {
        this.recordId = recordId;
    }

    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    public long getRecordId() {
        return this.recordId;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public String toString() {
        String retStr = "    Category: " + this.getCategoryString() + "\n";
        retStr = retStr + "    Severity: " + this.getSeverityString() + "\n";
        retStr = retStr + "    EventId:  " + this.eventId + "\n";
        retStr = retStr + "    User:\t " + this.userName + "\n";
        retStr = retStr + "    AppName:  " + LogRecordHeader.getPattern(this.appName, null) + "\n";
        retStr = retStr + "    Date:\t " + this.getDateString() + "\n";
        retStr = retStr + "    Time:\t " + this.getTimeString() + "\n";
        retStr = retStr + "    Client:\t " + this.clientHostName + "\n";
        retStr = retStr + "    Agent:\t " + this.agentHostName + "\n";
        retStr = retStr + "    Message:  " + this.getSummaryMesg(true) + "\n";
        return retStr;
    }

    public String formatHeader() {
        boolean i = false;
        boolean j = false;
        Date recDate = this.getDate();
        long milli = recDate.getTime();
        String retStr = this.getAppKey() + MARKER + String.valueOf(this.getCategory()) + MARKER + String.valueOf(this.getSeverity()) + MARKER + this.getUserName() + MARKER + this.getClientHostName() + MARKER + this.getAgentHostName() + MARKER + String.valueOf(milli) + MARKER + this.getSummaryMesgId() + MARKER + this.getEventId() + MARKER + String.valueOf(this.recordId) + MARKER + String.valueOf(this.hashCode) + MARKER;
        return retStr;
    }

    private static String getPattern(String key, Locale loc) {
        PropertyResourceBundle prb = null;
        String ptrn = null;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String str1 = LogRecordHeader.getBundleName();
        try {
            prb = (PropertyResourceBundle)ResourceBundle.getBundle(str1, loc);
            ptrn = prb.getString(key);
        }
        catch (Exception x) {
            ptrn = key;
        }
        return ptrn;
    }

    protected static String getBundleName() {
        return "com.sun.wbem.utility.log.LogMessages";
    }
}

