/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.cimom.ReadersWriter;
import com.sun.wbem.solarisprovider.common.PropertyUtil;
import com.sun.wbem.solarisprovider.common.PropertyUtilException;
import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.Buffer;
import com.sun.wbem.solarisprovider.logsvc.CorruptDataException;
import com.sun.wbem.solarisprovider.logsvc.DataRecord;
import com.sun.wbem.solarisprovider.logsvc.DataStore;
import com.sun.wbem.solarisprovider.logsvc.FilterThread;
import com.sun.wbem.solarisprovider.logsvc.Filterable;
import com.sun.wbem.solarisprovider.logsvc.InvalidRecordException;
import com.sun.wbem.solarisprovider.logsvc.LogFileNotFoundException;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import com.sun.wbem.solarisprovider.logsvc.LogRecordNotFoundException;
import com.sun.wbem.solarisprovider.logsvc.LogServiceInterface;
import com.sun.wbem.solarisprovider.logsvc.LogSvcNative;
import com.sun.wbem.solarisprovider.logsvc.ReadThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class LogService
implements LogServiceInterface {
    public static final String LOG_SERVICE_FILE_DIR = "wbem.logging.file.dir";
    public static final String LOG_SERVICE_FILE_NAME = "wbem.logging.file.name";
    public static final String LOG_SERVICE_FILE_SIZE = "wbem.logging.file.size";
    public static final String LOG_SERVICE_FILE_NUM = "wbem.logging.file.num";
    public static final String LOG_SERVICE_SYSLOG = "wbem.logging.syslog";
    public static final String LOG_FILE_DIR = "/var/sadm/wbem/log";
    public static final String LOG_FILE_NAME = "wbem_log";
    public static final int LOG_FILE_SIZE = 5;
    public static final int LOG_FILE_NUM = 5;
    public static final String SYSLOG_SWITCH = "on";
    public static final String TYPE_SYSLOG = "Syslog";
    public static final String TYPE_WBEMLOG = "WBEM Log";
    public static final String IDENTITY = "WBEM_Logging_Service";
    public static final String LOGSVC_APPNAME = "Log Viewer";
    public static final int MEG = 0x100000;
    public static final int EIGHT_K = 8192;
    private static final String CONF = "/etc/syslog.conf";
    private static final String DEV = "/dev";
    private static ReadersWriter lock = null;
    private Map logFilesHash = Collections.synchronizedMap(new HashMap());
    private Map syslogFilesHash = Collections.synchronizedMap(new HashMap());
    private DataStore storage;
    private long fileSize = 0L;
    private int numOfLogFiles = 0;
    private String dirName = null;
    private String fileName = null;
    private String logFileName = null;
    private long currentFileSize = 0L;
    private String currentViewerFileName = null;
    private boolean serverSyslogSwitch = true;
    private boolean syslogEx = false;
    private PropertyUtil props = null;
    public static LogService theOnlyService = null;

    public static LogService getInstance() throws AdminLogException {
        if (theOnlyService == null) {
            theOnlyService = new LogService();
        }
        return theOnlyService;
    }

    private LogService() throws AdminLogException {
        String file_size = null;
        String file_num = null;
        String syslog_str = null;
        try {
            this.props = new PropertyUtil("propdir", "WbemServices.properties", 1);
            this.fileName = this.props.getProp(LOG_SERVICE_FILE_NAME);
            this.dirName = this.props.getProp(LOG_SERVICE_FILE_DIR);
            file_size = this.props.getProp(LOG_SERVICE_FILE_SIZE);
            file_num = this.props.getProp(LOG_SERVICE_FILE_NUM);
            syslog_str = this.props.getProp(LOG_SERVICE_SYSLOG);
        }
        catch (PropertyUtilException ex) {
            throw new AdminLogException(ex.getMessage());
        }
        if (this.fileName == null) {
            this.fileName = LOG_FILE_NAME;
        }
        if (this.dirName == null) {
            this.dirName = LOG_FILE_DIR;
        }
        this.fileSize = file_size == null ? 5L : Long.parseLong(file_size);
        this.fileSize *= 0x100000L;
        this.numOfLogFiles = file_num == null ? 5 : Integer.parseInt(file_num);
        if (syslog_str == null) {
            syslog_str = SYSLOG_SWITCH;
        }
        this.serverSyslogSwitch = syslog_str.equalsIgnoreCase(SYSLOG_SWITCH);
        File direct = new File(this.dirName);
        if (!direct.exists() && !direct.mkdirs()) {
            throw new AdminLogException("EXLOG_DIR", this.dirName);
        }
        this.logFileName = this.dirName + File.separator + this.fileName;
        this.initHash();
        this.fillSyslogHash();
        if (lock == null) {
            lock = new ReadersWriter();
        }
    }

    public void writeRecord(LogRecord record, boolean syslogFlag) throws AdminLogException {
        this.writeRecord(record, syslogFlag, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRecord(LogRecord record, boolean syslogFlag, String bundleName) throws AdminLogException {
        try {
            lock.writeLock();
            try {
                this.currentFileSize = this.storage.writeRecord(record.formatRecord(), this.fileSize);
            }
            catch (CorruptDataException ex) {
                File corrupted = new File(this.logFileName);
                try {
                    if (corrupted.exists()) {
                        corrupted.renameTo(new File(this.logFileName + ".corrupted"));
                    }
                    this.storage = new DataStore(this.logFileName);
                }
                catch (Exception e) {
                    throw new AdminLogException("EXLOG_FPM", this.dirName);
                }
                this.initHash();
                throw new AdminLogException("EXLOG_COR", this.logFileName);
            }
            catch (InvalidRecordException x) {
            }
            catch (IOException x) {
                File corrupted = new File(this.logFileName);
                try {
                    if (corrupted.exists()) {
                        corrupted.renameTo(new File(this.logFileName + ".corrupted"));
                    }
                    this.storage = new DataStore(this.logFileName);
                }
                catch (Exception e) {
                    throw new AdminLogException("EXLOG_FPM", this.dirName);
                }
                this.initHash();
                throw new AdminLogException("EXLOG_IO", this.logFileName);
            }
            if (this.currentFileSize < 0L) {
                try {
                    this.synchronizedClearLog(this.currentViewerFileName);
                }
                catch (AdminLogException x) {
                    throw new AdminLogException("EXLOG_WR", this.logFileName);
                }
                try {
                    this.currentFileSize = this.storage.writeRecord(record.formatRecord(), this.fileSize);
                }
                catch (InvalidRecordException x) {
                    throw new AdminLogException("EXLOG_IO", this.logFileName);
                }
                catch (IOException x) {
                    throw new AdminLogException("EXLOG_IO", this.logFileName);
                }
            }
            if (this.currentFileSize == this.fileSize) {
                try {
                    this.synchronizedClearLog(this.currentViewerFileName);
                }
                catch (AdminLogException x) {
                    throw new AdminLogException("EXLOG_WR", this.logFileName);
                }
            }
            if (syslogFlag && this.serverSyslogSwitch) {
                int severity;
                String message = record.getDetailedMesg(true);
                if (message == null) {
                    message = record.getSummaryMesg(true);
                }
                if ((severity = record.getSeverity()) == -1) {
                    severity = 0;
                }
                try {
                    LogSvcNative.writeToSyslog(message, IDENTITY, severity);
                }
                catch (AdminLogException e) {
                    // empty catch block
                }
            }
        }
        finally {
            lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord readRecord(long recordId, int hashCode, String fileName) throws AdminLogException {
        try {
            lock.readLock();
            LogRecord logRecord = this.synchronizedReadRecord(recordId, hashCode, fileName);
            return logRecord;
        }
        finally {
            lock.readUnlock();
        }
    }

    public long getNumRecords(String fileName) throws AdminLogException {
        return this.synchronizedGetNumRecords(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStartDate(String fileName) throws AdminLogException {
        try {
            Vector storage_vector;
            lock.readLock();
            if (fileName == null) {
                fileName = this.currentViewerFileName;
            }
            if ((storage_vector = (Vector)this.logFilesHash.get(fileName)) == null) {
                File syslog_file = (File)this.syslogFilesHash.get(fileName);
                if (syslog_file != null) {
                    long l = -1L;
                    return l;
                }
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            DataStore read_storage = (DataStore)storage_vector.elementAt(1);
            if (read_storage == null) {
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            String temp_file_name = (String)storage_vector.elementAt(0);
            if (temp_file_name == null) {
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            File tester = new File(temp_file_name);
            try {
                if (!tester.exists()) {
                    throw new LogFileNotFoundException("EXLOG_DEL", fileName);
                }
            }
            catch (Exception e) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            long l = read_storage.getFileDate();
            return l;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getList(int numRecords, Filterable log_filter, long recordId, String fileName) throws LogFileNotFoundException, AdminLogException {
        try {
            lock.readLock();
            Vector vector = this.synchronizedGetList(numRecords, log_filter, recordId, fileName);
            return vector;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLog(String fileName) throws AdminLogException {
        if (fileName == null) {
            fileName = this.currentViewerFileName;
        }
        try {
            lock.writeLock();
            this.synchronizedClearLog(fileName);
        }
        finally {
            lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listLogFiles() throws AdminLogException {
        try {
            lock.readLock();
            String[] stringArray = this.synchronizedListLogFiles();
            return stringArray;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentLogFileName() {
        try {
            lock.readLock();
            String string = this.synchronizedGetCurrentLogFileName();
            return string;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumLogFiles() {
        try {
            lock.readLock();
            int n = this.synchronizedGetNumLogFiles();
            return n;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLogFileSize(String fileName) throws AdminLogException {
        try {
            lock.readLock();
            long l = this.synchronizedGetLogFileSize(fileName);
            return l;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSyslogSwitch() {
        try {
            lock.readLock();
            String string = this.synchronizedGetSyslogSwitch();
            return string;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogStorageName() {
        try {
            lock.readLock();
            String string = this.synchronizedGetLogStorageName();
            return string;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogFileDir() {
        try {
            lock.readLock();
            String string = this.synchronizedGetLogFileDir();
            return string;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(int size, int numFiles, String syslogSwitch, String dir) throws AdminLogException {
        try {
            lock.writeLock();
            this.synchronizedSetProperties(size, numFiles, syslogSwitch, dir);
        }
        finally {
            lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listSyslogFiles() throws AdminLogException {
        try {
            lock.readLock();
            this.fillSyslogHash();
            if (this.syslogEx && this.syslogFilesHash.size() == 0) {
                throw new AdminLogException("EXLOG_SYSLOGEX");
            }
            String[] arr = new String[this.syslogFilesHash.size()];
            Set files = this.syslogFilesHash.keySet();
            String[] stringArray = this.syslogFilesHash;
            synchronized (this.syslogFilesHash) {
                files.toArray(arr);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                stringArray = arr;
                return stringArray;
            }
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSyslogRecords(String fileName) throws AdminLogException {
        try {
            lock.readLock();
            this.fillSyslogHash();
            if (this.syslogEx && this.syslogFilesHash.size() == 0) {
                throw new AdminLogException("EXLOG_SYSLOGEX");
            }
            if (fileName != null) {
                File syslogfile = (File)this.syslogFilesHash.get(fileName);
                if (syslogfile == null || !syslogfile.exists()) {
                    throw new AdminLogException("EXLOG_FNF", fileName);
                }
                ArrayList<String> arr = new ArrayList<String>();
                try {
                    FileInputStream fstream = new FileInputStream(syslogfile);
                    InputStreamReader reader = new InputStreamReader(fstream);
                    BufferedReader bufReader = new BufferedReader(reader);
                    while (bufReader.ready()) {
                        String logLine = bufReader.readLine();
                        arr.add(logLine);
                    }
                    fstream.close();
                }
                catch (Exception ex) {
                    throw new AdminLogException(ex.getMessage());
                }
                String[] recordArray = new String[arr.size()];
                arr.toArray(recordArray);
                String[] stringArray = recordArray;
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            lock.readUnlock();
        }
    }

    public int getLogPercentageFull(String fileName) throws AdminLogException {
        try {
            Vector storage_vector;
            lock.readLock();
            if (fileName == null) {
                fileName = this.currentViewerFileName;
            }
            if ((storage_vector = (Vector)this.logFilesHash.get(fileName)) == null) {
                File syslog_file = (File)this.syslogFilesHash.get(fileName);
                if (syslog_file != null) {
                    int n = 0;
                    return n;
                }
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            DataStore read_storage = (DataStore)storage_vector.elementAt(1);
            if (read_storage == null) {
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            try {
                double size = read_storage.getFileSize();
                Double dub = new Double(size / (double)this.fileSize * 100.0);
                int n = dub.intValue();
                return n;
            }
            catch (IOException e) {
                throw new AdminLogException("EXLOG_IO", fileName);
            }
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeOfLastChange(String fileName) throws AdminLogException {
        try {
            Vector storage_vector;
            lock.readLock();
            if (fileName == null) {
                fileName = this.currentViewerFileName;
            }
            if ((storage_vector = (Vector)this.logFilesHash.get(fileName)) == null) {
                File syslog_file = (File)this.syslogFilesHash.get(fileName);
                if (syslog_file != null) {
                    long l = 0L;
                    return l;
                }
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            DataStore read_storage = (DataStore)storage_vector.elementAt(1);
            if (read_storage == null) {
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            long l = read_storage.getTimeOfLastChange();
            return l;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogHeaderFormat(String fileName) throws AdminLogException {
        try {
            Vector storage_vector;
            lock.readLock();
            if (fileName == null) {
                fileName = this.currentViewerFileName;
            }
            if ((storage_vector = (Vector)this.logFilesHash.get(fileName)) == null) {
                File syslog_file = (File)this.syslogFilesHash.get(fileName);
                if (syslog_file != null) {
                    String string = "";
                    return string;
                }
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            DataStore read_storage = (DataStore)storage_vector.elementAt(1);
            if (read_storage == null) {
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            String string = read_storage.getLogHeaderFormat();
            return string;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLogHeaderSize(String fileName) throws AdminLogException {
        try {
            Vector storage_vector;
            lock.readLock();
            if (fileName == null) {
                fileName = this.currentViewerFileName;
            }
            if ((storage_vector = (Vector)this.logFilesHash.get(fileName)) == null) {
                File syslog_file = (File)this.syslogFilesHash.get(fileName);
                if (syslog_file != null) {
                    long l = 0L;
                    return l;
                }
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            DataStore read_storage = (DataStore)storage_vector.elementAt(1);
            if (read_storage == null) {
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            long l = read_storage.getLogHeaderSize();
            return l;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRecordHeaderFormat(String fileName) throws AdminLogException {
        try {
            Vector storage_vector;
            lock.readLock();
            if (fileName == null) {
                fileName = this.currentViewerFileName;
            }
            if ((storage_vector = (Vector)this.logFilesHash.get(fileName)) == null) {
                File syslog_file = (File)this.syslogFilesHash.get(fileName);
                if (syslog_file != null) {
                    String string = null;
                    return string;
                }
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            DataStore read_storage = (DataStore)storage_vector.elementAt(1);
            if (read_storage == null) {
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            String string = read_storage.getRecordHeaderFormat();
            return string;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRecordHeaderSize(String fileName) throws AdminLogException {
        try {
            Vector storage_vector;
            lock.readLock();
            if (fileName == null) {
                fileName = this.currentViewerFileName;
            }
            if ((storage_vector = (Vector)this.logFilesHash.get(fileName)) == null) {
                File syslog_file = (File)this.syslogFilesHash.get(fileName);
                if (syslog_file != null) {
                    long l = 0L;
                    return l;
                }
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            DataStore read_storage = (DataStore)storage_vector.elementAt(1);
            if (read_storage == null) {
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            long l = read_storage.getRecordHeaderSize();
            return l;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogType(String fileName) throws AdminLogException {
        try {
            Vector storage_vector;
            lock.readLock();
            if (fileName == null) {
                fileName = this.currentViewerFileName;
            }
            if ((storage_vector = (Vector)this.logFilesHash.get(fileName)) == null) {
                File syslog_file = (File)this.syslogFilesHash.get(fileName);
                if (syslog_file != null) {
                    if (syslog_file.exists()) {
                        String string = TYPE_SYSLOG;
                        return string;
                    }
                    throw new LogFileNotFoundException("EXLOG_FNF", fileName);
                }
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            DataStore read_storage = (DataStore)storage_vector.elementAt(1);
            if (read_storage == null) {
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            String string = TYPE_WBEMLOG;
            return string;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxLogFileSize(String fileName) throws AdminLogException {
        try {
            Vector storage_vector;
            lock.readLock();
            if (fileName == null) {
                fileName = this.currentViewerFileName;
            }
            if ((storage_vector = (Vector)this.logFilesHash.get(fileName)) == null) {
                File syslog_file = (File)this.syslogFilesHash.get(fileName);
                if (syslog_file != null) {
                    long l = 0L;
                    return l;
                }
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            DataStore read_storage = (DataStore)storage_vector.elementAt(1);
            if (read_storage == null) {
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            long l = this.fileSize;
            return l;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogVersion(String fileName) throws AdminLogException {
        try {
            Vector storage_vector;
            lock.readLock();
            if (fileName == null) {
                fileName = this.currentViewerFileName;
            }
            if ((storage_vector = (Vector)this.logFilesHash.get(fileName)) == null) {
                File syslog_file = (File)this.syslogFilesHash.get(fileName);
                if (syslog_file != null) {
                    if (syslog_file.exists()) {
                        String string = "N/A";
                        return string;
                    }
                    throw new LogFileNotFoundException("EXLOG_FNF", fileName);
                }
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            DataStore read_storage = (DataStore)storage_vector.elementAt(1);
            if (read_storage == null) {
                throw new LogFileNotFoundException("EXLOG_FNF", fileName);
            }
            String string = read_storage.getVersion();
            return string;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogFileName(String dataFile) {
        try {
            lock.readLock();
            if (this.syslogFilesHash.get(dataFile) != null) {
                String string = dataFile;
                return string;
            }
            Set logFiles = this.logFilesHash.entrySet();
            Map map = this.logFilesHash;
            synchronized (map) {
                for (Map.Entry entry : logFiles) {
                    Vector storage = (Vector)entry.getValue();
                    String logfilename = (String)storage.elementAt(0);
                    if (!logfilename.equalsIgnoreCase(dataFile)) continue;
                    String string = (String)entry.getKey();
                    return string;
                }
            }
            map = null;
            return map;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogStorageName(String logFile) {
        try {
            lock.readLock();
            if (this.syslogFilesHash.get(logFile) != null) {
                String string = logFile;
                return string;
            }
            Set logFiles = this.logFilesHash.entrySet();
            Map map = this.logFilesHash;
            synchronized (map) {
                for (Map.Entry entry : logFiles) {
                    String logfilename;
                    String lfile = (String)entry.getKey();
                    if (!lfile.equalsIgnoreCase(logFile)) continue;
                    Vector storage = (Vector)entry.getValue();
                    String string = logfilename = (String)storage.elementAt(0);
                    return string;
                }
            }
            map = null;
            return map;
        }
        finally {
            lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do_cascaded_backup() throws AdminLogException {
        int i = 0;
        boolean j = false;
        Collection c = this.logFilesHash.values();
        Map map = this.logFilesHash;
        synchronized (map) {
            Object[] arr = c.toArray();
            for (i = 0; i < arr.length; ++i) {
                DataStore temp;
                Vector storage_vector = (Vector)arr[i];
                if (storage_vector == null || (temp = (DataStore)storage_vector.elementAt(1)) == null) continue;
                temp.close();
            }
        }
        for (i = this.numOfLogFiles; i > 1; --i) {
            File del = new File(this.logFileName + "." + String.valueOf(i));
            File prev = new File(this.logFileName + "." + String.valueOf(i - 1));
            try {
                if (!prev.exists()) continue;
                prev.renameTo(del);
                continue;
            }
            catch (SecurityException x) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
        }
        File this_file = new File(this.logFileName);
        File next = new File(this.logFileName + ".1");
        try {
            if (this_file.exists()) {
                this_file.renameTo(next);
            }
        }
        catch (SecurityException x) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        this.initHash();
        this.fillSyslogHash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHash() throws AdminLogException {
        Vector<Object> file_storage = new Vector<Object>();
        Map map = this.logFilesHash;
        synchronized (map) {
            this.logFilesHash.clear();
            try {
                this.storage = new DataStore(this.logFileName);
            }
            catch (EOFException x) {
                File corrupted = new File(this.logFileName);
                try {
                    if (corrupted.exists()) {
                        corrupted.renameTo(new File(this.logFileName + ".corrupted"));
                    }
                    this.storage = new DataStore(this.logFileName);
                }
                catch (Exception e) {
                    throw new AdminLogException("EXLOG_FPM", this.dirName);
                }
            }
            catch (IOException e) {
                throw new AdminLogException("EXLOG_IO", this.logFileName);
            }
            long date = this.storage.getFileDate();
            if (date <= 0L) {
                throw new AdminLogException("EXLOG_COR", this.logFileName);
            }
            Date file_date = new Date(date);
            SimpleDateFormat date_form = (SimpleDateFormat)DateFormat.getDateInstance(1);
            date_form.applyPattern("MM/dd/yyyy.HH:mm:ss");
            String date_extension = date_form.format(file_date);
            if (date_extension == null) {
                date_extension = String.valueOf(date);
            }
            file_storage.addElement(this.logFileName);
            file_storage.addElement(this.storage);
            this.currentViewerFileName = "Log." + date_extension;
            this.logFilesHash.put(this.currentViewerFileName, file_storage.clone());
            file_storage.removeAllElements();
            int i = 0;
            DataStore backup = null;
            for (i = 1; i <= this.numOfLogFiles; ++i) {
                File tester = new File(this.logFileName + "." + String.valueOf(i));
                try {
                    if (tester.exists()) {
                        try {
                            backup = new DataStore(this.logFileName + "." + String.valueOf(i));
                        }
                        catch (EOFException e) {
                        }
                        catch (IOException e) {}
                    }
                }
                catch (Exception e) {
                    throw new AdminLogException("EXLOG_FPM", this.dirName);
                }
                if (backup != null) {
                    date = backup.getFileDate();
                    if (date <= 0L) continue;
                    file_date = new Date(date);
                    date_form.applyPattern("MM/dd/yyyy.HH:mm:ss");
                    date_extension = date_form.format(file_date);
                    if (date_extension == null) {
                        date_extension = String.valueOf(date);
                    }
                    file_storage.addElement(this.logFileName + "." + String.valueOf(i));
                    file_storage.addElement(backup);
                    this.logFilesHash.put("Log." + date_extension, file_storage.clone());
                }
                backup = null;
                file_storage.removeAllElements();
            }
        }
    }

    private LogRecord synchronizedReadRecord(long recordId, int hashCode, String fileName) throws AdminLogException {
        if (fileName == null) {
            fileName = this.currentViewerFileName;
        }
        DataRecord rec = null;
        Vector storage_vector = (Vector)this.logFilesHash.get(fileName);
        if (storage_vector == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", fileName);
        }
        DataStore read_storage = (DataStore)storage_vector.elementAt(1);
        if (read_storage == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", fileName);
        }
        String temp_file_name = (String)storage_vector.elementAt(0);
        if (temp_file_name == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", fileName);
        }
        File tester = new File(temp_file_name);
        try {
            if (!tester.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", fileName);
            }
        }
        catch (Exception e) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        try {
            rec = read_storage.readSpecificRecordAsStr(recordId, hashCode);
        }
        catch (CorruptDataException x) {
            String cor_file = read_storage.getFileName();
            File corrupted = new File(cor_file);
            try {
                if (corrupted.exists()) {
                    corrupted.renameTo(new File(read_storage.getFileName() + ".corrupted"));
                }
            }
            catch (Exception e) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            throw new AdminLogException("EXLOG_COR", fileName);
        }
        catch (InvalidRecordException x) {
            throw new LogRecordNotFoundException(x.getMessage());
        }
        catch (EOFException x) {
            String cor_file = read_storage.getFileName();
            File corrupted = new File(cor_file);
            try {
                if (corrupted.exists()) {
                    corrupted.renameTo(new File(read_storage.getFileName() + ".corrupted"));
                }
            }
            catch (Exception e) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            throw new AdminLogException("EXLOG_IO", fileName);
        }
        catch (IOException x) {
            String cor_file = read_storage.getFileName();
            File corrupted = new File(cor_file);
            try {
                if (corrupted.exists()) {
                    corrupted.renameTo(new File(read_storage.getFileName() + ".corrupted"));
                }
            }
            catch (Exception e) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            throw new AdminLogException("EXLOG_IO", fileName);
        }
        if (rec == null) {
            String cor_file = read_storage.getFileName();
            File corrupted = new File(cor_file);
            try {
                if (corrupted.exists()) {
                    corrupted.renameTo(new File(read_storage.getFileName() + ".corrupted"));
                }
            }
            catch (Exception e) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            throw new AdminLogException("EXLOG_COR", fileName);
        }
        LogRecord log_record = (LogRecord)rec.getRecord();
        log_record.setRecordId(rec.getOffset());
        log_record.setHashCode(rec.getHash());
        return log_record;
    }

    private Vector synchronizedGetList(int numRecords, Filterable log_filter, long recordId, String fileName) throws LogFileNotFoundException, AdminLogException {
        Vector storage_vector;
        if (fileName == null) {
            fileName = this.currentViewerFileName;
        }
        if ((storage_vector = (Vector)this.logFilesHash.get(fileName)) == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", fileName);
        }
        DataStore read_storage = (DataStore)storage_vector.elementAt(1);
        if (read_storage == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", fileName);
        }
        String temp_file_name = (String)storage_vector.elementAt(0);
        if (temp_file_name == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", fileName);
        }
        File tester = new File(temp_file_name);
        try {
            if (!tester.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", fileName);
            }
        }
        catch (Exception e) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        Buffer buf = new Buffer();
        FilterThread filterThr = new FilterThread(buf, log_filter, numRecords);
        ReadThread readThr = new ReadThread(buf, recordId, numRecords, log_filter.getSortDirection(), read_storage);
        Thread t1 = new Thread(filterThr);
        Thread t2 = new Thread(readThr);
        t2.start();
        t1.start();
        try {
            t2.join();
            t1.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        AdminLogException x = buf.getException();
        if (x != null && (x instanceof CorruptDataException || x instanceof InvalidRecordException)) {
            String cor_file = read_storage.getFileName();
            File corrupted = new File(cor_file);
            try {
                if (corrupted.exists()) {
                    corrupted.renameTo(new File(read_storage.getFileName() + ".corrupted"));
                }
            }
            catch (Exception e) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            this.fillSyslogHash();
            throw new AdminLogException("EXLOG_COR", fileName);
        }
        return buf.getVect();
    }

    private synchronized long synchronizedGetNumRecords(String fileName) throws AdminLogException {
        Vector storage_vector;
        if (fileName == null) {
            fileName = this.currentViewerFileName;
        }
        if ((storage_vector = (Vector)this.logFilesHash.get(fileName)) == null) {
            File syslog_file = (File)this.syslogFilesHash.get(fileName);
            if (syslog_file != null) {
                try {
                    String[] recs = this.getSyslogRecords(fileName);
                    if (recs != null) {
                        return recs.length;
                    }
                    return 0L;
                }
                catch (Exception except) {
                    return 0L;
                }
            }
            throw new LogFileNotFoundException("EXLOG_FNF", fileName);
        }
        DataStore read_storage = (DataStore)storage_vector.elementAt(1);
        if (read_storage == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", fileName);
        }
        String temp_file_name = (String)storage_vector.elementAt(0);
        if (temp_file_name == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", fileName);
        }
        File tester = new File(temp_file_name);
        try {
            if (!tester.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", fileName);
            }
        }
        catch (Exception e) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        return read_storage.getNumRecords();
    }

    private void synchronizedClearLog(String fileName) throws AdminLogException {
        if (fileName == null) {
            fileName = this.currentViewerFileName;
        }
        if (!this.logFilesHash.containsKey(fileName)) {
            throw new LogFileNotFoundException("EXLOG_FNF", fileName);
        }
        Vector storage_vector = (Vector)this.logFilesHash.get(fileName);
        String actualFile = (String)storage_vector.elementAt(0);
        if (actualFile == null) {
            throw new AdminLogException("EXLOG_ACT", (Object)actualFile, fileName);
        }
        if (actualFile.compareTo(this.logFileName) == 0) {
            this.do_cascaded_backup();
        } else {
            try {
                File del = new File(actualFile);
                if (del.exists()) {
                    storage_vector = (Vector)this.logFilesHash.get(fileName);
                    if (storage_vector == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", fileName);
                    }
                    DataStore read_storage = (DataStore)storage_vector.elementAt(1);
                    if (read_storage != null) {
                        read_storage.close();
                    }
                    this.logFilesHash.remove(fileName);
                    del.delete();
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] synchronizedListLogFiles() {
        String[] files = new String[this.logFilesHash.size()];
        Set c = this.logFilesHash.keySet();
        Map map = this.logFilesHash;
        synchronized (map) {
            Object[] arr = c.toArray();
            for (int i = 0; i < arr.length; ++i) {
                files[i] = (String)arr[i];
            }
        }
        return files;
    }

    private String synchronizedGetCurrentLogFileName() {
        return this.currentViewerFileName;
    }

    private int synchronizedGetNumLogFiles() {
        return this.numOfLogFiles;
    }

    private long synchronizedGetLogFileSize(String logFile) throws AdminLogException {
        Vector storage_vector;
        if (this.fileName == null) {
            this.fileName = this.currentViewerFileName;
        }
        if ((storage_vector = (Vector)this.logFilesHash.get(logFile)) == null) {
            File syslog_file = (File)this.syslogFilesHash.get(logFile);
            if (syslog_file != null) {
                return syslog_file.length();
            }
            throw new LogFileNotFoundException("EXLOG_FNF", logFile);
        }
        DataStore read_storage = (DataStore)storage_vector.elementAt(1);
        if (read_storage == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", logFile);
        }
        try {
            return read_storage.getFileSize();
        }
        catch (IOException e) {
            throw new AdminLogException("EXLOG_IO", logFile);
        }
    }

    private String synchronizedGetSyslogSwitch() {
        if (this.serverSyslogSwitch) {
            return SYSLOG_SWITCH;
        }
        return "off";
    }

    private String synchronizedGetLogStorageName() {
        return this.fileName;
    }

    private String synchronizedGetLogFileDir() {
        return this.dirName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void synchronizedSetProperties(int size, int numFiles, String syslogSwitch, String dir) throws AdminLogException {
        boolean setExcept;
        block28: {
            setExcept = false;
            if (syslogSwitch == null) {
                syslogSwitch = SYSLOG_SWITCH;
            } else if (syslogSwitch.equalsIgnoreCase(SYSLOG_SWITCH)) {
                this.serverSyslogSwitch = true;
            } else if (syslogSwitch.equalsIgnoreCase("off")) {
                this.serverSyslogSwitch = false;
            } else {
                syslogSwitch = SYSLOG_SWITCH;
            }
            if (dir != null) {
                File direct = new File(dir);
                if (!direct.exists() && !direct.mkdirs()) {
                    setExcept = true;
                }
                if (!direct.isDirectory()) {
                    setExcept = true;
                } else {
                    Collection c = this.logFilesHash.values();
                    Map map = this.logFilesHash;
                    synchronized (map) {
                        Object[] arr = c.toArray();
                        for (int i = 0; i < arr.length; ++i) {
                            DataStore temp;
                            Vector storage_vector = (Vector)arr[i];
                            if (storage_vector == null || (temp = (DataStore)storage_vector.elementAt(1)) == null) continue;
                            temp.close();
                        }
                    }
                    for (int i = 1; i <= this.numOfLogFiles; ++i) {
                        String new_dir = dir + File.separator + this.fileName;
                        String old_dir = this.logFileName;
                        File del = new File(new_dir + "." + String.valueOf(i));
                        File prev = new File(old_dir + "." + String.valueOf(i));
                        try {
                            if (!prev.exists() || prev.renameTo(del) || this.do_copy(prev, del)) continue;
                            this.flush_dir(new_dir, i);
                            setExcept = true;
                            continue;
                        }
                        catch (SecurityException x) {
                            throw new AdminLogException("EXLOG_FPM", this.dirName);
                        }
                    }
                    if (!setExcept) {
                        File this_file = new File(this.logFileName);
                        String new_logFileName = dir + File.separator + this.fileName;
                        File next = new File(new_logFileName);
                        try {
                            if (!this_file.exists()) break block28;
                            if (!this_file.renameTo(next)) {
                                if (!this.do_copy(this_file, next)) {
                                    this.flush_dir(new_logFileName, 0);
                                    setExcept = true;
                                    break block28;
                                } else {
                                    this.flush_dir(this.logFileName, -1);
                                    this.logFileName = dir + File.separator + this.fileName;
                                    this.dirName = dir;
                                }
                                break block28;
                            }
                            this.logFileName = dir + File.separator + this.fileName;
                            this.dirName = dir;
                        }
                        catch (SecurityException x) {
                            throw new AdminLogException("EXLOG_FPM", this.dirName);
                        }
                    }
                }
            }
        }
        if (size > 0) {
            this.fileSize = size * 0x100000;
        }
        if (numFiles > 0) {
            this.numOfLogFiles = numFiles;
        }
        if (dir != null) {
            this.initHash();
            this.fillSyslogHash();
        }
        if (setExcept) {
            throw new AdminLogException("EXLOG_PROP_DIR", (Object)this.dirName, dir);
        }
        try {
            this.props.putProp(LOG_SERVICE_FILE_SIZE, String.valueOf(size));
            this.props.putProp(LOG_SERVICE_FILE_NUM, String.valueOf(numFiles));
            this.props.putProp(LOG_SERVICE_FILE_DIR, dir);
            this.props.putProp(LOG_SERVICE_SYSLOG, syslogSwitch);
            this.props.saveProps("Wbem Services properties file");
            return;
        }
        catch (PropertyUtilException ex) {
            throw new AdminLogException(ex.getMessage());
        }
    }

    private boolean do_copy(File old_dir, File new_dir) {
        BufferedInputStream inBuf = null;
        BufferedOutputStream outBuf = null;
        byte[] readArr = new byte[8192];
        try {
            inBuf = new BufferedInputStream(new FileInputStream(old_dir), 8192);
            outBuf = new BufferedOutputStream(new FileOutputStream(new_dir));
        }
        catch (Exception e) {
            return false;
        }
        try {
            int i;
            while ((i = inBuf.read(readArr, 0, 8192)) >= 0) {
                outBuf.write(readArr, 0, i);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void flush_dir(String fileName, int index) {
        File del_file = null;
        int start_index = 0;
        int num_files = this.numOfLogFiles;
        if (index == -1) {
            del_file = new File(fileName);
        } else if (index == 0) {
            del_file = new File(fileName + "." + String.valueOf(1));
        } else {
            del_file = new File(fileName + "." + String.valueOf(1));
            num_files = index - 1;
        }
        while (start_index <= num_files) {
            try {
                if (del_file.exists()) {
                    del_file.delete();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            del_file = new File(fileName + "." + String.valueOf(++start_index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillSyslogHash() {
        boolean except_occurred = false;
        Map map = this.syslogFilesHash;
        synchronized (map) {
            int i;
            this.syslogFilesHash.clear();
            RandomAccessFile syslog = null;
            try {
                syslog = new RandomAccessFile(CONF, "r");
            }
            catch (Exception ex) {
                this.syslogEx = true;
                except_occurred = true;
                return;
            }
            String line = null;
            HashMap<String, String> dirhash = new HashMap<String, String>();
            try {
                line = syslog.readLine();
                if (line == null) {
                    System.out.println("Empty conf file");
                }
                i = 0;
                while (syslog.getFilePointer() < syslog.length()) {
                    String log_dir;
                    if (line == null || line.trim().length() == 0 || line.startsWith("#")) {
                        line = syslog.readLine();
                        continue;
                    }
                    int slash_index = line.indexOf("/");
                    if (slash_index == -1) {
                        line = syslog.readLine();
                        continue;
                    }
                    int blank_index = line.indexOf(", ", slash_index);
                    if (blank_index == -1) {
                        blank_index = line.indexOf(" ", slash_index);
                    }
                    if (blank_index == -1) {
                        blank_index = line.indexOf("\n", slash_index);
                    }
                    if (blank_index == -1) {
                        blank_index = line.length();
                    }
                    if (!dirhash.containsValue(log_dir = line.substring(slash_index, blank_index))) {
                        dirhash.put(String.valueOf(i), log_dir);
                        ++i;
                    }
                    line = syslog.readLine();
                }
                syslog.close();
            }
            catch (Exception ex) {
                except_occurred = true;
            }
            for (i = 0; i < dirhash.size(); ++i) {
                int dirIndex;
                String dirName;
                String dir = (String)dirhash.get(String.valueOf(i));
                File fstr = null;
                try {
                    fstr = new File(dir);
                }
                catch (Exception ex) {
                    except_occurred = true;
                    continue;
                }
                if (fstr.isDirectory() || !fstr.isFile() || (dirName = dir.substring(0, dirIndex = dir.lastIndexOf("/"))) != null && dirName.equalsIgnoreCase(DEV)) continue;
                try {
                    fstr = new File(dirName);
                }
                catch (Exception ex) {
                    except_occurred = true;
                    continue;
                }
                int slashIndex = dir.lastIndexOf("/");
                String fileNamePrefix = dir.substring(slashIndex + 1);
                File[] files = fstr.listFiles();
                for (int j = 0; files != null && j < files.length; ++j) {
                    String fileName = files[j].getName();
                    if (files[j].isDirectory() || !fileName.startsWith(fileNamePrefix)) continue;
                    this.syslogFilesHash.put(files[j].toString(), files[j]);
                }
            }
            this.syslogEx = except_occurred && this.syslogFilesHash.size() == 0;
        }
    }
}

