/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.LogFilter;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import com.sun.wbem.solarisprovider.logsvc.LogService;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;

public class LogServiceWrapper {
    public static final String LOG_SERVICE_FILE_DIR = "wbem.logging.file.dir";
    public static final String LOG_SERVICE_FILE_NAME = "wbem.logging.file.name";
    public static final String LOG_SERVICE_FILE_SIZE = "wbem.logging.file.size";
    public static final String LOG_SERVICE_FILE_NUM = "wbem.logging.file.num";
    public static final String LOG_SERVICE_SYSLOG = "wbem.logging.syslog";
    private String log_file = "wbem_log";
    private String log_dir = "/var/sadm/wbem/log";
    private String file_size = "5";
    private String file_num = "5";
    private String syslog_switch = "on";
    public static LogServiceWrapper theOnlyWrapper = null;
    public static boolean stop_service = false;
    public LogService logsvc = null;
    public CIMOMHandle cimomhandle = null;

    private LogServiceWrapper(CIMOMHandle chandle) throws AdminLogException {
        this.cimomhandle = chandle;
        this.logsvc = LogService.getInstance();
    }

    public static LogServiceWrapper getInstance(CIMOMHandle chandle) throws AdminLogException {
        if (theOnlyWrapper == null) {
            theOnlyWrapper = new LogServiceWrapper(chandle);
        }
        if (!stop_service) {
            return theOnlyWrapper;
        }
        return null;
    }

    public synchronized boolean isStarted() {
        return !stop_service;
    }

    public static synchronized void stopService() {
        stop_service = true;
    }

    public static synchronized void startService(CIMOMHandle chandle) throws AdminLogException {
        stop_service = false;
        if (theOnlyWrapper == null) {
            theOnlyWrapper = new LogServiceWrapper(chandle);
        }
    }

    public synchronized LogRecord readRecord(long recordId, int hashCode, String fileName) throws AdminLogException {
        String record = "";
        return this.logsvc.readRecord(recordId, hashCode, fileName);
    }

    public synchronized void writeRecord(LogRecord record, boolean syslogFlag) throws AdminLogException {
        this.logsvc.writeRecord(record, syslogFlag);
    }

    public synchronized Vector listRecords() throws AdminLogException {
        LogFilter lfilt = new LogFilter();
        int numRec = 0;
        long recId = 0L;
        String fileName = "";
        String[] files = this.logsvc.listLogFiles();
        for (int i = 0; i < files.length; ++i) {
            numRec = (int)((long)numRec + this.logsvc.getNumRecords(files[i]));
        }
        Vector<Vector> logRecords = new Vector<Vector>();
        for (int i = 0; i < files.length; ++i) {
            Vector lRec = this.logsvc.getList(numRec, lfilt, recId, files[i]);
            if (lRec == null) continue;
            lRec.addElement(files[i]);
            logRecords.addElement(lRec);
        }
        return logRecords;
    }

    public synchronized Vector listRecords(String fileName) throws AdminLogException {
        LogFilter lfilt = new LogFilter();
        int numRec = 0;
        long recId = 0L;
        numRec = (int)((long)numRec + this.logsvc.getNumRecords(fileName));
        Vector logRecords = new Vector();
        logRecords = this.logsvc.getList(numRec, lfilt, recId, fileName);
        if (logRecords != null) {
            return logRecords;
        }
        return null;
    }

    public synchronized Vector listRecords(LogFilter filter) throws AdminLogException {
        int numRec = 0;
        long recId = 0L;
        String fileName = filter.getFileName();
        filter.setFileName(null);
        if (fileName == null) {
            fileName = this.logsvc.getCurrentLogFileName();
        }
        numRec = (int)((long)numRec + this.logsvc.getNumRecords(fileName));
        Vector logRecords = new Vector();
        logRecords = this.logsvc.getList(numRec, filter, recId, fileName);
        if (logRecords != null) {
            return logRecords;
        }
        return null;
    }

    public synchronized Integer clearLog(String fileName) throws AdminLogException {
        this.logsvc.clearLog(fileName);
        return new Integer(0);
    }

    public synchronized Long getNumRecords(String fileName, Vector outParams) throws AdminLogException {
        long num_rec = 0L;
        num_rec = this.logsvc.getNumRecords(fileName);
        Long numRec = new Long(num_rec);
        outParams.addElement(new CIMValue((Object)numRec));
        return numRec;
    }

    public synchronized Integer listLogFiles(Vector outParams) throws AdminLogException {
        String[] files = null;
        files = this.logsvc.listLogFiles();
        Vector<String> fileNames = new Vector<String>();
        if (files == null) {
            return new Integer(-1);
        }
        for (int i = 0; i < files.length; ++i) {
            fileNames.addElement(files[i]);
        }
        outParams.addElement(new CIMValue(fileNames));
        return new Integer(0);
    }

    public synchronized String getCurrentLogfname() throws AdminLogException {
        return this.logsvc.getCurrentLogFileName();
    }

    public synchronized Integer getCurrentLogFileName(Vector outParams) throws AdminLogException {
        String fileName = this.logsvc.getCurrentLogFileName();
        if (fileName != null) {
            outParams.addElement(new CIMValue((Object)fileName));
            return new Integer(0);
        }
        return new Integer(-1);
    }

    public synchronized Integer getNumLogFiles(Vector outParams) throws AdminLogException {
        Integer numFiles = new Integer(this.logsvc.getNumLogFiles());
        outParams.addElement(new CIMValue((Object)numFiles));
        return numFiles;
    }

    public synchronized Long getLogFileSize(Vector outParams) throws AdminLogException {
        Long fileSize = new Long(this.logsvc.getLogFileSize(null));
        outParams.addElement(new CIMValue((Object)fileSize));
        return fileSize;
    }

    public synchronized Integer getSyslogSwitch(Vector outParams) throws AdminLogException {
        String syslogswitch = this.logsvc.getSyslogSwitch();
        if (syslogswitch != null) {
            outParams.addElement(new CIMValue((Object)syslogswitch));
            return new Integer(0);
        }
        return new Integer(-1);
    }

    public synchronized Integer getLogStorageName(Vector outParams) throws AdminLogException {
        String fileName = this.logsvc.getLogStorageName();
        if (fileName != null) {
            outParams.addElement(new CIMValue((Object)fileName));
            return new Integer(0);
        }
        return new Integer(-1);
    }

    public synchronized Integer getLogFileDir(Vector outParams) throws AdminLogException {
        String dirName = this.logsvc.getLogFileDir();
        if (dirName != null) {
            outParams.addElement(new CIMValue((Object)dirName));
            return new Integer(0);
        }
        return new Integer(-1);
    }

    public synchronized String getNumLogFiles() throws AdminLogException {
        return String.valueOf(this.logsvc.getNumLogFiles());
    }

    public synchronized String getLogFileSize() throws AdminLogException {
        return String.valueOf(this.logsvc.getLogFileSize(null));
    }

    public synchronized String getSyslogSwitch() throws AdminLogException {
        return this.logsvc.getSyslogSwitch();
    }

    public synchronized String getLogStorageName() throws AdminLogException {
        return this.logsvc.getLogStorageName();
    }

    public synchronized String getLogFileDir() throws AdminLogException {
        return this.logsvc.getLogFileDir();
    }

    public synchronized Integer setProperties(CIMInstance propInst) throws AdminLogException {
        this.log_dir = (String)propInst.getProperty("Directory").getValue().getValue();
        this.file_size = (String)propInst.getProperty("FileSize").getValue().getValue();
        this.file_num = (String)propInst.getProperty("NumFiles").getValue().getValue();
        this.syslog_switch = (String)propInst.getProperty("SyslogSwitch").getValue().getValue();
        this.logsvc.setProperties(Integer.parseInt(this.file_size), Integer.parseInt(this.file_num), this.syslog_switch, this.log_dir);
        return new Integer(0);
    }
}

