/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ServiceProps {
    public static final String ADMIN_SERVER_PROP_PATH = "/usr/sadm/lib/wbem";
    public static final String ADMIN_SERVER_PROP_FILE = "WbemServices.properties";
    public static final String ADMIN_PROP_SERVER_HDR = "Wbem Services properties file";
    public static final int ADMIN_PROP_MODE_READ = 0;
    public static final int ADMIN_PROP_MODE_WRITE = 1;
    public static final int ADMIN_PROP_MODE_CREATE = 2;
    public static final String ADMIN_PROP_ON_VALUE = "on";
    public static final String ADMIN_PROP_OFF_VALUE = "off";
    public static final String LOG_SERVICE_FILE_DIR = "wbem.logging.file.dir";
    public static final String LOG_SERVICE_FILE_NAME = "wbem.logging.file.name";
    public static final String LOG_SERVICE_FILE_SIZE = "wbem.logging.file.size";
    public static final String LOG_SERVICE_FILE_NUM = "wbem.logging.file.num";
    public static final String LOG_SERVICE_SYSLOG = "wbem.logging.syslog";
    private String propfile;
    private int propmode;
    private Properties props = null;

    public ServiceProps(String propPath, String propFileName, int propMode) throws AdminLogException {
        String path = null;
        if (propPath == null || propPath.trim().length() == 0) {
            throw new AdminLogException("EXLOG_PROP_PATH");
        }
        try {
            path = System.getProperty(propPath);
        }
        catch (Exception x) {
            path = null;
        }
        if (path == null) {
            throw new AdminLogException("EXLOG_PROP_PATH");
        }
        if (propFileName == null || propFileName.trim().length() == 0) {
            throw new AdminLogException("EXLOG_PROP_PATH");
        }
        this.propmode = propMode;
        path = path.concat(File.separator);
        this.propfile = path.concat(propFileName);
    }

    public ServiceProps(String propFilePath, int propMode) throws AdminLogException {
        this.propfile = propFilePath;
        this.propmode = propMode;
    }

    public String getServiceProp(String propName) throws AdminLogException {
        String val;
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        try {
            val = this.props.getProperty(propName);
        }
        catch (Exception ex) {
            throw new AdminLogException("EXLOG_PROP_NOT_FOUND", propName);
        }
        if (val == null) {
            val = "";
        }
        return val;
    }

    public Vector getServicePropList(String propNamePrefix) throws AdminLogException {
        Vector<String> vec = new Vector<String>();
        boolean sw = true;
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        int i = 1;
        String name = propNamePrefix.concat(".");
        while (sw) {
            name = propNamePrefix + "." + i;
            try {
                String val = this.props.getProperty(name);
                if (val == null) {
                    sw = false;
                } else {
                    vec.addElement(val);
                }
            }
            catch (Exception x) {
                sw = false;
            }
            ++i;
        }
        return vec;
    }

    public Vector getServicePropNames() throws AdminLogException {
        Vector<String> vec = new Vector<String>();
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        Enumeration<?> en = this.props.propertyNames();
        while (en.hasMoreElements()) {
            String name = new String((String)en.nextElement());
            vec.addElement(name);
        }
        return vec;
    }

    public void putServiceProp(String propName, String propValue) throws AdminLogException {
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        String val = propValue == null ? "" : propValue.trim();
        try {
            this.props.put(propName, val);
        }
        catch (Exception ex) {
            throw new AdminLogException("EXLOG_PNS", propName);
        }
    }

    public void delServiceProp(String propName) throws AdminLogException {
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        try {
            String val = (String)this.props.remove(propName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveServiceProps(String headInfo) throws AdminLogException {
        this.saveServiceProps(this.propfile, headInfo);
    }

    public void saveServiceProps(String propFile, String headInfo) throws AdminLogException {
        if (this.props != (Properties)null) {
            if (headInfo == null) {
                this.saveProperties(propFile, "*** DO NOT EDIT THIS FILE ***");
            } else {
                this.saveProperties(propFile, headInfo);
            }
        }
    }

    private void loadProperties() throws AdminLogException {
        boolean fnf = false;
        FileInputStream fin = null;
        BufferedInputStream bin = null;
        try {
            fin = new FileInputStream(this.propfile);
            bin = new BufferedInputStream(fin);
        }
        catch (FileNotFoundException fex) {
            fnf = true;
        }
        if (fnf && (this.propmode ^ 2) == 0) {
            throw new AdminLogException("EXLOG_BPF", this.propfile);
        }
        this.props = new Properties();
        if (!fnf) {
            try {
                this.props.load(bin);
            }
            catch (IOException ex) {
                throw new AdminLogException("EXLOG_LPF", (Object)this.propfile, ex.getMessage());
            }
        }
        try {
            fin.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void saveProperties(String propFile, String header) throws AdminLogException {
        BufferedOutputStream bout;
        FileOutputStream fout;
        try {
            fout = new FileOutputStream(propFile);
            bout = new BufferedOutputStream(fout);
        }
        catch (SecurityException fex) {
            throw new AdminLogException("EXLOG_NAP", propFile);
        }
        catch (IOException fex) {
            throw new AdminLogException("EXLOG_NWP", propFile);
        }
        try {
            this.props.store(bout, header);
        }
        catch (Exception ex) {
            throw new AdminLogException("EXLOG_NWP", (Object)propFile, ex);
        }
        try {
            bout.flush();
            fout.close();
        }
        catch (Exception ex) {
            throw new AdminLogException("EXLOG_NWP", (Object)propFile, ex);
        }
    }
}

