/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.LogFilter;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import com.sun.wbem.solarisprovider.logsvc.LogService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.query.AndQueryExp;
import javax.wbem.query.AttributeExp;
import javax.wbem.query.BinaryRelQueryExp;
import javax.wbem.query.DateTimeExp;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.NotQueryExp;
import javax.wbem.query.OrQueryExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.StringValueExp;
import javax.wbem.query.ValueExp;
import javax.wbem.query.WQLParser;

public class Solaris_LogEntry
implements InstanceProvider,
Authorizable {
    public static final String MARKER = "@%#";
    public static final String LOG_CCN = "LogCreationClassName";
    public static final String LOG_NAME = "LogName";
    public static final String RECORD_ID = "RecordID";
    public static final String RECORD_CCN = "CreationClassName";
    public static final String RECORD_TIME = "MessageTimestamp";
    public static final String RECORD_FORMAT = "DataFormat";
    public static final String RECORD_DATA = "RecordData";
    public static final String RECORD_CATEGORY = "Category";
    public static final String RECORD_SEVERITY = "Severity";
    public static final String RECORD_SOURCE = "Source";
    public static final String RECORD_USER = "UserName";
    public static final String RECORD_CLIENT = "ClientMachineName";
    public static final String RECORD_SERVER = "ServerMachineName";
    public static final String RECORD_SUMMARY = "SummaryMessage";
    public static final String RECORD_DETAIL = "DetailedMessage";
    public static final String RECORD_SYSLOG = "SyslogFlag";
    private ProviderUtility provUtil = null;
    private LogService logsvc = null;
    private ProviderCIMOMHandle cimomhandle = null;

    public void cleanup() throws CIMException {
    }

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = (ProviderCIMOMHandle)cimomhandle;
        this.provUtil = new ProviderUtility(cimomhandle, "Logging Service");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        this.provUtil.checkAuthenticated();
        long recId = 0L;
        int hashcode = 0;
        String fileName = "";
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(RECORD_ID)) {
                String recordid = (String)cp.getValue().getValue();
                int index = recordid.indexOf(MARKER);
                String id_str = recordid.substring(0, index);
                String hash_str = recordid.substring(index + MARKER.length());
                recId = Long.parseLong(id_str);
                hashcode = Integer.parseInt(hash_str);
            }
            if (!cp.getName().equalsIgnoreCase(LOG_NAME)) continue;
            fileName = (String)cp.getValue().getValue();
        }
        LogRecord rec = null;
        try {
            rec = this.logsvc.readRecord(recId, hashcode, fileName);
        }
        catch (AdminLogException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
        }
        CIMInstance ci = this.logToCim(cc, rec, fileName);
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        this.provUtil.checkAuthenticated();
        Vector<CIMObjectPath> allRecs = new Vector<CIMObjectPath>();
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        Vector<Vector> records = new Vector<Vector>();
        try {
            int i;
            LogFilter lfilt = new LogFilter();
            int numRec = 0;
            long recId = 0L;
            String fileName = "";
            String[] files = this.logsvc.listLogFiles();
            for (i = 0; i < files.length; ++i) {
                numRec = (int)((long)numRec + this.logsvc.getNumRecords(files[i]));
            }
            for (i = 0; i < files.length; ++i) {
                Vector lRec = this.logsvc.getList(numRec, lfilt, recId, files[i]);
                if (lRec == null) continue;
                lRec.addElement(files[i]);
                records.addElement(lRec);
            }
        }
        catch (AdminLogException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
        }
        for (int i = 0; i < records.size(); ++i) {
            Vector lRec = (Vector)records.elementAt(i);
            for (int j = 0; j < lRec.size() - 1; ++j) {
                LogRecord rec = (LogRecord)lRec.elementAt(j);
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                long recordId = rec.getRecordId();
                int hashcode = (int)rec.getHashCode();
                String id_str = String.valueOf(recordId);
                String hash_str = String.valueOf(hashcode);
                String record_id_str = id_str + MARKER + hash_str;
                cop.addKey(RECORD_ID, new CIMValue((Object)record_id_str));
                cop.addKey(RECORD_TIME, new CIMValue((Object)new CIMDateTime(rec.getDate())));
                cop.addKey(LOG_NAME, new CIMValue(lRec.elementAt(lRec.size() - 1)));
                cop.addKey(LOG_CCN, new CIMValue((Object)"Solaris_MessageLog"));
                cop.addKey(RECORD_CCN, new CIMValue((Object)"Solaris_LogEntry"));
                allRecs.addElement(cop);
            }
        }
        CIMObjectPath[] copArray = new CIMObjectPath[allRecs.size()];
        allRecs.toArray(copArray);
        return copArray;
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.provUtil.checkAuthenticated();
        LogRecord rec = new LogRecord();
        String fileName = null;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
                fileName = this.logsvc.getCurrentLogFileName();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        rec = this.cimToLog(ci, fileName);
        boolean syslogflag = (Boolean)ci.getProperty(RECORD_SYSLOG).getValue().getValue();
        try {
            this.logsvc.writeRecord(rec, syslogflag, null);
        }
        catch (AdminLogException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
        }
        long recordId = rec.getRecordId();
        int hashcode = (int)rec.getHashCode();
        String id_str = String.valueOf(recordId);
        String hash_str = String.valueOf(hashcode);
        String record_id_str = id_str + MARKER + hash_str;
        CIMObjectPath cop = new CIMObjectPath("Solaris_LogEntry");
        cop.setNameSpace("root/cimv2");
        cop.addKey(RECORD_ID, new CIMValue((Object)record_id_str));
        cop.addKey(LOG_NAME, new CIMValue((Object)rec.getFileName()));
        cop.addKey(RECORD_TIME, new CIMValue((Object)new CIMDateTime(rec.getDate())));
        cop.addKey(LOG_CCN, new CIMValue((Object)"Solaris_MessageLog"));
        cop.addKey(RECORD_CCN, new CIMValue((Object)"Solaris_LogEntry"));
        return cop;
    }

    public synchronized void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public synchronized void deleteInstance(CIMObjectPath cp) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        this.provUtil.checkAuthenticated();
        Vector allRecs = new Vector();
        Vector<CIMInstance> allInstances = new Vector<CIMInstance>();
        CIMInstance ci = null;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        Vector<Vector> records = new Vector<Vector>();
        try {
            int i;
            LogFilter lfilt = new LogFilter();
            int numRec = 0;
            long recId = 0L;
            String fileName = "";
            String[] files = this.logsvc.listLogFiles();
            for (i = 0; i < files.length; ++i) {
                numRec = (int)((long)numRec + this.logsvc.getNumRecords(files[i]));
            }
            for (i = 0; i < files.length; ++i) {
                Vector lRec = this.logsvc.getList(numRec, lfilt, recId, files[i]);
                if (lRec == null) continue;
                lRec.addElement(files[i]);
                records.addElement(lRec);
            }
        }
        catch (AdminLogException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
        }
        for (int i = 0; i < records.size(); ++i) {
            Vector lRec = (Vector)records.elementAt(i);
            for (int j = 0; j < lRec.size() - 1; ++j) {
                LogRecord rec = (LogRecord)lRec.elementAt(j);
                ci = this.logToCim(cc, rec, (String)lRec.elementAt(lRec.size() - 1));
                if (localOnly) {
                    ci = ci.localElements();
                }
                allInstances.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
            }
        }
        CIMInstance[] ciArray = new CIMInstance[allInstances.size()];
        allInstances.toArray(ciArray);
        return ciArray;
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        this.provUtil.checkAuthenticated();
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            NonJoinExp from = (NonJoinExp)q.getFromClause();
            QueryExp where = q.getWhereClause();
            String fileName = null;
            try {
                fileName = (String)this.getAttributeValueInQuery(where, LOG_NAME);
            }
            catch (Exception e) {
                fileName = null;
            }
            CIMInstance[] v = null;
            v = fileName != null ? this.myEnum(op, cc, fileName) : this.enumerateInstances(op, false, false, false, null, cc);
            for (int i = 0; v != null && i < v.length; ++i) {
                if (where != null && !where.apply((CIMElement)v[i])) continue;
                result.addElement(attrs.apply((CIMElement)v[i]));
            }
        }
        catch (Exception e) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)e.getMessage());
        }
        CIMInstance[] ciArray = new CIMInstance[result.size()];
        result.toArray(ciArray);
        return ciArray;
    }

    private Object getAttributeValueInQuery(QueryExp exp, String colName) throws Exception {
        if (exp instanceof AndQueryExp) {
            QueryExp leftExp = ((AndQueryExp)exp).getLeftExp();
            QueryExp rightExp = ((AndQueryExp)exp).getRightExp();
            Object retStr = this.getAttributeValueInQuery(leftExp, colName);
            if (retStr != null) {
                return retStr;
            }
            retStr = this.getAttributeValueInQuery(rightExp, colName);
            return retStr;
        }
        if (exp instanceof OrQueryExp) {
            QueryExp leftExp = ((OrQueryExp)exp).getLeftExp();
            QueryExp rightExp = ((OrQueryExp)exp).getRightExp();
            Object retStr = this.getAttributeValueInQuery(leftExp, colName);
            if (retStr != null) {
                return retStr;
            }
            retStr = this.getAttributeValueInQuery(rightExp, colName);
            return retStr;
        }
        if (exp instanceof NotQueryExp) {
            throw new Exception();
        }
        if (exp instanceof BinaryRelQueryExp) {
            ValueExp leftVal = ((BinaryRelQueryExp)exp).getLeftValue();
            ValueExp rightVal = ((BinaryRelQueryExp)exp).getRightValue();
            if (leftVal instanceof AttributeExp) {
                String attr = ((AttributeExp)leftVal).getAttributeName();
                if (attr.equalsIgnoreCase(colName)) {
                    if (rightVal instanceof StringValueExp) {
                        return ((StringValueExp)rightVal).getValue();
                    }
                    if (rightVal instanceof DateTimeExp) {
                        return ((DateTimeExp)rightVal).getValue();
                    }
                    return null;
                }
                return null;
            }
            if (rightVal instanceof AttributeExp) {
                String attr = ((AttributeExp)rightVal).getAttributeName();
                if (attr.equalsIgnoreCase(colName)) {
                    if (leftVal instanceof StringValueExp) {
                        return ((StringValueExp)leftVal).getValue();
                    }
                    if (leftVal instanceof DateTimeExp) {
                        return ((DateTimeExp)leftVal).getValue();
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private CIMInstance[] myEnum(CIMObjectPath op, CIMClass cc, String fileName) throws CIMException {
        Vector<CIMInstance> allInstances = new Vector<CIMInstance>();
        CIMInstance ci = null;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        Vector lRec = new Vector();
        try {
            LogFilter lfilt = new LogFilter();
            int numRec = 0;
            long recId = 0L;
            numRec = (int)((long)numRec + this.logsvc.getNumRecords(fileName));
            lRec = this.logsvc.getList(numRec, lfilt, recId, fileName);
        }
        catch (AdminLogException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
        }
        for (int j = 0; lRec != null && j < lRec.size(); ++j) {
            LogRecord rec = (LogRecord)lRec.elementAt(j);
            ci = this.logToCim(cc, rec, fileName);
            allInstances.addElement(ci);
        }
        CIMInstance[] ciArray = new CIMInstance[allInstances.size()];
        allInstances.toArray(ciArray);
        return ciArray;
    }

    private CIMInstance logToCim(CIMClass cc, LogRecord rec, String fileName) throws CIMException {
        CIMInstance ci = cc.newInstance();
        long recordId = rec.getRecordId();
        int hashcode = (int)rec.getHashCode();
        String id_str = String.valueOf(recordId);
        String hash_str = String.valueOf(hashcode);
        String record_id_str = id_str + MARKER + hash_str;
        ci.setProperty(LOG_CCN, new CIMValue((Object)"Solaris_MessageLog"));
        ci.setProperty(RECORD_CCN, new CIMValue((Object)"Solaris_LogEntry"));
        ci.setProperty(RECORD_ID, new CIMValue((Object)record_id_str));
        ci.setProperty(LOG_NAME, new CIMValue((Object)fileName));
        ci.setProperty(RECORD_TIME, new CIMValue((Object)new CIMDateTime(rec.getDate())));
        ci.setProperty(RECORD_CATEGORY, new CIMValue((Object)new Integer(rec.getCategory())));
        ci.setProperty(RECORD_SEVERITY, new CIMValue((Object)new Integer(rec.getSeverity())));
        ci.setProperty(RECORD_SOURCE, new CIMValue((Object)rec.getAppName()));
        ci.setProperty(RECORD_USER, new CIMValue((Object)rec.getUserName()));
        ci.setProperty(RECORD_CLIENT, new CIMValue((Object)rec.getClientHostName()));
        ci.setProperty(RECORD_SERVER, new CIMValue((Object)rec.getAgentHostName()));
        ci.setProperty(RECORD_SUMMARY, new CIMValue((Object)rec.getSummaryMesg(true)));
        ci.setProperty(RECORD_DETAIL, new CIMValue((Object)rec.getDetailedMesg(true)));
        ci.setProperty(RECORD_DATA, new CIMValue((Object)rec.getData()));
        ci.setProperty(RECORD_SYSLOG, new CIMValue((Object)new Boolean(rec.getSyslog())));
        return ci;
    }

    private LogRecord cimToLog(CIMInstance ci, String fileName) throws CIMException {
        LogRecord rec = new LogRecord();
        rec.setCategory((Integer)ci.getProperty(RECORD_CATEGORY).getValue().getValue());
        rec.setSeverity((Integer)ci.getProperty(RECORD_SEVERITY).getValue().getValue());
        rec.setAppName((String)ci.getProperty(RECORD_SOURCE).getValue().getValue());
        rec.setUserName(this.provUtil.getClientUserName());
        String addr = this.cimomhandle.getCurrentClientHost();
        String host_name = null;
        try {
            InetAddress ip_addr = InetAddress.getByName(addr);
            host_name = ip_addr.getHostName();
        }
        catch (Exception ex) {
            host_name = addr;
        }
        if (host_name == null) {
            host_name = addr;
        }
        rec.setClientHostName(host_name);
        try {
            rec.setAgentHostName(InetAddress.getLocalHost().getHostName());
        }
        catch (Exception e) {
            rec.setAgentHostName((String)ci.getProperty(RECORD_SERVER).getValue().getValue());
        }
        rec.setSummaryMesgId((String)ci.getProperty(RECORD_SUMMARY).getValue().getValue());
        rec.setDetailedMesgId((String)ci.getProperty(RECORD_DETAIL).getValue().getValue());
        rec.addData((String)ci.getProperty(RECORD_DATA).getValue().getValue());
        boolean syslogflag = (Boolean)ci.getProperty(RECORD_SYSLOG).getValue().getValue();
        rec.setSyslog(syslogflag);
        return rec;
    }
}

