/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.LogFilter;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import com.sun.wbem.solarisprovider.logsvc.LogService;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.AssociatorProvider;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_RecordInLog
implements InstanceProvider,
AssociatorProvider,
Authorizable {
    public static final String LOGSVC_WRITE_RIGHT = "solaris.admin.logsvc.write";
    public static final String LOGSVC_PURGE_RIGHT = "solaris.admin.logsvc.purge";
    public static final String LOGSVC_READ_RIGHT = "solaris.admin.logsvc.read";
    public static final String MESG_LOG = "MessageLog";
    public static final String SOLARIS_REC_INLOG = "Solaris_RecordInLog";
    public static final String SOLARIS_MESG_LOG = "Solaris_MessageLog";
    public static final String SOLARIS_LOG_REC = "Solaris_MessageLogRecord";
    public static final String SOLARIS_SYSLOG_REC = "Solaris_SysLogRecord";
    public static final String SOLARIS_LOG_ENTRY = "Solaris_LogEntry";
    public static final String LOG_REC = "LogRecord";
    public static final String MARKER = "@%#";
    public static final String CCN = "CreationClassName";
    public static final String NAME = "Name";
    public static final String LOG_CCN = "LogCreationClassName";
    public static final String LOG_NAME = "LogName";
    public static final String RECORD_ID = "RecordID";
    public static final String RECORD_CCN = "CreationClassName";
    public static final String RECORD_TIME = "MessageTimestamp";
    public static final String RECORD_FORMAT = "DataFormat";
    public static final String RECORD_DATA = "RecordData";
    public static final String RECORD_CATEGORY = "Category";
    public static final String RECORD_SEVERITY = "Severity";
    public static final String RECORD_SOURCE = "Source";
    public static final String RECORD_USER = "UserName";
    public static final String RECORD_CLIENT = "ClientMachineName";
    public static final String RECORD_SERVER = "ServerMachineName";
    public static final String RECORD_SUMMARY = "SummaryMessage";
    public static final String RECORD_DETAIL = "DetailedMessage";
    public static final String RECORD_SYSLOG = "SyslogFlag";
    public static final String MESGLOG_NAME = "Name";
    private LogService logsvc = null;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.provUtil = new ProviderUtility(cimomhandle, "Logging Service");
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        CIMObjectPath messageLog = null;
        CIMObjectPath logRecord = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(MESG_LOG)) {
                messageLog = (CIMObjectPath)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase(LOG_REC)) continue;
            logRecord = (CIMObjectPath)cp.getValue().getValue();
        }
        CIMInstance ci = cc.newInstance();
        ci.setProperty(MESG_LOG, new CIMValue(messageLog));
        ci.setProperty(LOG_REC, new CIMValue(logRecord));
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cp) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector associators(CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        CIMInstance ci = null;
        CIMObjectPath tempOp = null;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        Vector<CIMInstance> records = new Vector<CIMInstance>();
        if (objectName.getObjectName().equalsIgnoreCase(SOLARIS_MESG_LOG)) {
            if (role != null && !role.equalsIgnoreCase(MESG_LOG)) {
                throw new CIMProviderException("CIM_ERR_NOT_FOUND", (Object)role);
            }
            String logName = null;
            Enumeration e = objectName.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase("Name")) continue;
                logName = (String)cp.getValue().getValue();
            }
            CIMClass cc = null;
            Vector recs = new Vector();
            try {
                String logtype = this.logsvc.getLogType(logName);
                if (logtype.equalsIgnoreCase("WBEM Log")) {
                    int numRec = (int)this.logsvc.getNumRecords(logName);
                    LogFilter filt = new LogFilter();
                    filt.setFileName(logName);
                    recs = this.logsvc.getList(numRec, filt, 0L, logName);
                    cc = this.cimomhandle.getClass(new CIMObjectPath(SOLARIS_LOG_ENTRY), false, true, true, null);
                    Enumeration allRecs = recs.elements();
                    while (allRecs.hasMoreElements()) {
                        LogRecord rec = (LogRecord)allRecs.nextElement();
                        ci = this.logToCim(cc, rec, logName);
                        records.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
                    }
                }
                cc = this.cimomhandle.getClass(new CIMObjectPath(SOLARIS_SYSLOG_REC), false, true, true, null);
                String[] sysrec = this.logsvc.getSyslogRecords(logName);
                int j = 0;
                while (sysrec != null && sysrec.length > 0) {
                    ci = cc.newInstance();
                    ci.setProperty(LOG_CCN, new CIMValue((Object)SOLARIS_MESG_LOG));
                    ci.setProperty(LOG_NAME, new CIMValue((Object)logName));
                    ci.setProperty("CreationClassName", new CIMValue((Object)SOLARIS_SYSLOG_REC));
                    ci.setProperty(RECORD_FORMAT, new CIMValue((Object)"Unknown"));
                    ci.setProperty(RECORD_DATA, new CIMValue((Object)sysrec[j]));
                    ci.setProperty(RECORD_ID, new CIMValue((Object)String.valueOf(j)));
                    ci.setProperty(RECORD_TIME, new CIMValue((Object)new CIMDateTime(new Date())));
                    records.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
                    ++j;
                }
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        } else if (objectName.getObjectName().equalsIgnoreCase(SOLARIS_LOG_REC)) {
            if (role != null && !role.equalsIgnoreCase(LOG_REC)) {
                throw new CIMProviderException("CIM_ERR_NOT_FOUND", (Object)role);
            }
            if (resultClass != null) {
                tempOp = new CIMObjectPath(resultClass);
                tempOp.setNameSpace(assocName.getNameSpace());
            } else {
                tempOp = new CIMObjectPath(SOLARIS_MESG_LOG);
                tempOp.setNameSpace(assocName.getNameSpace());
            }
            String logName = null;
            Enumeration e = objectName.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase(LOG_NAME)) continue;
                logName = (String)cp.getValue().getValue();
            }
            tempOp.addKey("Name", new CIMValue(logName));
            tempOp.addKey("CreationClassName", new CIMValue((Object)SOLARIS_MESG_LOG));
            ci = this.cimomhandle.getInstance(tempOp, false, true, true, null);
            records.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
        } else {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)objectName);
        }
        return records;
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole) throws CIMException {
        String logName;
        CIMObjectPath tempOp = null;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        Vector<CIMObjectPath> records = new Vector<CIMObjectPath>();
        if (objectName.getObjectName().equalsIgnoreCase(SOLARIS_MESG_LOG)) {
            if (role != null && !role.equalsIgnoreCase(MESG_LOG)) {
                throw new CIMProviderException("CIM_ERR_NOT_FOUND", (Object)role);
            }
            logName = null;
            Enumeration e = objectName.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase("Name")) continue;
                logName = (String)cp.getValue().getValue();
            }
            CIMClass cc = null;
            Vector recs = new Vector();
            try {
                String logtype = this.logsvc.getLogType(logName);
                if (logtype.equalsIgnoreCase("WBEM Log")) {
                    int numRec = (int)this.logsvc.getNumRecords(logName);
                    LogFilter filt = new LogFilter();
                    filt.setFileName(logName);
                    recs = this.logsvc.getList(numRec, filt, 0L, logName);
                    cc = this.cimomhandle.getClass(new CIMObjectPath(SOLARIS_LOG_ENTRY), false, true, true, null);
                    Enumeration allRecs = recs.elements();
                    while (allRecs.hasMoreElements()) {
                        LogRecord rec = (LogRecord)allRecs.nextElement();
                        long recordId = rec.getRecordId();
                        int hashcode = (int)rec.getHashCode();
                        String id_str = String.valueOf(recordId);
                        String hash_str = String.valueOf(hashcode);
                        String record_id_str = id_str + MARKER + hash_str;
                        CIMObjectPath cop = new CIMObjectPath(SOLARIS_LOG_ENTRY);
                        cop.setNameSpace(assocName.getNameSpace());
                        cop.addKey(RECORD_ID, new CIMValue((Object)record_id_str));
                        cop.addKey(LOG_NAME, new CIMValue((Object)rec.getFileName()));
                        cop.addKey(RECORD_TIME, new CIMValue((Object)new CIMDateTime(rec.getDate())));
                        cop.addKey(LOG_CCN, new CIMValue((Object)SOLARIS_MESG_LOG));
                        cop.addKey("CreationClassName", new CIMValue((Object)SOLARIS_LOG_ENTRY));
                        records.addElement(cop);
                    }
                }
                String[] sysrec = this.logsvc.getSyslogRecords(logName);
                int j = 0;
                while (sysrec != null && sysrec.length > 0) {
                    CIMObjectPath cop = new CIMObjectPath(SOLARIS_SYSLOG_REC);
                    cop.setNameSpace(objectName.getNameSpace());
                    cop.addKey(RECORD_ID, new CIMValue((Object)String.valueOf(j)));
                    cop.addKey(LOG_NAME, new CIMValue((Object)logName));
                    cop.addKey(RECORD_TIME, new CIMValue((Object)new CIMDateTime(new Date())));
                    cop.addKey(LOG_CCN, new CIMValue((Object)SOLARIS_MESG_LOG));
                    cop.addKey("CreationClassName", new CIMValue((Object)SOLARIS_SYSLOG_REC));
                    records.addElement(cop);
                    ++j;
                }
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        } else if (objectName.getObjectName().equalsIgnoreCase(SOLARIS_LOG_REC)) {
            if (role != null && !role.equalsIgnoreCase(LOG_REC)) {
                throw new CIMProviderException("CIM_ERR_NOT_FOUND", (Object)role);
            }
            if (resultClass != null) {
                tempOp = new CIMObjectPath(resultClass);
                tempOp.setNameSpace(assocName.getNameSpace());
            } else {
                tempOp = new CIMObjectPath(SOLARIS_MESG_LOG);
                tempOp.setNameSpace(assocName.getNameSpace());
            }
            logName = null;
            Enumeration e = objectName.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase(LOG_NAME)) continue;
                logName = (String)cp.getValue().getValue();
            }
            tempOp.addKey("Name", new CIMValue((Object)logName));
            tempOp.addKey("CreationClassName", new CIMValue((Object)SOLARIS_MESG_LOG));
            records.addElement(tempOp);
        } else {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)objectName);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[records.size()];
        records.toArray(copArray);
        return copArray;
    }

    public Vector references(CIMObjectPath assocName, CIMObjectPath objectName, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        CIMInstance ci = null;
        Vector<CIMInstance> assocVec = new Vector<CIMInstance>();
        CIMObjectPath tempOp = null;
        CIMObjectPath assocOp = new CIMObjectPath(SOLARIS_REC_INLOG);
        assocOp.setNameSpace(objectName.getNameSpace());
        CIMClass cc = this.cimomhandle.getClass(new CIMObjectPath(SOLARIS_REC_INLOG), false, true, true, null);
        if (objectName.getObjectName().equalsIgnoreCase(SOLARIS_MESG_LOG)) {
            if (role != null && !role.equalsIgnoreCase(MESG_LOG)) {
                throw new CIMProviderException("CIM_ERR_NOT_FOUND", (Object)role);
            }
            CIMObjectPath[] records = this.associatorNames(assocOp, objectName, SOLARIS_LOG_REC, role, LOG_REC);
            for (int i = 0; records != null && i < records.length; ++i) {
                CIMObjectPath recOp = records[i];
                ci = cc.newInstance();
                ci.setProperty(MESG_LOG, new CIMValue((Object)objectName));
                ci.setProperty(LOG_REC, new CIMValue((Object)recOp));
                assocVec.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
            }
        } else if (objectName.getObjectName().equalsIgnoreCase(SOLARIS_LOG_REC)) {
            if (role != null && !role.equalsIgnoreCase(LOG_REC)) {
                throw new CIMProviderException("CIM_ERR_NOT_FOUND", (Object)role);
            }
            String logName = null;
            Enumeration e = objectName.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase(LOG_NAME)) continue;
                logName = (String)cp.getValue().getValue();
            }
            tempOp = new CIMObjectPath(SOLARIS_MESG_LOG);
            tempOp.setNameSpace(assocName.getNameSpace());
            tempOp.addKey("Name", new CIMValue((Object)logName));
            tempOp.addKey("CreationClassName", new CIMValue((Object)SOLARIS_MESG_LOG));
            ci = cc.newInstance();
            ci.setProperty(MESG_LOG, new CIMValue((Object)tempOp));
            ci.setProperty(LOG_REC, new CIMValue((Object)objectName));
            assocVec.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
        }
        return assocVec;
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath assocName, CIMObjectPath objectName, String role) throws CIMException {
        Vector<CIMObjectPath> assocVec = new Vector<CIMObjectPath>();
        CIMObjectPath tempOp = null;
        CIMObjectPath assocOp = new CIMObjectPath(SOLARIS_REC_INLOG);
        assocOp.setNameSpace(objectName.getNameSpace());
        if (objectName.getObjectName().equalsIgnoreCase(SOLARIS_MESG_LOG)) {
            if (role != null && !role.equalsIgnoreCase(MESG_LOG)) {
                throw new CIMProviderException("CIM_ERR_NOT_FOUND", (Object)role);
            }
            CIMObjectPath[] records = this.associatorNames(assocOp, objectName, SOLARIS_LOG_REC, role, LOG_REC);
            for (int i = 0; records != null && i < records.length; ++i) {
                CIMObjectPath recOp = records[i];
                tempOp = new CIMObjectPath(SOLARIS_REC_INLOG);
                tempOp.setNameSpace(assocName.getNameSpace());
                tempOp.addKey(MESG_LOG, new CIMValue((Object)objectName));
                tempOp.addKey(LOG_REC, new CIMValue((Object)recOp));
                assocVec.addElement(tempOp);
            }
        } else if (objectName.getObjectName().equalsIgnoreCase(SOLARIS_LOG_REC)) {
            if (role != null && !role.equalsIgnoreCase(LOG_REC)) {
                throw new CIMProviderException("CIM_ERR_NOT_FOUND", (Object)role);
            }
            String logName = null;
            Enumeration e = objectName.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase(LOG_NAME)) continue;
                logName = (String)cp.getValue().getValue();
            }
            tempOp = new CIMObjectPath(SOLARIS_MESG_LOG);
            tempOp.setNameSpace(assocName.getNameSpace());
            tempOp.addKey("Name", new CIMValue((Object)logName));
            tempOp.addKey("CreationClassName", new CIMValue((Object)SOLARIS_MESG_LOG));
            assocOp = new CIMObjectPath(SOLARIS_REC_INLOG);
            assocOp.setNameSpace(assocName.getNameSpace());
            assocOp.addKey(MESG_LOG, new CIMValue((Object)objectName));
            assocOp.addKey(LOG_REC, new CIMValue((Object)tempOp));
            assocVec.addElement(assocOp);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[assocVec.size()];
        assocVec.toArray(copArray);
        return copArray;
    }

    private CIMInstance logToCim(CIMClass cc, LogRecord rec, String fileName) throws CIMException {
        CIMInstance ci = cc.newInstance();
        long recordId = rec.getRecordId();
        int hashcode = (int)rec.getHashCode();
        String id_str = String.valueOf(recordId);
        String hash_str = String.valueOf(hashcode);
        String record_id_str = id_str + MARKER + hash_str;
        ci.setProperty(LOG_CCN, new CIMValue((Object)SOLARIS_MESG_LOG));
        ci.setProperty("CreationClassName", new CIMValue((Object)SOLARIS_LOG_ENTRY));
        ci.setProperty(RECORD_ID, new CIMValue((Object)record_id_str));
        ci.setProperty(LOG_NAME, new CIMValue((Object)fileName));
        ci.setProperty(RECORD_TIME, new CIMValue((Object)new CIMDateTime(rec.getDate())));
        ci.setProperty(RECORD_CATEGORY, new CIMValue((Object)new Integer(rec.getCategory())));
        ci.setProperty(RECORD_SEVERITY, new CIMValue((Object)new Integer(rec.getSeverity())));
        ci.setProperty(RECORD_SOURCE, new CIMValue((Object)rec.getAppName()));
        ci.setProperty(RECORD_USER, new CIMValue((Object)rec.getUserName()));
        ci.setProperty(RECORD_CLIENT, new CIMValue((Object)rec.getClientHostName()));
        ci.setProperty(RECORD_SERVER, new CIMValue((Object)rec.getAgentHostName()));
        ci.setProperty(RECORD_SUMMARY, new CIMValue((Object)rec.getSummaryMesg(true)));
        ci.setProperty(RECORD_DETAIL, new CIMValue((Object)rec.getDetailedMesg(true)));
        ci.setProperty(RECORD_DATA, new CIMValue((Object)rec.getData()));
        ci.setProperty(RECORD_SYSLOG, new CIMValue((Object)new Boolean(rec.getSyslog())));
        return ci;
    }
}

