/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.authorization;

public class AuthorizationUtility {
    private static boolean library_loaded = false;

    public static String[] getUserAuths(String userName) {
        String[] arr = new String[]{};
        if (library_loaded) {
            arr = AuthorizationUtility.secdbGetAuthNames(userName);
        }
        return arr;
    }

    public static String[] getUserAuths(String userName, String authPrefix) {
        String[] arr = new String[]{};
        if (library_loaded) {
            arr = AuthorizationUtility.secdbGetMatchingAuthNames(userName, authPrefix);
        }
        return arr;
    }

    public static boolean checkAuthName(String userName, String authName) {
        boolean bool = false;
        if (library_loaded) {
            bool = AuthorizationUtility.secdbCheckAuthName(userName, authName);
        }
        return bool;
    }

    public static String[] getRoleNames(String userName) {
        String[] arr = new String[]{};
        if (library_loaded) {
            arr = AuthorizationUtility.secdbGetRoleNames(userName);
        }
        return arr;
    }

    public static String[] getUserProfs(String userName) {
        String[] arr = new String[]{};
        if (library_loaded) {
            arr = AuthorizationUtility.secdbGetProfNames(userName);
        }
        return arr;
    }

    public static boolean checkCommandExec(String userName, String commandPathname) {
        boolean bool = false;
        if (library_loaded) {
            bool = AuthorizationUtility.secdbCheckCommandExec(userName, commandPathname);
        }
        return bool;
    }

    private static native String[] secdbGetAuthNames(String var0);

    private static native String[] secdbGetMatchingAuthNames(String var0, String var1);

    private static native String[] secdbGetRoleNames(String var0);

    private static native String[] secdbGetProfNames(String var0);

    private static native boolean secdbCheckAuthName(String var0, String var1);

    private static native boolean secdbCheckCommandExec(String var0, String var1);

    static {
        try {
            System.loadLibrary("provutil");
            library_loaded = true;
        }
        catch (SecurityException exception) {
            System.out.println("AuthUtil: Library not loaded");
        }
        catch (UnsatisfiedLinkError exception) {
            System.out.println("AuthUtil: Library not loaded");
        }
    }
}

