/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.common;

import com.sun.wbem.utility.common.Compare;
import com.sun.wbem.utility.common.QuickVector;
import java.util.Random;
import java.util.Vector;

public class Sort {
    private static Random rn = null;
    private static int MAX_ELEMENTS_FOR_COPY = 15000;
    static final int ASCENDING_SORT = 0;
    static final int DESCENDING_SORT = 0;

    private static void swap(Object[] arr, int i, int j) {
        Object tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    private static void quicksort(Object[] arr, int left, int right, Compare comp) {
        if (left >= right) {
            return;
        }
        Sort.swap(arr, left, left + (Math.abs(rn.nextInt()) % (right - left) + 1));
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (comp.doCompare(arr[i], arr[left]) >= 0) continue;
            Sort.swap(arr, ++last, i);
        }
        Sort.swap(arr, left, last);
        Sort.quicksort(arr, left, last - 1, comp);
        Sort.quicksort(arr, last + 1, right, comp);
    }

    private static void quicksort(String[] arr, int left, int right, int order) {
        if (left >= right) {
            return;
        }
        Sort.swap(arr, left, left + (Math.abs(rn.nextInt()) % (right - left) + 1));
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (order == 0) {
                if (arr[i].compareTo(arr[left]) >= 0) continue;
                Sort.swap(arr, ++last, i);
                continue;
            }
            if (arr[i].compareTo(arr[left]) <= 0) continue;
            Sort.swap(arr, ++last, i);
        }
        Sort.swap(arr, left, last);
        Sort.quicksort(arr, left, last - 1, order);
        Sort.quicksort(arr, last + 1, right, order);
    }

    private static void swap(Vector vec, int i, int j) {
        Object tmp = vec.elementAt(i);
        vec.setElementAt(vec.elementAt(j), i);
        vec.setElementAt(tmp, j);
    }

    private static void quicksort(Vector vec, int left, int right, Compare comp) {
        if (left >= right) {
            return;
        }
        Sort.swap(vec, left, left + (Math.abs(rn.nextInt()) % (right - left) + 1));
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (comp.doCompare(vec.elementAt(i), vec.elementAt(left)) >= 0) continue;
            Sort.swap(vec, ++last, i);
        }
        Sort.swap(vec, left, last);
        Sort.quicksort(vec, left, last - 1, comp);
        Sort.quicksort(vec, last + 1, right, comp);
    }

    private static void quicksort(Vector vec, int left, int right, int order) {
        if (left >= right) {
            return;
        }
        Sort.swap(vec, left, left + (Math.abs(rn.nextInt()) % (right - left) + 1));
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (order == 0) {
                if (((String)vec.elementAt(i)).compareTo((String)vec.elementAt(left)) >= 0) continue;
                Sort.swap(vec, ++last, i);
                continue;
            }
            if (((String)vec.elementAt(i)).compareTo((String)vec.elementAt(left)) <= 0) continue;
            Sort.swap(vec, ++last, i);
        }
        Sort.swap(vec, left, last);
        Sort.quicksort(vec, left, last - 1, order);
        Sort.quicksort(vec, last + 1, right, order);
    }

    private static void quicksort(QuickVector vec, int left, int right, Compare comp) {
        if (left >= right) {
            return;
        }
        vec.quickSwapElementsAt(left, left + (Math.abs(rn.nextInt()) % (right - left) + 1));
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (comp.doCompare(vec.quickElementAt(i), vec.quickElementAt(left)) >= 0) continue;
            vec.quickSwapElementsAt(++last, i);
        }
        vec.quickSwapElementsAt(left, last);
        Sort.quicksort(vec, left, last - 1, comp);
        Sort.quicksort(vec, last + 1, right, comp);
    }

    private static void quicksort(QuickVector vec, int left, int right, int order) {
        if (left >= right) {
            return;
        }
        vec.quickSwapElementsAt(left, left + (Math.abs(rn.nextInt()) % (right - left) + 1));
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (order == 0) {
                if (((String)vec.quickElementAt(i)).compareTo((String)vec.quickElementAt(left)) >= 0) continue;
                vec.quickSwapElementsAt(++last, i);
                continue;
            }
            if (((String)vec.quickElementAt(i)).compareTo((String)vec.quickElementAt(left)) <= 0) continue;
            vec.quickSwapElementsAt(++last, i);
        }
        vec.quickSwapElementsAt(left, last);
        Sort.quicksort(vec, left, last - 1, order);
        Sort.quicksort(vec, last + 1, right, order);
    }

    public static void sort(Object[] arr, Compare comp) {
        if (rn == null) {
            rn = new Random();
        }
        Sort.quicksort(arr, 0, arr.length - 1, comp);
    }

    public static void sort(String[] arr, int order) {
        if (rn == null) {
            rn = new Random();
        }
        Sort.quicksort(arr, 0, arr.length - 1, order);
    }

    public static void sort(String[] arr) {
        Sort.sort(arr, 0);
    }

    public static void sort(Vector vec, Compare comp) {
        if (rn == null) {
            rn = new Random();
        }
        if (vec.size() > MAX_ELEMENTS_FOR_COPY) {
            Sort.quicksort(vec, 0, vec.size() - 1, comp);
        } else {
            Object[] arr = new Object[vec.size()];
            vec.copyInto(arr);
            Sort.quicksort(arr, 0, arr.length - 1, comp);
            for (int i = 0; i < arr.length; ++i) {
                vec.setElementAt(arr[i], i);
            }
        }
    }

    public static void sort(Vector vec, int order) {
        if (rn == null) {
            rn = new Random();
        }
        if (vec.size() > MAX_ELEMENTS_FOR_COPY) {
            Sort.quicksort(vec, 0, vec.size() - 1, order);
        } else {
            Object[] arr = new String[vec.size()];
            vec.copyInto(arr);
            vec.removeAllElements();
            Sort.quicksort((String[])arr, 0, arr.length - 1, order);
            vec.setSize(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                vec.setElementAt(arr[i], i);
            }
        }
    }

    public static void sort(Vector vec) {
        Sort.sort(vec, 0);
    }

    public static void sort(QuickVector vec, Compare comp) {
        if (rn == null) {
            rn = new Random();
        }
        Sort.quicksort(vec, 0, vec.size() - 1, comp);
    }

    public static void sort(QuickVector vec, int order) {
        if (rn == null) {
            rn = new Random();
        }
        Sort.quicksort(vec, 0, vec.size() - 1, order);
    }

    public static void sort(QuickVector vec) {
        Sort.sort(vec, 0);
    }
}

