/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;

public class DirectoryFilter
implements SearchTemplate {
    public static final int COMBINATION_METHOD_NULL = 1;
    public static final int COMBINATION_METHOD_AND = 2;
    public static final int COMBINATION_METHOD_OR = 3;
    public static final int MAX_COMBINATION_METHOD = 3;
    public static final int SEARCH_ATTRIBUTE_CONTAINS = 1;
    public static final int SEARCH_ATTRIBUTE_DOES_NOT_CONTAIN = 2;
    public static final int SEARCH_ATTRIBUTE_STARTS_WITH = 3;
    public static final int SEARCH_ATTRIBUTE_ENDS_WITH = 4;
    public static final int SEARCH_ATTRIBUTE_EQUALS = 5;
    public static final int SEARCH_ATTRIBUTE_DOES_NOT_EQUAL = 6;
    public static final int SEARCH_ATTRIBUTE_LESS_THAN = 7;
    public static final int SEARCH_ATTRIBUTE_GREATER_THAN = 8;
    public static final int SEARCH_ATTRIBUTE_MATCHES_REGULAR_EXPRESSION = 9;
    public static final int MAX_SEARCH_ATTRIBUTE = 9;
    private int[] columnNumbers;
    private int[] combinationMethods;
    private int[] searchAttributes;
    private String[] values;
    private boolean[] truthValues;
    private int size;
    private int nextAvail;

    public DirectoryFilter(int numberOfElements) {
        this.columnNumbers = new int[numberOfElements];
        this.combinationMethods = new int[numberOfElements];
        this.searchAttributes = new int[numberOfElements];
        this.values = new String[numberOfElements];
        this.truthValues = new boolean[numberOfElements];
        this.nextAvail = 0;
        this.size = numberOfElements;
    }

    public boolean matchRow(DirectoryRow row, TableDefinitions tableDefs) throws DirectoryTableException {
        return this.matchRow(row, 1, tableDefs);
    }

    public boolean matchRow(DirectoryRow row, int rowNum, TableDefinitions tableDefs) throws DirectoryTableException {
        boolean ignoreCase;
        boolean bl = ignoreCase = (tableDefs.getTableAttributes() & 8) != 8;
        if (this.nextAvail == 0) {
            return true;
        }
        block11: for (int i = 0; i < this.nextAvail; ++i) {
            String compareValue;
            String columnValue;
            if (ignoreCase) {
                columnValue = row.getColumn(this.columnNumbers[i], rowNum).toLowerCase();
                compareValue = this.values[i].toLowerCase();
            } else {
                columnValue = row.getColumn(this.columnNumbers[i], rowNum);
                compareValue = this.values[i];
            }
            switch (this.searchAttributes[i]) {
                case 1: {
                    this.truthValues[i] = columnValue.indexOf(compareValue) != -1;
                    continue block11;
                }
                case 2: {
                    this.truthValues[i] = columnValue.indexOf(compareValue) == -1;
                    continue block11;
                }
                case 3: {
                    this.truthValues[i] = columnValue.regionMatches(0, compareValue, 0, compareValue.length());
                    continue block11;
                }
                case 9: {
                    this.truthValues[i] = DirectoryTableLibrary.matchRegexp(compareValue, columnValue);
                    continue block11;
                }
                case 4: {
                    this.truthValues[i] = columnValue.regionMatches(columnValue.length() - compareValue.length(), compareValue, 0, compareValue.length());
                    continue block11;
                }
                case 5: {
                    this.truthValues[i] = columnValue.equals(compareValue);
                    continue block11;
                }
                case 6: {
                    this.truthValues[i] = !columnValue.equals(compareValue);
                    continue block11;
                }
                case 7: {
                    this.truthValues[i] = DirectoryUtility.compareColumns(compareValue, columnValue, tableDefs.getColumnAttributes(this.columnNumbers[i]) & 0xE) > 0;
                    continue block11;
                }
                case 8: {
                    this.truthValues[i] = DirectoryUtility.compareColumns(compareValue, columnValue, tableDefs.getColumnAttributes(this.columnNumbers[i]) & 0xE) < 0;
                    continue block11;
                }
                default: {
                    this.truthValues[i] = false;
                }
            }
        }
        int lastOr = 0;
        boolean isOr = false;
        boolean andSatisfied = true;
        if (this.nextAvail > 1) {
            for (int j = 1; j < this.nextAvail; ++j) {
                if (this.combinationMethods[j] != 3) continue;
                isOr = true;
                andSatisfied = true;
                for (int k = lastOr; k < j; ++k) {
                    if (this.truthValues[k]) continue;
                    andSatisfied = false;
                }
                if (andSatisfied) {
                    return true;
                }
                lastOr = j;
            }
            if (isOr) {
                andSatisfied = true;
                for (int k = lastOr; k < this.nextAvail; ++k) {
                    if (this.truthValues[k]) continue;
                    andSatisfied = false;
                }
                if (andSatisfied) {
                    return true;
                }
            }
        }
        if (!isOr) {
            for (int l = 0; l < this.nextAvail; ++l) {
                if (this.truthValues[l]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public DirectoryRow getTemplateAsRow(TableDefinitions tableDefs) throws DirectoryTableException {
        DirectoryRow row = null;
        if (this.nextAvail == 0) {
            return null;
        }
        for (int i = 0; i < this.nextAvail; ++i) {
            if (this.searchAttributes[i] == 5 && this.combinationMethods[i] != 3) {
                if (row == null) {
                    row = new DirectoryRow(tableDefs.getNumberOfColumns(), 1);
                }
            } else {
                return null;
            }
            row.putColumn(this.columnNumbers[i], this.values[i]);
        }
        return row;
    }

    public void add(int colNum, int combinationMethod, int searchAttribute, String value) throws DirectoryTableException {
        if (combinationMethod < 1 || combinationMethod > 3) {
            throw new DirectoryTableInvalidParameterException("EXM_INVALID");
        }
        if (searchAttribute < 1 || searchAttribute > 9) {
            throw new DirectoryTableInvalidParameterException("EXM_INVALID");
        }
        if (this.nextAvail >= this.size) {
            throw new DirectoryTableInvalidParameterException("EXM_INVALID");
        }
        this.columnNumbers[this.nextAvail] = colNum;
        this.combinationMethods[this.nextAvail] = combinationMethod;
        this.searchAttributes[this.nextAvail] = searchAttribute;
        this.values[this.nextAvail] = value;
        ++this.nextAvail;
    }
}

