/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.BitSet;

public class DirectoryMask {
    public static int NONE_SET = -1;
    private BitSet mask;
    private TableDefinitions tableDefinitions;
    private int numberOfColumns;
    private int lastColumnSet;

    public DirectoryMask(TableDefinitions tableDefs) {
        this.tableDefinitions = tableDefs;
        this.numberOfColumns = this.tableDefinitions.getNumberOfColumns();
        this.lastColumnSet = NONE_SET;
        this.mask = new BitSet(this.numberOfColumns);
    }

    public void setColumn(int colNum) throws DirectoryTableException {
        this.mask.set(colNum - 1);
        if (this.lastColumnSet == NONE_SET) {
            this.lastColumnSet = colNum;
        } else if (colNum > this.lastColumnSet) {
            this.lastColumnSet = colNum;
        }
    }

    public void setAllColumns() throws DirectoryTableException {
        for (int i = 0; i < this.numberOfColumns; ++i) {
            this.mask.set(i);
        }
        this.lastColumnSet = this.numberOfColumns;
    }

    public void setIndexedColumns() throws DirectoryTableException {
        int lastSet = NONE_SET;
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if ((this.tableDefinitions.getColumnAttributes(i + 1) & 1) != 1) continue;
            this.mask.set(i);
            lastSet = i + 1;
        }
        if (this.lastColumnSet == NONE_SET) {
            this.lastColumnSet = lastSet;
        } else if (lastSet > this.lastColumnSet) {
            this.lastColumnSet = lastSet;
        }
    }

    public void clearColumn(int colNum) throws DirectoryTableException {
        int i = 0;
        this.mask.clear(colNum - 1);
        if (this.lastColumnSet != NONE_SET && colNum == this.lastColumnSet) {
            for (i = this.lastColumnSet; i > 0; --i) {
                if (!this.mask.get(i - 1)) continue;
                this.lastColumnSet = i;
                break;
            }
            if (i == 0) {
                this.lastColumnSet = NONE_SET;
            }
        }
    }

    public void clearAllColumns() throws DirectoryTableException {
        for (int i = 0; i < this.numberOfColumns; ++i) {
            this.mask.clear(i);
        }
        this.lastColumnSet = NONE_SET;
    }

    public boolean getColumn(int colNum) throws DirectoryTableException {
        return this.mask.get(colNum - 1);
    }

    public int getLastColumnSet() throws DirectoryTableException {
        return this.lastColumnSet;
    }
}

