/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.Compare;
import com.sun.wbem.utility.common.QuickVector;
import com.sun.wbem.utility.common.Sort;
import com.sun.wbem.utility.directorytable.DirectoryRowCompare;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;

public class DirectoryRow
implements SearchTemplate {
    private QuickVector rows;
    private int numberOfColumns;
    private int numberOfRows;
    private boolean isEmpty;
    private int nextRow;

    public DirectoryRow(int numCols, int numRows) {
        String[] columns = null;
        this.rows = new QuickVector(numRows);
        this.rows.setSize(numRows);
        for (int i = 0; i < numRows; ++i) {
            columns = new String[numCols];
            for (int j = 0; j < numCols; ++j) {
                columns[j] = "";
            }
            this.rows.quickSetElementAt(columns, i);
        }
        this.numberOfColumns = numCols;
        this.numberOfRows = numRows;
        this.nextRow = 0;
        this.isEmpty = true;
    }

    public DirectoryRow(int numCols) {
        this(numCols, 1);
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public void addRows(int numRowsToAdd) {
        String[] columns = null;
        this.rows.setSize(numRowsToAdd + this.numberOfRows);
        for (int i = this.numberOfRows; i < numRowsToAdd + this.numberOfRows; ++i) {
            columns = new String[this.numberOfColumns];
            for (int j = 0; j < this.numberOfColumns; ++j) {
                columns[j] = "";
            }
            this.rows.quickSetElementAt(columns, i);
        }
        this.numberOfRows += numRowsToAdd;
    }

    public void deleteRow(int rowToDelete) {
        this.rows.removeElementAt(rowToDelete - 1);
        --this.numberOfRows;
    }

    public void clearRow(int rowToClear) throws DirectoryTableInvalidParameterException {
        String[] columns = null;
        try {
            columns = (String[])this.rows.quickElementAt(rowToClear - 1);
            for (int i = 0; i < this.numberOfColumns; ++i) {
                columns[i] = "";
            }
            if (this.numberOfRows == 1) {
                this.isEmpty = true;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new DirectoryTableInvalidParameterException("EXM_NOROW");
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isEmpty(int row) throws DirectoryTableInvalidParameterException {
        String[] columns = null;
        if (this.numberOfRows < row || row < 1) {
            throw new DirectoryTableInvalidParameterException("EXM_NOROW");
        }
        columns = (String[])this.rows.quickElementAt(row - 1);
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (columns[i].equals("")) continue;
            return false;
        }
        return true;
    }

    public String getColumn(int col) throws DirectoryTableInvalidParameterException {
        return this.getColumn(col, 1);
    }

    public String getColumn(int col, int row) throws DirectoryTableInvalidParameterException {
        String[] columns = null;
        try {
            columns = (String[])this.rows.quickElementAt(row - 1);
            return columns[col - 1];
        }
        catch (IndexOutOfBoundsException e) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
    }

    public void putColumn(int col, String contents) throws DirectoryTableInvalidParameterException {
        this.putColumn(col, 1, contents);
        this.isEmpty = false;
    }

    public void putColumn(int col, int row, String contents) throws DirectoryTableInvalidParameterException {
        String[] columns = null;
        try {
            columns = (String[])this.rows.quickElementAt(row - 1);
            columns[col - 1] = contents;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.isEmpty = false;
    }

    public DirectoryRow extractRows(int firstRow, int lastRow) throws DirectoryTableException {
        if (firstRow < 1 || firstRow > this.numberOfRows) {
            throw new DirectoryTableInvalidParameterException("EXM_NOROW");
        }
        if (lastRow < firstRow || lastRow > this.numberOfRows) {
            throw new DirectoryTableInvalidParameterException("EXM_NOROW");
        }
        DirectoryRow row = new DirectoryRow(this.numberOfColumns, lastRow - firstRow + 1);
        for (int r = firstRow; r <= lastRow; ++r) {
            for (int c = 1; c <= this.numberOfColumns; ++c) {
                row.putColumn(c, r - firstRow + 1, this.getColumn(c, r));
            }
        }
        return row;
    }

    public boolean matchRow(DirectoryRow row, TableDefinitions tableDefs) throws DirectoryTableException {
        return this.matchRow(row, 1, tableDefs);
    }

    public boolean matchRow(DirectoryRow row, int rowNum, TableDefinitions tableDefs) throws DirectoryTableException {
        return this.matchRow(row, rowNum, 1, tableDefs);
    }

    public boolean matchRow(DirectoryRow row, int rowNum, int templateRowNum, TableDefinitions tableDefs) throws DirectoryTableException {
        String[] templateColumns = (String[])this.rows.quickElementAt(templateRowNum - 1);
        if (this.isEmpty) {
            return true;
        }
        boolean caseSensitive = (tableDefs.getTableAttributes() & 8) == 8;
        for (int i = 0; i < this.numberOfColumns; ++i) {
            String columnToMatch;
            String templateColumnValue = templateColumns[i];
            if (templateColumnValue.equals("") || (tableDefs.getColumnAttributes(i + 1) & 1) != 1 || (columnToMatch = row.getColumn(i + 1, rowNum)) == null || !(caseSensitive ? !columnToMatch.equals(templateColumnValue) : !columnToMatch.equalsIgnoreCase(templateColumnValue))) continue;
            return false;
        }
        return true;
    }

    public DirectoryRow getTemplateAsRow(TableDefinitions tableDefs) throws DirectoryTableException {
        return this;
    }

    public int getFirstRow(SearchTemplate template, TableDefinitions tableDefs) throws DirectoryTableException {
        this.nextRow = 1;
        while (this.nextRow <= this.numberOfRows) {
            if (template.matchRow(this, this.nextRow, tableDefs)) {
                return this.nextRow;
            }
            ++this.nextRow;
        }
        return 0;
    }

    public int getNextRow(SearchTemplate template, TableDefinitions tableDefs) throws DirectoryTableException {
        while (this.nextRow <= this.numberOfRows) {
            if (template.matchRow(this, this.nextRow, tableDefs)) {
                return this.nextRow;
            }
            ++this.nextRow;
        }
        return 0;
    }

    public void sortByColumn(int col, TableDefinitions tableDefs) throws DirectoryTableException {
        DirectoryRowCompare comp = new DirectoryRowCompare(col - 1, tableDefs.getColumnAttributes(col) & 0xE);
        Sort.sort(this.rows, (Compare)comp);
    }
}

