/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.UException;
import com.sun.wbem.utility.common.UProps;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DirectoryUtility {
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_ISMASTER = "check";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_PWDIR = "/etc";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_ALIASES = "/etc/mail/aliases";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_DIR = "/etc";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_RBACDIR = "/etc/security";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_MAKEPATH = "/var/yp";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_MAKEFILE = "Makefile";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_UPDATESCHEDULE = "always";
    public static final String DEFAULT_DIRECTORY_TABLE_LDAP_PORT = "389";
    public static final String DIRECTORY_TABLE_LDAP_PORT = "directorytable.ldap.port";
    public static final String DIRECTORY_TABLE_NIS_ISMASTER = "directorytable.nis.ismaster";
    public static final String DIRECTORY_TABLE_NIS_PWDIR = "directorytable.nis.pwdir";
    public static final String DIRECTORY_TABLE_NIS_ALIASES = "directorytable.nis.aliases";
    public static final String DIRECTORY_TABLE_NIS_DIR = "directorytable.nis.dir";
    public static final String DIRECTORY_TABLE_NIS_RBACDIR = "directorytable.nis.rbacdir";
    public static final String DIRECTORY_TABLE_NIS_MAKEPATH = "directorytable.nis.makepath";
    public static final String DIRECTORY_TABLE_NIS_MAKEFILE = "directorytable.nis.makefile";
    public static final String DIRECTORY_TABLE_NIS_UPDATESCHEDULE = "directorytable.nis.updateschedule";
    public static final String DEFAULT_DIRECTORY_TABLE_DNS_NAMEDCONF = "/etc/named.conf";
    public static final String DEFAULT_DIRECTORY_TABLE_DNS_UPDATESCHEDULE = "always";
    public static final String DEFAULT_DIRECTORY_TABLE_DNS_INNAMED = "in.named";
    public static final String DIRECTORY_TABLE_DNS_NAMEDCONF = "directorytable.dns.namedconf";
    public static final String DIRECTORY_TABLE_DNS_UPDATESCHEDULE = "directorytable.dns.updateschedule";
    public static final String DIRECTORY_TABLE_DNS_INNAMED = "directorytable.dns.innamed";

    protected static int compareColumns(String col1, String col2, int dataType) {
        if ((dataType & 8) == 8) {
            return col1.compareTo(col2);
        }
        if ((dataType & 4) == 4) {
            int val1 = Integer.valueOf(col1);
            int val2 = Integer.valueOf(col2);
            return val1 - val2;
        }
        if ((dataType & 2) == 2) {
            return DirectoryTableLibrary.addressCompare(col1, col2);
        }
        return 0;
    }

    protected static String getDirectoryTableProperty(String propName) throws UException {
        UProps dirProps = new UProps("propdir", "WbemUtilityServices.properties", 0);
        return dirProps.getProp(propName);
    }

    protected static Vector getDirectoryTablePropertyList(String propName) throws UException {
        UProps dirProps = new UProps("propdir", "WbemUtilityServices.properties", 0);
        return dirProps.getPropList(propName);
    }

    protected static void setDirectoryTableProperty(String propName, String propValue) throws UException {
        UProps dirProps = new UProps("propdir", "WbemUtilityServices.properties", 1);
        dirProps.putProp(propName, propValue);
        dirProps.saveProps("off");
    }

    protected static String getContextProperty(String context, String propName) {
        int tokenStart = 0;
        int nextSeparator = 0;
        if (propName.equals("serverName")) {
            String prop;
            try {
                prop = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                prop = new String("");
            }
            nextSeparator = context.indexOf("/");
            if (nextSeparator == -1) {
                nextSeparator = context.length();
            }
            if (nextSeparator > 0) {
                prop = context.substring(tokenStart, nextSeparator);
            }
            return prop;
        }
        if (propName.equals("domainName")) {
            String prop = new String("");
            nextSeparator = context.indexOf("/");
            if (nextSeparator == -1) {
                return prop;
            }
            if (nextSeparator == context.length()) {
                return prop;
            }
            tokenStart = nextSeparator + 1;
            if ((nextSeparator = context.indexOf("/", tokenStart)) == -1) {
                nextSeparator = context.length();
            }
            if (nextSeparator - tokenStart > 0 && (prop = context.substring(tokenStart, nextSeparator)).charAt(prop.length() - 1) == '.') {
                prop = prop.substring(0, prop.length() - 1);
            }
            return prop;
        }
        String prop = new String("");
        nextSeparator = context.indexOf("/");
        if (nextSeparator == -1) {
            return prop;
        }
        if (nextSeparator == context.length()) {
            return prop;
        }
        tokenStart = nextSeparator + 1;
        if ((nextSeparator = context.indexOf("/", tokenStart)) == -1) {
            return prop;
        }
        String remainingContext = context.substring(nextSeparator + 1, context.length());
        if (remainingContext.length() > 0) {
            tokenStart = remainingContext.indexOf(propName + " = ");
            if (tokenStart == -1) {
                return prop;
            }
            nextSeparator = (remainingContext = remainingContext.substring(tokenStart + propName.length() + 1, remainingContext.length())).indexOf(", ");
            if (nextSeparator == -1) {
                nextSeparator = remainingContext.length();
            }
            prop = remainingContext.substring(0, nextSeparator);
        }
        return prop;
    }

    protected static boolean isLocalServer(String serverName) {
        String localName = null;
        InetAddress[] localAddresses = null;
        InetAddress serverAddress = null;
        Vector hostnames = DirectoryUtility.getListOfLocalHostnames();
        for (int j = 0; j < hostnames.size(); ++j) {
            String hostname = (String)hostnames.elementAt(j);
            if (!hostname.equals(serverName)) continue;
            return true;
        }
        try {
            localName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return false;
        }
        try {
            localAddresses = InetAddress.getAllByName(localName);
        }
        catch (UnknownHostException e) {
            return false;
        }
        try {
            serverAddress = InetAddress.getByName(serverName);
        }
        catch (UnknownHostException e) {
            return false;
        }
        for (int i = 0; i < localAddresses.length; ++i) {
            if (!localAddresses[i].equals(serverAddress)) continue;
            return true;
        }
        return false;
    }

    static Vector getListOfLocalHostnames() {
        File etcDirectory = new File("/etc");
        Vector<String> hostnames = new Vector<String>();
        if (etcDirectory.isDirectory()) {
            String[] etcFiles = etcDirectory.list();
            for (int i = 0; i < etcFiles.length; ++i) {
                if (!etcFiles[i].startsWith("hostname.")) continue;
                try {
                    BufferedReader readStream = new BufferedReader(new FileReader("/etc/" + etcFiles[i]));
                    String host = readStream.readLine();
                    readStream.close();
                    if (host == null) continue;
                    StringTokenizer st = new StringTokenizer(host);
                    if (st.countTokens() > 1) {
                        hostnames.add(st.nextToken());
                        continue;
                    }
                    hostnames.add(host.trim());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return hostnames;
    }
}

