/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.CommonTools;
import com.sun.wbem.utility.common.UException;
import com.sun.wbem.utility.directorytable.DirectoryMask;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import com.sun.wbem.utility.directorytable.DirectoryTableOperationNotSupportedException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.DnsTableDefinitions;
import com.sun.wbem.utility.directorytable.FileEditor;
import com.sun.wbem.utility.directorytable.NamedConf;
import com.sun.wbem.utility.directorytable.NamedConfSection;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import com.sun.wbem.utility.directorytable.TableSetup;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DnsDirectoryTable
implements DirectoryTable,
TableSetup {
    private static int ROW_INCREMENT = 5;
    FileEditor fileEditor;
    TableDefinitions tableDefinitions;
    boolean singleSeparatorOnly;
    boolean allowsInlineComment;
    boolean allowEscapes;
    boolean caseSensitive;
    boolean needsFlush;
    String serverName;
    String domainName;
    DirectoryMask allSetMask;
    String updateSchedule;
    String innamed;

    public DnsDirectoryTable() {
        try {
            this.updateSchedule = DirectoryUtility.getDirectoryTableProperty("directorytable.dns.updateschedule");
            if (this.updateSchedule == null || this.updateSchedule.equals("")) {
                this.updateSchedule = "always";
            }
        }
        catch (UException a) {
            this.updateSchedule = "always";
        }
        try {
            this.innamed = DirectoryUtility.getDirectoryTableProperty("directorytable.dns.innamed");
            if (this.innamed == null || this.innamed.equals("")) {
                this.innamed = "in.named";
            }
        }
        catch (UException a) {
            this.innamed = "in.named";
        }
    }

    public int access(String tableName) throws DirectoryTableException {
        int access = 0;
        DnsTableDefinitions tableDefinitionsArg = new DnsTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        String checkFile = tableDefinitionsArg.getMappedTableName();
        if (DirectoryTableLibrary.fileAccess(checkFile, 0) != 0) {
            return access;
        }
        if (DirectoryTableLibrary.fileAccess(checkFile, 2) == 0) {
            access |= 0xB;
        }
        if (DirectoryTableLibrary.fileAccess(checkFile, 4) == 0) {
            access |= 4;
        }
        return access;
    }

    public int access(TableDefinitions tableDefinitionsArg) throws DirectoryTableException {
        int access = 0;
        String checkFile = tableDefinitionsArg.getMappedTableName();
        if (DirectoryTableLibrary.fileAccess(checkFile, 0) != 0) {
            return access;
        }
        if (DirectoryTableLibrary.fileAccess(checkFile, 2) == 0) {
            access |= 0xB;
        }
        if (DirectoryTableLibrary.fileAccess(checkFile, 4) == 0) {
            access |= 4;
        }
        return access;
    }

    public void open(String tableName) throws DirectoryTableException {
        DnsTableDefinitions tableDefinitionsArg = new DnsTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        if (DirectoryTableLibrary.fileAccess(tableDefinitionsArg.getMappedTableName(), 0) != 0) {
            throw new DirectoryTableDoesNotExistException(tableName, "dns", tableName);
        }
        this.tableDefinitions = tableDefinitionsArg;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.allowEscapes = (this.tableDefinitions.getTableAttributes() & 0x10) == 16;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void open(TableDefinitions tableDefinitionsArg) throws DirectoryTableException {
        if (DirectoryTableLibrary.fileAccess(tableDefinitionsArg.getMappedTableName(), 0) != 0) {
            throw new DirectoryTableDoesNotExistException(tableDefinitionsArg.getTableName(), "dns", tableDefinitionsArg.getMappedTableName());
        }
        this.tableDefinitions = tableDefinitionsArg;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.allowEscapes = (this.tableDefinitions.getTableAttributes() & 0x10) == 16;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void create(TableDefinitions tableDefinitionsArg) throws DirectoryTableException {
        int mode = 0;
        int ret = 0;
        mode = DirectoryTableLibrary.convertAccessToMode(tableDefinitionsArg.getAccess());
        ret = DirectoryTableLibrary.fileCreate(tableDefinitionsArg.getMappedTableName(), tableDefinitionsArg.getUser(), tableDefinitionsArg.getGroup(), mode);
        DirectoryTableLibrary.errnoToException(ret, tableDefinitionsArg);
        this.tableDefinitions = tableDefinitionsArg;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.allowEscapes = (this.tableDefinitions.getTableAttributes() & 0x10) == 16;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void create(String tableName) throws DirectoryTableException {
        int mode = 0;
        int ret = 0;
        DnsTableDefinitions tableDefinitionsArg = new DnsTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        mode = DirectoryTableLibrary.convertAccessToMode(tableDefinitionsArg.getAccess());
        ret = DirectoryTableLibrary.fileCreate(tableDefinitionsArg.getMappedTableName(), tableDefinitionsArg.getUser(), tableDefinitionsArg.getGroup(), mode);
        DirectoryTableLibrary.errnoToException(ret, tableDefinitionsArg);
        this.tableDefinitions = tableDefinitionsArg;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.allowEscapes = (this.tableDefinitions.getTableAttributes() & 0x10) == 16;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void delete(TableDefinitions tableDefs) throws DirectoryTableException {
        int ret = 0;
        ret = DirectoryTableLibrary.fileDelete(tableDefs.getMappedTableName());
        DirectoryTableLibrary.errnoToException(ret, tableDefs);
    }

    public void delete(String tableName) throws DirectoryTableException {
        int ret = 0;
        DnsTableDefinitions tableDefinitionsArg = new DnsTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        ret = DirectoryTableLibrary.fileDelete(tableDefinitionsArg.getMappedTableName());
        DirectoryTableLibrary.errnoToException(ret, tableDefinitionsArg);
    }

    public void close() {
        try {
            this.flush();
        }
        catch (DirectoryTableException e) {
            this.needsFlush = false;
        }
        this.tableDefinitions = null;
        this.fileEditor = null;
        this.singleSeparatorOnly = false;
        this.allowsInlineComment = false;
        this.allowEscapes = false;
        this.allSetMask = null;
    }

    public void flush() throws DirectoryTableException {
        if (this.needsFlush) {
            String currentLine = this.fileEditor.getFirstLine();
            String newLine = null;
            String[] outputArr = null;
            this.needsFlush = false;
            if (this.isRealDnsTable()) {
                while (currentLine != null) {
                    if (this.isType("SOA", currentLine)) {
                        newLine = this.incrementSoaSerialNumber(currentLine);
                        this.fileEditor.modifyLine(currentLine, newLine);
                        break;
                    }
                    currentLine = this.fileEditor.getNextLine();
                }
                if (this.updateSchedule.equals("always")) {
                    String flushCmd = "/usr/bin/pkill -HUP " + this.innamed;
                    outputArr = CommonTools.CMN_exec(flushCmd);
                    this.needsFlush = false;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRealDnsTable() {
        if (this.tableDefinitions.getTableName().equals("hosts")) return true;
        if (this.tableDefinitions.getTableName().equals("RR_REVIP")) return true;
        if (!this.tableDefinitions.getTableName().equals("RR")) return false;
        return true;
    }

    private boolean isType(String typename, String line) {
        int i = 0;
        boolean isClass = false;
        StringTokenizer st = new StringTokenizer(line, "\t ");
        if (!this.isRealDnsTable()) {
            return true;
        }
        if (typename.equals("")) {
            return isClass;
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            token.trim();
            if (token.equals(typename) && (++i == 3 || i == 4)) {
                isClass = true;
            }
            if (i <= 4) continue;
            break;
        }
        return isClass;
    }

    private String incrementSoaSerialNumber(String line) {
        int i = 0;
        boolean isSOA = false;
        String newLine = "";
        StringTokenizer st = new StringTokenizer(line, "\t ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            token.trim();
            ++i;
            newLine = newLine + token + " ";
            if (!token.equals("(") || !st.hasMoreTokens()) continue;
            int serial = 0;
            token = st.nextToken();
            serial = Integer.valueOf(token);
            token = String.valueOf(++serial);
            newLine = newLine + token + " ";
        }
        return newLine;
    }

    public void addRow(DirectoryRow row) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        String typename = this.fillInRequiredColumns(row);
        int i = 0;
        DirectoryRow checkRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String currentLine = this.fileEditor.getFirstLine();
        if (currentLine != null) {
            if (this.isType(typename, currentLine)) {
                this.parseStringIntoRow(currentLine, checkRow, 1, this.allSetMask);
                if (!checkRow.isEmpty()) {
                    for (i = 1; i <= row.getNumberOfRows(); ++i) {
                        if (!row.matchRow(checkRow, 1, i, this.tableDefinitions)) continue;
                        throw new DirectoryTableRowNotUniqueException();
                    }
                }
            }
            currentLine = this.fileEditor.getNextLine();
            while (currentLine != null) {
                if (this.isType(typename, currentLine)) {
                    checkRow.clearRow(1);
                    this.parseStringIntoRow(currentLine, checkRow, 1, this.allSetMask);
                    if (!checkRow.isEmpty()) {
                        for (i = 1; i <= row.getNumberOfRows(); ++i) {
                            if (!row.matchRow(checkRow, 1, i, this.tableDefinitions)) continue;
                            throw new DirectoryTableRowNotUniqueException();
                        }
                    }
                }
                currentLine = this.fileEditor.getNextLine();
            }
        }
        for (i = 1; i <= row.getNumberOfRows(); ++i) {
            String lineToAdd = this.getRowAsString(row, i);
            this.fileEditor.addLine(lineToAdd);
        }
        this.needsFlush = true;
    }

    public void deleteRow(DirectoryRow row) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        String typename = this.fillInRequiredColumns(row);
        int i = 0;
        DirectoryRow checkRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String currentLine = this.fileEditor.getFirstLine();
        int numRows = row.getNumberOfRows();
        Vector<String> linesToDelete = new Vector<String>();
        linesToDelete.setSize(numRows);
        if (currentLine != null) {
            if (this.isType(typename, currentLine)) {
                this.parseStringIntoRow(currentLine, checkRow, 1, this.allSetMask);
                if (!checkRow.isEmpty()) {
                    for (i = 1; i <= numRows; ++i) {
                        if (!row.matchRow(checkRow, 1, i, this.tableDefinitions)) continue;
                        linesToDelete.setElementAt(currentLine, i - 1);
                    }
                }
            }
            currentLine = this.fileEditor.getNextLine();
            while (currentLine != null) {
                if (this.isType(typename, currentLine)) {
                    checkRow.clearRow(1);
                    this.parseStringIntoRow(currentLine, checkRow, 1, this.allSetMask);
                    if (!checkRow.isEmpty()) {
                        for (i = 1; i <= numRows; ++i) {
                            if (!row.matchRow(checkRow, 1, i, this.tableDefinitions)) continue;
                            linesToDelete.setElementAt(currentLine, i - 1);
                        }
                    }
                }
                currentLine = this.fileEditor.getNextLine();
            }
        }
        for (i = 0; i < numRows; ++i) {
            if (linesToDelete.elementAt(i) != null) continue;
            throw new DirectoryTableRowNotFoundException();
        }
        for (i = 0; i < numRows; ++i) {
            this.fileEditor.deleteLine((String)linesToDelete.elementAt(i));
        }
        this.needsFlush = true;
    }

    public void modifyRow(DirectoryRow searchRow, DirectoryRow replaceRow) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        String typename = this.fillInRequiredColumns(searchRow);
        String typename2 = this.fillInRequiredColumns(replaceRow);
        DirectoryRow row = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String currentLine = this.fileEditor.getFirstLine();
        String replaceLine = this.getRowAsString(replaceRow, 1);
        if (currentLine == null) {
            throw new DirectoryTableRowNotFoundException();
        }
        String matchLine = currentLine;
        if (this.isType(typename, currentLine)) {
            this.parseStringIntoRow(currentLine, row, 1, this.allSetMask);
            if (row.getNumberOfColumns() > 0 && searchRow.matchRow(row, 1, this.tableDefinitions)) {
                this.fileEditor.modifyLine(matchLine, replaceLine);
                this.needsFlush = true;
                return;
            }
        }
        currentLine = this.fileEditor.getNextLine();
        while (currentLine != null) {
            row.clearRow(1);
            matchLine = currentLine;
            if (this.isType(typename, currentLine)) {
                this.parseStringIntoRow(currentLine, row, 1, this.allSetMask);
                if (row.getNumberOfColumns() > 0 && searchRow.matchRow(row, 1, this.tableDefinitions)) {
                    this.fileEditor.modifyLine(matchLine, replaceLine);
                    this.needsFlush = true;
                    return;
                }
            }
            currentLine = this.fileEditor.getNextLine();
        }
        throw new DirectoryTableRowNotFoundException();
    }

    public DirectoryRow getFirstRow() throws DirectoryTableException {
        DirectoryRow emptyRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getFirstRow(emptyRow);
    }

    public DirectoryRow getNextRow() throws DirectoryTableException {
        DirectoryRow emptyRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getNextRow(emptyRow);
    }

    public DirectoryRow getFirstRow(SearchTemplate template) throws DirectoryTableException {
        DirectoryRow row = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String currentLine = this.fileEditor.getFirstLine();
        String typename = this.tableDefinitions.getAuxilliaryColumnData(this.tableDefinitions.getColumnNumber("type"));
        if (currentLine == null) {
            return null;
        }
        if (this.isType(typename, currentLine)) {
            this.parseStringIntoRow(currentLine, row, 1, this.allSetMask);
            if (!row.isEmpty() && template.matchRow(row, 1, this.tableDefinitions)) {
                return row;
            }
        }
        currentLine = this.fileEditor.getNextLine();
        while (currentLine != null) {
            if (this.isType(typename, currentLine)) {
                row.clearRow(1);
                this.parseStringIntoRow(currentLine, row, 1, this.allSetMask);
                if (!row.isEmpty() && template.matchRow(row, 1, this.tableDefinitions)) {
                    return row;
                }
            }
            currentLine = this.fileEditor.getNextLine();
        }
        return null;
    }

    public DirectoryRow getNextRow(SearchTemplate template) throws DirectoryTableException {
        DirectoryRow row = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String typename = this.tableDefinitions.getAuxilliaryColumnData(this.tableDefinitions.getColumnNumber("type"));
        String currentLine = this.fileEditor.getNextLine();
        while (currentLine != null) {
            if (this.isType(typename, currentLine)) {
                row.clearRow(1);
                this.parseStringIntoRow(currentLine, row, 1, this.allSetMask);
                if (!row.isEmpty() && template.matchRow(row, 1, this.tableDefinitions)) {
                    return row;
                }
            }
            currentLine = this.fileEditor.getNextLine();
        }
        return null;
    }

    public DirectoryRow getAll() throws DirectoryTableException {
        return this.getAll(this.allSetMask);
    }

    public DirectoryRow getAll(DirectoryMask mask) throws DirectoryTableException {
        DirectoryRow row = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), ROW_INCREMENT);
        String currentLine = this.fileEditor.getFirstLine();
        int currentRow = 1;
        int rowsRemaining = ROW_INCREMENT;
        int lastColsParsed = 0;
        String typename = this.tableDefinitions.getAuxilliaryColumnData(this.tableDefinitions.getColumnNumber("type"));
        if (currentLine == null) {
            return null;
        }
        if (this.isType(typename, currentLine) && (lastColsParsed = this.parseStringIntoRow(currentLine, row, currentRow, mask)) > 0) {
            if (--rowsRemaining == 0) {
                row.addRows(ROW_INCREMENT);
                rowsRemaining = ROW_INCREMENT;
            }
            ++currentRow;
        }
        currentLine = this.fileEditor.getNextLine();
        while (currentLine != null) {
            if (this.isType(typename, currentLine) && (lastColsParsed = this.parseStringIntoRow(currentLine, row, currentRow, mask)) > 0) {
                if (--rowsRemaining == 0) {
                    row.addRows(ROW_INCREMENT);
                    rowsRemaining = ROW_INCREMENT;
                }
                ++currentRow;
            }
            currentLine = this.fileEditor.getNextLine();
        }
        if (currentRow == 1 && row.isEmpty(currentRow)) {
            return null;
        }
        for (int i = rowsRemaining - 1; i >= 0; --i) {
            row.deleteRow(currentRow + i);
        }
        return row;
    }

    public DirectoryRow getAll(SearchTemplate template) throws DirectoryTableException {
        return this.getAll(template, this.allSetMask);
    }

    public DirectoryRow getAll(SearchTemplate template, DirectoryMask mask) throws DirectoryTableException {
        DirectoryRow tempRow = null;
        DirectoryRow row = null;
        String currentLine = this.fileEditor.getFirstLine();
        int currentRow = 0;
        String typename = this.tableDefinitions.getAuxilliaryColumnData(this.tableDefinitions.getColumnNumber("type"));
        if (currentLine == null) {
            return row;
        }
        tempRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
        if (this.isType(typename, currentLine)) {
            this.parseStringIntoRow(currentLine, tempRow, 1, mask);
            if (!tempRow.isEmpty() && template.matchRow(tempRow, 1, this.tableDefinitions)) {
                if (currentRow == 0) {
                    row = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
                    currentRow = 1;
                }
                this.parseStringIntoRow(currentLine, row, currentRow, mask);
                ++currentRow;
            }
        }
        currentLine = this.fileEditor.getNextLine();
        while (currentLine != null) {
            if (this.isType(typename, currentLine)) {
                tempRow.clearRow(1);
                this.parseStringIntoRow(currentLine, tempRow, 1, mask);
                if (!tempRow.isEmpty() && template.matchRow(tempRow, 1, this.tableDefinitions)) {
                    if (currentRow == 0) {
                        row = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
                        currentRow = 1;
                    } else {
                        row.addRows(1);
                    }
                    this.parseStringIntoRow(currentLine, row, currentRow, mask);
                    ++currentRow;
                }
            }
            currentLine = this.fileEditor.getNextLine();
        }
        return row;
    }

    public DirectoryRow getRowInstance() {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
    }

    public DirectoryRow getRowInstance(int rows) {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), rows);
    }

    public TableDefinitions getTableDefinitionsInstance() {
        return new DnsTableDefinitions(this.serverName, this.domainName);
    }

    public DirectoryMask getDirectoryMaskInstance() {
        return new DirectoryMask(this.tableDefinitions);
    }

    public TableDefinitions getCurrentTableDefinitions() {
        return this.tableDefinitions;
    }

    private String fillInRequiredColumns(DirectoryRow row) {
        int i = 0;
        int numRows = row.getNumberOfRows();
        String typename = "";
        try {
            int typeCol = this.tableDefinitions.getColumnNumber("type");
            int classCol = this.tableDefinitions.getColumnNumber("class");
            for (i = 1; i <= numRows; ++i) {
                if (row.getColumn(typeCol).equals("")) {
                    row.putColumn(typeCol, this.tableDefinitions.getAuxilliaryColumnData(typeCol));
                }
                typename = row.getColumn(typeCol);
                if (!row.getColumn(classCol).equals("")) continue;
                row.putColumn(classCol, this.tableDefinitions.getAuxilliaryColumnData(classCol));
            }
        }
        catch (DirectoryTableException e) {
            // empty catch block
        }
        return typename;
    }

    private int parseStringIntoRow(String rawString, DirectoryRow row, int rowNum, DirectoryMask mask) throws DirectoryTableException {
        int i;
        int j;
        int numColsParsed = 0;
        char[] chars = rawString.toCharArray();
        int lastChar = chars.length;
        char[] cseps = this.tableDefinitions.getCommentSeparators().toCharArray();
        int csepsLen = cseps.length;
        char[] seps = this.tableDefinitions.getColumnSeparators().toCharArray();
        int sepsLen = seps.length;
        boolean foundChars = false;
        for (j = 0; j < lastChar; ++j) {
            if (sepsLen > 1) {
                for (i = 1; i < sepsLen; ++i) {
                    if (chars[j] != seps[i]) continue;
                    chars[j] = seps[0];
                }
            }
            if (!foundChars && chars[j] != seps[0]) {
                foundChars = true;
            }
            for (i = 0; i < csepsLen; ++i) {
                if (chars[j] != cseps[i]) continue;
                if (j == 0) {
                    return numColsParsed;
                }
                if (!this.allowsInlineComment || j >= lastChar) continue;
                if (mask.getColumn(this.tableDefinitions.getNumberOfColumns())) {
                    row.putColumn(this.tableDefinitions.getNumberOfColumns(), rowNum, new String(chars, j + 1, lastChar - j - 1));
                }
                ++numColsParsed;
                lastChar = j;
            }
        }
        if (!foundChars) {
            return numColsParsed;
        }
        char d = seps[0];
        int columnNumber = 1;
        i = 0;
        if (i < lastChar && chars[i] == d) {
            ++i;
        }
        while (i < lastChar && chars[i] == d) {
            ++i;
            if (!this.singleSeparatorOnly) continue;
            ++columnNumber;
        }
        while (i < lastChar) {
            if (this.tableDefinitions.getColumnName(columnNumber).equals("data") || (this.tableDefinitions.getColumnAttributes(columnNumber) & 0x40) > 0) {
                if (mask.getColumn(columnNumber)) {
                    row.putColumn(columnNumber, rowNum, new String(chars, i, lastChar - i));
                }
                return ++numColsParsed;
            }
            for (j = i; j < lastChar && chars[j] != d; ++j) {
            }
            if (j != i) {
                if (this.tableDefinitions.getColumnName(columnNumber).equals("ttl")) {
                    try {
                        int ttl = Integer.valueOf(new String(chars, i, j - i));
                    }
                    catch (NumberFormatException e) {
                        ++columnNumber;
                    }
                }
                if (mask.getColumn(columnNumber)) {
                    row.putColumn(columnNumber, rowNum, new String(chars, i, j - i));
                }
                ++columnNumber;
                ++numColsParsed;
            }
            for (i = j + 1; i < lastChar && chars[i] == d; ++i) {
                if (!this.singleSeparatorOnly) continue;
                ++columnNumber;
            }
        }
        return numColsParsed;
    }

    private String getRowAsString(DirectoryRow row, int rowNum) throws DirectoryTableException {
        int lastCol;
        String columnToString = "";
        char columnSeparator = this.tableDefinitions.getColumnSeparators().charAt(0);
        char commentSeparator = this.tableDefinitions.getCommentSeparators().charAt(0);
        int commentCol = 0;
        if (this.allowsInlineComment) {
            lastCol = this.tableDefinitions.getNumberOfColumns() - 1;
            commentCol = this.tableDefinitions.getNumberOfColumns();
        } else {
            lastCol = this.tableDefinitions.getNumberOfColumns();
        }
        for (int i = 1; i <= lastCol; ++i) {
            if (i != 1) {
                columnToString = columnToString + columnSeparator;
            }
            if (row.getColumn(i, rowNum).equals("")) continue;
            columnToString = columnToString.concat(row.getColumn(i, rowNum));
        }
        if (this.allowsInlineComment && !row.getColumn(commentCol, rowNum).equals("")) {
            columnToString = columnToString.concat(commentSeparator + row.getColumn(commentCol, rowNum));
        }
        return columnToString;
    }

    public void setContext(String context) throws DirectoryTableException {
        this.serverName = DirectoryUtility.getContextProperty(context, "serverName");
        this.domainName = DirectoryUtility.getContextProperty(context, "domainName");
        if (!DirectoryUtility.isLocalServer(this.serverName)) {
            throw new DirectoryTableOperationNotSupportedException("Remote DNS");
        }
    }

    private Vector getDomains(int flags) {
        Vector attr = null;
        Vector mods = null;
        Vector<String> domains = null;
        String zone = null;
        try {
            NamedConf namedConf = new NamedConf();
            if ((flags & 2) == 2 ? DirectoryTableLibrary.fileAccess(namedConf.getFileName(), 2) != 0 : DirectoryTableLibrary.fileAccess(namedConf.getFileName(), 4) != 0) {
                return null;
            }
            namedConf.load();
            Vector namedConfSections = namedConf.getSections("zone");
            if (namedConfSections != null) {
                domains = new Vector<String>();
                for (int i = 0; i < namedConfSections.size(); ++i) {
                    NamedConfSection namedConfSection = (NamedConfSection)namedConfSections.get(i);
                    mods = namedConfSection.getSectionModifiers();
                    if (mods == null || (zone = (String)mods.get(0)).toUpperCase().endsWith("IN-ADDR.ARPA") || (attr = namedConfSection.getAttributeValue("type")) == null || !attr.get(0).equals("master")) continue;
                    domains.addElement(zone);
                }
            }
            if (domains != null && domains.size() > 0) {
                return domains;
            }
            domains = null;
            return null;
        }
        catch (DirectoryTableException d) {
            return null;
        }
    }

    public Vector getScopes(int flags) {
        String localServer;
        Vector domains = null;
        Vector<String> scopes = null;
        try {
            localServer = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            localServer = "";
        }
        domains = this.getDomains(flags);
        if (domains == null || domains.size() <= 0) {
            return scopes;
        }
        scopes = new Vector<String>();
        for (int i = 0; i < domains.size(); ++i) {
            scopes.addElement("dns:/" + localServer + "/" + domains.elementAt(i));
        }
        domains = null;
        return scopes;
    }

    public void setup() {
    }

    public void refreshSetup() {
    }
}

