/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.NamedConf;
import com.sun.wbem.utility.directorytable.NamedConfSection;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.StringTokenizer;
import java.util.Vector;

public class DnsTableDefinitions
implements TableDefinitions {
    static int NUMBER_OF_TABLES = 8;
    static int TABLE_NAME = 0;
    static int MAPPED_TABLE_NAME = 1;
    static int COLUMN_SEPARATORS = 2;
    static int COMMENT_SEPARATORS = 3;
    static int USERID = 4;
    static int GROUPID = 5;
    static int ACCESS = 6;
    static int TABLE_ATTRIBUTES = 7;
    static int NUMBER_OF_COLUMNS = 8;
    static int USER_DEFINED = 99;
    static String[][] definitions = new String[][]{{"hosts", "%DBFILE%", " \t", ";", "0", "3", Integer.toString(273), Integer.toString(132), "7", "cname", "owner", "", Integer.toString(9), "ttl", "ttl", "", Integer.toString(20), "class", "class", "IN", Integer.toString(9), "type", "type", "A", Integer.toString(9), "addr", "data", "", Integer.toString(3), "aliases", "aliases", "CNAME", Integer.toString(9), "comment", "comment", "", Integer.toString(8)}, {"user_attr", "/etc/user_attr", ":", "; ", "0", "3", Integer.toString(287), Integer.toString(42), "5", "name", "", "", Integer.toString(9), "qualifier", "", "", Integer.toString(9), "res1", "", "", Integer.toString(8), "res2", "", "", Integer.toString(8), "attr", "", "", Integer.toString(8)}, {"auth_attr", "/etc/security/auth_attr", ":", "; ", "0", "3", Integer.toString(287), Integer.toString(42), "6", "name", "", "", Integer.toString(9), "res1", "", "", Integer.toString(8), "res2", "", "", Integer.toString(8), "short_descr", "", "", Integer.toString(8), "long_descr", "", "", Integer.toString(8), "attr", "", "", Integer.toString(8)}, {"RR_REVIP", "%DBFILE%", " \t", ";", "0", "3", Integer.toString(287), Integer.toString(132), "6", "addr", "owner", "", Integer.toString(9), "ttl", "ttl", "", Integer.toString(25), "class", "class", "IN", Integer.toString(9), "type", "type", "PTR", Integer.toString(9), "cname", "data", "", Integer.toString(9), "comment", "comment", "", Integer.toString(8)}, {"ethers", "/etc/ethers", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(4), "5", "addr", "", "", Integer.toString(3), "name", "", "", Integer.toString(9), "class", "class", "", Integer.toString(9), "type", "type", "", Integer.toString(9), "comment", "", "", Integer.toString(8)}, {"bootparams", "/etc/bootparams", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(36), "5", "clientname", "", "", Integer.toString(9), "identifiers", "", "", Integer.toString(72), "class", "class", "", Integer.toString(9), "type", "type", "", Integer.toString(9), "comment", "", "", Integer.toString(8)}, {"timezone", "/etc/timezone", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "5", "timezone", "", "", Integer.toString(8), "domain", "", "", Integer.toString(9), "class", "class", "", Integer.toString(9), "type", "type", "", Integer.toString(9), "comment", "", "", Integer.toString(8)}, {"RR", "%DBFILE%", " \t", ";", "0", "3", Integer.toString(287), Integer.toString(132), "5", "owner", "", "", Integer.toString(9), "ttl", "", "", Integer.toString(25), "class", "", "", Integer.toString(9), "type", "", "", Integer.toString(9), "data", "", "", Integer.toString(9)}};
    int tableIndex = USER_DEFINED;
    String tableName = "";
    String tableType = "";
    String mappedTableName = "";
    String columnSeparators = " \t";
    String commentSeparators = "; ";
    int numberOfColumns;
    int tableAttributes = 0;
    int[] columnAttributes = null;
    String[] columnNames = null;
    String[] mappedColumnNames = null;
    String[] secondaryMappedColumnNames = null;
    int userId = 0;
    int groupId = 3;
    int access = 273;
    String serverName;
    String domainName;
    String db_file;

    public DnsTableDefinitions(String server, String domain) {
        this.domainName = domain;
        this.serverName = server;
        this.db_file = this.getDbFileName();
    }

    public void loadTableDefinitions(String tableName) throws DirectoryTableInvalidParameterException {
        int i;
        this.tableName = tableName;
        for (i = 0; i < NUMBER_OF_TABLES; ++i) {
            if (!tableName.equalsIgnoreCase(definitions[i][TABLE_NAME])) continue;
            this.tableIndex = i;
            this.tableName = definitions[i][TABLE_NAME];
            this.tableType = this.tableName + "_tbl";
            this.mappedTableName = definitions[i][MAPPED_TABLE_NAME];
            this.columnSeparators = definitions[i][COLUMN_SEPARATORS];
            this.commentSeparators = definitions[i][COMMENT_SEPARATORS];
            this.userId = Integer.valueOf(definitions[i][USERID]);
            this.groupId = Integer.valueOf(definitions[i][GROUPID]);
            this.access = Integer.valueOf(definitions[i][ACCESS]);
            this.tableAttributes = Integer.valueOf(definitions[i][TABLE_ATTRIBUTES]);
            this.numberOfColumns = Integer.valueOf(definitions[i][NUMBER_OF_COLUMNS]);
            this.columnNames = new String[this.numberOfColumns];
            this.mappedColumnNames = new String[this.numberOfColumns];
            this.secondaryMappedColumnNames = new String[this.numberOfColumns];
            this.columnAttributes = new int[this.numberOfColumns];
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.columnNames[j] = definitions[i][NUMBER_OF_COLUMNS + j * 4 + 1];
                this.mappedColumnNames[j] = definitions[i][NUMBER_OF_COLUMNS + j * 4 + 2];
                this.secondaryMappedColumnNames[j] = definitions[i][NUMBER_OF_COLUMNS + j * 4 + 3];
                this.columnAttributes[j] = Integer.valueOf(definitions[i][NUMBER_OF_COLUMNS + j * 4 + 4]);
            }
            break;
        }
        if (i == NUMBER_OF_TABLES) {
            throw new DirectoryTableInvalidParameterException("EXM_NOTABLEDEF", tableName);
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String getColumnName(int col) throws DirectoryTableInvalidParameterException {
        if (col < 0 || col > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.columnNames[col - 1];
    }

    public String getMappedColumnName(int col) throws DirectoryTableInvalidParameterException {
        if (col < 0 || col > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.mappedColumnNames[col - 1];
    }

    public String getAuxilliaryColumnData(int col) throws DirectoryTableInvalidParameterException {
        if (col < 0 || col > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.secondaryMappedColumnNames[col - 1];
    }

    public int getColumnNumber(String name) throws DirectoryTableInvalidParameterException {
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (!this.columnNames[i].equalsIgnoreCase(name)) continue;
            return i + 1;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getColumnAttributes(int col) throws DirectoryTableInvalidParameterException {
        if (col <= this.numberOfColumns && col > 0) {
            return this.columnAttributes[col - 1];
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getTableAttributes() {
        return this.tableAttributes;
    }

    public String getRawMappedTableName() {
        return this.mappedTableName;
    }

    public String getMappedTableName() {
        return this.expandMacros(this.mappedTableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getCommentSeparators() {
        return this.commentSeparators;
    }

    public String getColumnSeparators() {
        return this.columnSeparators;
    }

    public int getUser() {
        return this.userId;
    }

    public int getGroup() {
        return this.groupId;
    }

    public int getAccess() {
        return this.access;
    }

    public void setNumberOfColumns(int size) throws DirectoryTableInvalidParameterException {
        if (size < 0) {
            throw new DirectoryTableInvalidParameterException();
        }
        this.numberOfColumns = size;
        this.columnNames = new String[this.numberOfColumns];
        this.columnAttributes = new int[this.numberOfColumns];
    }

    public void setColumnName(int col, String name) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnNames[col - 1] = name;
    }

    public void setMappedColumnName(int col, String name) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.mappedColumnNames[col - 1] = name;
    }

    public void setAuxilliaryColumnData(int col, String name) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.secondaryMappedColumnNames[col - 1] = name;
    }

    public void setColumnAttributes(int col, int attributes) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnAttributes[col - 1] = attributes;
    }

    public void setTableAttributes(int attributes) {
        this.tableAttributes = attributes;
    }

    public void setMappedTableName(String mappedName) {
        this.mappedTableName = mappedName;
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    public void setTableType(String tblType) {
        this.tableType = tblType;
    }

    public void setCommentSeparators(String separators) {
        this.commentSeparators = separators;
    }

    public void setColumnSeparators(String separators) {
        this.columnSeparators = separators;
    }

    public void setUser(int user) {
        this.userId = user;
    }

    public void setGroup(int group) {
        this.groupId = group;
    }

    public void setAccess(int acc) {
        this.access = acc;
    }

    private String expandMacros(String unexpanded) {
        String expanded = "";
        String tok = null;
        StringTokenizer unexpandedTokens = null;
        unexpandedTokens = new StringTokenizer(unexpanded, "%");
        while (unexpandedTokens.hasMoreTokens()) {
            tok = unexpandedTokens.nextToken();
            if (tok.compareTo("DBFILE") == 0) {
                expanded = expanded + this.db_file;
                continue;
            }
            expanded = expanded + tok;
        }
        return expanded;
    }

    private String getDbFileName() {
        Vector attr = null;
        Vector mods = null;
        String directoryRel = "";
        String fileName = "";
        try {
            NamedConfSection namedConfSection;
            int i;
            NamedConf namedConf = new NamedConf();
            namedConf.load();
            Vector namedConfSections = namedConf.getSections("options");
            if (namedConfSections != null) {
                for (i = 0; i < namedConfSections.size(); ++i) {
                    namedConfSection = (NamedConfSection)namedConfSections.get(i);
                    attr = namedConfSection.getAttributeValue("directory");
                    if (attr == null) continue;
                    directoryRel = (String)attr.get(0);
                }
            }
            if ((namedConfSections = namedConf.getSections("zone")) != null) {
                for (i = 0; i < namedConfSections.size(); ++i) {
                    namedConfSection = (NamedConfSection)namedConfSections.get(i);
                    mods = namedConfSection.getSectionModifiers();
                    if (mods == null || !mods.get(0).equals(this.domainName) || (attr = namedConfSection.getAttributeValue("type")) == null || !attr.get(0).equals("master")) continue;
                    fileName = (String)namedConfSection.getAttributeValue("file").get(0);
                }
            }
            return directoryRel + "/" + fileName;
        }
        catch (DirectoryTableException d) {
            return "";
        }
    }
}

