/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.TableDefinitions;

public class FileTableDefinitions
implements TableDefinitions {
    static int NUMBER_OF_TABLES = 35;
    static int TABLE_NAME = 0;
    static int MAPPED_TABLE_NAME = 1;
    static int COLUMN_SEPARATORS = 2;
    static int COMMENT_SEPARATORS = 3;
    static int USERID = 4;
    static int GROUPID = 5;
    static int ACCESS = 6;
    static int TABLE_ATTRIBUTES = 7;
    static int NUMBER_OF_COLUMNS = 8;
    static int USER_DEFINED = 99;
    static String[][] definitions = new String[][]{{"sharetab", "/etc/dfs/sharetab", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(4), "5", "pathname", Integer.toString(9), "resource", Integer.toString(8), "fstype", Integer.toString(8), "options", Integer.toString(8), "description", Integer.toString(72)}, {"dfstab", "/etc/dfs/dfstab", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(4), "2", "command", Integer.toString(73), "comment", Integer.toString(9)}, {"mounttab", "/etc/vfstab", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "8", "resource", Integer.toString(9), "fsckDevice", Integer.toString(8), "mountPoint", Integer.toString(9), "fsType", Integer.toString(8), "fsckPass", Integer.toString(8), "bootMount", Integer.toString(8), "options", Integer.toString(8), "filler", Integer.toString(8)}, {"usagetable", "", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "7", "fileSystem", Integer.toString(8), "totalBytes", Integer.toString(8), "usedBytes", Integer.toString(8), "availBytes", Integer.toString(8), "capacity", Integer.toString(8), "mountPoint", Integer.toString(8), "filler", Integer.toString(8)}, {"nfssec", "/etc/nfssec.conf", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "6", "modename", Integer.toString(9), "modenumber", Integer.toString(8), "gssname", Integer.toString(8), "gssquality", Integer.toString(8), "gssservices", Integer.toString(8), "comment", Integer.toString(8)}, {"netconfig", "/etc/netconfig", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "8", "networkId", Integer.toString(9), "semantics", Integer.toString(8), "flags", Integer.toString(8), "protoFamily", Integer.toString(8), "protoName", Integer.toString(8), "device", Integer.toString(8), "nameToAddrLibs", Integer.toString(8), "filler", Integer.toString(8)}, {"ethers", "/etc/ethers", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(4), "3", "addr", Integer.toString(3), "name", Integer.toString(9), "comment", Integer.toString(8)}, {"bootparams", "/etc/bootparams", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(36), "3", "clientname", Integer.toString(9), "identifiers", Integer.toString(72), "comment", Integer.toString(8)}, {"netmasks", "/etc/inet/netmasks", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "3", "addr", Integer.toString(3), "mask", Integer.toString(3), "comment", Integer.toString(8)}, {"timezone", "/etc/timezone", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "3", "timezone", Integer.toString(8), "domain", Integer.toString(9), "comment", Integer.toString(8)}, {"group", "/etc/group", ":", "#", "0", "3", Integer.toString(287), Integer.toString(10), "4", "name", Integer.toString(9), "passwd", Integer.toString(8), "gid", Integer.toString(5), "members", Integer.toString(8)}, {"hosts", "/etc/inet/hosts", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "4", "addr", Integer.toString(3), "cname", Integer.toString(9), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"networks", "/etc/inet/networks", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(20), "4", "cname", Integer.toString(9), "addr", Integer.toString(3), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"passwd", "/etc/passwd", ":", "#", "0", "3", Integer.toString(287), Integer.toString(10), "7", "name", Integer.toString(9), "passwd", Integer.toString(8), "uid", Integer.toString(5), "gid", Integer.toString(4), "gcos", Integer.toString(8), "home", Integer.toString(8), "shell", Integer.toString(8)}, {"shadow", "/etc/shadow", ":", "#", "0", "3", Integer.toString(1), Integer.toString(10), "9", "name", Integer.toString(9), "passwd", Integer.toString(8), "lastchg", Integer.toString(8), "min", Integer.toString(8), "max", Integer.toString(8), "warn", Integer.toString(8), "inactive", Integer.toString(8), "expire", Integer.toString(8), "flag", Integer.toString(8)}, {"protocols", "/etc/inet/protocols", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "4", "cname", Integer.toString(9), "number", Integer.toString(9), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"services", "/etc/inet/services", " \t/", "#", "0", "3", Integer.toString(273), Integer.toString(4), "5", "cname", Integer.toString(9), "port", Integer.toString(5), "proto", Integer.toString(9), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"rpc", "/etc/rpc", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(4), "4", "cname", Integer.toString(9), "number", Integer.toString(5), "aliases", Integer.toString(73), "comment", Integer.toString(8)}, {"aliases", "/etc/mail/aliases", ":", "#", "0", "3", Integer.toString(287), Integer.toString(70), "3", "alias", Integer.toString(9), "expansion", Integer.toString(72), "comment", Integer.toString(8)}, {"auto_master", "/etc/auto_master", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(8), "2", "key", Integer.toString(9), "value", Integer.toString(73)}, {"auto_home", "/etc/auto_home", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(8), "2", "key", Integer.toString(9), "value", Integer.toString(72)}, {"user_attr", "/etc/user_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "5", "name", Integer.toString(9), "qualifier", Integer.toString(9), "res1", Integer.toString(8), "res2", Integer.toString(8), "attr", Integer.toString(8)}, {"auth_attr", "/etc/security/auth_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "6", "name", Integer.toString(9), "res1", Integer.toString(8), "res2", Integer.toString(8), "short_descr", Integer.toString(8), "long_descr", Integer.toString(8), "attr", Integer.toString(8)}, {"prof_attr", "/etc/security/prof_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "5", "name", Integer.toString(9), "res1", Integer.toString(8), "res2", Integer.toString(8), "long_descr", Integer.toString(8), "attr", Integer.toString(8)}, {"exec_attr", "/etc/security/exec_attr", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "7", "name", Integer.toString(9), "policy", Integer.toString(9), "type", Integer.toString(8), "res1", Integer.toString(8), "res2", Integer.toString(8), "id", Integer.toString(9), "attr", Integer.toString(8)}, {"audit_user", "/etc/security/audit_user", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "3", "name", Integer.toString(9), "alwaysauditflags", Integer.toString(8), "neverauditflags", Integer.toString(8)}, {"audit_class", "/etc/security/audit_class", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "3", "mask", Integer.toString(8), "name", Integer.toString(9), "desc", Integer.toString(8)}, {"project", "/etc/project", ":", "#", "0", "3", Integer.toString(287), Integer.toString(10), "6", "name", Integer.toString(9), "id", Integer.toString(8), "comment", Integer.toString(8), "user", Integer.toString(8), "group", Integer.toString(8), "keyvalue", Integer.toString(8)}, {"crontab", "/var/spool/cron/crontabs/root", " \t", "#", "0", "3", Integer.toString(1), Integer.toString(12), "7", "minute", Integer.toString(9), "hour", Integer.toString(9), "dayofmonth", Integer.toString(9), "month", Integer.toString(9), "dayofweek", Integer.toString(9), "command", Integer.toString(73), "comment", Integer.toString(8)}, {"patchdb", "/tmp/patchdb", "|", "#", "0", "3", Integer.toString(273), Integer.toString(10), "8", "pkgid", Integer.toString(9), "installed", Integer.toString(9), "obsolete", Integer.toString(9), "required", Integer.toString(9), "incompat", Integer.toString(9), "osversions", Integer.toString(9), "arch", Integer.toString(9), "type", Integer.toString(9)}, {"pkginfo", "/tmp/properties", "=", "#", "0", "3", Integer.toString(273), Integer.toString(10), "2", "key", Integer.toString(9), "value", Integer.toString(73)}, {"text", "/tmp/text", " ", "#", "0", "3", Integer.toString(273), Integer.toString(8), "1", "line", Integer.toString(73)}, {"tnrhtp", "/etc/security/tsol/tnrhtp", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "2", "name", Integer.toString(9), "attributes", Integer.toString(8)}, {"tnrhdb", "/etc/security/tsol/tnrhdb", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "2", "addr", Integer.toString(9), "name", Integer.toString(8)}, {"tnzonecfg", "/etc/security/tsol/tnzonecfg", ":", "#", "0", "3", Integer.toString(287), Integer.toString(42), "5", "name", Integer.toString(9), "label", Integer.toString(8), "policy", Integer.toString(8), "mlp_local", Integer.toString(8), "mlp_shared", Integer.toString(8)}};
    int tableIndex = USER_DEFINED;
    String tableName = "";
    String tableType = "";
    String mappedTableName = "";
    String columnSeparators = " \t";
    String commentSeparators = "#";
    int numberOfColumns;
    int tableAttributes = 0;
    int[] columnAttributes = null;
    String[] columnNames = null;
    String[] mappedColumnNames = null;
    String[] secondaryMappedColumnNames = null;
    int userId = 0;
    int groupId = 3;
    int access = 273;

    public void loadTableDefinitions(String tableName) throws DirectoryTableInvalidParameterException {
        int i;
        this.tableName = tableName;
        for (i = 0; i < NUMBER_OF_TABLES; ++i) {
            if (!tableName.equalsIgnoreCase(definitions[i][TABLE_NAME])) continue;
            this.tableIndex = i;
            this.tableName = definitions[i][TABLE_NAME];
            this.tableType = this.tableName + "_tbl";
            this.mappedTableName = definitions[i][MAPPED_TABLE_NAME];
            this.columnSeparators = definitions[i][COLUMN_SEPARATORS];
            this.commentSeparators = definitions[i][COMMENT_SEPARATORS];
            this.userId = Integer.valueOf(definitions[i][USERID]);
            this.groupId = Integer.valueOf(definitions[i][GROUPID]);
            this.access = Integer.valueOf(definitions[i][ACCESS]);
            this.tableAttributes = Integer.valueOf(definitions[i][TABLE_ATTRIBUTES]);
            this.numberOfColumns = Integer.valueOf(definitions[i][NUMBER_OF_COLUMNS]);
            this.columnNames = new String[this.numberOfColumns];
            this.mappedColumnNames = new String[this.numberOfColumns];
            this.secondaryMappedColumnNames = new String[this.numberOfColumns];
            this.columnAttributes = new int[this.numberOfColumns];
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.columnNames[j] = definitions[i][NUMBER_OF_COLUMNS + j * 2 + 1];
                this.mappedColumnNames[j] = definitions[i][NUMBER_OF_COLUMNS + j * 2 + 1];
                this.secondaryMappedColumnNames[j] = definitions[i][NUMBER_OF_COLUMNS + j * 2 + 1];
                this.columnAttributes[j] = Integer.valueOf(definitions[i][NUMBER_OF_COLUMNS + j * 2 + 2]);
            }
            break;
        }
        if (i == NUMBER_OF_TABLES) {
            throw new DirectoryTableInvalidParameterException("EXM_NOTABLEDEF", tableName);
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String getColumnName(int col) throws DirectoryTableInvalidParameterException {
        if (col < 0 || col > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.columnNames[col - 1];
    }

    public String getMappedColumnName(int col) throws DirectoryTableInvalidParameterException {
        if (col < 0 || col > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.mappedColumnNames[col - 1];
    }

    public String getAuxilliaryColumnData(int col) throws DirectoryTableInvalidParameterException {
        if (col < 0 || col > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.secondaryMappedColumnNames[col - 1];
    }

    public int getColumnNumber(String name) throws DirectoryTableInvalidParameterException {
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (!this.columnNames[i].equalsIgnoreCase(name)) continue;
            return i + 1;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getColumnAttributes(int col) throws DirectoryTableInvalidParameterException {
        if (col <= this.numberOfColumns && col > 0) {
            return this.columnAttributes[col - 1];
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getTableAttributes() {
        return this.tableAttributes;
    }

    public String getRawMappedTableName() {
        return this.mappedTableName;
    }

    public String getMappedTableName() {
        return this.mappedTableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getCommentSeparators() {
        return this.commentSeparators;
    }

    public String getColumnSeparators() {
        return this.columnSeparators;
    }

    public int getUser() {
        return this.userId;
    }

    public int getGroup() {
        return this.groupId;
    }

    public int getAccess() {
        return this.access;
    }

    public void setNumberOfColumns(int size) throws DirectoryTableInvalidParameterException {
        if (size < 0) {
            throw new DirectoryTableInvalidParameterException();
        }
        this.numberOfColumns = size;
        this.columnNames = new String[this.numberOfColumns];
        this.columnAttributes = new int[this.numberOfColumns];
    }

    public void setColumnName(int col, String name) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnNames[col - 1] = name;
    }

    public void setMappedColumnName(int col, String name) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.mappedColumnNames[col - 1] = name;
    }

    public void setAuxilliaryColumnData(int col, String name) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.secondaryMappedColumnNames[col - 1] = name;
    }

    public void setColumnAttributes(int col, int attributes) throws DirectoryTableInvalidParameterException {
        if (col > this.numberOfColumns || col <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnAttributes[col - 1] = attributes;
    }

    public void setTableAttributes(int attributes) {
        this.tableAttributes = attributes;
    }

    public void setMappedTableName(String mappedName) {
        this.mappedTableName = mappedName;
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    public void setTableType(String tblType) {
        this.tableType = tblType;
    }

    public void setCommentSeparators(String separators) {
        this.commentSeparators = separators;
    }

    public void setColumnSeparators(String separators) {
        this.columnSeparators = separators;
    }

    public void setUser(int user) {
        this.userId = user;
    }

    public void setGroup(int group) {
        this.groupId = group;
    }

    public void setAccess(int acc) {
        this.access = acc;
    }
}

