/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.UException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.FileEditor;
import com.sun.wbem.utility.directorytable.NamedConfSection;
import java.util.Vector;

public class NamedConf {
    FileEditor fileEditor;
    Vector sections = null;
    String conffile = null;

    public NamedConf() {
        try {
            this.conffile = DirectoryUtility.getDirectoryTableProperty("directorytable.dns.namedconf");
            if (this.conffile == null || this.conffile.equals("")) {
                this.conffile = "/etc/named.conf";
            }
        }
        catch (UException a) {
            this.conffile = "/etc/named.conf";
        }
    }

    public String getFileName() {
        return this.conffile;
    }

    public void load() throws DirectoryTableException {
        this.load(this.conffile);
    }

    public void load(String namedConfFile) throws DirectoryTableException {
        int numOfSections = 0;
        this.fileEditor = new FileEditor(namedConfFile, 256);
        String line = this.fileEditor.getFirstLine();
        while (line != null) {
            if (this.sections == null) {
                this.sections = new Vector(1);
            }
            this.sections.setSize(++numOfSections);
            this.sections.setElementAt(new NamedConfSection(line), numOfSections - 1);
            line = this.fileEditor.getNextLine();
        }
    }

    public Vector getAllSections() {
        return this.sections;
    }

    public Vector getSections(String sectionName) {
        Vector<NamedConfSection> selectedSections = null;
        NamedConfSection section = null;
        int numOfSelectedSections = 0;
        if (this.sections == null) {
            return selectedSections;
        }
        for (int i = 0; i < this.sections.size(); ++i) {
            section = (NamedConfSection)this.sections.get(i);
            if (!section.getSectionName().equals(sectionName)) continue;
            if (selectedSections == null) {
                selectedSections = new Vector<NamedConfSection>(1);
            }
            selectedSections.setSize(++numOfSelectedSections);
            selectedSections.setElementAt(section, numOfSelectedSections - 1);
        }
        return selectedSections;
    }
}

