/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryMask;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import com.sun.wbem.utility.directorytable.DirectoryTableOperationNotSupportedException;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.NisplusTableDefinitions;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import com.sun.wbem.utility.directorytable.TableSetup;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.Vector;

public class NisplusDirectoryTable
implements DirectoryTable,
TableSetup {
    TableDefinitions tableDefinitions;
    TableDefinitions passwdTableDefinitions;
    boolean needsFlush;
    String domainName;
    String serverName;
    String dataType = "";
    boolean isShadow = false;
    boolean isPasswd = false;
    int sessionDescriptor = -1;
    DirectoryMask allSetMask;
    int NISPLUS_RETRYLIMIT = 9;

    public int access(String tableName) throws DirectoryTableException {
        int access = 0;
        NisplusTableDefinitions tableDefinitionsArg = new NisplusTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        String checkTable = tableDefinitionsArg.getMappedTableName();
        if (DirectoryTableLibrary.nisplusAccess(checkTable, 16) != 0) {
            return access;
        }
        if (DirectoryTableLibrary.nisplusAccess(checkTable, 4) == 0) {
            access |= 1;
        }
        if (DirectoryTableLibrary.nisplusAccess(checkTable, 8) == 0) {
            access |= 2;
        }
        if (DirectoryTableLibrary.nisplusAccess(checkTable, 2) == 0) {
            access |= 8;
        }
        if (DirectoryTableLibrary.nisplusAccess(checkTable, 1) == 0) {
            access |= 4;
        }
        return access;
    }

    public int access(TableDefinitions tableDefinitionsArg) throws DirectoryTableException {
        int access = 0;
        String checkTable = tableDefinitionsArg.getMappedTableName();
        if (DirectoryTableLibrary.nisplusAccess(checkTable, 16) != 0) {
            return access;
        }
        if (DirectoryTableLibrary.nisplusAccess(checkTable, 4) == 0) {
            access |= 1;
        }
        if (DirectoryTableLibrary.nisplusAccess(checkTable, 8) == 0) {
            access |= 2;
        }
        if (DirectoryTableLibrary.nisplusAccess(checkTable, 2) == 0) {
            access |= 8;
        }
        if (DirectoryTableLibrary.nisplusAccess(checkTable, 1) == 0) {
            access |= 4;
        }
        return access;
    }

    public void open(String tableName) throws DirectoryTableException {
        NisplusTableDefinitions tableDefinitionsArg = new NisplusTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        this.sessionDescriptor = DirectoryTableLibrary.nisplusOpenTable(tableDefinitionsArg.getMappedTableName(), tableDefinitionsArg.getTableType());
        if (this.sessionDescriptor < 1) {
            int niserror = 0 - this.sessionDescriptor;
            DirectoryTableLibrary.nisplusErrorToException(niserror, tableDefinitionsArg);
        }
        this.tableDefinitions = tableDefinitionsArg;
        if (this.tableDefinitions.getTableName().equals("shadow")) {
            this.passwdTableDefinitions = new NisplusTableDefinitions(this.serverName, this.domainName);
            this.passwdTableDefinitions.loadTableDefinitions("passwd");
            this.isShadow = true;
        }
        if (this.tableDefinitions.getTableName().equals("passwd")) {
            this.isPasswd = true;
        }
        this.dataType = this.tableDefinitions.getTableType();
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void open(TableDefinitions tableDefinitionsArg) throws DirectoryTableException {
        this.sessionDescriptor = DirectoryTableLibrary.nisplusOpenTable(tableDefinitionsArg.getMappedTableName(), tableDefinitionsArg.getTableType());
        if (this.sessionDescriptor < 1) {
            int niserror = 0 - this.sessionDescriptor;
            DirectoryTableLibrary.nisplusErrorToException(niserror, tableDefinitionsArg);
        }
        this.tableDefinitions = tableDefinitionsArg;
        if (this.tableDefinitions.getTableName().equals("shadow")) {
            this.passwdTableDefinitions = new NisplusTableDefinitions(this.serverName, this.domainName);
            this.passwdTableDefinitions.loadTableDefinitions("passwd");
            this.isShadow = true;
        }
        if (this.tableDefinitions.getTableName().equals("passwd")) {
            this.isPasswd = true;
        }
        this.dataType = this.tableDefinitions.getTableType();
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void create(TableDefinitions tableDefinitionsArg) throws DirectoryTableException {
        char columnSeparator = tableDefinitionsArg.getColumnSeparators().charAt(0);
        int rights = DirectoryTableLibrary.convertAccessToRights(tableDefinitionsArg.getAccess());
        int n = tableDefinitionsArg.getNumberOfColumns();
        String[] colNames = new String[n];
        for (int i = 0; i < n; ++i) {
            colNames[i] = (tableDefinitionsArg.getColumnAttributes(i + 1) & 1) == 1 ? "S" + tableDefinitionsArg.getMappedColumnName(i + 1) : "N" + tableDefinitionsArg.getMappedColumnName(i + 1);
        }
        this.sessionDescriptor = DirectoryTableLibrary.nisplusAddTable(tableDefinitionsArg.getMappedTableName(), tableDefinitionsArg.getTableType(), rights, colNames, columnSeparator);
        if (this.sessionDescriptor < 1) {
            int niserror = 0 - this.sessionDescriptor;
            DirectoryTableLibrary.nisplusErrorToException(niserror, tableDefinitionsArg);
        }
        this.tableDefinitions = tableDefinitionsArg;
        if (this.tableDefinitions.getTableName().equals("shadow")) {
            this.passwdTableDefinitions = new NisplusTableDefinitions(this.serverName, this.domainName);
            this.passwdTableDefinitions.loadTableDefinitions("passwd");
            this.isShadow = true;
        }
        if (this.tableDefinitions.getTableName().equals("passwd")) {
            this.isPasswd = true;
        }
        this.dataType = this.tableDefinitions.getTableType();
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void create(String tableName) throws DirectoryTableException {
        NisplusTableDefinitions tableDefinitionsArg = new NisplusTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        char columnSeparator = tableDefinitionsArg.getColumnSeparators().charAt(0);
        int rights = DirectoryTableLibrary.convertAccessToRights(tableDefinitionsArg.getAccess());
        int n = tableDefinitionsArg.getNumberOfColumns();
        String[] colNames = new String[n];
        for (int i = 0; i < n; ++i) {
            colNames[i] = (tableDefinitionsArg.getColumnAttributes(i + 1) & 1) == 1 ? "S" + tableDefinitionsArg.getMappedColumnName(i + 1) : "N" + tableDefinitionsArg.getMappedColumnName(i + 1);
        }
        this.sessionDescriptor = DirectoryTableLibrary.nisplusAddTable(tableDefinitionsArg.getMappedTableName(), tableDefinitionsArg.getTableType(), rights, colNames, columnSeparator);
        if (this.sessionDescriptor < 1) {
            int niserror = 0 - this.sessionDescriptor;
            DirectoryTableLibrary.nisplusErrorToException(niserror, tableDefinitionsArg);
        }
        this.tableDefinitions = tableDefinitionsArg;
        if (this.tableDefinitions.getTableName().equals("shadow")) {
            this.passwdTableDefinitions = new NisplusTableDefinitions(this.serverName, this.domainName);
            this.passwdTableDefinitions.loadTableDefinitions("passwd");
            this.isShadow = true;
        }
        if (this.tableDefinitions.getTableName().equals("passwd")) {
            this.isPasswd = true;
        }
        this.dataType = this.tableDefinitions.getTableType();
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void delete(TableDefinitions tableDefs) throws DirectoryTableException {
        int ret = 0;
        ret = DirectoryTableLibrary.nisplusDeleteTable(tableDefs.getMappedTableName());
        DirectoryTableLibrary.nisplusErrorToException(ret, tableDefs);
    }

    public void delete(String tableName) throws DirectoryTableException {
        int ret = 0;
        NisplusTableDefinitions tableDefinitionsArg = new NisplusTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        ret = DirectoryTableLibrary.nisplusDeleteTable(tableDefinitionsArg.getMappedTableName());
        DirectoryTableLibrary.nisplusErrorToException(ret, tableDefinitionsArg);
    }

    public void close() {
        try {
            this.flush();
        }
        catch (DirectoryTableException e) {
            this.needsFlush = false;
        }
        DirectoryTableLibrary.nisplusCloseTable(this.sessionDescriptor);
        this.tableDefinitions = null;
        this.sessionDescriptor = -1;
        this.isShadow = false;
        this.isPasswd = false;
        this.dataType = "";
        this.allSetMask = null;
    }

    public void flush() throws DirectoryTableException {
        if (this.needsFlush) {
            this.needsFlush = false;
        }
    }

    public void addRow(DirectoryRow row) throws DirectoryTableException {
        int cnameCol = -1;
        int nameCol = -1;
        int retry = 0;
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        if (this.isShadow) {
            for (int i = 1; i <= row.getNumberOfRows(); ++i) {
                DirectoryRow passwdRow = new DirectoryRow(this.passwdTableDefinitions.getNumberOfColumns());
                String shadowEntry = this.rowToShadowEntry(row, i);
                passwdRow.putColumn(this.passwdTableDefinitions.getColumnNumber("shadow"), shadowEntry);
                passwdRow.putColumn(this.passwdTableDefinitions.getColumnNumber("passwd"), row.getColumn(this.tableDefinitions.getColumnNumber("passwd"), i));
                int ret = DirectoryTableLibrary.nisplusModifyEntry(this.sessionDescriptor, this.rowToSearchName(row, i, this.tableDefinitions.getColumnNumber("name")), this.passwdTableDefinitions.getColumnNumber("shadow"), this.rowToArray(passwdRow, 1));
                DirectoryTableLibrary.nisplusErrorToException(ret, this.tableDefinitions);
                ret = DirectoryTableLibrary.nisplusModifyEntry(this.sessionDescriptor, this.rowToSearchName(row, 1, this.tableDefinitions.getColumnNumber("name")), this.passwdTableDefinitions.getColumnNumber("passwd"), this.rowToArray(passwdRow, 1));
                DirectoryTableLibrary.nisplusErrorToException(ret, this.tableDefinitions);
            }
        } else if (this.isPasswd) {
            for (int i = 1; i <= row.getNumberOfRows(); ++i) {
                String owner = row.getColumn(this.tableDefinitions.getColumnNumber("name"), i) + "." + this.domainName + ".";
                int ret = DirectoryTableLibrary.nisplusAddEntry(this.sessionDescriptor, this.rowToArray(row, i), owner);
                DirectoryTableLibrary.nisplusErrorToException(ret, this.tableDefinitions);
            }
        } else {
            try {
                cnameCol = this.tableDefinitions.getColumnNumber("cname");
                nameCol = this.tableDefinitions.getColumnNumber("aliases");
            }
            catch (DirectoryTableInvalidParameterException e) {
                cnameCol = -1;
                nameCol = -1;
            }
            if (cnameCol != -1 && nameCol != -1) {
                for (int i = 1; i <= row.getNumberOfRows(); ++i) {
                    int ret;
                    DirectoryRow tempRow = row.extractRows(i, i);
                    String aliases = tempRow.getColumn(nameCol);
                    if (aliases.compareTo("") == 0) {
                        tempRow.putColumn(nameCol, tempRow.getColumn(cnameCol));
                        ret = DirectoryTableLibrary.nisplusAddEntry(this.sessionDescriptor, this.rowToArray(tempRow, 1), "");
                        DirectoryTableLibrary.nisplusErrorToException(ret, this.tableDefinitions);
                        continue;
                    }
                    String alias = null;
                    StringTokenizer tokens = null;
                    tokens = new StringTokenizer(aliases, " \t");
                    while (tokens.hasMoreTokens()) {
                        alias = tokens.nextToken();
                        tempRow.putColumn(nameCol, alias);
                        ret = DirectoryTableLibrary.nisplusAddEntry(this.sessionDescriptor, this.rowToArray(tempRow, 1), "");
                        DirectoryTableLibrary.nisplusErrorToException(ret, this.tableDefinitions);
                    }
                }
            } else {
                for (int i = 1; i <= row.getNumberOfRows(); ++i) {
                    int ret;
                    while ((ret = DirectoryTableLibrary.nisplusAddEntry(this.sessionDescriptor, this.rowToArray(row, i), "")) == 7 && retry <= this.NISPLUS_RETRYLIMIT) {
                        try {
                            Thread.sleep((int)Math.exp(retry));
                        }
                        catch (Exception e) {
                            System.err.println(e);
                        }
                        ++retry;
                    }
                    DirectoryTableLibrary.nisplusErrorToException(ret, this.tableDefinitions);
                }
            }
        }
        this.needsFlush = true;
    }

    public void deleteRow(DirectoryRow row) throws DirectoryTableException {
        int retry = 0;
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        if (this.isShadow) {
            for (int i = 1; i <= row.getNumberOfRows(); ++i) {
                DirectoryRow emptyPasswdRow = new DirectoryRow(this.passwdTableDefinitions.getNumberOfColumns());
                int ret = DirectoryTableLibrary.nisplusModifyEntry(this.sessionDescriptor, this.rowToSearchName(row, i, this.tableDefinitions.getColumnNumber("name")), this.passwdTableDefinitions.getColumnNumber("shadow"), this.rowToArray(emptyPasswdRow, 1));
                DirectoryTableLibrary.nisplusErrorToException(ret, this.tableDefinitions);
            }
        } else {
            for (int i = 1; i <= row.getNumberOfRows(); ++i) {
                int ret;
                while ((ret = DirectoryTableLibrary.nisplusDeleteEntry(this.sessionDescriptor, this.rowToSearchName(row, i))) == 7 && retry <= this.NISPLUS_RETRYLIMIT) {
                    try {
                        Thread.sleep((int)Math.exp(retry));
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                    ++retry;
                }
                DirectoryTableLibrary.nisplusErrorToException(ret, this.tableDefinitions);
            }
        }
        this.needsFlush = true;
    }

    public void modifyRow(DirectoryRow searchRow, DirectoryRow replaceRow) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        if (this.isShadow) {
            DirectoryRow passwdRow = new DirectoryRow(this.passwdTableDefinitions.getNumberOfColumns());
            String shadowEntry = this.rowToShadowEntry(replaceRow, 1);
            passwdRow.putColumn(this.passwdTableDefinitions.getColumnNumber("shadow"), shadowEntry);
            passwdRow.putColumn(this.passwdTableDefinitions.getColumnNumber("passwd"), replaceRow.getColumn(this.tableDefinitions.getColumnNumber("passwd"), 1));
            int ret = DirectoryTableLibrary.nisplusModifyEntry(this.sessionDescriptor, this.rowToSearchName(searchRow, 1, this.tableDefinitions.getColumnNumber("name")), this.passwdTableDefinitions.getColumnNumber("shadow"), this.rowToArray(passwdRow, 1));
            DirectoryTableLibrary.nisplusErrorToException(ret, this.tableDefinitions);
            ret = DirectoryTableLibrary.nisplusModifyEntry(this.sessionDescriptor, this.rowToSearchName(searchRow, 1, this.tableDefinitions.getColumnNumber("name")), this.passwdTableDefinitions.getColumnNumber("passwd"), this.rowToArray(passwdRow, 1));
            DirectoryTableLibrary.nisplusErrorToException(ret, this.tableDefinitions);
        } else {
            int ret = DirectoryTableLibrary.nisplusModifyEntry(this.sessionDescriptor, this.rowToSearchName(searchRow, 1), -1, this.rowToArray(replaceRow, 1));
            DirectoryTableLibrary.nisplusErrorToException(ret, this.tableDefinitions);
        }
        this.needsFlush = true;
    }

    public DirectoryRow getFirstRow() throws DirectoryTableException {
        DirectoryRow emptyRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getFirstRow(emptyRow);
    }

    public DirectoryRow getNextRow() throws DirectoryTableException {
        DirectoryRow emptyRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getNextRow(emptyRow);
    }

    public DirectoryRow getFirstRow(SearchTemplate template) throws DirectoryTableException {
        DirectoryRow searchRow = template.getTemplateAsRow(this.tableDefinitions);
        String searchStr = searchRow == null ? "" : this.rowToSearchName(searchRow, 1);
        String[] arr = DirectoryTableLibrary.nisplusGetFirstEntry(this.sessionDescriptor, searchStr);
        if (arr == null) {
            return null;
        }
        DirectoryRow row = this.arrayToRow(arr);
        if (!row.isEmpty() && template.matchRow(row, 1, this.tableDefinitions)) {
            return row;
        }
        arr = DirectoryTableLibrary.nisplusGetNextEntry(this.sessionDescriptor);
        while (arr != null) {
            row = this.arrayToRow(arr);
            if (!row.isEmpty() && template.matchRow(row, 1, this.tableDefinitions)) {
                return row;
            }
            arr = DirectoryTableLibrary.nisplusGetNextEntry(this.sessionDescriptor);
        }
        return null;
    }

    public DirectoryRow getNextRow(SearchTemplate template) throws DirectoryTableException {
        String[] arr = DirectoryTableLibrary.nisplusGetNextEntry(this.sessionDescriptor);
        while (arr != null) {
            DirectoryRow row = this.arrayToRow(arr);
            if (!row.isEmpty() && template.matchRow(row, 1, this.tableDefinitions)) {
                return row;
            }
            arr = DirectoryTableLibrary.nisplusGetNextEntry(this.sessionDescriptor);
        }
        return null;
    }

    public DirectoryRow getAll() throws DirectoryTableException {
        return this.getAll(this.allSetMask);
    }

    public DirectoryRow getAll(DirectoryMask mask) throws DirectoryTableException {
        DirectoryRow row = null;
        boolean currentRow = true;
        int nCol = 0;
        int nRow = 0;
        String[] arr = DirectoryTableLibrary.nisplusGetAllEntries(this.sessionDescriptor, "");
        if (arr == null) {
            return row;
        }
        nCol = this.tableDefinitions.getNumberOfColumns();
        nRow = arr.length / nCol;
        row = new DirectoryRow(nCol, nRow);
        this.arrayIntoRow(arr, 0, row, 1, nRow, mask);
        return row;
    }

    public DirectoryRow getAll(SearchTemplate template) throws DirectoryTableException {
        return this.getAll(template, this.allSetMask);
    }

    public DirectoryRow getAll(SearchTemplate template, DirectoryMask mask) throws DirectoryTableException {
        DirectoryRow row = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
        int currentRow = 1;
        int nCol = 0;
        int nRow = 0;
        DirectoryRow searchRow = template.getTemplateAsRow(this.tableDefinitions);
        String searchStr = searchRow == null ? "" : this.rowToSearchName(searchRow, 1);
        String[] arr = DirectoryTableLibrary.nisplusGetAllEntries(this.sessionDescriptor, searchStr);
        if (arr == null) {
            return null;
        }
        nCol = this.tableDefinitions.getNumberOfColumns();
        nRow = arr.length / nCol;
        for (int i = 0; i < nRow; ++i) {
            this.arrayIntoRow(arr, i * nCol, row, currentRow, 1, mask);
            if (row.isEmpty() || !template.matchRow(row, currentRow, this.tableDefinitions)) continue;
            row.addRows(1);
            ++currentRow;
        }
        row.deleteRow(currentRow);
        if (currentRow == 1) {
            return null;
        }
        return row;
    }

    public DirectoryRow getRowInstance() {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
    }

    public DirectoryRow getRowInstance(int rows) {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), rows);
    }

    public TableDefinitions getTableDefinitionsInstance() {
        return new NisplusTableDefinitions(this.serverName, this.domainName);
    }

    public DirectoryMask getDirectoryMaskInstance() {
        return new DirectoryMask(this.tableDefinitions);
    }

    public TableDefinitions getCurrentTableDefinitions() {
        return this.tableDefinitions;
    }

    public void setContext(String dirContext) throws DirectoryTableException {
        this.serverName = DirectoryUtility.getContextProperty(dirContext, "serverName");
        this.domainName = DirectoryUtility.getContextProperty(dirContext, "domainName");
        if (!DirectoryUtility.isLocalServer(this.serverName)) {
            throw new DirectoryTableOperationNotSupportedException("Remote NIS+");
        }
    }

    private String[] rowToArray(DirectoryRow row, int rowNum) throws DirectoryTableException {
        int n = row.getNumberOfColumns();
        String[] arr = new String[n];
        for (int i = 0; i < n; ++i) {
            arr[i] = row.getColumn(i + 1, rowNum);
        }
        return arr;
    }

    private DirectoryRow arrayToRow(String[] arr) throws DirectoryTableException {
        int n = this.tableDefinitions.getNumberOfColumns();
        DirectoryRow row = new DirectoryRow(n);
        if (this.isShadow) {
            int i;
            String shadowEntry = arr[this.passwdTableDefinitions.getColumnNumber("shadow") - 1];
            row.putColumn(this.tableDefinitions.getColumnNumber("name"), arr[this.passwdTableDefinitions.getColumnNumber("name") - 1]);
            row.putColumn(this.tableDefinitions.getColumnNumber("passwd"), arr[this.passwdTableDefinitions.getColumnNumber("passwd") - 1]);
            int len = shadowEntry.length();
            int lastind = -1;
            int nextind = 0;
            String entryCol = null;
            nextind = shadowEntry.indexOf(58, 0);
            for (i = this.tableDefinitions.getColumnNumber("passwd") + 1; nextind != -1 && i <= n; ++i) {
                if (nextind - lastind > 1) {
                    entryCol = shadowEntry.substring(lastind + 1, nextind);
                    row.putColumn(i, entryCol);
                }
                if ((lastind = nextind) >= len - 1) break;
                nextind = shadowEntry.indexOf(58, lastind + 1);
            }
            if (lastind < len - 1 && i <= n) {
                entryCol = shadowEntry.substring(lastind + 1, len);
                row.putColumn(i, entryCol);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                row.putColumn(i + 1, arr[i]);
            }
        }
        return row;
    }

    private void arrayIntoRow(String[] arr, int arrIndex, DirectoryRow row, int rowIndex, int rowNum, DirectoryMask mask) throws DirectoryTableException {
        int n = this.tableDefinitions.getNumberOfColumns();
        if (rowNum == 0) {
            rowNum = (arr.length - arrIndex) / n;
        }
        block0: for (int rNum = rowIndex; rNum < rowIndex + rowNum; ++rNum) {
            if (this.isShadow) {
                String shadowEntry = arr[(rNum - rowIndex) * n + arrIndex + (this.passwdTableDefinitions.getColumnNumber("shadow") - 1)];
                if (mask.getColumn(this.tableDefinitions.getColumnNumber("name"))) {
                    row.putColumn(this.tableDefinitions.getColumnNumber("name"), rNum, arr[(rNum - rowIndex) * n + arrIndex + (this.passwdTableDefinitions.getColumnNumber("name") - 1)]);
                }
                if (mask.getColumn(this.tableDefinitions.getColumnNumber("passwd"))) {
                    row.putColumn(this.tableDefinitions.getColumnNumber("passwd"), rNum, arr[(rNum - rowIndex) * n + arrIndex + (this.passwdTableDefinitions.getColumnNumber("passwd") - 1)]);
                }
                int len = shadowEntry.length();
                int lastind = -1;
                int nextind = 0;
                String entryCol = null;
                nextind = shadowEntry.indexOf(58, 0);
                for (int i = this.tableDefinitions.getColumnNumber("passwd") + 1; nextind != -1 && i <= n; ++i) {
                    if (nextind - lastind > 1) {
                        entryCol = shadowEntry.substring(lastind + 1, nextind);
                        if (mask.getColumn(i)) {
                            row.putColumn(i, entryCol);
                        }
                    }
                    if ((lastind = nextind) >= len - 1) continue block0;
                    nextind = shadowEntry.indexOf(58, lastind + 1);
                }
                continue;
            }
            for (int i = 0; i < n; ++i) {
                if (!mask.getColumn(i + 1)) continue;
                row.putColumn(i + 1, rNum, arr[(rNum - rowIndex) * n + arrIndex + i]);
            }
        }
    }

    private String rowToShadowEntry(DirectoryRow row, int rowNum) throws DirectoryTableException {
        int i;
        int n = this.tableDefinitions.getNumberOfColumns();
        String shadowEntry = new String("");
        for (i = 3; i < n; ++i) {
            shadowEntry = shadowEntry + row.getColumn(i, rowNum) + ":";
        }
        shadowEntry = shadowEntry + row.getColumn(i, rowNum);
        return shadowEntry;
    }

    private String rowToSearchName(DirectoryRow row, int rowNum, int colNum) throws DirectoryTableException {
        String searchName = new String("");
        searchName = "[" + this.tableDefinitions.getMappedColumnName(colNum) + "=\"" + row.getColumn(colNum, rowNum) + "\"],";
        return searchName;
    }

    private String rowToSearchName(DirectoryRow row, int rowNum) throws DirectoryTableException {
        int n = row.getNumberOfColumns();
        boolean firstCol = true;
        String searchName = new String("");
        for (int i = 1; i <= n; ++i) {
            if ((this.tableDefinitions.getColumnAttributes(i) & 1) != 1 || row.getColumn(i, rowNum).equals("")) continue;
            if (firstCol) {
                searchName = searchName + "[";
                firstCol = false;
            } else {
                searchName = searchName + ",";
            }
            searchName = searchName + this.tableDefinitions.getMappedColumnName(i) + "=\"" + row.getColumn(i, rowNum) + "\"";
        }
        if (!firstCol) {
            searchName = searchName + "],";
        }
        return searchName;
    }

    public Vector getScopes(int flags) {
        String localServer;
        Vector<String> scopes = null;
        try {
            localServer = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return scopes;
        }
        String domain = DirectoryTableLibrary.getDomain();
        if (domain.length() > 0 && domain.charAt(domain.length() - 1) == '.') {
            domain = domain.substring(0, domain.length() - 1);
        }
        if (domain.equals("")) {
            return scopes;
        }
        NisplusTableDefinitions tableDefinitionsArg = new NisplusTableDefinitions(localServer, domain);
        try {
            tableDefinitionsArg.loadTableDefinitions("group");
        }
        catch (Exception e) {
            return scopes;
        }
        String checkTable = tableDefinitionsArg.getMappedTableName();
        if ((flags & 2) == 2) {
            if (DirectoryTableLibrary.nisplusAccess(checkTable, 2) == 0) {
                scopes = new Vector<String>();
                scopes.addElement("nisplus:/" + localServer + "/" + domain);
            }
        } else if (DirectoryTableLibrary.nisplusAccess(checkTable, 1) == 0) {
            scopes = new Vector();
            scopes.addElement("nisplus:/" + localServer + "/" + domain);
        }
        return scopes;
    }

    public void setup() {
    }

    public void refreshSetup() {
    }
}

