/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_SYS_FM_FS_ZFS_H
#define	_SYS_FM_FS_ZFS_H

#pragma ident	"@(#)zfs.h	1.3	08/06/18 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#define	ZFS_ERROR_CLASS				"fs.zfs"

#define	FM_EREPORT_ZFS_CHECKSUM			"checksum"
#define	FM_EREPORT_ZFS_IO			"io"
#define	FM_EREPORT_ZFS_DATA			"data"
#define	FM_EREPORT_ZFS_POOL			"zpool"
#define	FM_EREPORT_ZFS_DEVICE_UNKNOWN		"vdev.unknown"
#define	FM_EREPORT_ZFS_DEVICE_OPEN_FAILED	"vdev.open_failed"
#define	FM_EREPORT_ZFS_DEVICE_CORRUPT_DATA	"vdev.corrupt_data"
#define	FM_EREPORT_ZFS_DEVICE_NO_REPLICAS	"vdev.no_replicas"
#define	FM_EREPORT_ZFS_DEVICE_BAD_GUID_SUM	"vdev.bad_guid_sum"
#define	FM_EREPORT_ZFS_DEVICE_TOO_SMALL		"vdev.too_small"
#define	FM_EREPORT_ZFS_DEVICE_BAD_LABEL		"vdev.bad_label"
#define	FM_EREPORT_ZFS_IO_FAILURE		"io_failure"

#define	FM_EREPORT_PAYLOAD_ZFS_POOL		"pool"
#define	FM_EREPORT_PAYLOAD_ZFS_POOL_FAILMODE	"pool_failmode"
#define	FM_EREPORT_PAYLOAD_ZFS_POOL_GUID	"pool_guid"
#define	FM_EREPORT_PAYLOAD_ZFS_POOL_CONTEXT	"pool_context"
#define	FM_EREPORT_PAYLOAD_ZFS_VDEV_GUID	"vdev_guid"
#define	FM_EREPORT_PAYLOAD_ZFS_VDEV_TYPE	"vdev_type"
#define	FM_EREPORT_PAYLOAD_ZFS_VDEV_PATH	"vdev_path"
#define	FM_EREPORT_PAYLOAD_ZFS_VDEV_DEVID	"vdev_devid"
#define	FM_EREPORT_PAYLOAD_ZFS_PARENT_GUID	"parent_guid"
#define	FM_EREPORT_PAYLOAD_ZFS_PARENT_TYPE	"parent_type"
#define	FM_EREPORT_PAYLOAD_ZFS_PARENT_PATH	"parent_path"
#define	FM_EREPORT_PAYLOAD_ZFS_PARENT_DEVID	"parent_devid"
#define	FM_EREPORT_PAYLOAD_ZFS_ZIO_OBJSET	"zio_objset"
#define	FM_EREPORT_PAYLOAD_ZFS_ZIO_OBJECT	"zio_object"
#define	FM_EREPORT_PAYLOAD_ZFS_ZIO_LEVEL	"zio_level"
#define	FM_EREPORT_PAYLOAD_ZFS_ZIO_BLKID	"zio_blkid"
#define	FM_EREPORT_PAYLOAD_ZFS_ZIO_ERR		"zio_err"
#define	FM_EREPORT_PAYLOAD_ZFS_ZIO_OFFSET	"zio_offset"
#define	FM_EREPORT_PAYLOAD_ZFS_ZIO_SIZE		"zio_size"
#define	FM_EREPORT_PAYLOAD_ZFS_PREV_STATE	"prev_state"

#define	FM_EREPORT_FAILMODE_WAIT		"wait"
#define	FM_EREPORT_FAILMODE_CONTINUE		"continue"
#define	FM_EREPORT_FAILMODE_PANIC		"panic"

#define	FM_RESOURCE_OK				"ok"
#define	FM_RESOURCE_REMOVED			"removed"
#define	FM_RESOURCE_AUTOREPLACE			"autoreplace"

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_FM_FS_ZFS_H */
