<?xml version="1.0" encoding="UTF-8" ?>
<!--
   Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
-->
<!-- Generated from default-domain.xml.template -->

<!DOCTYPE domain PUBLIC "-//Sun Microsystems Inc.//DTD Application Server 8.0 Domain//EN" "http://www.sun.com/software/appserver/dtds/sun-domain_1_1.dtd">

<domain application-root="${com.sun.aas.instanceRoot}/applications" 
	log-root="${com.sun.aas.instanceRoot}/logs"> 

 <applications>
    <web-module name="adminapp" context-root="/web1" 
	location="${com.sun.aas.installRoot}/lib/install/applications/adminapp/adminapp_war" 
	object-type="system-admin" enabled="true" directory-deployed="true" 
	availability-enabled="false">
	<!-- System Web Module - DO NOT DELETE! -->
    </web-module>

    <web-module name="admingui" context-root="/asadmin" 
	location="${com.sun.aas.installRoot}/lib/install/applications/admingui/adminGUI_war" 
	object-type="system-admin" enabled="true" directory-deployed="true" 
	availability-enabled="false">
	<!-- System Web Module - DO NOT DELETE! -->
    </web-module>
    <web-module name="com_sun_web_ui" context-root="/com_sun_web_ui" 
	location="%%console_home%%/webapps/com_sun_web_ui" 
	object-type="system-admin" enabled="true" directory-deployed="true" 
	availability-enabled="false">
	<!-- System Web Module - DO NOT DELETE! -->
    </web-module>

    <web-module name="console" context-root="/console" 
	location="%%console_home%%/webapps/console" 
	object-type="system-admin" enabled="true" directory-deployed="true">
    	<!-- Sun Java Web Console(TM) Module - DO NOT DELETE! -->
    </web-module>

 </applications>

 <resources>
   <jdbc-resource jndi-name="jdbc/__TimerPool" pool-name="__TimerPool" 
	object-type="system-admin" enabled="true"/>
   <jdbc-resource jndi-name="jdbc/__default" pool-name="DerbyPool" 
	object-type="user" enabled="true"/>

   <jdbc-connection-pool connection-validation-method="auto-commit" 
	datasource-classname="org.apache.derby.jdbc.EmbeddedXADataSource" 
	fail-all-connections="false" idle-timeout-in-seconds="300" 
	is-connection-validation-required="false" is-isolation-level-guaranteed="true" 
	max-pool-size="32" max-wait-time-in-millis="60000" res-type="javax.sql.XADataSource" 
	name="__TimerPool" pool-resize-quantity="2" steady-pool-size="8">

      <property name="databaseName" 
	 value="${com.sun.aas.instanceRoot}/lib/databases/ejbtimer"/>
    </jdbc-connection-pool>

    <jdbc-connection-pool connection-validation-method="auto-commit" 
	datasource-classname="org.apache.derby.jdbc.ClientDataSource" 
	fail-all-connections="false" idle-timeout-in-seconds="300" 
	is-connection-validation-required="false" is-isolation-level-guaranteed="true" 
	max-pool-size="32" max-wait-time-in-millis="60000" res-type="javax.sql.DataSource" 
	name="DerbyPool" pool-resize-quantity="2" steady-pool-size="8">

     <property name="PortNumber" value="1527"/>
     <property name="Password" value="APP"/>
     <property name="User" value="APP"/>
     <property name="serverName" value="localhost"/>
     <property name="DatabaseName" value="sun-appserv-samples"/>
     <property name="connectionAttributes" value=";create=true"/>
   </jdbc-connection-pool>
 </resources>

 <configs>
  <config name="%%%CONFIG_MODEL_NAME%%%" dynamic-reconfiguration-enabled="true" >
      <http-service> <http-listener id="http-listener-1" address="0.0.0.0" 
	port="%%%HTTP_PORT%%%" acceptor-threads="50" security-enabled="false" 
	default-virtual-server="%%%SERVER_ID%%%" server-name="" 
	xpowered-by="true" enabled="true">
    </http-listener>

    <http-listener id="http-listener-2" address="0.0.0.0" port="%%%HTTP_SSL_PORT%%%" 
	acceptor-threads="50" security-enabled="true" 
	default-virtual-server="%%%SERVER_ID%%%" server-name="" 
	xpowered-by="true" enabled="true">
	<!-- need to revert to console once password problem is fixed 
	    <ssl cert-nickname="s1as" client-auth-enabled="false"
	-->
	    <ssl cert-nickname="s1as" client-auth-enabled="false"
		ssl2-enabled="false" ssl3-enabled="true" tls-enabled="true"
		tls-rollback-enabled="true"/>
    </http-listener>

    <http-listener id="admin-listener" address="0.0.0.0" port="%%%ADMIN_PORT%%%" 
	acceptor-threads="50" security-enabled="false" default-virtual-server="__asadmin" 
	server-name="" xpowered-by="true" enabled="true">
    </http-listener>

     <virtual-server id="%%%SERVER_ID%%%" http-listeners="http-listener-1,http-listener-2" 
	hosts="${com.sun.aas.hostName}" state="on" default-web-module="console">
      <property name="docroot" value="${com.sun.aas.instanceRoot}/docroot"/>
      <property name="accesslog" value="%%console_log%%/%%console_instance%%/access"/>
     </virtual-server>

     <virtual-server id="__asadmin" http-listeners="admin-listener" 
	hosts="${com.sun.aas.hostName}" state="on" default-web-module="admingui">
      <property name="docroot" value="${com.sun.aas.instanceRoot}/docroot"/>
      <property name="accesslog" value="${com.sun.aas.instanceRoot}/logs/access"/>
     </virtual-server>

   </http-service>

   <iiop-service>

     <orb use-thread-pool-ids="thread-pool-1" 
	message-fragment-size="1024" max-connections="1024" />

     <iiop-listener id="orb-listener-1" 
	address="0.0.0.0" port="%%%ORB_LISTENER_PORT%%%" enabled="true"/>
     <iiop-listener id="SSL" address="0.0.0.0" 
	port="%%%ORB_SSL_PORT%%%" security-enabled="true" enabled="true">
     <ssl cert-nickname="s1as" client-auth-enabled="false"/>
    </iiop-listener>

    <iiop-listener id="SSL_MUTUALAUTH" address="0.0.0.0" 
	port="%%%ORB_MUTUALAUTH_PORT%%%" security-enabled="true" enabled="true">
     <ssl cert-nickname="s1as" client-auth-enabled="true"/>
    </iiop-listener>

   </iiop-service>

   <admin-service system-jmx-connector-name="system" type="das-and-server">

     <!-- The JSR 160 "system-jmx-connector" -->
     <jmx-connector accept-all="false" address="0.0.0.0" 
	auth-realm-name="admin-realm" enabled="true" name="system" 
	port="%%%JMX_SYSTEM_CONNECTOR_PORT%%%" protocol="rmi_jrmp" security-enabled="false"/>

     <!-- The JSR 160 "system-jmx-connector" -->
     <das-config dynamic-reload-enabled="true" dynamic-reload-poll-interval-in-seconds="2" 
	autodeploy-enabled="true" autodeploy-polling-interval-in-seconds="2" 
	autodeploy-dir="${com.sun.aas.instanceRoot}/autodeploy" 
	autodeploy-verifier-enabled="false" autodeploy-jsp-precompilation-enabled="false" 
	deploy-xml-validation="full" admin-session-timeout-in-minutes="60" />
   </admin-service>
   <web-container />

   <!-- WE SHOULD REMOVE THIS -->
   <ejb-container steady-pool-size="0" pool-resize-quantity="8" 
	max-pool-size="32" cache-resize-quantity="32" max-cache-size="512" 
	pool-idle-timeout-in-seconds="600" cache-idle-timeout-in-seconds="600" 
	removal-timeout-in-seconds="5400" victim-selection-policy="nru" 
	commit-option="B" session-store="${com.sun.aas.instanceRoot}/session-store"> 
     <ejb-timer-service></ejb-timer-service>
   </ejb-container>

   <mdb-container steady-pool-size="0" pool-resize-quantity="8" 
	max-pool-size="32" idle-timeout-in-seconds="600"/>

   <jms-service init-timeout-in-seconds="60" type="LOCAL" 
	default-jms-host="default_JMS_host" reconnect-interval-in-seconds="60" 
	reconnect-attempts="3" reconnect-enabled="true" 
	addresslist-behavior="random" addresslist-iterations="3">
    <jms-host name="default_JMS_host" host="%%%HOST_NAME%%%" 
	port="%%%JMS_PROVIDER_PORT%%%" admin-user-name="%%%JMS_PROVIDER_USERID%%%" 
	admin-password="%%%JMS_PROVIDER_PASSWORD%%%"/>
   </jms-service>

   <log-service file="${com.sun.aas.instanceRoot}/logs/server.log" 
	use-system-logging="false" log-to-console="false" alarms="false" 
	log-rotation-limit-in-bytes="2000000">
    <module-log-levels 
	root="INFO" server="INFO" ejb-container="INFO" cmp-container="INFO" 
	mdb-container="INFO" web-container="INFO" classloader="INFO" 
	configuration="INFO" naming="INFO" security="INFO" admin="INFO" 
	jts="INFO" jta="INFO" deployment="INFO" verifier="INFO" jaxr="INFO" 
	jaxrpc="INFO" saaj="INFO" corba="INFO" javamail="INFO" jms="INFO" 
	connector="INFO" jdo="INFO" cmp="INFO" util="INFO" resource-adapter="INFO"  />
   </log-service>

   <security-service default-realm="file" anonymous-role="ANYONE" 
	audit-enabled="false" jacc="default" audit-modules="default">

    <!-- All administrative users use this realm by default. -->
    <auth-realm name="admin-realm" 
	classname="com.sun.enterprise.security.auth.realm.file.FileRealm">
     <property name="file" value="${com.sun.aas.instanceRoot}/config/admin-keyfile"/>
     <property name="jaas-context" value="fileRealm"/>
    </auth-realm>

    <!-- All administrative users use this realm by default. -->
    <auth-realm name="file" 
	classname="com.sun.enterprise.security.auth.realm.file.FileRealm">
     <property name="file" value="${com.sun.aas.instanceRoot}/config/keyfile"/>
     <property name="jaas-context" value="fileRealm"/>
    </auth-realm>

    <auth-realm name="certificate" 
	classname="com.sun.enterprise.security.auth.realm.certificate.CertificateRealm">
    </auth-realm>

    <jacc-provider name="default" 
     policy-provider="com.sun.enterprise.security.provider.PolicyWrapper" 
     policy-configuration-factory-provider="com.sun.enterprise.security.provider.PolicyConfigurationFactoryImpl">
     <property name="repository" value="${com.sun.aas.instanceRoot}/generated/policy"/>
    </jacc-provider>

    <audit-module name="default" classname="com.sun.enterprise.security.Audit">
	<property name="auditOn" value="false"/>
    </audit-module>

   <message-security-config auth-layer="SOAP">
	<!-- turned off by default -->
         <provider-config class-name="com.sun.xml.wss.provider.ClientSecurityAuthModule" 
	    provider-id="ClientProvider" provider-type="client">
         	<request-policy auth-source="content"/>
         	<response-policy auth-source="content"/>
         	<property name="security.config" 
		    value="${com.sun.aas.instanceRoot}/config/wss-server-config.xml"/>
         </provider-config>
         <provider-config class-name="com.sun.xml.wss.provider.ServerSecurityAuthModule" 
	    provider-id="ServerProvider" provider-type="server">
            <request-policy auth-source="content"/>
            <response-policy auth-source="content"/>
            <property name="security.config" 
		value="${com.sun.aas.instanceRoot}/config/wss-server-config.xml"/>
         </provider-config>
       </message-security-config> 
   </security-service>

   <transaction-service automatic-recovery="false" timeout-in-seconds="0" 
	tx-log-dir="${com.sun.aas.instanceRoot}/logs" heuristic-decision="rollback" 
	keypoint-interval="2048" retry-timeout-in-seconds="600"/>
    <monitoring-service>
	<module-monitoring-levels thread-pool="OFF" orb="OFF" ejb-container="OFF" 
	web-container="OFF" transaction-service="OFF" http-service="OFF" 
	jdbc-connection-pool="OFF" connector-connection-pool="OFF"/>
    </monitoring-service>
    <!--
	native-library-path-prefix="%%console_home%%/private/lib"
    -->

    <java-config java-home="${com.sun.aas.javaRoot}" debug-enabled="false" 
	debug-options="-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=9009" 
	rmic-options="-iiop -poa -alwaysgenerate -keepgenerated -g" javac-options="-g"
        server-classpath="${path.separator}${com.sun.aas.installRoot}/lib/install/applications/jmsra/imqjmsra.jar${path.separator}${com.sun.aas.imqLib}/jaxm-api.jar${path.separator}${com.sun.aas.imqLib}/fscontext.jar${path.separator}${com.sun.aas.antLib}/ant.jar" classpath-suffix="${com.sun.aas.installRoot}/pointbase/lib/pbclient.jar${path.separator}${com.sun.aas.installRoot}/pointbase/lib/pbembedded.jar" env-classpath-ignored="true"
 classpath-prefix="">
    <!-- various required jvm-options -->
    <jvm-options>-client</jvm-options>
    <jvm-options>-Djava.library.path=%%console_home%%/private/lib</jvm-options>
    <jvm-options>-Djava.endorsed.dirs=${com.sun.aas.installRoot}/lib/endorsed</jvm-options>
    <jvm-options>-Djava.security.policy=%%console_security_policyfile%%</jvm-options>
    <jvm-options>-Djava.security.auth.login.config=${com.sun.aas.instanceRoot}/config/login.conf</jvm-options>
    <jvm-options>-Dsun.rmi.dgc.server.gcInterval=3600000</jvm-options>
    <jvm-options>-Dsun.rmi.dgc.client.gcInterval=3600000</jvm-options>
    <jvm-options>-Xmx512m</jvm-options>
    <jvm-options>-Djavax.net.ssl.keyStore=${com.sun.aas.instanceRoot}/config/keystore.jks</jvm-options>
    <jvm-options>-Djavax.net.ssl.trustStore=${com.sun.aas.instanceRoot}/config/cacerts.jks</jvm-options>
    <jvm-options>-Djava.ext.dirs=${com.sun.aas.javaRoot}/jre/lib/ext${path.separator}${com.sun.aas.instanceRoot}/lib/ext</jvm-options>
   <jvm-options> -Djdbc.drivers=com.pointbase.jdbc.jdbcUniversalDriver</jvm-options>
   <jvm-options>-Djavax.management.builder.initial=com.sun.enterprise.admin.server.core.jmx.AppServerMBeanServerBuilder</jvm-options>
    <jvm-options>-Dcom.sun.enterprise.config.config_environment_factory_class=com.sun.enterprise.config.serverbeans.AppserverConfigEnvironmentFactory</jvm-options>
    <jvm-options>-Dcom.sun.enterprise.taglibs=appserv-jstl.jar,jsf-impl.jar,webui.jar</jvm-options>
    <jvm-options>-Dcom.sun.enterprise.taglisteners=jsf-impl.jar,webui.jar</jvm-options>
    <jvm-options>-Dcom.sun.web.console.conf=%%console_conf%%/%%console_instance%%</jvm-options>
    <jvm-options>-Dcom.sun.web.console.logdir=%%console_log%%/%%console_instance%%</jvm-options>
    <jvm-options>-Dcom.sun.web.console.home=%%console_home%%</jvm-options>
    <jvm-options>-Dcom.sun.web.console.appbase=%%console_appbase%%</jvm-options>
    <jvm-options>-Dcom.sun.web.console.base=%%console_base%%</jvm-options>
    <jvm-options>-Dcom.sun.web.console.secureport=%%console_httpsport%%</jvm-options>
    <jvm-options>-Dcom.sun.web.console.unsecureport=%%console_httpport%%</jvm-options>
    <jvm-options>-Dcom.sun.web.console.unsecurehost=%%console_unsecurehost%%</jvm-options>
    <jvm-options>-Dwebconsole.default.file=%%console_conf%%/%%console_instance%%/default.properties</jvm-options>
    <jvm-options>-Dwebconsole.config.file=%%console_conf%%/%%console_instance%%/config.properties</jvm-options>
    <jvm-options>-Dcom.sun.web.console.startfile=%%console_base%%/tmp/%%console_instance%%_start.tmp</jvm-options>
    <jvm-options>-Dcom.sun.web.console.native=%%console_native%%</jvm-options>
    <jvm-options>-Djava.awt.headless=true</jvm-options>
    <jvm-options>-XX:NewRatio=2</jvm-options>
   </java-config>

   <thread-pools>
        <thread-pool thread-pool-id="thread-pool-1" min-thread-pool-size="0" 
	    max-thread-pool-size="200" idle-thread-timeout-in-seconds="120" 
	    num-work-queues="1" />
    </thread-pools>
  </config> <!-- config model with name "%%%CONFIG_MODEL_NAME%%%" ends -->
 </configs>

 <servers>
  <server name="%%%SERVER_ID%%%" config-ref="%%%CONFIG_MODEL_NAME%%%"> 
    <application-ref enabled="true" ref="adminapp" virtual-servers="__asadmin" 
	lb-enabled="false" disable-timeout-in-minutes="30"/>
    <application-ref enabled="true" ref="admingui" virtual-servers="__asadmin" 
	lb-enabled="false" disable-timeout-in-minutes="30"/>
    <application-ref enabled="true" ref="com_sun_web_ui" 
	virtual-servers="__asadmin, %%%SERVER_ID%%%" 
	lb-enabled="false" disable-timeout-in-minutes="30"/>
    <application-ref enabled="true" ref="console" virtual-servers="%%%SERVER_ID%%%" 
	lb-enabled="false" disable-timeout-in-minutes="30"/>

    <resource-ref enabled="true" ref="jdbc/__TimerPool"/>
    <resource-ref enabled="true" ref="jdbc/__default"/>
  </server>
 </servers>
 <property name="administrative.domain.name" value="%%%DOMAIN_NAME%%%"/>
</domain>
