<?xml version="1.0" encoding="UTF-8"?>

<!DOCTYPE web-app PUBLIC
  "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN"
  "http://java.sun.com/dtd/web-app_2_3.dtd">

<web-app>

<!-- Sun Java Web Console 3.0 Web Application Deployment Descriptor -->
<!-- For web applications using the console JSF based components -->

  <!-- Context parameters for JSF based components -->
  <context-param>
    <param-name>javax.faces.STATE_SAVING_METHOD</param-name>
    <param-value>client</param-value>
  </context-param>
  <context-param>
    <param-name>javax.faces.CONFIG_FILES</param-name>
    <param-value>/WEB-INF/console-faces-config.xml</param-value>
  </context-param>

  <!-- CONSOLE FILTER CONFIGURATION -->
  <!-- All management web applications must define this filter. -->
  <!-- Add ignore path parameter values for URI's for which the -->
  <!-- filter should pass through without making security checks. -->
  <!-- Paths can end with the "*" wildcard indicator. -->
  <filter>
    <filter-name>AppSessionManagerFilter</filter-name>
    <filter-class>
      com.sun.management.services.session.AppSessionManagerFilter
    </filter-class>

    <!-- ADD URI PATHS TO IGNORE WHEN USING THE SECURE PORT -->
    <init-param>
      <param-name>ignore-paths-https</param-name>
      <param-value>
        /images/*
        /help/*
        /html/*
        /version/*
      </param-value>
    </init-param>

    <!-- ADD URI PATHS TO IGNORE WHEN USING THE NON-SECURE PORT -->
    <init-param>
      <param-name>ignore-paths-http</param-name>
      <param-value>
        /html/*
        /help/*
        /help2/*
        /images/*
      </param-value>
    </init-param>
  </filter>
  <filter-mapping>
    <filter-name>AppSessionManagerFilter</filter-name>
    <url-pattern>/*</url-pattern>
  </filter-mapping>
  
  <!-- ADD OPTIONAL APPLICATION FILTER DEFINITIONS HERE -->


  <!-- CONSOLE COMMON COMPONENT SERVLET CONFIGURATION DEFINITIONS -->

  <!-- Internal servlet required for console registration -->
  <servlet>
    <servlet-name>Registrar</servlet-name>
    <servlet-class>
      com.sun.management.services.registration.servlet.WebConsoleRegistrarServlet
    </servlet-class>
    <load-on-startup>3</load-on-startup>
  </servlet>

  <!-- Internal common component servlets required for JSF components -->
  <servlet>
     <servlet-name>FacesServlet</servlet-name>
     <servlet-class>javax.faces.webapp.FacesServlet</servlet-class>
     <load-on-startup>1</load-on-startup>
  </servlet>
  <servlet>
     <servlet-name>ThemeServlet</servlet-name>
     <servlet-class>com.sun.web.ui.theme.ThemeServlet</servlet-class>
  </servlet>


  <!-- ADD APPLICATION SERVLET CONFIGURATION DEFINITIONS HERE -->


  <!-- CONSOLE COMMON COMPONENT SERVLET MAPPINGS -->

  <!-- Internal servlet required for console registration -->
  <servlet-mapping>
    <servlet-name>Registrar</servlet-name>
    <url-pattern>/Registrar</url-pattern>
  </servlet-mapping>

  <!-- Internal common component servlet mappings for JSF components -->
  <servlet-mapping>
     <servlet-name>FacesServlet</servlet-name>
     <url-pattern>/faces/*</url-pattern>
  </servlet-mapping>
  <servlet-mapping>
     <servlet-name>ThemeServlet</servlet-name>
     <url-pattern>/theme/*</url-pattern>
  </servlet-mapping>


  <!-- ADD APPLICATION SERVLET MAPPINGS HERE -->


  <!-- ADD APPLICATION TAGLIB DEFINITIONS HERE -->


</web-app>
