<%--
/**
 * ident "@(#)Masthead.jsp 1.10 10/04/08 SMI"
 * 
 * Copyright (c) 2010,2012 Oracle and/or its affiliates. All Rights Reserved.
 * Use is subject to license terms.
 */
--%>
<%@page language="java" %>
<%@page import="com.sun.web.ui.common.CCI18N" %>
<%@page import="com.sun.web.ui.common.CCSystem" %>
<%@page import="com.iplanet.jato.util.HtmlUtil" %>
<%@page import="com.sun.web.ui.servlet.help2.Help2Utils" %>
<%@taglib uri="/WEB-INF/tld/com_iplanet_jato/jato.tld" prefix="jato"%>
<%@taglib uri="/WEB-INF/tld/com_sun_web_ui/cc.tld" prefix="cc"%>

<%
    // Get query parameters.
    String windowTitle = (request.getParameter("windowTitle") != null)
	? request.getParameter("windowTitle") : "";
    String mastheadTitle = (request.getParameter("mastheadTitle") != null)
	? request.getParameter("mastheadTitle") : "";
    String mastheadAlt = (request.getParameter("mastheadAlt") != null)
	? request.getParameter("mastheadAlt") : "";
    String pageTitle = (request.getParameter("pageTitle") != null)
	? request.getParameter("pageTitle") : "help.pageTitle";
    String helpLogoWidth = (request.getParameter("helpLogoWidth") != null)
        ? request.getParameter("helpLogoWidth") : "";
    String helpLogoHeight= (request.getParameter("helpLogoHeight") != null)
        ? request.getParameter("helpLogoHeight") : "";	

    // Prevent XSS attacks - only allow relative URLs to resources.
    if (! CCSystem.checkRelativeUrl(mastheadTitle)) {
	throw new ServletException("Invalid product name relative URL: " +
	HtmlUtil.escape(mastheadTitle));
    }
    helpLogoWidth = Help2Utils.enforceNumericString(helpLogoWidth);
    helpLogoHeight = Help2Utils.enforceNumericString(helpLogoHeight);
%>

<jato:useViewBean className="com.sun.web.ui.servlet.help2.MastheadViewBean">

<!-- Header -->
<cc:header
 name="Header"
 pageTitle="<%=windowTitle %>"
 styleClass="HlpMstTtlBdy"
 baseName="com.sun.web.ui.resources.Resources"
 bundleID="help2Bundle">

<cc:form name="mastheadForm" method="post">

<!-- Secondary Masthead -->
<cc:secondarymasthead
 name="Masthead"
 src="<%=mastheadTitle %>"
 alt="<%=mastheadAlt %>"
 bundleID="help2Bundle"
 width="<%=helpLogoWidth %>"
 height="<%=helpLogoHeight %>" />

<!-- Page Title -->
<cc:pagetitle name="PageTitle" bundleID="help2Bundle"
 pageTitleText="<%=pageTitle %>"
 showPageTitleSeparator="true"
 showPageButtonsTop="true"
 showPageButtonsBottom="false" />

</cc:form>
</cc:header>
</jato:useViewBean>
