#pragma ident "%W% %E% SMI"

#!/bin/sh

# Copyright 2005 Sun Microsystems, Inc. All rights reserved.
# Use is subject to license terms.

# Usage:
# iobushangscript.sh <PID>

PID=$1
DATESTRING=`/usr/bin/date`

VER=`cat .version |grep 7.`

if [ "$VER" != "" ];
then
	/usr/bin/mkdir -m 644 -p /var/sunvts/hanginfo/iobus
	path="/var/sunvts/hanginfo/iobus/iobus.$PID.$DATESTRING"
else
	/usr/bin/mkdir -m 644 -p /var/opt/SUNWvts/hanginfo/iobus
	path="/var/opt/SUNWvts/hanginfo/iobus/iobus.$PID.$DATESTRING"
fi
{
echo
echo "     iobustest debug information Data      "
echo "*******************************************"
echo 

echo "iobustest process was found to be hung. Test run time exceeded"
echo "expected test completion run time.  The process-id of the iobustest"
echo "process is $PID"

echo
echo 
echo "[1] Data from ps -elf on iobustest "
echo "    ****************************** "

ps -elfo pid,vsz,pcpu,pmem,etime,wchan,nlwp,args | grep -i iobustest


echo
echo 
echo "[2] Data from plimit -m "
echo "    ******************* " 

plimit -m $PID


echo 
echo 
echo "[3] Data from pflags "
echo "    **************** "

pflags $PID


echo 
echo
echo "[4] Data from pwdx "
echo "    ************** "

pwdx $PID 


echo 
echo 
echo "[5] Data from pmap -x "
echo "    ***************** " 

pmap -x $PID

echo 
echo 
echo "[6] Data from pldd -F "
echo "    ***************** "

pldd -F $PID

echo 
echo 
echo "[7] Data from psig "
echo "    ************** "

psig $PID

echo
echo
echo "[8] Data from pargs "
echo "    *************** "

pargs $PID
echo 
echo 
echo "[9] Data from pstack "
echo "    **************** "

pstack $PID

echo
echo
echo "[10] System Configuration Data"
echo "     *************************"

uname -a
echo
echo

cat /etc/release
echo
echo

showrev -p|/bin/cut -d' ' -f2|/bin/sort
echo
echo

echo "Other Relevant Information"
echo "**************************"
echo
echo
echo "[11] Data from iostat "
echo "     **************** " 

iostat -xcn 2 4


echo
echo
echo "[12] Data from netstat "
echo "     ***************** "

netstat -Ii 2 4


}> "$path"

exit
