/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.util;

public class GetOpt {
    protected int optind;
    protected String optarg = null;
    protected String[] argv;
    protected int argc;
    protected String optionString;
    int MINUS_POSITION = 0;
    int OPTION_POSITION = 1;
    int AFTER_OPTION_POSITION = 2;

    public GetOpt(String[] argv, int start, int length, String optionString) {
        this.argv = argv;
        this.optind = start;
        this.argc = length + start;
        this.optionString = optionString;
    }

    public GetOpt(String[] argv, String optionString) {
        this(argv, 0, argv.length, optionString);
    }

    public GetOpt(String[] argv, int start, String optionString) {
        this(argv, start, argv.length - start, optionString);
    }

    public int getNextOption() throws IllegalArgumentException {
        this.optarg = null;
        if (this.optind >= this.argc || this.argv[this.optind].length() < 2 || this.argv[this.optind].charAt(this.MINUS_POSITION) != '-') {
            return -1;
        }
        char currentOption = this.argv[this.optind].charAt(this.OPTION_POSITION);
        if (!this.isValidOption(currentOption)) {
            ++this.optind;
            throw new IllegalArgumentException("Illegal Option -- " + currentOption);
        }
        if (this.isOptionArgAllowedByOption(currentOption) && this.OPTION_POSITION == 1) {
            if (this.argv[this.optind].length() != 2) {
                this.optarg = this.argv[this.optind].substring(this.AFTER_OPTION_POSITION);
                ++this.optind;
            } else if (this.optind + 1 >= this.argc) {
                ++this.optind;
                if (this.isOptionArgMandatoryByOption(currentOption)) {
                    throw new IllegalArgumentException("Option -- " + currentOption + " requires an argument");
                }
            } else {
                this.optarg = this.argv[++this.optind];
                ++this.optind;
            }
            this.OPTION_POSITION = 1;
        } else {
            if (this.isOptionArgMandatoryByOption(currentOption)) {
                throw new IllegalArgumentException("Option -- " + currentOption + " requires an argument");
            }
            if (this.argv[this.optind].length() == this.OPTION_POSITION + 1) {
                this.OPTION_POSITION = 1;
                ++this.optind;
            } else {
                ++this.OPTION_POSITION;
            }
        }
        return currentOption;
    }

    public String getOptionArg() {
        return this.optarg;
    }

    private boolean isValidOption(char c) {
        return c != ':' && this.optionString.indexOf(c) != -1;
    }

    private boolean isOptionArgMandatoryByOption(char option) {
        char x = option;
        return this.isValidOption(option) && this.optionString.length() > this.optionString.indexOf(option) + 1 && this.optionString.charAt(this.optionString.indexOf(option) + 1) == ':';
    }

    public int getNextOptionIndex() {
        return this.optind;
    }

    private boolean isOptionArgAllowedByOption(char option) {
        char x = option;
        return this.isValidOption(option) && this.optionString.length() > this.optionString.indexOf(option) + 1 && (this.optionString.charAt(this.optionString.indexOf(option) + 1) == ':' || this.optionString.charAt(this.optionString.indexOf(option) + 1) == ';');
    }

    private Character C(char c) {
        return new Character(c);
    }
}

