/*
 * Decompiled with CFR 0.152.
 */
package com.sun.database.simpleadapter.ndbm;

import com.sun.database.simpleadapter.ndbm.ClassXlator;
import com.sun.database.simpleadapter.ndbm.Ndbm;
import com.sun.database.simpleadapter.ndbm.NdbmEnumerator;
import com.sun.database.simpleadapter.ndbm.State;
import com.sun.database.simpledatabase.AccessMethod;
import com.sun.database.simpledatabase.AlreadyPopulatedException;
import com.sun.database.simpledatabase.DatabaseError;
import com.sun.database.simpledatabase.DatabaseExistsException;
import com.sun.database.simpledatabase.DuplicateAlreadyStoredException;
import com.sun.database.simpledatabase.DuplicateEntryException;
import com.sun.database.simpledatabase.NoSuchDatabaseException;
import com.sun.database.simpledatabase.NoSuchObjectException;
import com.sun.database.simpledatabase.SimpleDatabasePrtl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class NDBMAdapter
extends SimpleDatabasePrtl {
    private String defaultLocation = "/var/tmp";
    private String NdbmDelimiter = "<!>";
    private boolean stateChanged = false;
    private State state;
    private Field[] classFields;
    private Field[] keyFields;
    private ClassXlator classXlator;
    private String databasePath;
    private String stateFilePath;
    private String[] keyFieldStrings;
    private Ndbm objectStore;
    private Ndbm[] keyDbm;
    private int databaseHandle = 0;
    private File currentLockFile;
    private File databaseLockFile;
    private File databaseClearFile;
    static final int LOCKATTEMPTLIMIT = 15;
    static final int LOCKTIMEOUT = 1000;

    public NDBMAdapter(String string, Class clazz, String[] stringArray) throws NoSuchFieldException, SecurityException, DatabaseExistsException {
        this(null, string, clazz, stringArray);
    }

    public NDBMAdapter(URL uRL, Class clazz, String[] stringArray) throws NoSuchFieldException, SecurityException, DatabaseExistsException {
        this(uRL, null, clazz, stringArray);
    }

    private NDBMAdapter(URL uRL, String string, Class clazz, String[] stringArray) throws NoSuchFieldException, SecurityException, DatabaseExistsException {
        if (uRL != null) {
            File file = new File(uRL.getFile());
            this.setDefaultLocation(file.getParent());
            string = file.getName();
        }
        this.databasePath = new String(this.defaultLocation + "/" + string);
        this.identifyLockFile(this.databasePath);
        try {
            this.createLockFile();
        }
        catch (IOException iOException) {
            throw new DatabaseError("NDBMAdapter: Unable to create a lock file at " + this.databaseClearFile + ".");
        }
        this.state = new State();
        this.stateChanged = true;
        this.state.fieldDelimiter = this.NdbmDelimiter;
        this.state.keyFieldStrings = stringArray;
        this.state.classInStore = clazz;
        this.classFields = clazz.getFields();
        this.state.nextObjectHandle = 0;
        this.state.databaseSize = 0;
        this.keyFieldStrings = stringArray;
        this.stateFilePath = new String(this.databasePath + ".sta");
        int n = stringArray.length;
        if (n == 0) {
            throw new NoSuchFieldException("No key fields specified. Use a Vector.");
        }
        this.state.keyDbmState = new int[n];
        this.keyFields = new Field[n];
        this.acquireDatabase();
        try {
            this.objectStore = new Ndbm(this.databasePath, this.state.fieldDelimiter, 0, true);
        }
        catch (NoSuchDatabaseException noSuchDatabaseException) {
            throw new DatabaseError(noSuchDatabaseException, "NDBMAdapter:NoSuchDatabaseException thrown while creating the database");
        }
        this.state.objectStoreState = 0;
        this.classXlator = new ClassXlator(this.state.fieldDelimiter, this.state.classInStore, this.classFields);
        this.keyDbm = new Ndbm[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.keyFields[i] = this.state.classInStore.getField(stringArray[i]);
                int n2 = this.classXlator.getFieldNumber(this.keyFields[i]);
                this.keyDbm[i] = new Ndbm(this.databasePath, this.state.fieldDelimiter, n2, true);
                this.state.keyDbmState[i] = n2;
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    this.destroyDatabase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new NoSuchFieldException("No such field as " + stringArray[i]);
            }
            catch (NoSuchDatabaseException noSuchDatabaseException) {
                throw new DatabaseError(noSuchDatabaseException, "NDBMAdapter: NoSuchDatabaseException thrown while creating the database");
            }
        }
        this.saveState();
    }

    public NDBMAdapter(String string) throws SecurityException, NoSuchDatabaseException {
        this(null, string);
    }

    public NDBMAdapter(URL uRL) throws SecurityException, NoSuchDatabaseException {
        this(uRL, null);
    }

    private NDBMAdapter(URL uRL, String string) throws SecurityException, NoSuchDatabaseException {
        if (uRL != null) {
            File file = new File(uRL.getFile());
            this.setDefaultLocation(file.getParent());
            string = file.getName();
        }
        this.databasePath = new String(this.defaultLocation + "/" + string);
        if (!new File(this.databasePath + ".sta").exists()) {
            throw new NoSuchDatabaseException("NDBMAdapter: database " + this.databasePath + " does not exist.");
        }
        this.stateFilePath = new String(this.databasePath + ".sta");
        this.identifyLockFile(this.databasePath);
        this.acquireDatabase();
        try {
            this.state = this.retrieveState();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NoSuchDatabaseException("NDBMAdapter: Cannot open state file at " + this.stateFilePath + ". Exception returns " + fileNotFoundException.getMessage());
        }
        try {
            this.objectStore = new Ndbm(this.databasePath, this.state.objectStoreState, false);
        }
        catch (DatabaseExistsException databaseExistsException) {
            throw new DatabaseError(databaseExistsException, "NDBAMAdapter: Threw a DatabaseExistsException on the object store for " + this.databasePath + " even though that's the " + "whole point to this access.");
        }
        catch (NoSuchDatabaseException noSuchDatabaseException) {
            try {
                this.objectStore = this.reattemptOpen(this.state.objectStoreState);
            }
            catch (Exception exception) {
                throw new DatabaseError(exception, "NDBAMAdapter: Threw a NoSuchDatabaseException on the object store for " + this.databasePath + ".");
            }
        }
        catch (Exception exception) {
            throw new DatabaseError(exception, "NDBAMAdapter: Could not access " + this.databasePath + ".");
        }
        int n = this.state.keyFieldStrings.length;
        this.keyFields = new Field[n];
        this.classXlator = new ClassXlator(this.state.fieldDelimiter, this.state.classInStore, this.state.classInStore.getFields());
        this.keyDbm = new Ndbm[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.keyFields[i] = this.state.classInStore.getField(this.state.keyFieldStrings[i]);
                int n2 = this.classXlator.getFieldNumber(this.keyFields[i]);
                this.keyDbm[i] = new Ndbm(this.databasePath, this.state.keyDbmState[i], false);
                continue;
            }
            catch (DatabaseExistsException databaseExistsException) {
                this.cleanupOpens(i);
                throw new DatabaseError(databaseExistsException, "NDBAMAdapter: Threw a DatabaseExistsException on a key of " + this.databasePath + ". Yes, thank you, we already knew that.");
            }
            catch (NoSuchDatabaseException noSuchDatabaseException) {
                try {
                    this.keyDbm[i] = this.reattemptOpen(this.state.keyDbmState[i]);
                    continue;
                }
                catch (Exception exception) {
                    this.cleanupOpens(i);
                    throw new DatabaseError(exception, "NDBAMAdapter: Threw a NoSuchDatabaseException on a key for " + this.databasePath + " even though its other components have already " + "been located.");
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                this.cleanupOpens(i);
                throw new DatabaseError(noSuchFieldException, "NDBAMAdapter: Called out an invalid field");
            }
        }
    }

    private void cleanupOpens(int n) {
        this.objectStore.close();
        while (--n > 0) {
            this.keyDbm[n].close();
        }
    }

    private Ndbm reattemptOpen(int n) throws Exception {
        System.gc();
        Thread.sleep(1000L);
        return new Ndbm(this.databasePath, n, false);
    }

    protected void setDefaultLocation(String string) {
        this.defaultLocation = string;
    }

    public void destroyDatabase() throws IllegalAccessException {
        this.objectStore.destroyNdbm();
        int n = this.state.keyFieldStrings.length;
        for (int i = 0; i < n; ++i) {
            this.keyDbm[i].destroyNdbm();
        }
        new File(this.stateFilePath).delete();
        this.currentLockFile.delete();
    }

    public void useAccessMethod(AccessMethod accessMethod, String string) throws NoSuchFieldException, AlreadyPopulatedException {
        throw new AlreadyPopulatedException();
    }

    public void allowDuplicates(int n, boolean bl) throws ArrayIndexOutOfBoundsException, DuplicateAlreadyStoredException {
        if (bl) {
            throw new DuplicateAlreadyStoredException();
        }
    }

    public void allowDuplicates(String string, boolean bl) throws NoSuchFieldException, DuplicateAlreadyStoredException {
        throw new DuplicateAlreadyStoredException();
    }

    public String whatClass() {
        return this.state.classInStore.toString();
    }

    public boolean areDuplicatesAllowed(String string) {
        return false;
    }

    public int addObject(Object object) throws DuplicateEntryException, IllegalAccessException {
        String string = this.classXlator.getRecordFromObject(object, this.state.nextObjectHandle);
        for (int i = 0; i < this.keyDbm.length; ++i) {
            try {
                this.keyDbm[i].addRecord(string);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalAccessException("NDBAMAdapter.addObject: Internal array miscalculation.");
            }
        }
        ++this.state.nextObjectHandle;
        this.stateChanged = true;
        ++this.state.databaseSize;
        this.objectStore.addRecord(string);
        return this.state.nextObjectHandle;
    }

    public void deleteObject(int n) throws NoSuchObjectException, IllegalAccessException {
        Object object = this.getObject(n);
        for (int i = 0; i < this.keyDbm.length; ++i) {
            Field field;
            try {
                field = this.state.classInStore.getField(this.state.keyFieldStrings[i]);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new NoSuchObjectException(noSuchFieldException.getMessage());
            }
            this.keyDbm[i].deleteRecord(field.get(object).toString());
        }
        this.objectStore.deleteRecord(new Integer(n).toString());
        --this.state.databaseSize;
        this.stateChanged = true;
    }

    public void flushDatabase() throws IllegalAccessException {
        this.saveState();
    }

    public void closeDatabase() {
        this.saveState();
        for (int i = 0; i < this.keyDbm.length; ++i) {
            this.keyDbm[i].close();
        }
        this.objectStore.close();
        System.gc();
        this.releaseDatabase();
    }

    public Object findObject(String string, Object object) throws NoSuchFieldException, NoSuchObjectException {
        return this.findObject(this.findMatchingKeyfield(string, this.state.keyFieldStrings), object);
    }

    public Object findObject(int n, Object object) throws ArrayIndexOutOfBoundsException, NoSuchObjectException {
        try {
            String string = this.keyDbm[n].findRecord(object.toString());
            return this.classXlator.getObjectFromRecord(string);
        }
        catch (InstantiationException instantiationException) {
            throw new NoSuchObjectException("NDBAMAdapter.findObject: Could not instantiate requested object with key " + object.toString());
        }
        catch (Exception exception) {
            throw new NoSuchObjectException("Object with key " + object.toString() + " is inaccessible.");
        }
    }

    public int findObjectHandle(String string, Object object) throws NoSuchFieldException, NoSuchObjectException {
        return this.findObjectHandle(this.findMatchingKeyfield(string, this.state.keyFieldStrings), object);
    }

    public int findObjectHandle(int n, Object object) throws ArrayIndexOutOfBoundsException, NoSuchObjectException {
        int n2;
        String string = this.keyDbm[n].findRecord(object.toString());
        String string2 = new StringTokenizer(string, this.state.fieldDelimiter).nextToken();
        try {
            Integer n3 = new Integer(string2);
            n2 = n3;
        }
        catch (Exception exception) {
            throw new NoSuchObjectException("While the object was technically found, it's object handle, " + string2 + ", is not valid.");
        }
        return n2;
    }

    public Enumeration findList(int n, Object object) throws ArrayIndexOutOfBoundsException, NoSuchObjectException {
        Vector<Integer> vector = new Vector<Integer>();
        vector.addElement(new Integer(this.findObjectHandle(n, object)));
        return vector.elements();
    }

    public Enumeration findList(String string, Object object) throws NoSuchFieldException, NoSuchObjectException {
        return this.findList(this.findMatchingKeyfield(string, this.state.keyFieldStrings), object);
    }

    public Enumeration elements() {
        return new NdbmEnumerator(this.objectStore, this.classXlator, this.state.databaseSize);
    }

    public Object getObject(int n) throws NoSuchObjectException {
        try {
            String string = this.objectStore.findRecord(new Integer(n).toString());
            return this.classXlator.getObjectFromRecord(string);
        }
        catch (Exception exception) {
            throw new NoSuchObjectException(exception.getMessage());
        }
    }

    private void saveState() {
        if (this.stateChanged) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.stateFilePath);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this.state);
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                throw new DatabaseError(iOException, "NDBMAdapter.saveState: Attempt to write state file at " + this.stateFilePath + " failed.");
            }
            this.stateChanged = false;
        }
    }

    private State retrieveState() throws FileNotFoundException {
        State state;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.stateFilePath);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            state = (State)objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new FileNotFoundException(exception.getMessage());
        }
        this.stateChanged = false;
        return state;
    }

    private void identifyLockFile(String string) {
        this.databaseClearFile = new File(new String(string + ".clear"));
        this.databaseLockFile = new File(new String(string + ".lock"));
        this.currentLockFile = new File(this.databaseClearFile.getPath());
    }

    private void createLockFile() throws IOException {
        if (this.databaseLockFile.exists()) {
            this.currentLockFile = new File(this.databaseLockFile.getPath());
            this.currentLockFile.renameTo(this.databaseClearFile);
        } else if (!this.databaseClearFile.exists()) {
            FileOutputStream fileOutputStream = new FileOutputStream(this.databaseClearFile);
            fileOutputStream.write(new String("lockFile for " + this.databasePath).getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
    }

    private void acquireDatabase() throws SecurityException {
        int n = 0;
        while (!this.databaseClearFile.renameTo(this.databaseLockFile)) {
            if (n++ >= 15) {
                throw new SecurityException("NDBMAdapter.acquireDatabase: Timed out attempting to acquire the database.");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void releaseDatabase() {
        this.databaseLockFile.renameTo(this.databaseClearFile);
    }
}

