/*
 * Decompiled with CFR 0.152.
 */
package com.sun.database.util;

import com.sun.database.util.AvailableRecord;
import com.sun.database.util.SortArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;

public class PersistentVector {
    private static final int IDXFILE_ENTRY_SIZE = 8;
    private static final int FLD_SIZE_INUSE = 2;
    private static final int FLD_SIZE_RESERVED = 2;
    private int totalEntries = 0;
    private File idxFile = null;
    private File dtaFile = null;
    private RandomAccessFile idxRAFile = null;
    private RandomAccessFile dtaRAFile = null;
    private AvailableRecord[] availableRecordList;
    private String pathname = null;
    private long lastTimeModified = 0L;

    public PersistentVector(String string) {
        this.pathname = string;
    }

    private void openfiles() throws IOException {
        try {
            this.idxFile = new File(this.pathname + ".idx");
            this.idxRAFile = new RandomAccessFile(this.idxFile, "rw");
            this.dtaFile = new File(this.pathname + ".dta");
            this.dtaRAFile = new RandomAccessFile(this.dtaFile, "rw");
        }
        catch (IOException iOException) {
            throw new IOException("IOException detected while opening Random Access Files");
        }
    }

    private void closefiles() throws IOException {
        try {
            this.idxRAFile.close();
            this.dtaRAFile.close();
        }
        catch (IOException iOException) {
            throw new IOException("IOException detected while closing Random Access Files");
        }
    }

    public void delete() throws Exception {
        try {
            this.idxFile.delete();
            this.dtaFile.delete();
        }
        catch (Exception exception) {
            throw new Exception("Exception detected while deleting Random Access Files");
        }
    }

    public void addElement(Object object) throws Exception {
        try {
            long l = 0L;
            this.openfiles();
            this.idxRAFile.seek(this.idxRAFile.length());
            byte[] byArray = this.byteArray(object);
            l = this.getAvailableOffset((short)byArray.length);
            this.dtaRAFile.seek(l);
            this.idxRAFile.writeLong(l);
            this.dtaRAFile.writeShort(byArray.length);
            this.dtaRAFile.writeShort(4 + byArray.length);
            this.dtaRAFile.write(byArray, 0, byArray.length);
            this.lastTimeModified = this.dtaFile.lastModified();
            this.closefiles();
        }
        catch (Exception exception) {
            throw new Exception("Error encounted while adding element." + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() {
        int n = this.size();
        Vector<Object> vector = new Vector<Object>(n);
        try {
            for (int i = 0; i < n; ++i) {
                vector.addElement(this.elementAt(i));
            }
        }
        catch (Exception exception) {}
        finally {
            return vector.elements();
        }
    }

    public Object elementAt(int n) throws Exception {
        long l = 0L;
        Object object = null;
        try {
            this.openfiles();
            this.idxRAFile.seek(n * 8);
            l = this.idxRAFile.readLong();
            this.dtaRAFile.seek(l);
            short s = this.dtaRAFile.readShort();
            int n2 = this.dtaRAFile.skipBytes(2);
            byte[] byArray = new byte[s];
            this.dtaRAFile.read(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
            this.closefiles();
        }
        catch (Exception exception) {
            throw new Exception("Error encountered while retrieving an element." + exception.getMessage());
        }
        return object;
    }

    public void insertElementAt(Object object, int n) throws Exception {
        try {
            int n2 = this.size();
            int n3 = 0;
            long l = 0L;
            this.openfiles();
            if (n2 == n) {
                this.addElement(object);
                return;
            }
            if (n < 0 || n > n2) {
                throw new Exception("Error: Index is out of range (0 to current size of vector)");
            }
            Vector<Long> vector = new Vector<Long>(n2 + 1);
            n3 = 0;
            for (int i = 0; i < n2; ++i) {
                this.idxRAFile.seek(n3);
                vector.addElement(new Long(this.idxRAFile.readLong()));
                n3 += 8;
            }
            byte[] byArray = this.byteArray(object);
            l = this.getAvailableOffset((short)byArray.length);
            this.dtaRAFile.seek(l);
            this.dtaRAFile.writeShort(byArray.length);
            this.dtaRAFile.writeShort(byArray.length + 4);
            this.dtaRAFile.write(byArray, 0, byArray.length);
            n3 = 0;
            vector.insertElementAt(new Long(l), n);
            for (int i = 0; i < vector.size(); ++i) {
                this.idxRAFile.seek(n3);
                this.idxRAFile.writeLong((Long)vector.elementAt(i));
                n3 += 8;
            }
            this.lastTimeModified = this.dtaFile.lastModified();
            this.closefiles();
        }
        catch (Exception exception) {
            throw new Exception("Error encountered while inserting a new element." + exception.getMessage());
        }
    }

    public void removeElementAt(int n) throws Exception {
        try {
            int n2 = this.size();
            this.openfiles();
            if (n < 0 || n > n2) {
                throw new Exception("Error: Index is out of range (0 to current size of vector)");
            }
            Vector<Long> vector = new Vector<Long>(n2);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                this.idxRAFile.seek(n3);
                vector.addElement(new Long(this.idxRAFile.readLong()));
                n3 += 8;
            }
            long l = (Long)vector.elementAt(n);
            this.dtaRAFile.seek(l);
            this.dtaRAFile.writeShort(0);
            vector.removeElementAt(n);
            this.createAvailableRecordList();
            this.lastTimeModified = this.dtaFile.lastModified();
            this.closefiles();
            File file = new File(this.pathname + ".tmp");
            File file2 = new File(this.pathname + ".idx");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            n3 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                randomAccessFile.seek(n3);
                randomAccessFile.writeLong((Long)vector.elementAt(i));
                n3 += 8;
            }
            file.renameTo(file2);
            file.delete();
            file2 = null;
        }
        catch (Exception exception) {
            throw new Exception("Error encountered while removing an element." + exception.getMessage());
        }
    }

    public void setElementAt(Object object, int n) throws Exception {
        try {
            this.removeElementAt(n);
            this.insertElementAt(object, n);
        }
        catch (Exception exception) {
            throw new Exception("Error encountered while replacing an element." + exception.getMessage());
        }
    }

    private void createAvailableRecordList() throws IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        short s = 0;
        short s2 = 0;
        Vector<AvailableRecord> vector = new Vector<AvailableRecord>();
        this.availableRecordList = null;
        try {
            this.dtaRAFile.seek(n2);
        }
        catch (IOException iOException) {
            throw new IOException("... IO Exception detected. " + iOException.getMessage());
        }
        try {
            while (true) {
                s = this.dtaRAFile.readShort();
                s2 = this.dtaRAFile.readShort();
                if (s == 0) {
                    AvailableRecord availableRecord = new AvailableRecord(s2, n3);
                    vector.addElement(availableRecord);
                    this.dtaRAFile.skipBytes(s2 - 4);
                } else {
                    this.dtaRAFile.skipBytes(s);
                }
                n3 += s2;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            throw new IOException("... IO Exception detected. " + iOException.getMessage());
        }
        Object[] objectArray = new Object[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            objectArray[n] = (AvailableRecord)vector.elementAt(n);
        }
        if (objectArray.length != 0) {
            this.availableRecordList = new AvailableRecord[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                this.availableRecordList[n] = (AvailableRecord)objectArray[n];
            }
            if (this.availableRecordList.length > 0) {
                SortArray sortArray = new SortArray();
                SortArray.shellsort(this.availableRecordList);
            }
        }
    }

    private long getAvailableOffset(short s) {
        long l;
        try {
            l = this.dtaRAFile.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
        if (this.lastTimeModified == 0L || this.lastTimeModified != this.dtaFile.lastModified()) {
            this.availableRecordList = null;
            try {
                this.createAvailableRecordList();
            }
            catch (IOException iOException) {
                return -1L;
            }
        }
        if (this.availableRecordList != null && this.availableRecordList.length > 0) {
            for (int i = 0; i < this.availableRecordList.length; ++i) {
                AvailableRecord availableRecord;
                if (this.availableRecordList[i] == null || s > (availableRecord = this.availableRecordList[i]).getBytesAvailable() - 4) continue;
                this.availableRecordList[i] = null;
                return availableRecord.getFilePosition();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n = 0;
        try {
            File file = new File(this.pathname + ".idx");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            n = (int)randomAccessFile.length() / 8;
            randomAccessFile.close();
        }
        catch (IOException iOException) {}
        finally {
            return n;
        }
    }

    private byte[] byteArray(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
        }
        catch (IOException iOException) {
            throw new IOException("Exception detected while mapping object to byte array");
        }
        return byteArrayOutputStream.toByteArray();
    }
}

