/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.MultipartDataSource;
import javax.mail.Part;

public abstract class Multipart {
    protected Vector parts = new Vector();
    protected String contentType = "multipart/mixed";
    protected Part parent;

    public int getCount() throws MessagingException {
        if (this.parts == null) {
            return 0;
        }
        return this.parts.size();
    }

    protected Multipart() {
    }

    public void removeBodyPart(int n) throws MessagingException {
        if (this.parts == null) {
            throw new IndexOutOfBoundsException("No such BodyPart");
        }
        BodyPart bodyPart = (BodyPart)this.parts.elementAt(n);
        this.parts.removeElementAt(n);
        bodyPart.setParent(null);
    }

    public abstract void writeTo(OutputStream var1) throws IOException, MessagingException;

    public String getContentType() {
        return this.contentType;
    }

    public BodyPart getBodyPart(int n) throws MessagingException {
        if (this.parts == null) {
            throw new IndexOutOfBoundsException("No such BodyPart");
        }
        return (BodyPart)this.parts.elementAt(n);
    }

    public synchronized void addBodyPart(BodyPart bodyPart) throws MessagingException {
        if (this.parts == null) {
            this.parts = new Vector();
        }
        this.parts.addElement(bodyPart);
        bodyPart.setParent(this);
    }

    public boolean removeBodyPart(BodyPart bodyPart) throws MessagingException {
        if (this.parts == null) {
            throw new MessagingException("No such body part");
        }
        boolean bl = this.parts.removeElement(bodyPart);
        bodyPart.setParent(null);
        return bl;
    }

    public synchronized void addBodyPart(BodyPart bodyPart, int n) throws MessagingException {
        if (this.parts == null) {
            this.parts = new Vector();
        }
        this.parts.insertElementAt(bodyPart, n);
        bodyPart.setParent(this);
    }

    protected void setMultipartDataSource(MultipartDataSource multipartDataSource) throws MessagingException {
        this.contentType = multipartDataSource.getContentType();
        int n = multipartDataSource.getCount();
        int n2 = 0;
        while (n2 < n) {
            this.addBodyPart(multipartDataSource.getBodyPart(n2));
            ++n2;
        }
    }

    public Part getParent() {
        return this.parent;
    }

    public void setParent(Part part) {
        this.parent = part;
    }
}

