/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.agent;

import com.sun.swup.client.agent.SwupAgentData;
import com.sun.swup.client.agent.SwupCommand;
import com.sun.swup.client.agent.SwupInstallCommand;
import com.sun.swup.client.agent.SwupSetPrefCommand;
import com.sun.swup.client.agent.SwupUninstallCommand;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProcessSwupMsg
extends DefaultHandler {
    private static boolean debug = false;
    private static SwupAgentData sad = null;
    private static SAXParserFactory factory = SAXParserFactory.newInstance();
    private static SAXParser saxParser = null;
    private static StringBuffer accumulator = new StringBuffer();
    private String refID = "";
    private SwupCommand scom = null;
    private int commandType = 0;

    public ProcessSwupMsg() {
        sad = SwupAgentData.getInstance();
        debug = sad.getDebug();
    }

    int processMsg(String msg, String transRefID) {
        if (debug) {
            System.out.println("in ProcessSwupMsg.ProcessMsg()");
        }
        if (debug) {
            System.out.println(msg);
        }
        int retstat = 0;
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            return -1;
        }
        catch (SAXException se) {
            se.printStackTrace();
            return -1;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(msg.getBytes());
        try {
            saxParser.parse((InputStream)bais, (DefaultHandler)this);
        }
        catch (SAXException se) {
            se.printStackTrace();
            return -1;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return -1;
        }
        if (this.scom != null) {
            this.scom.setTransportRefID(transRefID);
            if (debug) {
                this.scom.dumpIt();
            }
            SwupAgentData.addSwupCmd(this.scom);
            if (debug) {
                System.out.println("processMsg: just added to cmd vector");
            }
        } else {
            if (debug) {
                System.out.println("processMsg: no recognized cmd found");
            }
            retstat = -1;
        }
        return retstat;
    }

    public void startElement(String nuri, String lname, String qname, Attributes attrs) {
        boolean errorOccurred = false;
        boolean haveCommand = false;
        accumulator.setLength(0);
        if (debug) {
            System.out.println("begin parsing of incoming command");
        }
        if (qname.equals("swup:Command") && attrs != null) {
            for (int ii = 0; ii < attrs.getLength(); ++ii) {
                String aname = attrs.getQName(ii);
                if (!aname.equals("swup:id")) continue;
                this.refID = attrs.getValue(ii);
                haveCommand = true;
                if (!debug) continue;
                System.out.println("processMsg: found Command");
            }
        } else if (qname.equals("swup:InstallCommand")) {
            if (!haveCommand) {
                // empty if block
            }
            this.scom = new SwupInstallCommand();
            this.scom.setRefID(this.refID);
            if (debug) {
                System.out.println("processMsg: found swup:InstallCommand");
            }
            for (int ii = 0; ii < attrs.getLength(); ++ii) {
                String aname = attrs.getQName(ii);
                if (!aname.equals("swup:collectionName")) continue;
                ((SwupInstallCommand)this.scom).setCollectionName(attrs.getValue(ii));
            }
        } else if (qname.equals("swup:UninstallCommand")) {
            if (!haveCommand) {
                // empty if block
            }
            this.scom = new SwupUninstallCommand();
            this.scom.setRefID(this.refID);
            if (debug) {
                System.out.println("processMsg: found swup:UninstallCommand");
            }
        } else if (qname.equals("swup:PreferenceChange")) {
            if (!haveCommand) {
                // empty if block
            }
            this.scom = new SwupSetPrefCommand();
            this.scom.setRefID(this.refID);
            if (debug) {
                System.out.println("processMsg: found swup:PreferenceChange");
            }
        } else if (qname.equals("swup:Preference")) {
            if (this.scom != null && this.scom instanceof SwupSetPrefCommand) {
                for (int ii = 0; ii < attrs.getLength(); ++ii) {
                    String nextAname;
                    String aname = attrs.getQName(ii);
                    if (!aname.equals("swup:name") || !(nextAname = attrs.getQName(ii + 1)).equals("swup:value")) continue;
                    ((SwupSetPrefCommand)this.scom).setCheckinIntervalPref(attrs.getValue(ii + 1));
                }
            }
            if (debug) {
                System.out.println("processMsg: found swup:Preference");
            }
        } else if (qname.equals("swup:Property")) {
            if (this.scom != null && this.scom instanceof SwupSetPrefCommand) {
                for (int ii = 0; ii < attrs.getLength(); ++ii) {
                    String aname = attrs.getQName(ii);
                    if (aname.equals("swup:name")) {
                        ((SwupSetPrefCommand)this.scom).setPropName(attrs.getValue(ii));
                        continue;
                    }
                    if (!aname.equals("swup:value")) continue;
                    ((SwupSetPrefCommand)this.scom).setPropValue(attrs.getValue(ii));
                }
            }
            if (debug) {
                System.out.println("processMsg: found swup:Property");
            }
        } else if (qname.equals("swup:Update") && attrs != null) {
            if (this.scom != null && (this.scom instanceof SwupInstallCommand || this.scom instanceof SwupUninstallCommand)) {
                for (int ii = 0; ii < attrs.getLength(); ++ii) {
                    String aname = attrs.getQName(ii);
                    if (!aname.equals("swup:id")) continue;
                    if (this.scom != null && this.scom instanceof SwupInstallCommand) {
                        ((SwupInstallCommand)this.scom).addUpdateName(attrs.getValue(ii));
                        continue;
                    }
                    if (this.scom == null || !(this.scom instanceof SwupUninstallCommand)) continue;
                    ((SwupUninstallCommand)this.scom).addUpdateName(attrs.getValue(ii));
                }
            }
            if (debug) {
                System.out.println("processMsg: found swup:Update");
            }
        } else if (debug) {
            System.out.println("processMsg: found unexpected element: " + qname);
        }
    }

    public void endElement(String nms, String localName, String qname) {
    }

    public void characters(char[] buffer, int start, int length) {
        accumulator.append(buffer, start, length);
    }
}

