/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.common;

import com.sun.swup.client.common.LogThread;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExecuteCommand {
    private boolean collectOutput = false;
    private String[] errorLogFiles = null;
    private String[] outputLogFiles = null;
    private int outputType = 0;
    public static final int NORMAL = 1;
    public static final int ERRORS = 2;
    private int result = -1;
    private String output = "";
    private String errors = "";
    private String both = "";
    private boolean state = false;
    private String errorMessage = null;
    private String stringEncoder = null;
    private InputStream stdin = null;
    private Hashtable env = null;
    private File workingDir = null;
    private String[] command = null;

    public void setStdin(InputStream stdin) {
        this.stdin = stdin;
    }

    public void setEncoder(String stringEncoder) {
        this.stringEncoder = stringEncoder;
    }

    public InputStream getStdin() {
        return this.stdin;
    }

    public boolean getCollectOutput() {
        return this.collectOutput;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public void setCollectOutput(boolean output) {
        this.collectOutput = output;
    }

    public void setOutputType(int type) {
        this.outputType = type;
    }

    public void setCommand(String[] args) {
        this.command = args;
    }

    public void setWorkingDir(String wdir) {
        this.workingDir = new File(wdir);
    }

    public void setCommand(String command) {
        this.command = ExecuteCommand.parseCommand(command);
    }

    public static String[] parseCommand(String cmd) {
        StringTokenizer st = new StringTokenizer(cmd);
        int toks = st.countTokens();
        String[] pcmd = new String[toks];
        for (int i = 0; i < toks; ++i) {
            pcmd[i] = st.nextToken();
        }
        return pcmd;
    }

    public static String expandCommand(String[] cmd) {
        String scmd = "";
        for (int i = 0; i < cmd.length; ++i) {
            scmd = scmd + cmd[i] + " ";
        }
        scmd = scmd.trim();
        return scmd;
    }

    public String[] getCommand() {
        return this.command;
    }

    public void putEnvironmentSetting(String setting, String val) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        if (setting == null) {
            throw new IllegalArgumentException("ExecuteCommand: putEnvironmentSetting: setting cannot be null");
        }
        if (val == null) {
            this.env.remove(setting);
        } else {
            this.env.put(setting, val);
        }
    }

    public String removeEnvironmentSetting(String setting) {
        if (setting == null) {
            throw new IllegalArgumentException("ExecuteCommand: removeEnvironmentSetting: setting cannot be null");
        }
        if (this.env == null) {
            return null;
        }
        return (String)this.env.remove(setting);
    }

    public void setLogFiles(String[] logFiles) {
        this.addLogFiles(3, logFiles);
    }

    public void addLogFiles(int type, String[] newFiles) {
        String[] tmp;
        if ((type & 1) != 0) {
            if (this.outputLogFiles == null) {
                this.outputLogFiles = newFiles;
            } else {
                tmp = this.outputLogFiles;
                this.outputLogFiles = new String[tmp.length + newFiles.length];
                System.arraycopy(tmp, 0, this.outputLogFiles, 0, tmp.length);
                System.arraycopy(newFiles, 0, this.outputLogFiles, tmp.length, newFiles.length);
            }
        }
        if ((type & 2) != 0) {
            if (this.errorLogFiles == null) {
                this.errorLogFiles = newFiles;
            } else {
                tmp = this.errorLogFiles;
                this.errorLogFiles = new String[tmp.length + newFiles.length];
                System.arraycopy(tmp, 0, this.errorLogFiles, 0, tmp.length);
                System.arraycopy(newFiles, 0, this.errorLogFiles, tmp.length, newFiles.length);
            }
        }
    }

    public ExecuteCommand(String command) {
        this(command, null);
    }

    public ExecuteCommand(String[] command) {
        this("", null);
        this.setCommand(command);
    }

    public ExecuteCommand(String command, InputStream stdin) {
        this(command, stdin, null, 3);
    }

    public ExecuteCommand(String command, InputStream stdin, String[] logOutputFiles, int which) {
        this.setStdin(stdin);
        this.setCollectOutput(true);
        this.setOutputType(which);
        this.setCommand(command);
        this.setLogFiles(logOutputFiles);
    }

    private static String[] createEnvArray(Hashtable env) {
        if (env == null) {
            return null;
        }
        Enumeration keys = env.keys();
        String[] result = new String[env.size()];
        int i = 0;
        while (keys.hasMoreElements()) {
            String nextKey = (String)keys.nextElement();
            String nextVal = (String)env.get(nextKey);
            result[i++] = nextKey + "=" + nextVal;
        }
        return result;
    }

    public void execute() throws InterruptedException {
        Process process = null;
        try {
            String[] envArray = ExecuteCommand.createEnvArray(this.env);
            process = this.workingDir != null ? Runtime.getRuntime().exec(this.command, envArray, this.workingDir) : Runtime.getRuntime().exec(this.command, envArray);
            if (process != null) {
                LogThread feeder = null;
                if (this.stdin != null) {
                    feeder = new LogThread(this.stdin, process.getOutputStream());
                    feeder.setClose(true);
                    feeder.setName("Feeder");
                    feeder.start();
                }
                if (this.collectOutput) {
                    this.readOutput(process);
                } else {
                    this.result = process.waitFor();
                }
                if (feeder != null) {
                    feeder.join();
                }
                process.getInputStream().close();
                process.getOutputStream().close();
                process.getErrorStream().close();
                process.destroy();
                process = null;
                this.state = true;
            }
        }
        catch (IOException ex) {
            if (process == null) {
                this.errorMessage = "ExecuteCommand: " + ExecuteCommand.expandCommand(this.command) + " failed";
            }
            System.out.println("ExecuteCommand Error: " + ex);
            ex.printStackTrace();
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public int getResult() {
        return this.result;
    }

    public void setErrorMessage(String errMsg) {
        this.errorMessage = errMsg;
    }

    public String getOutput() {
        return this.output;
    }

    public String getErrors() {
        return this.errors;
    }

    public String getAllOutput() {
        return this.both;
    }

    public void readOutput(Process process) throws InterruptedException {
        int currentLog;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ByteArrayOutputStream berr = new ByteArrayOutputStream();
        ByteArrayOutputStream bboth = new ByteArrayOutputStream();
        DataInputStream in = new DataInputStream(process.getInputStream());
        DataInputStream err = new DataInputStream(process.getErrorStream());
        Object nextLine = null;
        String newLine = System.getProperty("line.separator");
        if (newLine == null) {
            newLine = "\r\n";
        }
        FileOutputStream[] outputLog = null;
        OutputStream[] outputOutstrm = null;
        FileOutputStream[] errorLog = null;
        OutputStream[] errorOutstrm = null;
        if (this.outputLogFiles != null) {
            outputLog = new FileOutputStream[this.outputLogFiles.length];
            outputOutstrm = new DataOutputStream[this.outputLogFiles.length];
            currentLog = 0;
            try {
                for (currentLog = 0; currentLog < this.outputLogFiles.length; ++currentLog) {
                    outputLog[currentLog] = new FileOutputStream(this.outputLogFiles[currentLog], true);
                    outputOutstrm[currentLog] = new DataOutputStream(outputLog[currentLog]);
                }
                if ((this.outputType & 1) != 0) {
                    this.output.concat("---> " + this.outputLogFiles[0]);
                    this.both.concat("---> " + this.outputLogFiles[0]);
                }
            }
            catch (IOException e) {
                System.out.println("RunCmd: Error opening log file \"" + this.outputLogFiles[currentLog] + "\" for writing standard output");
                outputLog = null;
            }
        }
        if (this.errorLogFiles != null) {
            errorLog = new FileOutputStream[this.errorLogFiles.length];
            errorOutstrm = new DataOutputStream[this.errorLogFiles.length];
            currentLog = 0;
            try {
                for (currentLog = 0; currentLog < this.errorLogFiles.length; ++currentLog) {
                    errorLog[currentLog] = new FileOutputStream(this.errorLogFiles[currentLog], true);
                    errorOutstrm[currentLog] = new DataOutputStream(errorLog[currentLog]);
                }
                if ((this.outputType & 1) != 0) {
                    this.output.concat("---> " + this.errorLogFiles[0]);
                    this.both.concat("---> " + this.errorLogFiles[0]);
                }
            }
            catch (IOException e) {
                System.out.println("RunCmd: Error opening log file \"" + this.errorLogFiles[currentLog] + "\" for writing standard error");
                errorLog = null;
            }
        }
        try {
            OutputStream[] outs;
            LogThread inReader = null;
            LogThread errReader = null;
            if ((this.outputType & 1) != 0) {
                if (outputLog != null) {
                    inReader = new LogThread((InputStream)in, outputOutstrm);
                } else {
                    outs = new ByteArrayOutputStream[]{bout, bboth};
                    inReader = new LogThread((InputStream)in, outs);
                }
                inReader.setName("STDIN Reader");
                inReader.start();
            }
            if ((this.outputType & 2) != 0) {
                if (errorLog != null) {
                    errReader = new LogThread((InputStream)err, errorOutstrm);
                } else {
                    outs = new ByteArrayOutputStream[]{berr, bboth};
                    errReader = new LogThread((InputStream)err, outs);
                }
                errReader.setName("STDERR Reader");
                errReader.start();
            }
            this.result = process.waitFor();
            if (inReader != null) {
                inReader.join();
            }
            if (errReader != null) {
                errReader.join();
            }
            in.close();
            err.close();
            if (this.stringEncoder != null) {
                this.output = bout.toString(this.stringEncoder);
                this.errors = berr.toString(this.stringEncoder);
                this.both = bboth.toString(this.stringEncoder);
            } else {
                this.output = bout.toString();
                this.errors = berr.toString();
                this.both = bboth.toString();
            }
            if (outputOutstrm != null) {
                for (int streamCount = 0; streamCount < outputOutstrm.length; ++streamCount) {
                    ((DataOutputStream)outputOutstrm[streamCount]).flush();
                    ((FilterOutputStream)outputOutstrm[streamCount]).close();
                }
            }
            if (errorOutstrm != null) {
                for (int streamCount = 0; streamCount < errorOutstrm.length; ++streamCount) {
                    ((DataOutputStream)errorOutstrm[streamCount]).flush();
                    ((FilterOutputStream)errorOutstrm[streamCount]).close();
                }
            }
            if (outputLog != null) {
                for (int streamCount = 0; streamCount < outputLog.length; ++streamCount) {
                    outputLog[streamCount].flush();
                    outputLog[streamCount].close();
                }
            }
            if (errorLog != null) {
                for (int streamCount = 0; streamCount < errorLog.length; ++streamCount) {
                    errorLog[streamCount].flush();
                    errorLog[streamCount].close();
                }
            }
        }
        catch (IOException ex) {
            if (ex instanceof EOFException) {
                return;
            }
            System.out.println("ExecuteCommand Error:" + ex);
            ex.printStackTrace();
        }
    }

    public static void addRuntimeResources(Vector v) {
        v.addElement("com.sun.install.products.ExecuteCommand");
        v.addElement("com.sun.install.products.LogThread");
    }
}

