/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.common.environment;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public abstract class AbstractEnvironment {
    private String sName = "abstract";
    private String sImageFolder = "default";
    private HashMap hashMap = new HashMap();
    private HashMap fontHashMap = new HashMap();
    private HashMap fontSizeHashMap = new HashMap();
    private HashMap imageIconHashMap = new HashMap();
    private HashMap insetsHashMap = new HashMap();
    private HashMap dimensionHashMap = new HashMap();
    private HashMap integerHashMap = new HashMap();

    public AbstractEnvironment() {
        this.putFont("small-font", new Font("Sans Serif", 0, 11));
        this.putFont("large-font", new Font("Sans Serif", 0, 13));
        this.putFont("header-font", new Font("Sans Serif", 0, 12));
        this.putFont("monospace-font", new Font("Courier", 0, 9));
        this.putFontSize("small-font", 11.0f);
        this.putFontSize("large-font", 13.0f);
        this.initialize();
    }

    public void initialize() {
        boolean iAlpha = false;
        Color clearColor = new Color(0, 0, 0, 0);
        UIManager.put("Table.focusCellHighlightBorder", BorderFactory.createLineBorder(clearColor, 1));
        UIManager.put("List.focusCellHighlightBorder", BorderFactory.createLineBorder(clearColor, 1));
        Color color = UIManager.getColor("Table.background");
        if (color != null) {
            UIManager.put("Viewport.background", color);
        }
        UIManager.put("windowBorder", BorderFactory.createLineBorder(Color.red, 3));
    }

    protected boolean isMetal() {
        return false;
    }

    protected boolean isSolaris() {
        return false;
    }

    protected boolean isWindows() {
        return false;
    }

    protected boolean isLinux() {
        return false;
    }

    protected boolean isJDS() {
        return false;
    }

    protected boolean isMac() {
        return false;
    }

    protected String setName(String sName) {
        return this.sName;
    }

    protected String getName() {
        return this.sName;
    }

    protected void setImageFolder(String sImageFolder) {
        this.sImageFolder = sImageFolder;
    }

    protected String getImageFolder() {
        return this.sImageFolder;
    }

    public void putValue(String sKey, Object object) {
        this.hashMap.put(sKey, object);
    }

    public Object getValue(String sKey) {
        return this.hashMap.get(sKey);
    }

    public void putFont(String sKey, Font font) {
        this.fontHashMap.put(sKey, font);
    }

    public Font getFont(String sKey) {
        return (Font)this.fontHashMap.get(sKey);
    }

    public void putFontSize(String sKey, float size) {
        this.fontSizeHashMap.put(sKey, new Float(size));
    }

    public float getFontSize(String sKey) {
        Float fontSize = (Float)this.fontSizeHashMap.get(sKey);
        if (fontSize != null) {
            return fontSize.floatValue();
        }
        return -1.0f;
    }

    public void putImageIcon(String sKey, ImageIcon imageIcon) {
        this.imageIconHashMap.put(sKey, imageIcon);
    }

    public ImageIcon getImageIcon(String sKey) {
        return (ImageIcon)this.imageIconHashMap.get(sKey);
    }

    public void putInsets(String sKey, Insets insets) {
        this.insetsHashMap.put(sKey, insets);
    }

    public Insets getInsets(String sKey) {
        return (Insets)this.insetsHashMap.get(sKey);
    }

    public void putDimension(String sKey, Dimension dimension) {
        this.dimensionHashMap.put(sKey, dimension);
    }

    public Dimension getDimension(String sKey) {
        return (Dimension)this.dimensionHashMap.get(sKey);
    }

    public void putInteger(String sKey, int integer) {
        this.integerHashMap.put(sKey, new Integer(integer));
    }

    public int getInteger(String sKey) {
        return (Integer)this.integerHashMap.get(sKey);
    }

    public boolean isToggleKeyDown(MouseEvent e) {
        if (e.isPopupTrigger()) {
            return false;
        }
        return e.isControlDown();
    }
}

