/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.common.environment;

import com.sun.swup.client.common.environment.AbstractEnvironment;
import com.sun.swup.client.common.environment.Solaris;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public abstract class Environment {
    static final String DEFAULT_IMAGE_FOLDER = "default";
    private static final String IMAGE_PATH = "resources/images/";
    private static final String KNOWN_IMAGE = "blank.png";
    public static final String SMALL_FONT = "small-font";
    public static final String LARGE_FONT = "large-font";
    public static final String HEADER_FONT = "header-font";
    public static final String MONOSPACE_FONT = "monospace-font";
    private static AbstractEnvironment environment;

    public static void initializeEnvironment() {
        Environment.lookAndFeelChanged();
    }

    public static void lookAndFeelChanged() {
        if (System.getProperty("mrj.version") != null) {
            Environment.setEnvironment(Environment.createEnvironment("com.sun.swup.client.ui.foundation.environment.MacAqua"));
        } else {
            Environment.setEnvironment(new Solaris());
        }
    }

    private static AbstractEnvironment createEnvironment(String sClass) {
        Class<?> theClass = null;
        AbstractEnvironment environment = null;
        try {
            theClass = Class.forName(sClass);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            environment = (AbstractEnvironment)theClass.newInstance();
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return environment;
    }

    public static void setMetalEnabled(boolean bMetalEnabled) {
        if (bMetalEnabled) {
            try {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public static void setEnvironment(AbstractEnvironment environment) {
        Environment.environment = environment;
    }

    public static AbstractEnvironment getEnvironment() {
        return environment;
    }

    public static boolean isJDS() {
        return Environment.getEnvironment().isJDS();
    }

    public static boolean isSolaris() {
        return Environment.getEnvironment().isSolaris();
    }

    public static boolean isMetal() {
        return Environment.getEnvironment().isMetal();
    }

    public static boolean isLinux() {
        return Environment.getEnvironment().isLinux();
    }

    public static boolean isWindows() {
        return Environment.getEnvironment().isWindows();
    }

    public static boolean isMac() {
        return Environment.getEnvironment().isMac();
    }

    public void putValue(String sKey, Object object) {
        Environment.getEnvironment().putValue(sKey, object);
    }

    public Object getValue(String sKey) {
        return Environment.getEnvironment().getValue(sKey);
    }

    public static void putFont(String sKey, Font font) {
        Environment.getEnvironment().putFont(sKey, font);
    }

    public static Font getFont(String sKey) {
        return Environment.getEnvironment().getFont(sKey);
    }

    public void putFontSize(String sKey, float size) {
        Environment.getEnvironment().putFontSize(sKey, size);
    }

    public static float getFontSize(String sKey) {
        return Environment.getEnvironment().getFontSize(sKey);
    }

    public static void putImageIcon(String sKey, ImageIcon imageIcon) {
        Environment.getEnvironment().putImageIcon(sKey, imageIcon);
    }

    public static ImageIcon getImageIcon(String sImage) {
        ImageIcon imageIcon = Environment.getEnvironment().getImageIcon(sImage);
        if (imageIcon == null) {
            String sImagePath = IMAGE_PATH + Environment.getEnvironment().getImageFolder() + "/" + sImage;
            URL url = Environment.getEnvironment().getClass().getClassLoader().getResource(sImagePath);
            if (url == null) {
                sImagePath = IMAGE_PATH + sImage;
                url = Environment.getEnvironment().getClass().getClassLoader().getResource(sImagePath);
            }
            if (url == null) {
                sImagePath = "resources/images/default/" + sImage;
                url = Environment.getEnvironment().getClass().getClassLoader().getResource(sImagePath);
                if (url == null) {
                    sImagePath = "resources/images/default/blank.png";
                    url = Environment.getEnvironment().getClass().getClassLoader().getResource(sImagePath);
                }
            }
            imageIcon = new ImageIcon(url);
        }
        return imageIcon;
    }

    public static void putInsets(String sKey, Insets insets) {
        Environment.getEnvironment().putInsets(sKey, insets);
    }

    public static Insets getInsets(String sKey) {
        return Environment.getEnvironment().getInsets(sKey);
    }

    public static void putDimension(String sKey, Dimension dimension) {
        Environment.getEnvironment().putDimension(sKey, dimension);
    }

    public static Dimension getDimension(String sKey) {
        return Environment.getEnvironment().getDimension(sKey);
    }

    public static void putInteger(String sKey, int integer) {
        Environment.getEnvironment().putInteger(sKey, integer);
    }

    public static int getInteger(String sKey) {
        return Environment.getEnvironment().getInteger(sKey);
    }
}

