/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client;

import com.sun.xml.rpc.client.HandlerException;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;

public class HandlerChainImpl
extends Vector
implements HandlerChain {
    protected List handlerInfos;
    String[] roles = null;
    boolean initialized = false;
    Hashtable handlerPool = new Hashtable();
    List understoodHeaders = new ArrayList();

    private void createHandlerInstances() {
        int i = 0;
        while (i < this.handlerInfos.size()) {
            this.add(this.newHandler(this.getHandlerInfo(i)));
            ++i;
        }
    }

    public void destroy() {
        int i = 0;
        while (i < this.size()) {
            this.deleteHandlerInstance(i);
            ++i;
        }
        this.clear();
    }

    protected void deleteHandlerInstance(int index) {
        Handler h = this.getHandlerInstance(index);
        h.destroy();
        this.removeHandlerFromPool(h.getClass());
    }

    protected void removeHandlerFromPool(Class clz) {
        this.handlerPool.remove(clz.getName());
    }

    public String[] getRoles() {
        return this.roles;
    }

    public void setRoles(String[] soapActorNames) {
        this.roles = soapActorNames;
    }

    public HandlerChainImpl(List handlerInfos) {
        this.handlerInfos = handlerInfos;
        this.createHandlerInstances();
    }

    public void init(Map config) {
    }

    public void addUnderstoodHeaders(QName[] ignoredHeaders) {
        if (ignoredHeaders != null) {
            int i = 0;
            while (i < ignoredHeaders.length) {
                this.understoodHeaders.add(ignoredHeaders[i]);
                ++i;
            }
        }
    }

    protected Handler getHandlerInstance(int index) {
        return this.castToHandler(this.get(index));
    }

    protected HandlerInfo getHandlerInfo(int index) {
        return (HandlerInfo)this.handlerInfos.get(index);
    }

    public void addHandlerInfo(int index, HandlerInfo handlerInfo) {
        this.handlerInfos.add(index, handlerInfo);
        this.add(index, this.newHandler(handlerInfo));
    }

    public void addHandlerInfo(HandlerInfo handlerInfo) {
        this.addHandlerInfo(this.handlerInfos.size(), handlerInfo);
    }

    public boolean checkMustUnderstand(MessageContext mc) throws SOAPException {
        if (this.roles != null && !this.isEmpty()) {
            SOAPMessage soapMessage = ((SOAPMessageContext)mc).getMessage();
            SOAPHeader header = soapMessage.getSOAPPart().getEnvelope().getHeader();
            if (header == null) {
                return true;
            }
            int i = 0;
            while (i < this.roles.length) {
                String actor = this.roles[i];
                Iterator it = header.examineMustUnderstandHeaderElements(actor);
                while (it.hasNext()) {
                    SOAPHeaderElement element = (SOAPHeaderElement)it.next();
                    Name saajName = element.getElementName();
                    QName qname = new QName(saajName.getURI(), saajName.getLocalName());
                    if (this.understoodHeaders.contains(qname)) continue;
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean handleFault(MessageContext _context) {
        int n;
        SOAPMessageContext context = (SOAPMessageContext)_context;
        int i = n = context.getCurrentHandler();
        while (i >= 0) {
            context.setCurrentHandler(i);
            try {
                if (!this.getHandlerInstance(i).handleFault((MessageContext)context)) {
                    return false;
                }
            }
            catch (SOAPFaultException sfe) {
                throw sfe;
            }
            catch (RuntimeException re) {
                this.deleteHandlerInstance(i);
                this.setElementAt(this.newHandler(this.getHandlerInfo(i)), i);
                throw re;
            }
            --i;
        }
        context.setCurrentHandler(-1);
        return true;
    }

    public boolean handleRequest(MessageContext _context) {
        SOAPMessageContext context = (SOAPMessageContext)_context;
        context.setRoles(this.roles);
        int i = 0;
        while (i < this.size()) {
            Handler currentHandler = this.getHandlerInstance(i);
            context.setCurrentHandler(i);
            try {
                if (!currentHandler.handleRequest((MessageContext)context)) {
                    return false;
                }
            }
            catch (SOAPFaultException sfe) {
                throw sfe;
            }
            catch (RuntimeException re) {
                this.deleteHandlerInstance(i);
                this.setElementAt(this.newHandler(this.getHandlerInfo(i)), i);
                throw re;
            }
            ++i;
        }
        context.setCurrentHandler(-1);
        return true;
    }

    public boolean handleResponse(MessageContext _context) {
        if (this.size() > 0) {
            SOAPMessageContext context = (SOAPMessageContext)_context;
            int n = context.getCurrentHandler();
            if (n == -1) {
                n = this.size() - 1;
            }
            int i = n;
            while (i >= 0) {
                context.setCurrentHandler(i);
                try {
                    if (!this.getHandlerInstance(i).handleResponse((MessageContext)context)) {
                        context.setCurrentHandler(-1);
                        return false;
                    }
                }
                catch (SOAPFaultException sfe) {
                    throw sfe;
                }
                catch (RuntimeException re) {
                    this.deleteHandlerInstance(i);
                    this.setElementAt(this.newHandler(this.getHandlerInfo(i)), i);
                    throw re;
                }
                --i;
            }
            context.setCurrentHandler(-1);
        }
        return true;
    }

    protected Handler castToHandler(Object o) {
        if (!(o instanceof Handler)) {
            throw new HandlerException("handler.chain.contains.handler.only", new Object[]{o.getClass().getName()});
        }
        return (Handler)o;
    }

    protected Handler getHandlerFromPool(HandlerInfo handlerInfo) {
        Class clz = handlerInfo.getHandlerClass();
        Handler h = (Handler)this.handlerPool.get(clz.getName());
        if (h == null) {
            try {
                h = (Handler)clz.newInstance();
                h.init(handlerInfo);
                this.addUnderstoodHeaders(h.getHeaders());
                this.handlerPool.put(clz.getName(), h);
            }
            catch (Exception ex) {
                throw new HandlerException("Unable to instantiate handler: ", new Object[]{handlerInfo.getHandlerClass(), new LocalizableExceptionAdapter(ex)});
            }
        }
        return h;
    }

    protected Handler newHandler(HandlerInfo handlerInfo) {
        return this.getHandlerFromPool(handlerInfo);
    }
}

