/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.client.dii.BasicCall;
import com.sun.xml.rpc.client.dii.OperationInfo;
import com.sun.xml.rpc.client.dii.ParameterMemberInfo;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ObjectArraySerializer;
import com.sun.xml.rpc.encoding.PolymorphicArraySerializer;
import com.sun.xml.rpc.encoding.ReferenceableSerializerImpl;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerConstants;
import com.sun.xml.rpc.encoding.SingletonDeserializerFactory;
import com.sun.xml.rpc.encoding.SingletonSerializerFactory;
import com.sun.xml.rpc.encoding.TypeMappingException;
import com.sun.xml.rpc.encoding.TypeMappingImpl;
import com.sun.xml.rpc.encoding.ValueTypeSerializer;
import com.sun.xml.rpc.encoding.literal.LiteralArraySerializer;
import com.sun.xml.rpc.encoding.literal.LiteralFragmentSerializer;
import com.sun.xml.rpc.encoding.literal.LiteralObjectArraySerializer;
import com.sun.xml.rpc.encoding.literal.LiteralObjectSerializerBase;
import com.sun.xml.rpc.encoding.literal.LiteralSimpleTypeSerializer;
import com.sun.xml.rpc.encoding.literal.ValueTypeLiteralSerializer;
import com.sun.xml.rpc.encoding.simpletype.XSDIntEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDListTypeEncoder;
import com.sun.xml.rpc.encoding.soap.SOAP12Constants;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralListType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.Serializer;
import javax.xml.rpc.encoding.SerializerFactory;

public class DynamicInternalTypeMappingRegistry
implements InternalTypeMappingRegistry,
SerializerConstants {
    protected static final QName ELEMENT_NAME = null;
    protected static String DEFAULT_OPERATION_STYLE = "document";
    protected InternalTypeMappingRegistry registry = null;
    private TypeMappingImpl cachedEncodedMappings = new TypeMappingImpl();
    private TypeMappingImpl cachedLiteralMappings = new TypeMappingImpl();
    private HashMap qnameToJavaClass = new HashMap();
    private SOAPEncodingConstants soapEncodingConstants = null;
    private String operationStyle;
    private BasicCall currentCall;
    private HashMap dynamicMemberRegistry = new HashMap();
    static /* synthetic */ Class class$javax$xml$soap$SOAPElement;
    static /* synthetic */ Class class$java$rmi$Remote;

    public DynamicInternalTypeMappingRegistry(InternalTypeMappingRegistry registry) {
        this(registry, null, SOAPVersion.SOAP_11);
    }

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public static boolean isValueType(Class javaType) throws Exception {
        if (javaType == null || (class$java$rmi$Remote == null ? (class$java$rmi$Remote = DynamicInternalTypeMappingRegistry.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(javaType)) {
            return false;
        }
        boolean hasPublicConstructor = false;
        Constructor<?>[] constructors = javaType.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            if (constructors[i].getParameterTypes().length == 0) {
                hasPublicConstructor = true;
                break;
            }
            ++i;
        }
        if (!hasPublicConstructor) {
            return false;
        }
        boolean hasPropertiesOrPublicFields = false;
        if (Introspector.getBeanInfo(javaType).getPropertyDescriptors().length == 0) {
            Field[] fields = javaType.getFields();
            int i2 = 0;
            while (i2 < fields.length) {
                Field currentField = fields[i2];
                int fieldModifiers = currentField.getModifiers();
                if (Modifier.isPublic(fieldModifiers) && !Modifier.isTransient(fieldModifiers) && !Modifier.isFinal(fieldModifiers)) {
                    hasPropertiesOrPublicFields = true;
                    break;
                }
                ++i2;
            }
        } else {
            hasPropertiesOrPublicFields = true;
        }
        return hasPropertiesOrPublicFields;
    }

    public String getStyle() {
        return this.operationStyle;
    }

    public void setStyles(String operationStyle) {
        this.operationStyle = operationStyle;
        if (operationStyle == null) {
            operationStyle = DEFAULT_OPERATION_STYLE;
        }
    }

    private Collection getCurrentOperationParameterModels() {
        OperationInfo info;
        if (this.currentCall != null && (info = this.currentCall.getOperationInfo()) != null) {
            return info.getParameterModels();
        }
        return new ArrayList();
    }

    public HashMap getDynamicMemberRegistry() {
        return this.dynamicMemberRegistry;
    }

    public DynamicInternalTypeMappingRegistry(InternalTypeMappingRegistry registry, BasicCall currentCall) {
        this(registry, currentCall, SOAPVersion.SOAP_11);
    }

    LiteralType getParameterLiteralType(String parameterName) {
        Collection parameterModels = this.getCurrentOperationParameterModels();
        Iterator modelsIter = parameterModels.iterator();
        while (modelsIter.hasNext()) {
            QName name;
            Object model = modelsIter.next();
            if (!(model instanceof LiteralElementMember) || !(name = ((LiteralElementMember)model).getName()).getLocalPart().equalsIgnoreCase(parameterName)) continue;
            LiteralType type = ((LiteralElementMember)model).getType();
            return type;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static boolean isArray(Class javaType, QName xmlType) {
        return DynamicInternalTypeMappingRegistry.isArray(javaType, xmlType, SOAPVersion.SOAP_11);
    }

    public static boolean isLiteralArray(Class javaType, QName xmlType) {
        return DynamicInternalTypeMappingRegistry.isLiteralArray(javaType, xmlType, SOAPVersion.SOAP_11);
    }

    private QName checkParameterXmlTypesUsingModels(QName suppliedXmlType) {
        Collection parameterModels = this.getCurrentOperationParameterModels();
        if (parameterModels == null) {
            return null;
        }
        Iterator iter = parameterModels.iterator();
        return this.recursiveCheck(iter, suppliedXmlType);
    }

    private ReferenceableSerializerImpl createArraySerializer(Class javaType, QName xmlType) throws Exception {
        int idx;
        if (javaType == null || xmlType == null) {
            return null;
        }
        Class<?> elementType = javaType.getComponentType();
        String elementName = null;
        if (elementType != null && (idx = (elementName = elementType.getName()).lastIndexOf(".")) != -1) {
            elementName = elementName.substring(idx + 1, elementName.length()).toLowerCase();
        }
        Serializer componentSerializer = null;
        try {
            componentSerializer = this.registry.getSerializer(this.soapEncodingConstants.getURIEncoding(), elementType);
        }
        catch (TypeMappingException ex) {
            // empty catch block
        }
        ObjectArraySerializer objectArraySerializer = null;
        ReferenceableSerializerImpl serializer = null;
        if (componentSerializer != null) {
            objectArraySerializer = new ObjectArraySerializer(xmlType, true, true, "http://schemas.xmlsoap.org/soap/encoding/", ELEMENT_NAME, new QName("http://www.w3.org/2001/XMLSchema", elementName), elementType, 1, null);
            serializer = new ReferenceableSerializerImpl(false, objectArraySerializer);
            this.cachedEncodedMappings.register(javaType, this.soapEncodingConstants.getQNameEncodingArray(), new SingletonSerializerFactory(objectArraySerializer), new SingletonDeserializerFactory(objectArraySerializer));
        } else {
            serializer = new ReferenceableSerializerImpl(false, new PolymorphicArraySerializer(xmlType, false, true, this.soapEncodingConstants.getURIEncoding(), ELEMENT_NAME));
            this.cachedEncodedMappings.register(javaType, xmlType, new SingletonSerializerFactory(serializer), new SingletonDeserializerFactory(serializer));
        }
        serializer.initialize(this);
        return serializer;
    }

    private ReferenceableSerializerImpl createValueSerializer(Class javaType, QName xmlType) throws Exception {
        if (javaType == null || xmlType == null) {
            return null;
        }
        ReferenceableSerializerImpl serializer = new ReferenceableSerializerImpl(true, new ValueTypeSerializer(xmlType, false, true, this.soapEncodingConstants.getURIEncoding(), javaType));
        this.cachedEncodedMappings.register(javaType, xmlType, new SingletonSerializerFactory(serializer), new SingletonDeserializerFactory(serializer));
        serializer.initialize(this);
        return serializer;
    }

    public DynamicInternalTypeMappingRegistry(InternalTypeMappingRegistry registry, BasicCall currentCall, SOAPVersion ver) {
        this.init(ver);
        if (registry == null) {
            throw new IllegalArgumentException("registry must not be null");
        }
        this.currentCall = currentCall;
        this.registry = registry;
    }

    public static boolean isArray(Class javaType, QName xmlType, SOAPVersion ver) {
        if (javaType == null) {
            return false;
        }
        QName encArray = SOAPConstants.QNAME_ENCODING_ARRAY;
        if (ver == SOAPVersion.SOAP_12) {
            encArray = SOAP12Constants.QNAME_ENCODING_ARRAY;
        }
        boolean isArray = javaType.isArray();
        boolean isSame = false;
        if (xmlType != null) {
            if (xmlType.getLocalPart().indexOf(encArray.getLocalPart()) != -1) {
                isSame = true;
            }
            return isArray && isSame;
        }
        return isArray;
    }

    public static boolean isLiteralArray(Class javaType, QName xmlType, SOAPVersion ver) {
        if (javaType == null) {
            return false;
        }
        return javaType.isArray();
    }

    public Class getJavaType(String encoding, QName xmlType) throws Exception {
        return this.registry.getJavaType(encoding, xmlType);
    }

    private Collection orderCurrentMembersPerWsdl(QName suppliedQName, Class javaType) {
        if (javaType == null) {
            return null;
        }
        String className = javaType.getName();
        ArrayList<String> names = new ArrayList<String>();
        Collection parameterModels = this.getCurrentOperationParameterModels();
        if (parameterModels == null) {
            return null;
        }
        Iterator iter = parameterModels.iterator();
        while (iter.hasNext()) {
            Object model = iter.next();
            if (!(model instanceof LiteralElementMember)) continue;
            QName qname = ((LiteralElementMember)model).getName();
            if (suppliedQName != null && !qname.getLocalPart().equalsIgnoreCase(suppliedQName.getLocalPart())) continue;
            this.qnameToJavaClass.put(qname, className);
            LiteralType literalType = ((LiteralElementMember)model).getType();
            if (!(literalType instanceof LiteralSequenceType) && !(literalType instanceof LiteralAllType)) continue;
            qname = literalType.getName();
            Iterator elements = null;
            if (literalType instanceof LiteralSequenceType) {
                elements = ((LiteralSequenceType)literalType).getElementMembers();
            }
            if (literalType instanceof LiteralAllType) {
                elements = ((LiteralAllType)literalType).getElementMembers();
            }
            while (elements.hasNext()) {
                LiteralElementMember member = (LiteralElementMember)elements.next();
                if (member.getType() instanceof LiteralSequenceType) {
                    JavaStructureMember structureMember = member.getJavaStructureMember();
                    String javaName = structureMember.getType().getName();
                    this.qnameToJavaClass.put(qname, javaName);
                }
                String name = member.getName().getLocalPart();
                names.add(name);
            }
        }
        return names;
    }

    public QName getXmlType(String encoding, Class javaType) throws Exception {
        return this.registry.getXmlType(encoding, javaType);
    }

    private QName recursiveCheck(Iterator iter, QName suppliedQName) {
        if (iter.hasNext()) {
            LiteralElementMember type = (LiteralElementMember)iter.next();
            QName qname = type.getName();
            if (qname.getLocalPart().equalsIgnoreCase(suppliedQName.getLocalPart())) {
                return qname;
            }
            LiteralType literalType = type.getType();
            qname = literalType.getName();
            if (qname.getLocalPart().equalsIgnoreCase(suppliedQName.getLocalPart())) {
                return qname;
            }
            if (literalType instanceof LiteralSequenceType || literalType instanceof LiteralAllType) {
                Iterator members = ((LiteralSequenceType)literalType).getElementMembers();
                return this.recursiveCheck(members, suppliedQName);
            }
        }
        return null;
    }

    protected Deserializer getCachedEncodedDeserializer(Class javaType, QName xmlType) {
        DeserializerFactory deserializerFactory = this.cachedEncodedMappings.getDeserializer(javaType, xmlType);
        if (deserializerFactory != null) {
            return deserializerFactory.getDeserializerAs("http://java.sun.com/jax-rpc-ri/1.0/streaming/");
        }
        return null;
    }

    protected Deserializer getCachedLiteralDeserializer(Class javaType, QName xmlType) {
        DeserializerFactory deserializerFactory = this.cachedLiteralMappings.getDeserializer(javaType, xmlType);
        if (deserializerFactory != null) {
            return deserializerFactory.getDeserializerAs("http://java.sun.com/jax-rpc-ri/1.0/streaming/");
        }
        return null;
    }

    public Deserializer getDeserializer(String encoding, QName xmlType) throws Exception {
        return this.registry.getDeserializer(encoding, xmlType);
    }

    public Serializer getSerializer(String encoding, Class javaType) throws Exception {
        return this.registry.getSerializer(encoding, javaType);
    }

    public Serializer SOAPElementLiteralSerializer(QName xmlType, Class javaType) {
        LiteralFragmentSerializer serializer = new LiteralFragmentSerializer(xmlType, false, "");
        this.cachedLiteralMappings.register(javaType, xmlType, new SingletonSerializerFactory(serializer), new SingletonDeserializerFactory(serializer));
        return serializer;
    }

    private Serializer createLiteralValueTypeSerializer(QName xmlType, Class javaType) throws Exception {
        if (javaType != null && (class$javax$xml$soap$SOAPElement == null ? (class$javax$xml$soap$SOAPElement = DynamicInternalTypeMappingRegistry.class$("javax.xml.soap.SOAPElement")) : class$javax$xml$soap$SOAPElement).isAssignableFrom(javaType)) {
            return this.SOAPElementLiteralSerializer(xmlType, javaType);
        }
        JAXRPCSerializer stdSerializer = this.getStandardSerializer("", javaType, xmlType);
        if (stdSerializer != null) {
            this.cachedLiteralMappings.register(javaType, xmlType, new SingletonSerializerFactory(stdSerializer), new SingletonDeserializerFactory((JAXRPCDeserializer)((Object)stdSerializer)));
            return stdSerializer;
        }
        Collection params = this.orderCurrentMembersPerWsdl(xmlType, javaType);
        ValueTypeLiteralSerializer serializer = new ValueTypeLiteralSerializer(xmlType, false, true, "", javaType, params);
        this.cachedLiteralMappings.register(javaType, xmlType, new SingletonSerializerFactory(serializer), new SingletonDeserializerFactory(serializer));
        serializer.initialize(this);
        return serializer;
    }

    private Serializer createLiteralArraySerializer(Class javaType, QName xmlType) throws Exception {
        LiteralObjectSerializerBase ArraySerializer;
        block15: {
            int idx;
            QName foundXmlType;
            if (javaType == null || xmlType == null) {
                return null;
            }
            LiteralType type = this.getParameterLiteralType(xmlType.getLocalPart());
            if (type != null && type instanceof LiteralListType) {
                return this.createLiteralListSerializer(javaType, xmlType);
            }
            if (javaType.isArray() && (foundXmlType = this.checkParameterXmlTypesUsingModels(xmlType)) != null) {
                xmlType = foundXmlType;
            }
            Class<?> elementType = javaType.getComponentType();
            String elementName = null;
            if (elementType != null && (idx = (elementName = elementType.getName()).lastIndexOf(".")) != -1) {
                elementName = elementName.substring(idx + 1, elementName.length()).toLowerCase();
            }
            QName componentQName = new QName("http://www.w3.org/2001/XMLSchema", elementName);
            JAXRPCSerializer componentSerializer = null;
            try {
                componentSerializer = (JAXRPCSerializer)this.registry.getSerializer("", elementType, componentQName);
            }
            catch (TypeMappingException ex) {
                // empty catch block
            }
            ArraySerializer = null;
            if (componentSerializer != null && componentSerializer instanceof LiteralSimpleTypeSerializer) {
                componentSerializer = new LiteralSimpleTypeSerializer(xmlType, "", ((LiteralSimpleTypeSerializer)componentSerializer).getEncoder());
                ArraySerializer = new LiteralArraySerializer(xmlType, true, "", false, javaType, componentSerializer, elementType);
                this.cachedLiteralMappings.register(javaType, xmlType, new SingletonSerializerFactory(ArraySerializer), new SingletonDeserializerFactory(ArraySerializer));
            } else if (componentSerializer != null) {
                ArraySerializer = new LiteralObjectArraySerializer(xmlType, true, "", false, javaType, componentSerializer, elementType);
                this.cachedLiteralMappings.register(javaType, xmlType, new SingletonSerializerFactory(ArraySerializer), new SingletonDeserializerFactory(ArraySerializer));
            } else {
                QName foundQName = this.checkParameterXmlTypesUsingModels(componentQName);
                if (foundQName != null) {
                    componentQName = foundQName;
                }
                if (!DynamicInternalTypeMappingRegistry.isLiteralArray(elementType, componentQName)) {
                    componentSerializer = (JAXRPCSerializer)this.createLiteralValueTypeSerializer(xmlType, elementType);
                    ArraySerializer = new LiteralObjectArraySerializer(xmlType, true, "", false, javaType, componentSerializer, elementType);
                    this.cachedLiteralMappings.register(javaType, xmlType, new SingletonSerializerFactory(ArraySerializer), new SingletonDeserializerFactory(ArraySerializer));
                }
            }
            try {
                if (ArraySerializer instanceof LiteralArraySerializer) {
                    ((LiteralArraySerializer)ArraySerializer).initialize(this);
                    break block15;
                }
                ArraySerializer.initialize(this);
            }
            catch (ClassCastException ce) {
                System.out.println("literal ArraySerializer.initialize" + ce.getMessage());
                ce.printStackTrace();
            }
        }
        return ArraySerializer;
    }

    Serializer createLiteralListSerializer(Class javaType, QName xmlType) {
        QName type = xmlType;
        LiteralSimpleTypeSerializer serializer = new LiteralSimpleTypeSerializer(type, "", XSDListTypeEncoder.getInstance(XSDIntEncoder.getInstance(), Integer.TYPE));
        this.cachedLiteralMappings.register(javaType, xmlType, new SingletonSerializerFactory(serializer), new SingletonDeserializerFactory(serializer));
        return serializer;
    }

    private Serializer createRPCLiteralArraySerializer(Class javaType, QName xmlType) throws Exception {
        LiteralObjectSerializerBase ArraySerializer;
        block19: {
            int idx;
            QName foundXmlType;
            if (javaType == null || xmlType == null) {
                return null;
            }
            if (javaType.isArray() && (foundXmlType = this.checkParameterXmlTypesUsingModels(xmlType)) != null) {
                xmlType = foundXmlType;
            }
            ParameterMemberInfo[] pmemberInfos = this.getDynamicRegistryMembers(javaType, xmlType, "");
            int size = 0;
            if (pmemberInfos != null) {
                size = pmemberInfos.length;
            }
            String pmname = null;
            QName pmXmlType = null;
            Class pmClass = null;
            if (size > 0) {
                ParameterMemberInfo pinfo = pmemberInfos[0];
                pmname = pinfo.getMemberName();
                pmXmlType = pinfo.getMemberXmlType();
                pmClass = pinfo.getMemberJavaClass();
            }
            Class<?> elementType = javaType.getComponentType();
            String elementName = null;
            if (elementType != null && (idx = (elementName = elementType.getName()).lastIndexOf(".")) != -1) {
                if ((idx = (elementName = elementName.substring(idx + 1, elementName.length()).toLowerCase()).indexOf("big")) != -1) {
                    elementName = elementName.substring(idx + 3, elementName.length());
                }
                if (elementName.equals("calendar")) {
                    elementName = "dateTime";
                }
            }
            QName componentQName = null;
            if (elementType == pmClass && pmXmlType != null) {
                componentQName = pmXmlType;
            }
            componentQName = new QName("http://www.w3.org/2001/XMLSchema", elementName);
            JAXRPCSerializer componentSerializer = null;
            try {
                componentSerializer = (JAXRPCSerializer)this.registry.getSerializer("", elementType, componentQName);
            }
            catch (TypeMappingException ex) {
                // empty catch block
            }
            ArraySerializer = null;
            if (componentSerializer != null && componentSerializer instanceof LiteralSimpleTypeSerializer) {
                componentSerializer = new LiteralSimpleTypeSerializer(xmlType, "", ((LiteralSimpleTypeSerializer)componentSerializer).getEncoder());
                ArraySerializer = new LiteralArraySerializer(xmlType, true, "", false, javaType, componentSerializer, elementType);
                this.cachedLiteralMappings.register(javaType, xmlType, new SingletonSerializerFactory(ArraySerializer), new SingletonDeserializerFactory(ArraySerializer));
            } else if (componentSerializer != null) {
                ArraySerializer = new LiteralObjectArraySerializer(xmlType, true, "", false, javaType, componentSerializer, elementType);
                this.cachedLiteralMappings.register(javaType, xmlType, new SingletonSerializerFactory(ArraySerializer), new SingletonDeserializerFactory(ArraySerializer));
            } else {
                QName foundQName = this.checkParameterXmlTypesUsingModels(componentQName);
                if (foundQName != null) {
                    componentQName = foundQName;
                }
                if (!DynamicInternalTypeMappingRegistry.isLiteralArray(elementType, componentQName)) {
                    componentSerializer = (JAXRPCSerializer)this.createLiteralValueTypeSerializer(xmlType, elementType);
                    ArraySerializer = new LiteralObjectArraySerializer(xmlType, true, "", false, javaType, componentSerializer, elementType);
                    this.cachedLiteralMappings.register(javaType, xmlType, new SingletonSerializerFactory(ArraySerializer), new SingletonDeserializerFactory(ArraySerializer));
                }
            }
            try {
                if (ArraySerializer instanceof LiteralArraySerializer) {
                    ((LiteralArraySerializer)ArraySerializer).initialize(this);
                    break block19;
                }
                ArraySerializer.initialize(this);
            }
            catch (ClassCastException ce) {
                System.out.println("literal ArraySerializer.initialize" + ce.getMessage());
                ce.printStackTrace();
            }
        }
        return ArraySerializer;
    }

    protected Serializer getCachedEncodedSerializer(Class javaType, QName xmlType) {
        SerializerFactory serializerFactory = this.cachedEncodedMappings.getSerializer(javaType, xmlType);
        if (serializerFactory != null) {
            return serializerFactory.getSerializerAs("http://java.sun.com/jax-rpc-ri/1.0/streaming/");
        }
        return null;
    }

    protected Serializer getCachedLiteralSerializer(Class javaType, QName xmlType) {
        SerializerFactory serializerFactory = this.cachedLiteralMappings.getSerializer(javaType, xmlType);
        if (serializerFactory != null) {
            return serializerFactory.getSerializerAs("http://java.sun.com/jax-rpc-ri/1.0/streaming/");
        }
        return null;
    }

    public Serializer getSerializer(String encoding, QName xmlType) throws Exception {
        return this.registry.getSerializer(encoding, xmlType);
    }

    public ParameterMemberInfo[] getDynamicRegistryMembers(Class parentClass, QName parentXmlType, String encoding) {
        String key = this.makeKey(parentClass, parentXmlType, encoding);
        return (ParameterMemberInfo[])this.dynamicMemberRegistry.get(key);
    }

    public void addDynamicRegistryMembers(Class parentClass, QName parentXmlType, String encoding, ParameterMemberInfo[] memberInfo) {
        String key = this.makeKey(parentClass, parentXmlType, encoding);
        this.dynamicMemberRegistry.put(key, memberInfo);
    }

    JAXRPCDeserializer getStandardDeserializer(String encoding, Class javaType, QName xmlType) throws TypeMappingException, Exception {
        Object serializer = null;
        try {
            return (JAXRPCDeserializer)this.registry.getDeserializer(encoding, javaType, xmlType);
        }
        catch (Exception e) {
            try {
                return (JAXRPCDeserializer)this.registry.getSerializer(encoding, javaType);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    JAXRPCSerializer getStandardSerializer(String encoding, Class javaType, QName xmlType) throws TypeMappingException, Exception {
        Object serializer = null;
        try {
            return (JAXRPCSerializer)this.registry.getSerializer(encoding, javaType, xmlType);
        }
        catch (Exception e) {
            try {
                return (JAXRPCSerializer)this.registry.getSerializer(encoding, javaType);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private String makeKey(Class parentClass, QName parentXmlType, String encoding) {
        String pname = parentClass != null ? parentClass.getName() : "";
        String pxml = parentXmlType != null ? parentXmlType.getLocalPart() : "";
        return new String(pname + pxml + encoding);
    }

    public Deserializer getDeserializer(String encoding, Class javaType, QName xmlType) throws Exception {
        try {
            return this.registry.getDeserializer(encoding, javaType, xmlType);
        }
        catch (TypeMappingException ex) {
            try {
                if (encoding.equals(this.soapEncodingConstants.getSOAPEncodingNamespace())) {
                    Deserializer deserializer = this.getCachedEncodedDeserializer(javaType, xmlType);
                    if (deserializer != null) {
                        return deserializer;
                    }
                    if (DynamicInternalTypeMappingRegistry.isArray(javaType, xmlType)) {
                        return this.createArraySerializer(javaType, xmlType);
                    }
                    return this.createValueSerializer(javaType, xmlType);
                }
                if (encoding.equals("") && "document".equals(this.operationStyle)) {
                    Deserializer deserializer = this.getCachedLiteralDeserializer(javaType, xmlType);
                    if (deserializer != null) {
                        return deserializer;
                    }
                    if (DynamicInternalTypeMappingRegistry.isLiteralArray(javaType, xmlType)) {
                        return (Deserializer)this.createLiteralArraySerializer(javaType, xmlType);
                    }
                    return (Deserializer)this.createLiteralValueTypeSerializer(xmlType, javaType);
                }
                if (encoding.equals("") && "rpc".equals(this.operationStyle)) {
                    Deserializer deserializer = this.getCachedLiteralDeserializer(javaType, xmlType);
                    if (deserializer != null) {
                        return deserializer;
                    }
                    if (DynamicInternalTypeMappingRegistry.isLiteralArray(javaType, xmlType)) {
                        return (Deserializer)this.createRPCLiteralArraySerializer(javaType, xmlType);
                    }
                    return (Deserializer)this.createLiteralValueTypeSerializer(xmlType, javaType);
                }
                throw ex;
            }
            catch (JAXRPCExceptionBase e) {
                throw new SerializationException(e);
            }
            catch (Exception e) {
                throw new SerializationException(new LocalizableExceptionAdapter(e));
            }
        }
    }

    public Serializer getSerializer(String encoding, Class javaType, QName xmlType) throws Exception {
        try {
            return this.registry.getSerializer(encoding, javaType, xmlType);
        }
        catch (TypeMappingException ex) {
            try {
                if (encoding.equals(this.soapEncodingConstants.getSOAPEncodingNamespace())) {
                    Serializer serializer = this.getCachedEncodedSerializer(javaType, xmlType);
                    if (serializer != null) {
                        return serializer;
                    }
                    if (DynamicInternalTypeMappingRegistry.isArray(javaType, xmlType)) {
                        return this.createArraySerializer(javaType, xmlType);
                    }
                    return this.createValueSerializer(javaType, xmlType);
                }
                if (encoding.equals("") && "document".equals(this.operationStyle)) {
                    Serializer serializer = this.getCachedLiteralSerializer(javaType, xmlType);
                    if (serializer != null) {
                        return serializer;
                    }
                    if (DynamicInternalTypeMappingRegistry.isLiteralArray(javaType, xmlType)) {
                        return this.createLiteralArraySerializer(javaType, xmlType);
                    }
                    return this.createLiteralValueTypeSerializer(xmlType, javaType);
                }
                if (encoding.equals("") && "rpc".equals(this.operationStyle)) {
                    Serializer serializer = this.getCachedLiteralSerializer(javaType, xmlType);
                    if (serializer != null) {
                        return serializer;
                    }
                    if (DynamicInternalTypeMappingRegistry.isLiteralArray(javaType, xmlType)) {
                        return this.createRPCLiteralArraySerializer(javaType, xmlType);
                    }
                    return this.createLiteralValueTypeSerializer(xmlType, javaType);
                }
            }
            catch (JAXRPCExceptionBase e) {
                throw new SerializationException(e);
            }
            catch (Exception e) {
                throw new SerializationException(new LocalizableExceptionAdapter(e));
            }
            return null;
        }
    }
}

