/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.literal;

import com.sun.xml.rpc.client.dii.ParameterMemberInfo;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.DynamicInternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.literal.LiteralRequestSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPResponseStructure;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class LiteralResponseSerializer
extends LiteralRequestSerializer
implements Initializable {
    private static final QName RETURN_VALUE_QNAME = new QName("return");
    private static final QName[] EMPTY_QNAME_ARRAY = new QName[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    protected QName returnXmlType;
    protected QName returnXmlTypeQName;
    protected Class returnJavaType;
    protected ParameterMemberInfo[] returnMemberInfo;
    protected JAXRPCSerializer returnSerializer;
    protected JAXRPCDeserializer returnDeserializer;
    protected boolean isReturnVoid;
    private SOAPEncodingConstants soapEncodingConstants = null;

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        if (this.typeRegistry != null) {
            return;
        }
        ((DynamicInternalTypeMappingRegistry)registry).addDynamicRegistryMembers(this.returnJavaType, this.returnXmlType, "", this.returnMemberInfo);
        super.initialize(registry);
        if (this.isRPCLiteral()) {
            if (this.returnJavaType != null && this.returnXmlType != null) {
                this.returnSerializer = (JAXRPCSerializer)registry.getSerializer(this.encodingStyle, this.returnJavaType, this.returnXmlType);
                this.returnDeserializer = (JAXRPCDeserializer)registry.getDeserializer(this.encodingStyle, this.returnJavaType, this.returnXmlType);
            } else if (this.returnXmlType != null) {
                this.returnSerializer = (JAXRPCSerializer)registry.getSerializer(this.encodingStyle, null, this.returnXmlType);
                this.returnDeserializer = (JAXRPCDeserializer)registry.getDeserializer(this.encodingStyle, null, this.returnXmlType);
            }
        } else if (this.returnJavaType != null && this.returnXmlTypeQName != null) {
            if (DynamicInternalTypeMappingRegistry.isLiteralArray(this.returnJavaType, null, null) || DynamicInternalTypeMappingRegistry.isValueType(this.returnJavaType)) {
                this.returnSerializer = (JAXRPCSerializer)registry.getSerializer(this.encodingStyle, this.returnJavaType, this.returnXmlType);
                this.returnDeserializer = (JAXRPCDeserializer)registry.getDeserializer(this.encodingStyle, this.returnJavaType, this.returnXmlType);
            } else {
                this.returnSerializer = (JAXRPCSerializer)registry.getSerializer(this.encodingStyle, this.returnJavaType, this.returnXmlTypeQName);
                this.returnDeserializer = (JAXRPCDeserializer)registry.getDeserializer(this.encodingStyle, this.returnJavaType, this.returnXmlTypeQName);
            }
        }
    }

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    protected JAXRPCDeserializer getReturnDeserializer(XMLReader reader) throws Exception {
        JAXRPCDeserializer deserializer = this.returnDeserializer;
        if (deserializer == null) {
            QName xmlType = null;
            xmlType = this.isRPCLiteral() ? (this.returnXmlType != null ? this.returnXmlType : SerializerBase.getType(reader)) : (!"".equals(this.encodingStyle) ? (this.returnJavaType != null ? new QName("http://www.w3.org/2001/XMLSchema", this.returnJavaType.getName()) : (this.returnXmlType != null ? this.returnXmlType : SerializerBase.getType(reader))) : (this.returnXmlTypeQName != null ? this.returnXmlType : SerializerBase.getType(reader)));
            deserializer = DynamicInternalTypeMappingRegistry.isLiteralArray(this.returnJavaType, null, null) || DynamicInternalTypeMappingRegistry.isValueType(this.returnJavaType) ? (JAXRPCDeserializer)this.typeRegistry.getDeserializer(this.encodingStyle, this.returnJavaType, this.returnXmlType) : (JAXRPCDeserializer)this.typeRegistry.getDeserializer(this.encodingStyle, this.returnJavaType, this.returnXmlTypeQName);
        }
        return deserializer;
    }

    protected JAXRPCSerializer getReturnSerializer(Object returnValue) throws Exception {
        JAXRPCSerializer serializer = this.returnSerializer;
        if (serializer == null) {
            serializer = (JAXRPCSerializer)this.typeRegistry.getSerializer(this.encodingStyle, returnValue.getClass(), this.returnXmlType);
        }
        return serializer;
    }

    private static String getURIEncoding(SOAPVersion ver) {
        if (ver == SOAPVersion.SOAP_11) {
            return "http://schemas.xmlsoap.org/soap/encoding/";
        }
        if (ver == SOAPVersion.SOAP_11) {
            return "http://schemas.xmlsoap.org/soap/encoding/";
        }
        return null;
    }

    public LiteralResponseSerializer(QName type, boolean isNullable, String encodingStyle) {
        super(type, isNullable, encodingStyle);
    }

    public LiteralResponseSerializer(QName type, boolean isNullable, String encodingStyle, boolean encodeType) {
        super(type, isNullable, encodingStyle, encodeType);
    }

    public LiteralResponseSerializer(QName type, QName returnXmlType, Class returnJavaType) {
        this(type, returnXmlType, returnJavaType, SOAPVersion.SOAP_11);
    }

    protected Object doDeserialize(XMLReader reader, SOAPDeserializationContext context) throws Exception {
        Object returnedObject;
        SOAPResponseStructure instance = new SOAPResponseStructure();
        SOAPResponseStructureBuilder builder = null;
        boolean isComplete = true;
        if (this.isRPCLiteral()) {
            reader.nextElementContent();
        }
        int responseMemberIndex = 0;
        if (!this.isReturnVoid) {
            returnedObject = this.getReturnDeserializer(reader).deserialize(null, reader, context);
            if (returnedObject instanceof SOAPDeserializationState) {
                if (builder == null) {
                    builder = new SOAPResponseStructureBuilder(instance);
                }
                isComplete = false;
            } else {
                instance.returnValue = returnedObject;
            }
            if (this.parameterXmlTypes == null || this.parameterXmlTypes.length > 0) {
                // empty if block
            }
        }
        if (this.parameterXmlTypes != null) {
            int i = 0;
            while (i < this.parameterXmlTypes.length) {
                QName parameterName = this.parameterNames[i];
                if (reader.getName().equals(parameterName)) {
                    returnedObject = this.getParameterDeserializer(i, reader).deserialize(parameterName, reader, context);
                    if (returnedObject instanceof SOAPDeserializationState) {
                        if (builder == null) {
                            builder = new SOAPResponseStructureBuilder(instance);
                        }
                        responseMemberIndex = i + 1;
                        builder.setOutParameterName(responseMemberIndex, parameterName);
                        isComplete = false;
                    } else {
                        instance.outParameters.put(parameterName, returnedObject);
                        instance.outParametersStringKeys.put(parameterName.getLocalPart(), returnedObject);
                    }
                } else {
                    throw new DeserializationException("soap.unexpectedElementName", new Object[]{parameterName, reader.getName()});
                }
                XMLReaderUtil.verifyReaderState(reader, 2);
                ++i;
            }
        }
        if (this.isRPCLiteral()) {
            reader.nextElementContent();
        }
        return instance;
    }

    public LiteralResponseSerializer(QName type, QName returnXmlType, Class returnJavaType, SOAPVersion ver) {
        this(type, EMPTY_QNAME_ARRAY, EMPTY_QNAME_ARRAY, EMPTY_CLASS_ARRAY, returnXmlType, returnJavaType, ver);
    }

    public LiteralResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName returnXmlType, Class returnJavaType) {
        this(type, encodeType, isNullable, encodingStyle, returnXmlType, returnJavaType, SOAPVersion.SOAP_11);
    }

    public Object deserialize(QName name, XMLReader reader, SOAPDeserializationContext context) {
        try {
            return this.internalDeserialize(name, reader, context);
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalDeserialize(QName name, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        boolean pushedEncodingStyle = context.processEncodingStyle(reader);
        try {
            QName actualName;
            context.verifyEncodingStyle(this.encodingStyle);
            if (name != null && !(actualName = reader.getName()).equals(name)) {
                throw new DeserializationException("xsd.unexpectedElementName", new Object[]{name.toString(), actualName.toString()});
            }
            this.verifyType(reader);
            Attributes attrs = reader.getAttributes();
            String nullVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            boolean isNull = nullVal != null && SerializerBase.decodeBoolean(nullVal);
            Object obj = null;
            if (isNull) {
                if (!this.isNullable) {
                    throw new DeserializationException("xsd.unexpectedNull");
                }
                reader.next();
            } else {
                obj = this.doDeserialize(reader, context);
            }
            XMLReaderUtil.verifyReaderState(reader, 2);
            Object object = obj;
            Object var11_10 = null;
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
            return object;
        }
        catch (Throwable throwable) {
            block7: {
                Object var11_11 = null;
                if (!pushedEncodingStyle) break block7;
                context.popEncodingStyle();
            }
            throw throwable;
        }
    }

    public LiteralResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName returnXmlType, Class returnJavaType, SOAPVersion ver) {
        this(type, encodeType, isNullable, encodingStyle, EMPTY_QNAME_ARRAY, EMPTY_QNAME_ARRAY, EMPTY_CLASS_ARRAY, returnXmlType, returnJavaType, ver);
    }

    public LiteralResponseSerializer(QName type, QName[] parameterNames, QName[] parameterXmlTypes, Class[] parameterClasses, QName returnXmlType, Class returnJavaType) {
        this(type, parameterNames, parameterXmlTypes, parameterClasses, returnXmlType, returnJavaType, SOAPVersion.SOAP_11);
    }

    public LiteralResponseSerializer(QName type, QName[] parameterNames, QName[] parameterXmlTypes, Class[] parameterClasses, QName returnXmlType, Class returnJavaType, SOAPVersion ver) {
        this(type, false, true, LiteralResponseSerializer.getURIEncoding(ver), parameterNames, parameterXmlTypes, parameterClasses, returnXmlType, returnJavaType, ver);
    }

    public LiteralResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName[] parameterNames, QName[] parameterXmlTypes, Class[] parameterClasses, QName returnXmlType, Class returnJavaType) {
        this(type, encodeType, isNullable, encodingStyle, parameterNames, parameterXmlTypes, parameterClasses, returnXmlType, returnJavaType, SOAPVersion.SOAP_11);
    }

    public LiteralResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName[] parameterNames, QName[] parameterXmlTypes, Class[] parameterClasses, QName returnXmlType, Class returnJavaType, SOAPVersion ver) {
        super(type, encodeType, isNullable, "", parameterNames, parameterXmlTypes, parameterClasses, SOAPVersion.SOAP_11);
        this.init(ver);
        this.isReturnVoid = returnJavaType == null && returnXmlType == null;
        this.returnXmlType = returnXmlType;
        this.returnJavaType = returnJavaType;
    }

    public LiteralResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, String operationStyle, QName[] parameterNames, QName[] parameterXmlTypes, Class[] parameterClasses, ArrayList parameterMembers, QName returnXmlType, Class returnJavaType, ParameterMemberInfo[] returnMembers) {
        this(type, encodeType, isNullable, encodingStyle, operationStyle, parameterNames, parameterXmlTypes, parameterClasses, parameterMembers, returnXmlType, returnJavaType, returnMembers, SOAPVersion.SOAP_11);
    }

    public LiteralResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, String operationStyle, QName[] parameterNames, QName[] parameterXmlTypes, Class[] parameterClasses, ArrayList parameterMembers, QName returnXmlType, Class returnJavaType, ParameterMemberInfo[] returnMembers, SOAPVersion ver) {
        super(type, encodeType, isNullable, "", operationStyle, parameterNames, parameterXmlTypes, parameterClasses, parameterMembers, SOAPVersion.SOAP_11);
        this.init(ver);
        this.isReturnVoid = returnJavaType == null && returnXmlType == null;
        this.returnXmlType = returnXmlType;
        this.returnJavaType = returnJavaType;
    }

    public LiteralResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, String operationStyle, QName[] parameterNames, QName[] parameterXmlTypes, QName[] parameterXmlTypeQNames, Class[] parameterClasses, ArrayList parameterMembers, QName returnXmlType, QName returnXmlTypeQName, Class returnJavaType, ParameterMemberInfo[] returnMembers) {
        this(type, encodeType, isNullable, encodingStyle, operationStyle, parameterNames, parameterXmlTypes, parameterXmlTypeQNames, parameterClasses, parameterMembers, returnXmlType, returnXmlTypeQName, returnJavaType, returnMembers, SOAPVersion.SOAP_11);
    }

    public LiteralResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, String operationStyle, QName[] parameterNames, QName[] parameterXmlTypes, QName[] parameterXmlTypeQNames, Class[] parameterClasses, ArrayList parameterMembers, QName returnXmlType, QName returnXmlTypeQName, Class returnJavaType, ParameterMemberInfo[] returnMembers, SOAPVersion ver) {
        super(type, encodeType, isNullable, "", operationStyle, parameterNames, parameterXmlTypes, parameterXmlTypeQNames, parameterClasses, parameterMembers, SOAPVersion.SOAP_11);
        this.init(ver);
        this.isReturnVoid = returnJavaType == null && returnXmlType == null;
        this.returnXmlType = returnXmlType;
        this.returnJavaType = returnJavaType;
        this.returnXmlTypeQName = returnXmlTypeQName;
        this.returnMemberInfo = returnMembers;
    }

    protected static class SOAPResponseStructureBuilder
    implements SOAPInstanceBuilder {
        SOAPResponseStructure instance = null;
        List outParameterNames = new ArrayList();

        public void construct() {
        }

        public void initialize() {
        }

        public int memberGateType(int memberIndex) {
            return 6;
        }

        SOAPResponseStructureBuilder(SOAPResponseStructure instance) {
            this.instance = instance;
        }

        public Object getInstance() {
            return this.instance;
        }

        public void setMember(int index, Object memberValue) {
            try {
                if (index == 0) {
                    this.instance.returnValue = memberValue;
                } else {
                    this.instance.outParameters.put(this.outParameterNames.get(index), memberValue);
                    this.instance.outParametersStringKeys.put(((QName)this.outParameterNames.get(index)).getLocalPart(), memberValue);
                }
            }
            catch (Exception e) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
            }
        }

        public void setInstance(Object instance) {
            instance = (SOAPResponseStructure)instance;
        }

        public void setOutParameterName(int index, QName name) {
            this.outParameterNames.set(index, name);
        }
    }
}

