/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.j2ee.xml;

import com.sun.org.apache.xerces.internal.dom.DocumentImpl;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.BaseType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.ComplexType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.DOMWriter;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.EntityResolverRI;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.ErrorHandlerRI;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.SimpleType;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class Factory
implements Serializable {
    protected String xmlFile;
    protected String packageName;
    protected Document document;
    protected String encoding;
    protected String encodingTag;
    protected String dtdFileName;
    protected String dtdPublicId;
    protected String xsdFileName;
    protected String xsdNamespaceURI;
    protected Hashtable importedFileHashtable = new Hashtable();
    private String rootElementName;
    private static boolean _trace = false;

    public void save() {
        if (this.xmlFile != null) {
            String outputEncoding = this.encoding != null && !this.encoding.equals("") ? this.encoding : "UTF8";
            new DOMWriter(this.document, this.xmlFile, outputEncoding, this.encodingTag, this.getDocTypeString());
        }
    }

    public String getDTDFileName() {
        return this.dtdFileName;
    }

    private String getDocTypeString() {
        String docType = "";
        if (this.dtdFileName != null && !this.dtdFileName.equals("")) {
            if (this.dtdPublicId == null || this.dtdPublicId.equals("")) {
                this.dtdPublicId = this.rootElementName + "Id";
            }
            docType = "<!DOCTYPE " + this.rootElementName + " PUBLIC \"" + this.dtdPublicId + "\"" + " \"" + this.dtdFileName + "\"" + ">";
        }
        return docType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getNamespaceURI() {
        return this.xsdNamespaceURI;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPublicId() {
        return this.dtdPublicId;
    }

    public String getXMLFilename() {
        return this.xmlFile;
    }

    public String getXSDFileName() {
        return this.xsdFileName;
    }

    public void save(String filename) {
        String outputEncoding = this.encoding != null && !this.encoding.equals("") ? this.encoding : "UTF8";
        new DOMWriter(this.document, filename, outputEncoding, this.encodingTag, this.getDocTypeString());
    }

    public void setDTDFileName(String dtdFilename) {
        this.dtdFileName = dtdFilename;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setEncodingTag(String encodingTag) {
        this.encodingTag = encodingTag;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.xsdNamespaceURI = namespaceURI;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPublicId(String publicId) {
        this.dtdPublicId = publicId;
    }

    public void setXMLFilename(String filename) {
        this.xmlFile = filename;
    }

    public void setXSDFileName(String xsdFilename) {
        this.xsdFileName = xsdFilename;
    }

    private static void printElement(Element elem) {
        Factory.printElement("", elem);
    }

    public void print(PrintWriter writer, String prefix) {
        new DOMWriter(this.document, writer, this.encodingTag, this.getDocTypeString(), prefix);
    }

    public String getEncodingTag(String encodingTag) {
        return encodingTag;
    }

    private static void printElement(String prefix, Element elem) {
        String newPrefix = prefix + "    ";
        System.out.println(prefix + " tagName: " + elem.getTagName() + " namespaceURI: " + elem.getNamespaceURI() + " localName: " + elem.getLocalName() + " node name " + elem.getNodeName());
        NamedNodeMap attrs = elem.getAttributes();
        if (attrs != null) {
            System.out.println("  There are " + attrs.getLength() + " attributes");
            int i = 0;
            while (i < attrs.getLength()) {
                Attr attr = (Attr)attrs.item(i);
                System.out.println(prefix + "  " + attr.getName() + "=" + attr.getValue());
                ++i;
            }
        }
        NodeList children = elem.getChildNodes();
        int len = children.getLength();
        int i = 0;
        while (i < len) {
            Node child = children.item(i);
            if (child instanceof Element) {
                Factory.printElement(newPrefix, (Element)child);
            } else {
                System.out.println(newPrefix + "node: name " + child.getNodeName() + " namespaceURI: " + child.getNamespaceURI() + " localName: " + child.getLocalName() + " nodeName: " + child.getNodeName());
            }
            ++i;
        }
    }

    public BaseType loadDocument(String classname, String xmlFile) {
        return this.loadDocument(classname, xmlFile, true);
    }

    public BaseType loadDocument(String classname, String xmlFile, boolean validate) {
        System.out.print("[Factory] ==> classname = " + classname);
        System.out.print("[Factory] ==> xmlFile = " + xmlFile);
        System.out.print("[Factory] ==> validate = " + validate);
        this.xmlFile = xmlFile;
        DOMParser parser = new DOMParser();
        try {
            if (validate) {
                parser.setEntityResolver(new EntityResolverRI());
                parser.setFeature("http://xml.org/sax/features/validation", true);
            } else {
                parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setErrorHandler(new ErrorHandlerRI());
            parser.parse(xmlFile);
            this.document = parser.getDocument();
            Element rootElement = this.document.getDocumentElement();
            if (_trace) {
                Factory.printElement(rootElement);
            }
            return this.newInstance(rootElement, classname);
        }
        catch (Exception e) {
            System.out.println("Exception: Factory::loadDocument() " + e);
            e.printStackTrace();
            return null;
        }
    }

    protected BaseType newInstance(Node node, String className) {
        try {
            String fullname = className;
            if (this.packageName != null && !this.packageName.equals("")) {
                fullname = this.packageName + "." + className;
            }
            Class<?> javaClass = Class.forName(fullname);
            BaseType object = (BaseType)javaClass.newInstance();
            if (node instanceof Element) {
                object.setXMLElement((Element)node);
            } else {
                object.setXMLAttribute((Attr)node);
            }
            object.setFactory(this);
            return object;
        }
        catch (Exception e) {
            System.out.println("Factory::newInstance() error ***" + e);
            return null;
        }
    }

    public BaseType loadDocument(String classname, Element element) {
        try {
            ComplexType domElement = (ComplexType)this.newInstance(element, classname);
            return domElement;
        }
        catch (Exception e) {
            System.out.println("Exception: Factory::loadDocument() " + e);
            return null;
        }
    }

    public BaseType loadDocument(String classname, InputSource source) {
        return this.loadDocument(classname, source, true);
    }

    public BaseType loadDocument(String classname, InputSource source, boolean validate) {
        DOMParser parser = new DOMParser();
        try {
            if (validate) {
                parser.setEntityResolver(new EntityResolverRI());
                parser.setFeature("http://xml.org/sax/features/validation", true);
            } else {
                parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setErrorHandler(new ErrorHandlerRI());
            parser.parse(source);
            this.document = parser.getDocument();
            Element rootElement = this.document.getDocumentElement();
            if (_trace) {
                Factory.printElement(rootElement);
            }
            return this.newInstance(rootElement, classname);
        }
        catch (Exception e) {
            System.out.println("Exception: Factory::loadDocument() " + e);
            e.printStackTrace();
            return null;
        }
    }

    public ComplexType createDOMElementFromComplexType(String classname, String elementName) {
        Element childElement = this.document.createElement(elementName);
        return (ComplexType)this.newInstance(childElement, classname);
    }

    public ComplexType createRootDOMFromComplexType(String classname, String rootElementName) {
        return (ComplexType)this.createRootDOMHelper(classname, rootElementName);
    }

    public SimpleType createDOMElementFromSimpleType(String classname, String elementName) {
        Element childElement = this.document.createElement(elementName);
        return (SimpleType)this.newInstance(childElement, classname);
    }

    public SimpleType createRootDOMFromSimpleType(String classname, String rootElementName) {
        return (SimpleType)this.createRootDOMHelper(classname, rootElementName);
    }

    private Object createRootDOMHelper(String classname, String rootElementName) {
        this.document = new DocumentImpl();
        this.rootElementName = rootElementName;
        Element childElement = this.document.createElement(rootElementName);
        this.document.appendChild(childElement);
        if (this.xsdFileName != null && !this.xsdFileName.equals("")) {
            childElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (this.xsdNamespaceURI != null && !this.xsdNamespaceURI.equals("")) {
                int index = rootElementName.indexOf(":");
                if (index > 0) {
                    String prefix = ":" + rootElementName.substring(0, index);
                    childElement.setAttribute("xmlns" + prefix, this.xsdNamespaceURI);
                } else {
                    childElement.setAttribute("xmlns", this.xsdNamespaceURI);
                }
                Enumeration enums = this.importedFileHashtable.keys();
                String importedFileValidation = "";
                while (enums.hasMoreElements()) {
                    Object nsprefix = enums.nextElement();
                    String nsURI = (String)this.importedFileHashtable.get(nsprefix);
                    int blank = nsURI.indexOf(32);
                    childElement.setAttribute("xmlns:" + nsprefix, nsURI.substring(0, blank));
                    importedFileValidation = importedFileValidation + " " + nsURI;
                }
                childElement.setAttribute("xsi:schemaLocation", this.xsdNamespaceURI + " " + this.xsdFileName + importedFileValidation);
            } else {
                childElement.setAttribute("xsi:noNamespaceSchemaLocation", this.xsdFileName);
            }
        }
        return this.newInstance(childElement, classname);
    }

    public void addImportedFileInfo(String filename, String nsprefix, String nsURI) {
        this.importedFileHashtable.put(nsprefix, nsURI + " " + filename);
    }

    protected Attr createAttribute(String name, Element parentElement) {
        Attr attrNode = this.document.createAttribute(name);
        parentElement.setAttributeNode(attrNode);
        return attrNode;
    }

    protected Element createXMLElementAndText(String elementName, String elementValue) {
        Element item = this.document.createElement(elementName);
        Text text = this.document.createTextNode(elementValue);
        item.appendChild(text);
        return item;
    }

    protected Text createText(Element parentElement, String value) {
        Text textNode = this.document.createTextNode(value);
        parentElement.appendChild(textNode);
        return textNode;
    }
}

