/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.encoding.InternalEncodingConstants;
import com.sun.xml.rpc.processor.config.TypeMappingRegistryInfo;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayWrapperType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.JavaBean;
import com.sun.xml.rpc.processor.modeler.rmi.LiteralSimpleTypeCreator;
import com.sun.xml.rpc.processor.modeler.rmi.MemberInfo;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiStructure;
import com.sun.xml.rpc.processor.modeler.rmi.RmiType;
import com.sun.xml.rpc.processor.modeler.rmi.RmiTypeModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiUtils;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.ClassNameInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class LiteralTypeModeler
implements RmiConstants {
    private Map simpleTypeMap;
    private Map complexTypeMap;
    private Set typeNames = new HashSet();
    private RmiModeler modeler;
    private ProcessorEnvironment env;
    private TypeMappingRegistryInfo typeMappingRegistry;
    private LiteralSimpleTypeCreator literalTypes;
    private static final Set boxedPrimitiveSet = new HashSet();
    private static final Map unsupportedClasses = new HashMap();
    private static final String COLLECTION = "Collection";
    private static final String ATTACHMENT = "Attachment";
    private static final String OBJECT = "Object";

    static {
        boxedPrimitiveSet.add("java.lang.Boolean");
        boxedPrimitiveSet.add("java.lang.Byte");
        boxedPrimitiveSet.add("java.lang.Double");
        boxedPrimitiveSet.add("java.lang.Float");
        boxedPrimitiveSet.add("java.lang.Integer");
        boxedPrimitiveSet.add("java.lang.Long");
        boxedPrimitiveSet.add("java.lang.Short");
        unsupportedClasses.put("java.lang.Object", null);
        unsupportedClasses.put("java.awt.Image", ATTACHMENT);
        unsupportedClasses.put("javax.mail.internet.MimeMultipart", ATTACHMENT);
        unsupportedClasses.put("javax.xml.transform.Source", ATTACHMENT);
        unsupportedClasses.put("javax.activation.DataHandler", ATTACHMENT);
        unsupportedClasses.put("java.util.Collection", COLLECTION);
        unsupportedClasses.put("java.util.List", COLLECTION);
        unsupportedClasses.put("java.util.Set", COLLECTION);
        unsupportedClasses.put("java.util.Vector", COLLECTION);
        unsupportedClasses.put("java.util.Stack", COLLECTION);
        unsupportedClasses.put("java.util.LinkedList", COLLECTION);
        unsupportedClasses.put("java.util.ArrayList", COLLECTION);
        unsupportedClasses.put("java.util.HashSet", COLLECTION);
        unsupportedClasses.put("java.util.TreeSet", COLLECTION);
        unsupportedClasses.put("java.util.Map", COLLECTION);
        unsupportedClasses.put("java.util.HashMap", COLLECTION);
        unsupportedClasses.put("java.util.TreeMap", COLLECTION);
        unsupportedClasses.put("java.util.Hashtable", COLLECTION);
        unsupportedClasses.put("java.util.Properties", COLLECTION);
        unsupportedClasses.put("com.sun.xml.rpc.encoding.soap.JAXRpcMapEntry", COLLECTION);
    }

    private LiteralTypeModeler() {
        this.typeNames = new HashSet();
        this.simpleTypeMap = new HashMap();
        this.complexTypeMap = new HashMap();
        this.literalTypes = new LiteralSimpleTypeCreator();
        this.initializeTypeMap(this.simpleTypeMap);
    }

    public LiteralSimpleTypeCreator getLiteralTypes() {
        return this.literalTypes;
    }

    public void modelSubclasses(String typeUri) {
        LiteralType type;
        HashSet<LiteralType> abstractTypes = new HashSet<LiteralType>();
        int startSize = this.complexTypeMap.size();
        Iterator iter = this.complexTypeMap.entrySet().iterator();
        while (iter.hasNext()) {
            type = (LiteralType)iter.next().getValue();
            if (!(type instanceof LiteralStructuredType)) continue;
            abstractTypes.add(type);
        }
        iter = abstractTypes.iterator();
        while (iter.hasNext()) {
            type = (LiteralType)((Object)iter.next());
            this.modelSubclasses(typeUri, (JavaStructureType)type.getJavaType());
        }
        if (startSize != this.complexTypeMap.size()) {
            iter = this.complexTypeMap.entrySet().iterator();
            while (iter.hasNext()) {
                type = (LiteralType)iter.next().getValue();
                if (!(type instanceof LiteralStructuredType) || !((JavaStructureType)type.getJavaType()).isAbstract() || abstractTypes.contains(type)) continue;
                this.modelSubclasses(typeUri, (JavaStructureType)type.getJavaType());
            }
        }
    }

    public boolean nameClashes(String name) {
        name = name.toUpperCase();
        Iterator iter = this.complexTypeMap.values().iterator();
        while (iter.hasNext()) {
            LiteralType type = (LiteralType)iter.next();
            String typeName = ClassNameInfo.getName(type.getJavaType().getRealName()).toUpperCase();
            if (!typeName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void initializeTypeMap(Map typeMap) {
        this.literalTypes.initializeTypeMap(typeMap);
    }

    private void modelSubclasses(String typeUri, JavaStructureType type) {
        if (!type.isPresent()) {
            return;
        }
        try {
            Class typeClass = RmiUtils.getClassForName(type.getRealName(), this.env.getClassLoader());
            Class[] interfaces = typeClass.getInterfaces();
            if (RmiTypeModeler.multipleClasses(interfaces, this.env)) {
                throw new ModelerException("rmimodeler.type.implements.more.than.one.interface", new Object[]{type.getRealName(), interfaces[0].getName(), interfaces[1].getName()});
            }
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", type.getRealName());
        }
        int startSize = this.complexTypeMap.size();
        int curSize = 0;
        block2: while (curSize != startSize) {
            curSize = startSize;
            Iterator iterator = this.complexTypeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                JavaStructureType javaType;
                LiteralType extraType = (LiteralType)iterator.next().getValue();
                if (!(extraType instanceof LiteralStructuredType) || type.equals(javaType = (JavaStructureType)extraType.getJavaType()) || !javaType.isPresent() || !LiteralTypeModeler.isSubclass(javaType.getRealName(), type.getRealName(), this.env.getClassLoader())) continue;
                this.modelHierarchy(typeUri, javaType, type);
                curSize = this.complexTypeMap.size();
                if (curSize == startSize) continue;
                startSize = curSize;
                curSize = 0;
                continue block2;
            }
        }
    }

    public static void markInheritedMembers(ProcessorEnvironment env, LiteralStructuredType struct) {
        String className = struct.getJavaType().getRealName();
        try {
            JavaStructureMember javaMember;
            Iterator members = struct.getElementMembers();
            Class javaClass = RmiUtils.getClassForName(className, env.getClassLoader());
            if (javaClass.isInterface() || Modifier.isAbstract(javaClass.getModifiers())) {
                ((JavaStructureType)struct.getJavaType()).setAbstract(true);
            }
            Class superclass = javaClass.getSuperclass();
            while (members.hasNext()) {
                LiteralElementMember literalMember = (LiteralElementMember)members.next();
                javaMember = literalMember.getJavaStructureMember();
                if (javaMember.isPublic()) {
                    try {
                        Field field = javaClass.getDeclaredField(javaMember.getName());
                        if (field.getDeclaringClass().equals(javaClass)) continue;
                        javaMember.setInherited(true);
                        literalMember.setInherited(true);
                    }
                    catch (NoSuchFieldException e) {
                        javaMember.setInherited(true);
                        literalMember.setInherited(true);
                    }
                    continue;
                }
                String methodName = javaMember.getReadMethod();
                Class[] args = new Class[]{};
                boolean isInherited = RmiTypeModeler.isMethodInherited(methodName, args, javaClass);
                methodName = javaMember.getWriteMethod();
                if (methodName != null) {
                    boolean bl = isInherited = isInherited ? RmiTypeModeler.isMethodInherited(methodName, args, javaClass) : false;
                }
                if (!isInherited) continue;
                javaMember.setInherited(true);
                literalMember.setInherited(true);
            }
            members = struct.getAttributeMembers();
            while (members.hasNext()) {
                LiteralAttributeMember attributeMember = (LiteralAttributeMember)members.next();
                javaMember = attributeMember.getJavaStructureMember();
                if (javaMember.isPublic()) {
                    try {
                        Field field = javaClass.getDeclaredField(javaMember.getName());
                        if (field.getDeclaringClass().equals(javaClass)) continue;
                        javaMember.setInherited(true);
                        attributeMember.setInherited(true);
                    }
                    catch (NoSuchFieldException e) {
                        javaMember.setInherited(true);
                        attributeMember.setInherited(true);
                    }
                    continue;
                }
                String methodName = javaMember.getReadMethod();
                Class[] args = new Class[]{};
                boolean isInherited = RmiTypeModeler.isMethodInherited(methodName, args, javaClass);
                methodName = javaMember.getWriteMethod();
                if (methodName != null) {
                    boolean bl = isInherited = isInherited ? RmiTypeModeler.isMethodInherited(methodName, args, javaClass) : false;
                }
                if (!isInherited) continue;
                javaMember.setInherited(true);
                attributeMember.setInherited(true);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", className);
        }
    }

    private void mapLiteralType(RmiType type, LiteralType literalType) {
        this.mapLiteralType(type, literalType, false);
    }

    private void mapLiteralType(RmiType type, LiteralType literalType, boolean topLevel) {
        this.mapLiteralType(type.toString() + topLevel, literalType);
    }

    private LiteralType getMappedLiteralType(RmiType type, boolean topLevel) {
        LiteralType retType = null;
        String name = type.toString();
        retType = (LiteralType)this.simpleTypeMap.get(name);
        if (retType == null) {
            retType = (LiteralType)this.complexTypeMap.get(name + topLevel);
        }
        return retType;
    }

    private void mapLiteralType(String name, LiteralType literalType) {
        this.complexTypeMap.put(name, literalType);
    }

    LiteralTypeModeler(RmiModeler modeler, ProcessorEnvironment env) {
        this.modeler = modeler;
        this.env = env;
        this.typeMappingRegistry = modeler.getTypeMappingRegistryInfo();
        this.typeNames = new HashSet();
        this.simpleTypeMap = new HashMap();
        this.complexTypeMap = new HashMap();
        this.literalTypes = new LiteralSimpleTypeCreator();
        this.initializeTypeMap(this.simpleTypeMap);
    }

    private static void log(ProcessorEnvironment env, String msg) {
        if (env.verbose()) {
            System.out.println("[RmiTypeModeler: " + msg + "]");
        }
    }

    private void addTypeName(QName typeName, String javaType) {
        if (this.typeNames.contains(typeName)) {
            throw new ModelerException("rmimodeler.duplicate.type.name", new Object[]{typeName.toString(), javaType});
        }
        this.typeNames.add(typeName);
    }

    public boolean modelHierarchy(String typeUri, JavaStructureType subclass, JavaStructureType superclassType) {
        String superClassName = superclassType.getRealName();
        LiteralStructuredType superLiteralType = (LiteralStructuredType)superclassType.getOwner();
        LiteralStructuredType literalType = (LiteralStructuredType)subclass.getOwner();
        if (literalType.getParentType() != null) {
            if (literalType.getParentType().equals(superLiteralType)) {
                return true;
            }
            if (LiteralTypeModeler.isSubclass(literalType.getParentType().getJavaType().getRealName(), superClassName, this.env.getClassLoader())) {
                LiteralStructuredType tmpType = literalType;
                while (tmpType.getParentType() != null) {
                    if ((tmpType = tmpType.getParentType()).getJavaType().getRealName().equals(superClassName)) {
                        return true;
                    }
                    if (LiteralTypeModeler.isSubclass(tmpType.getJavaType().getRealName(), superClassName, this.env.getClassLoader())) continue;
                    throw new ModelerException("rmimodeler.type.is.used.as.two.types", new Object[]{subclass.getRealName(), tmpType.getJavaType().getRealName(), superClassName});
                }
                return this.modelHierarchy(typeUri, (JavaStructureType)tmpType.getJavaType(), superclassType);
            }
            if (!LiteralTypeModeler.isSubclass(superClassName, literalType.getParentType().getJavaType().getRealName(), this.env.getClassLoader())) {
                if (literalType.getParentType().getJavaType().getRealName().equals(superClassName)) {
                    return true;
                }
                throw new ModelerException("rmimodeler.type.is.used.as.two.types", new Object[]{subclass.getRealName(), literalType.getParentType().getJavaType().getRealName(), superClassName});
            }
        }
        try {
            Class subclassClass = RmiUtils.getClassForName(subclass.getRealName(), this.env.getClassLoader());
            Class superclass = subclassClass.getSuperclass();
            if (superclass == null || !superclass.getName().equals(superClassName) && !LiteralTypeModeler.isSubclass(superclass.getName(), superClassName, this.env.getClassLoader())) {
                Class<?>[] interfaces = subclassClass.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    if (interfaces[i].getName().equals(superClassName)) {
                        superLiteralType.addSubtype((LiteralStructuredType)subclass.getOwner());
                        ((JavaStructureType)superLiteralType.getJavaType()).addSubclass(subclass);
                        return true;
                    }
                    if (LiteralTypeModeler.isSubclass(interfaces[i].getName(), superClassName, this.env.getClassLoader())) {
                        RmiType type = RmiType.getRmiType(interfaces[i]);
                        LiteralElementMember elemMember = this.modelTypeLiteral(new QName(this.modeler.generateNameFromType(type, this.env)), typeUri, type);
                        LiteralStructuredType superType = (LiteralStructuredType)elemMember.getType();
                        superType.addSubtype((LiteralStructuredType)subclass.getOwner());
                        ((JavaStructureType)superType.getJavaType()).addSubclass(subclass);
                        return this.modelHierarchy(typeUri, (JavaStructureType)superType.getJavaType(), superclassType);
                    }
                    ++i;
                }
            }
            RmiType type = RmiType.getRmiType(superclass);
            LiteralElementMember elemMember = this.modelTypeLiteral(new QName(this.modeler.generateNameFromType(type, this.env)), typeUri, type);
            LiteralStructuredType superType = (LiteralStructuredType)elemMember.getType();
            superType.addSubtype((LiteralStructuredType)subclass.getOwner());
            ((JavaStructureType)superType.getJavaType()).addSubclass(subclass);
            if (!superclass.getName().equals(superClassName)) {
                return this.modelHierarchy(typeUri, (JavaStructureType)superType.getJavaType(), superclassType);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", subclass.getRealName());
        }
    }

    public static boolean isSubclass(String subtypeName, String supertypeName, ClassLoader classLoader) {
        return RmiTypeModeler.isSubclass(subtypeName, supertypeName, classLoader);
    }

    public String generateSchemaNameForArrayWrapper(RmiType type, ProcessorEnvironment env) {
        String base;
        int typeCode = type.getTypeCode();
        switch (typeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                base = type.toString();
                break;
            }
            case 9: {
                base = this.generateSchemaNameForArrayWrapper(type.getElementType(), env);
                break;
            }
            case 10: {
                RmiType holderValueType = RmiTypeModeler.getHolderValueType(env, this.modeler.getDefHolder(), type);
                if (holderValueType != null) {
                    return this.generateSchemaNameForArrayWrapper(holderValueType, env);
                }
                String tmp = ClassNameInfo.getName(type.getClassName());
                base = ClassNameInfo.replaceInnerClassSym(tmp);
                break;
            }
            default: {
                throw new Error("unexpected type code: " + typeCode);
            }
        }
        return base + "Array";
    }

    public LiteralElementMember modelTypeLiteral(QName elemName, String typeUri, RmiType type) {
        return this.modelTypeLiteral(elemName, typeUri, type, false, false);
    }

    public LiteralElementMember modelTypeLiteral(QName elemName, String typeUri, RmiType type, boolean topLevel, boolean allowHolders) {
        String tmp = (String)unsupportedClasses.get(type.toString());
        if (tmp != null) {
            if (tmp.equals(OBJECT)) {
                throw new ModelerException("rmimodeler.object.is.not.supported");
            }
            throw new ModelerException("rmimodeler.type.is.not.supported", new Object[]{tmp, type.toString()});
        }
        LiteralType typeNode = this.getMappedLiteralType(type, topLevel && type.getTypeCode() == 9);
        if (typeNode != null) {
            LiteralElementMember elemMember = new LiteralElementMember(elemName, typeNode);
            JavaStructureMember javaMember = new JavaStructureMember(elemMember.getName().getLocalPart(), typeNode.getJavaType(), elemMember, false);
            this.env.getNames().setJavaStructureMemberMethodNames(javaMember);
            elemMember.setJavaStructureMember(javaMember);
            elemMember.setRepeated(!topLevel && type.getTypeCode() == 9 && !typeNode.equals(this.literalTypes.XSD_BYTE_ARRAY_LITERALTYPE));
            elemMember.setNillable(!topLevel && type.isNillable());
            elemMember.setRequired(topLevel);
            return elemMember;
        }
        int typeCode = type.getTypeCode();
        String packageName = ClassNameInfo.getQualifier(type.toString());
        String namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = typeUri;
        }
        switch (typeCode) {
            case 11: {
                return null;
            }
            case 9: {
                RmiType elemRmiType = type.getElementType();
                LiteralElementMember elemMember = null;
                elemMember = elemRmiType.getTypeCode() == 9 && !"byte[]".equals(elemRmiType.toString()) ? this.modelTypeLiteral(elemName, typeUri, elemRmiType, true, false) : this.modelTypeLiteral(elemName, typeUri, elemRmiType);
                String fixedupClassName = type.typeString(false);
                JavaArrayType javaArType = new JavaArrayType(fixedupClassName, InternalEncodingConstants.ARRAY_ELEMENT_NAME.getLocalPart(), elemMember.getJavaStructureMember().getType());
                JavaStructureMember javaMember = new JavaStructureMember(elemMember.getName().getLocalPart(), javaArType, elemMember, false);
                this.env.getNames().setJavaStructureMemberMethodNames(javaMember);
                elemMember.setJavaStructureMember(javaMember);
                elemMember.setRepeated(true);
                elemMember.setNillable(!topLevel && elemMember.getType().isNillable());
                elemMember.setRequired(topLevel);
                if (topLevel) {
                    String fixedupMemberClassName;
                    String servicePackage = this.modeler.getServicePackage();
                    servicePackage = servicePackage != null && servicePackage.length() > 0 ? servicePackage + '.' : "";
                    servicePackage = servicePackage + "_arrays";
                    elemMember.setNillable(elemMember.getType().isNillable());
                    elemMember.setRequired(false);
                    LiteralElementMember topMember = new LiteralElementMember();
                    topMember.setName(elemName);
                    topMember.setNillable(false);
                    topMember.setRequired(true);
                    LiteralArrayWrapperType seqType = new LiteralArrayWrapperType();
                    String tmpNamespace = typeUri;
                    String elemPackage = Names.getPackageName(elemMember.getType().getJavaType().getName());
                    if (elemPackage.startsWith(servicePackage)) {
                        tmpNamespace = elemMember.getType().getName().getNamespaceURI();
                    } else if (!elemPackage.equals(servicePackage)) {
                        tmpNamespace = Names.getAdjustedURI(tmpNamespace, "arrays/" + elemPackage.replace('.', '/'));
                    }
                    seqType.setName(new QName(tmpNamespace, this.generateSchemaNameForArrayWrapper(elemRmiType, this.env)));
                    String arraysPackage = servicePackage + '.';
                    if (elemRmiType.getTypeCode() == 9) {
                        String str = elemMember.getType() instanceof LiteralSimpleType ? arraysPackage + this.env.getNames().validJavaClassName(elemRmiType.toString()) : elemMember.getType().getJavaType().getName();
                        fixedupMemberClassName = str + "Array";
                    } else {
                        fixedupMemberClassName = elemRmiType.getTypeCode() == 10 ? arraysPackage + elemRmiType.getClassName() + "Array" : arraysPackage + this.env.getNames().validJavaClassName(elemRmiType.toString() + "Array");
                    }
                    fixedupMemberClassName = fixedupMemberClassName.replace('$', '_');
                    JavaStructureType javaStruct = new JavaStructureType(fixedupMemberClassName, false, seqType);
                    JavaStructureMember jsMember = new JavaStructureMember(elemName.getLocalPart(), javaStruct, topMember);
                    this.env.getNames().setJavaStructureMemberMethodNames(jsMember);
                    seqType.setJavaType(javaStruct);
                    seqType.add(elemMember);
                    javaMember.setName("value");
                    this.env.getNames().setJavaStructureMemberMethodNames(javaMember);
                    if (elemRmiType.getTypeCode() == 9 && !(elemMember.getType() instanceof LiteralSimpleType)) {
                        String memName = this.env.getNames().getClassMemberName(elemMember.getType().getJavaType().getRealName());
                        JavaArrayType ja2 = new JavaArrayType(elemMember.getType().getJavaType().getName() + "[]", memName, elemMember.getType().getJavaType());
                        JavaStructureMember tmpMember = new JavaStructureMember(memName, ja2, elemMember);
                        this.env.getNames().setJavaStructureMemberMethodNames(tmpMember);
                        javaStruct.add(tmpMember);
                        JavaArrayType javaArray = new JavaArrayType(((LiteralArrayWrapperType)elemMember.getType()).getJavaArrayType().getName() + "[]", memName, elemMember.getType().getJavaType());
                        seqType.setJavaArrayType(javaArray);
                    } else {
                        javaStruct.add(elemMember.getJavaStructureMember());
                        seqType.setJavaArrayType((JavaArrayType)elemMember.getJavaStructureMember().getType());
                    }
                    elemMember.setName(new QName("value"));
                    topMember.setType(seqType);
                    topMember.setJavaStructureMember(jsMember);
                    javaMember.setOwner(topMember);
                    this.mapLiteralType(type, topMember.getType(), true);
                    return topMember;
                }
                return elemMember;
            }
            case 10: {
                Class typeClass;
                if (!allowHolders && LiteralTypeModeler.getHolderValueType(this.env, this.modeler.getDefHolder(), type) != null) {
                    throw new ModelerException("rmimodeler.no.literal.holders", new Object[]{type.toString()});
                }
                LiteralElementMember holderMember = this.modelHolder(elemName, this.modeler, this.env, typeUri, type);
                if (holderMember != null) {
                    this.mapLiteralType(type, holderMember.getType());
                    return holderMember;
                }
                QName structName = new QName(namespaceURI, type.typeString(true).replace('$', '.'));
                LiteralSequenceType struct = new LiteralSequenceType(structName);
                struct.setNillable(true);
                String fixedupClassName = type.getClassName();
                this.addTypeName(structName, fixedupClassName);
                this.mapLiteralType(type, (LiteralType)struct);
                JavaStructureType javaStruct = new JavaStructureType(fixedupClassName, true, struct);
                struct.setJavaType(javaStruct);
                Map members = RmiStructure.modelTypeSOAP(this.env, type);
                Map members2 = JavaBean.modelTypeSOAP(this.env, type);
                if (members.size() != 0 && members2.size() != 0) {
                    Iterator keys = members.keySet().iterator();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if (!members2.containsKey(key)) continue;
                        throw new ModelerException("rmimodeler.javabean.property.has.public.member", new Object[]{type.toString(), key});
                    }
                }
                members.putAll(members2);
                if (members.size() == 0) {
                    throw new ModelerException("rmimodeler.invalid.rmi.type", type.toString());
                }
                try {
                    typeClass = type.getTypeClass(this.env.getClassLoader());
                    if (typeClass.isInterface() || Modifier.isAbstract(typeClass.getModifiers())) {
                        ((JavaStructureType)struct.getJavaType()).setAbstract(true);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new ModelerException("rmimodeler.class.not.found", type.toString());
                }
                List sortedMembers = RmiTypeModeler.sortMembers(typeClass, members, this.env);
                this.fillInStructure(typeUri, struct, javaStruct, sortedMembers, type);
                LiteralElementMember elemMember = new LiteralElementMember(elemName, struct);
                elemMember.setNillable(!topLevel);
                JavaStructureMember javaMember = new JavaStructureMember(elemMember.getName().getLocalPart().replace('.', '_'), struct.getJavaType(), elemMember, false);
                this.env.getNames().setJavaStructureMemberMethodNames(javaMember);
                elemMember.setJavaStructureMember(javaMember);
                return elemMember;
            }
        }
        throw new ModelerException("rmimodeler.unexpected.type", type.toString());
    }

    public static RmiType getHolderValueType(ProcessorEnvironment env, Class defHolder, RmiType type) {
        return RmiTypeModeler.getHolderValueType(env, defHolder, type);
    }

    private void fillInStructure(String typeUri, LiteralStructuredType struct, JavaStructureType javaStruct, List sortedMembers, RmiType type) {
        ProcessorEnvironment env = this.modeler.getProcessorEnvironment();
        Iterator iter = sortedMembers.iterator();
        while (iter.hasNext()) {
            MemberInfo memInfo = (MemberInfo)iter.next();
            LiteralElementMember member = this.modelTypeLiteral(new QName(memInfo.getName()), typeUri, memInfo.getType());
            JavaStructureMember javaMember = member.getJavaStructureMember();
            javaMember.setReadMethod(memInfo.getReadMethod());
            javaMember.setWriteMethod(memInfo.getWriteMethod());
            javaMember.setPublic(memInfo.isPublic());
            if (memInfo.getDeclaringClass() != null) {
                javaMember.setDeclaringClass(memInfo.getDeclaringClass().getName());
            }
            javaStruct.add(javaMember);
            struct.add(member);
        }
        LiteralTypeModeler.markInheritedMembers(env, struct);
    }

    private LiteralElementMember modelHolder(QName elemName, RmiModeler modeler, ProcessorEnvironment env, String typeUri, RmiType type) {
        RmiType holderValueType = LiteralTypeModeler.getHolderValueType(env, modeler.getDefHolder(), type);
        if (holderValueType == null) {
            return null;
        }
        LiteralElementMember holderMember = this.modelTypeLiteral(elemName, typeUri, holderValueType, true, true);
        JavaType javaType = holderMember.getType().getJavaType();
        javaType.setHolder(true);
        javaType.setHolderPresent(true);
        javaType.setHolderName(type.toString());
        return holderMember;
    }
}

