/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.util;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

final class UUID
implements Serializable {
    private static final long serialVersionUID = -4856846361193249489L;
    private long mostSigBits;
    private long leastSigBits;
    private transient int version = -1;
    private transient int variant = -1;
    private transient long timestamp = -1L;
    private transient int sequence = -1;
    private transient long node = -1L;
    private static SecureRandom numberGenerator = null;

    private int clockSequence() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        this.sequence = (int)((this.leastSigBits & 0x3FFF000000000000L) >>> 48);
        return this.sequence;
    }

    public int hashCode() {
        return (int)(this.mostSigBits >> 32 ^ this.mostSigBits ^ this.leastSigBits >> 32 ^ this.leastSigBits);
    }

    private int variant() {
        if (this.variant < 0) {
            this.variant = this.leastSigBits >>> 63 == 0L ? 0 : (this.leastSigBits >>> 62 == 2L ? 2 : (int)(this.leastSigBits >>> 61));
        }
        return this.variant;
    }

    private int version() {
        if (this.version < 0) {
            this.version = (int)(this.mostSigBits >> 12 & 0xFL);
        }
        return this.version;
    }

    private long node() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        this.node = this.leastSigBits & 0xFFFFFFFFFFFFL;
        return this.node;
    }

    private long timestamp() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        this.timestamp = (this.mostSigBits & 0xFFFL) << 48;
        this.timestamp |= (this.mostSigBits >> 16 & 0xFFFFL) << 32;
        this.timestamp |= this.mostSigBits >>> 32;
        return this.timestamp;
    }

    private UUID(long mostSigBits, long leastSigBits) {
        this.mostSigBits = mostSigBits;
        this.leastSigBits = leastSigBits;
    }

    private UUID(byte[] data) {
        if (data.length != 16) {
            // empty if block
        }
        int i = 0;
        while (i < 8) {
            this.mostSigBits = this.mostSigBits << 8 | (long)(data[i] & 0xFF);
            ++i;
        }
        int i2 = 8;
        while (i2 < 16) {
            this.leastSigBits = this.leastSigBits << 8 | (long)(data[i2] & 0xFF);
            ++i2;
        }
    }

    protected static UUID randomUUID() {
        if (numberGenerator == null) {
            numberGenerator = new SecureRandom();
        }
        byte[] randomBytes = new byte[16];
        numberGenerator.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        UUID result = new UUID(randomBytes);
        return new UUID(randomBytes);
    }

    private int compareTo(UUID val) {
        if (val.variant() != this.variant()) {
            throw new IllegalArgumentException();
        }
        return this.mostSigBits < val.mostSigBits ? -1 : (this.mostSigBits > val.mostSigBits ? 1 : (this.leastSigBits < val.leastSigBits ? -1 : (this.leastSigBits > val.leastSigBits ? 1 : 0)));
    }

    private static UUID nameUUIDFromBytes(byte[] name) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InternalError("MD5 not supported");
        }
        byte[] md5Bytes = md.digest(name);
        md5Bytes[6] = (byte)(md5Bytes[6] & 0xF);
        md5Bytes[6] = (byte)(md5Bytes[6] | 0x30);
        md5Bytes[8] = (byte)(md5Bytes[8] & 0x3F);
        md5Bytes[8] = (byte)(md5Bytes[8] | 0x80);
        return new UUID(md5Bytes);
    }

    private UUID(DataInput in) throws IOException {
        this.mostSigBits = in.readLong();
        this.leastSigBits = in.readLong();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UUID)) {
            return false;
        }
        if (((UUID)obj).variant() != this.variant()) {
            return false;
        }
        UUID id = (UUID)obj;
        return this.mostSigBits == id.mostSigBits && this.leastSigBits == id.leastSigBits;
    }

    public String toString() {
        return UUID.digits(this.mostSigBits >> 32, 8) + "-" + UUID.digits(this.mostSigBits >> 16, 4) + "-" + UUID.digits(this.mostSigBits, 4) + "-" + UUID.digits(this.leastSigBits >> 48, 4) + "-" + UUID.digits(this.leastSigBits, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    private static UUID fromString(String name) {
        String[] components = name.split("-");
        if (components.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + name);
        }
        int i = 0;
        while (i < 5) {
            components[i] = "0x" + components[i];
            ++i;
        }
        long mostSigBits = Long.decode(components[0]);
        mostSigBits <<= 16;
        mostSigBits |= Long.decode(components[1]).longValue();
        mostSigBits <<= 16;
        long leastSigBits = Long.decode(components[3]);
        leastSigBits <<= 48;
        return new UUID(mostSigBits |= Long.decode(components[2]).longValue(), leastSigBits |= Long.decode(components[4]).longValue());
    }

    private static UUID nameUUIDFromString(String name) {
        byte[] md5Bytes;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InternalError("MD5 not supported");
        }
        try {
            md5Bytes = md.digest(name.getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new InternalError("8859_1 not supported");
        }
        md5Bytes[6] = (byte)(md5Bytes[6] & 0xF);
        md5Bytes[6] = (byte)(md5Bytes[6] | 0x30);
        md5Bytes[8] = (byte)(md5Bytes[8] & 0x3F);
        md5Bytes[8] = (byte)(md5Bytes[8] | 0x80);
        return new UUID(md5Bytes);
    }
}

