/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.comm;

import com.sun.scn.client.comm.SvcTagRunnable;
import com.sun.scn.client.ui.Client;
import com.sun.scn.client.ui.RegClientMessageArea;
import com.sun.scn.client.util.EncryptionHelper;
import com.sun.scn.servicetags.Agent;
import com.sun.scn.servicetags.EmptyAgent;
import com.sun.scn.servicetags.EncryptedAgent;
import com.sun.scn.servicetags.util.XMLUtil;
import com.sun.scn.util.XMLErrorSuppressor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Communicator {
    private static Logger log = Logger.getLogger(Communicator.class.getName());
    private Client client;
    private InetAddress addr;
    private int port;
    private int MAX_AGENT_THREADS;
    private int MAX_SVCTAG_THREADS;
    private String targetProductURN;

    public Communicator(Client client, InetAddress addr, int port) throws IOException, SocketException {
        this.client = client;
        this.addr = addr;
        this.port = port;
        this.targetProductURN = null;
    }

    public Communicator(Client client, InetAddress addr, int port, String targetProductURN) throws IOException, SocketException {
        this.client = client;
        this.addr = addr;
        this.port = port;
        this.targetProductURN = targetProductURN;
    }

    public static void handleComm(final Client client, final InetAddress address, final int port, final String targetProductURN) {
        Runnable commRunner = new Runnable(){

            public void run() {
                block3: {
                    try {
                        Communicator comm = null;
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "communicating with: " + address + ":" + port);
                        }
                        comm = targetProductURN != null ? new Communicator(client, address, port, targetProductURN) : new Communicator(client, address, port);
                        comm.getFromAgent();
                    }
                    catch (IOException ioe) {
                        if (!log.isLoggable(Level.FINE)) break block3;
                        log.log(Level.FINE, "Exception when communicating via TCP to: " + address + ":" + port, ioe);
                    }
                }
            }
        };
        Thread commThread = new Thread(commRunner, "commThread");
        commThread.start();
    }

    private void getServiceTags(Agent agent) {
        HttpURLConnection con = null;
        List<URL> stUrls = null;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Getting service tags for agent: " + agent.getAgentURN());
        }
        try {
            String ipAddress = this.addr.getHostAddress();
            URL stListUrl = new URL("http://" + ipAddress + ":" + this.port + "/stv1/svctag/");
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Using URL: " + stListUrl);
            }
            con = (HttpURLConnection)stListUrl.openConnection();
            con.setRequestMethod("GET");
            con.setDoInput(true);
            con.setDoOutput(false);
            con.setUseCaches(false);
            con.setAllowUserInteraction(false);
            con.connect();
            InputStream is = con.getInputStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new XMLErrorSuppressor());
            String xml = this.readStreamContents(is);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "XML: " + xml);
            }
            try {
                stUrls = this.parseSTURLInputStream(builder, new ByteArrayInputStream(xml.getBytes()), ipAddress);
            }
            catch (SAXException se) {
                StringTokenizer st = new StringTokenizer(xml, "\n");
                StringBuilder decSB = new StringBuilder();
                while (st.hasMoreTokens()) {
                    decSB.append(this.decrypt(st.nextToken())).append("\n");
                }
                xml = decSB.toString();
                try {
                    stUrls = this.parseSTURLInputStream(builder, new ByteArrayInputStream(xml.getBytes()), ipAddress);
                }
                catch (SAXException se2) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Exception parsing input stream", se2);
                    }
                }
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Encountered error: " + e.getMessage(), e);
            }
            RegClientMessageArea.logMessage((String)("Encountered a runtime exception: " + e.getMessage()));
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (Exception e) {}
        }
        try {
            long start = System.currentTimeMillis();
            ArrayList<Thread> stThreads = new ArrayList<Thread>(5);
            if (stUrls == null) {
                stUrls = new ArrayList<URL>();
            }
            for (URL stUrl : stUrls) {
                if (this.targetProductURN == null) {
                    stThreads.add(new Thread(new SvcTagRunnable(stUrl, agent, this.client)));
                } else {
                    stThreads.add(new Thread(new SvcTagRunnable(stUrl, agent, this.targetProductURN, this.client)));
                }
                if (stThreads.size() != 5) continue;
                for (Thread th : stThreads) {
                    th.start();
                }
                for (Thread th : stThreads) {
                    try {
                        th.join();
                    }
                    catch (Exception e) {}
                }
                stThreads = new ArrayList(5);
            }
            for (Thread th : stThreads) {
                th.start();
            }
            for (Thread th : stThreads) {
                try {
                    th.join();
                }
                catch (Exception e) {}
            }
            long stop = System.currentTimeMillis();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Encountered error: " + e.getMessage(), e);
            }
            RegClientMessageArea.logMessage((String)("Encountered a runtime exception: " + e.getMessage()));
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (Exception e) {}
        }
    }

    public void getFromAgent() {
        HttpURLConnection con = null;
        URL agentUrl = null;
        try {
            Agent agent;
            String ipAddress;
            block34: {
                String xml;
                DocumentBuilder builder;
                block33: {
                    ipAddress = this.addr.getHostAddress();
                    agentUrl = new URL("http://" + ipAddress + ":" + this.port + "/stv1/agent/");
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Getting agent: " + agentUrl);
                    }
                    con = (HttpURLConnection)agentUrl.openConnection();
                    con.setRequestMethod("GET");
                    con.setDoInput(true);
                    con.setDoOutput(false);
                    con.setUseCaches(false);
                    con.setAllowUserInteraction(false);
                    con.connect();
                    InputStream is = con.getInputStream();
                    if (con.getResponseCode() != 200) {
                        System.err.println(agentUrl.toString() + " returned: " + con.getResponseCode());
                        con.disconnect();
                        return;
                    }
                    agent = null;
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    builder = factory.newDocumentBuilder();
                    builder.setErrorHandler(new XMLErrorSuppressor());
                    xml = this.readStreamContents(is);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, xml);
                    }
                    try {
                        is.close();
                        con.disconnect();
                    }
                    catch (Exception e) {
                        if (!log.isLoggable(Level.FINE)) break block33;
                        log.log(Level.FINE, "Exception cleaning up connection: " + e.getMessage(), e);
                    }
                }
                try {
                    agent = this.parseAgentInputStream(builder, new ByteArrayInputStream(xml.getBytes()));
                }
                catch (SAXException se) {
                    StringTokenizer st = new StringTokenizer(xml, "\n");
                    StringBuilder decSB = new StringBuilder();
                    try {
                        while (st.hasMoreTokens()) {
                            decSB.append(this.decrypt(st.nextToken())).append("\n");
                        }
                        xml = decSB.toString();
                        agent = this.parseAgentInputStream(builder, new ByteArrayInputStream(xml.getBytes()));
                        RegClientMessageArea.logMessage((String)("Successfully decrypted agent: " + agent.getHost()));
                    }
                    catch (SAXException se2) {
                        agent = new EncryptedAgent("Encrypted Agent: " + UUID.randomUUID().toString());
                    }
                    catch (Exception e) {
                        if (!log.isLoggable(Level.FINE)) break block34;
                        log.log(Level.FINE, "Exception reading agent response", e);
                    }
                }
            }
            if (agent != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Discovered System: " + agent.getHost() + " -- " + ipAddress);
                }
                RegClientMessageArea.logMessage((String)("Discovered System: " + agent.getHost()));
                agent.ipAddress = ipAddress;
                if (!(agent instanceof EncryptedAgent)) {
                    this.getServiceTags(agent);
                }
                if (this.client != null) {
                    if (this.targetProductURN == null) {
                        this.client.addAgent(agent);
                    } else if (agent.getSvcTags().size() > 0) {
                        this.client.addAgent(agent);
                    } else {
                        this.client.addAgent((Agent)new EmptyAgent(agent.agentURN));
                    }
                }
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Error: " + e.getMessage() + " : " + agentUrl, e);
            }
            RegClientMessageArea.logMessage((String)("Encountered a runtime exception: " + e.getMessage()));
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (Exception e) {}
        }
    }

    private String readStreamContents(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "exception while reading stream contents: " + e.getMessage(), e);
        }
        try {
            br.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "exception while trying to close reader: " + e.getMessage(), e);
        }
        return sb.toString();
    }

    private List<URL> parseSTURLInputStream(DocumentBuilder builder, InputStream is, String ipAddress) throws SAXException, IOException {
        ArrayList<URL> stUrls = null;
        Document doc = builder.parse(is);
        NodeList links = doc.getElementsByTagName("link");
        if (links != null && links.getLength() > 0) {
            stUrls = new ArrayList<URL>(links.getLength());
            for (int i = 0; i < links.getLength(); ++i) {
                Element link = (Element)links.item(i);
                URL stUrl = new URL("http://" + ipAddress + ":" + this.port + link.getAttribute("href"));
                stUrls.add(stUrl);
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, "Discovered ST URL: " + stUrl);
            }
        }
        return stUrls;
    }

    private Agent parseAgentInputStream(DocumentBuilder builder, InputStream is) throws SAXException, IOException {
        Agent agent = null;
        Document doc = builder.parse(is);
        NodeList agentNodeList = doc.getElementsByTagName("agent");
        if (agentNodeList.getLength() == 1) {
            Element agentElement = (Element)agentNodeList.item(0);
            String agentURN = XMLUtil.getRequiredTextValue(agentElement, "agent_urn");
            agent = new Agent(agentURN);
            agent.setState(agentElement);
            agent.agentVersion = XMLUtil.getRequiredTextValue(agentElement, "agent_version");
            agent.helperVersion = XMLUtil.getRequiredTextValue(agentElement, "registry_version");
            agent.setPort(this.port);
        }
        return agent;
    }

    private String decrypt(String line) {
        String res = null;
        try {
            res = EncryptionHelper.decrypt(this.client.getEncryptionKey(), line);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }
}

