/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.comm;

import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CompoundProbe
implements Runnable {
    Set<Runnable> probes = Collections.synchronizedSet(new HashSet());
    Set<Thread> threads = Collections.synchronizedSet(new HashSet());

    public void addProbe(Runnable probe) {
        this.probes.add(probe);
    }

    public void run() {
        try {
            for (Runnable probe : this.probes) {
                Thread thread = new Thread(probe, "probe:" + probe.getClass().toString());
                this.threads.add(thread);
                thread.start();
            }
            for (Thread thread : this.threads) {
                thread.join();
            }
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException || t instanceof InterruptedIOException || Thread.currentThread().isInterrupted()) {
                for (Thread thread : this.threads) {
                    thread.interrupt();
                }
                this.threads.clear();
            }
            throw new RuntimeException(t);
        }
    }
}

