/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.comm;

import com.sun.scn.client.comm.RegSender;
import com.sun.scn.client.comm.SvcTagException;
import com.sun.scn.client.ui.RegClassicClient;
import com.sun.scn.client.ui.tree.AgentTreeNode;
import com.sun.scn.client.ui.tree.SvcTagTreeNode;
import com.sun.scn.servicetags.SvcTag;
import java.awt.event.ActionEvent;
import java.io.InterruptedIOException;
import java.security.KeyPair;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Timer;

public class Sync
implements Runnable {
    private static Logger log = Logger.getLogger(Sync.class.getName());
    private Set<AgentTreeNode> agents = Collections.synchronizedSet(new HashSet());
    private RegClassicClient regClassicClient;
    private KeyPair keyPair;
    private String clientId;
    private String proxyHost;
    private int domainId;
    private int proxyPort;
    private int actualCnt;
    private int expectedCnt;
    private int loopCnt;
    private Timer timer;

    public Sync(RegClassicClient client, String proxyHost, int proxyPort, KeyPair keyPair, String clientId, int domainId) {
        this.regClassicClient = client;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.keyPair = keyPair;
        this.clientId = clientId;
        this.domainId = domainId;
    }

    public void addAgent(AgentTreeNode agent) {
        this.agents.add(agent);
    }

    public void run() {
        this.expectedCnt = 0;
        this.actualCnt = 0;
        this.loopCnt = 0;
        Runnable syncListener = new Runnable(){

            public void run() {
                for (AgentTreeNode agent : Sync.this.agents) {
                    Sync.this.expectedCnt += agent.getChildCount();
                    Sync.this.handleComm(agent);
                }
            }
        };
        Thread syncListenerThread = new Thread(syncListener, "syncListenerThread");
        syncListenerThread.start();
        try {
            syncListenerThread.join();
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException || t instanceof InterruptedIOException || Thread.currentThread().isInterrupted()) {
                if (syncListenerThread != null) {
                    syncListenerThread.interrupt();
                }
            }
            throw new RuntimeException(t);
        }
        AbstractAction updateAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (Sync.this.actualCnt == Sync.this.expectedCnt || Sync.this.loopCnt++ > 30) {
                    if (Sync.this.actualCnt == Sync.this.expectedCnt && log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Sync found expected # of items");
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Sync loop cnt was:" + Sync.this.loopCnt);
                    }
                    Sync.this.regClassicClient.finishSyncAction();
                    Sync.this.timer.stop();
                }
            }
        };
        this.timer = new Timer(1000, updateAction);
        this.timer.start();
    }

    private synchronized void updateActualCount() {
        ++this.actualCnt;
    }

    private void handleComm(final AgentTreeNode agent) {
        Runnable commRunner = new Runnable(){

            public void run() {
                for (int i = 0; i < agent.getChildCount(); ++i) {
                    SvcTagTreeNode stNode = (SvcTagTreeNode)agent.getChildAt(i);
                    try {
                        SvcTag st;
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Syncing svctag: " + stNode.getSvcTag().toXMLString());
                        }
                        if ((st = RegSender.getSvcTag("svctag/" + stNode.getInstanceURN(), Sync.this.proxyHost, Sync.this.proxyPort, Sync.this.keyPair, Sync.this.clientId, Sync.this.domainId)) != null) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, "Sync'd svctag: " + st.toXMLString());
                            }
                            if (st.getCustomerAssetTag() == null || st.getCustomerAssetTag().equals("")) {
                                st.setCustomerAssetTag(stNode.getCustomerAssetTag());
                            }
                            if (stNode.getSvcTag().getVersion() != null && (st.getVersion() == null || st.getVersion().equals("null"))) {
                                st.setVersion(stNode.getSvcTag().getVersion());
                            }
                            if (st.getCustomerAssetTag() == null || st.getCustomerAssetTag().equals("null")) {
                                st.setCustomerAssetTag("");
                            }
                            if (st.getDomainName() == null || st.getDomainName().equals("null")) {
                                st.setDomainName("");
                            }
                            stNode.setSvcTag(st);
                        } else {
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, "Could not sync svctag, setting to unregistered");
                            }
                            stNode.setRegistrationStatus("UNREGISTERED");
                        }
                    }
                    catch (SvcTagException ste) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "When trying to sync, encountered exception: " + ste.getMinorCode(), ste);
                        }
                        if (ste.getMinorCode() == 6) {
                            stNode.setRegistrationStatus("UNREGISTERED");
                        }
                        stNode.setRegistrationStatus("UNKNOWN");
                    }
                    Sync.this.regClassicClient;
                    RegClassicClient.updateStatus((SvcTagTreeNode)stNode);
                    Sync.this.updateActualCount();
                }
            }
        };
        Thread commThread = new Thread(commRunner, "commThread");
        commThread.start();
    }
}

