/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.comm;

import com.sun.scn.client.comm.RegSender;
import com.sun.scn.client.comm.SvcTagException;
import com.sun.scn.client.ui.RegClient;
import com.sun.scn.client.ui.ServiceTag;
import com.sun.scn.servicetags.SvcTag;
import java.awt.event.ActionEvent;
import java.io.InterruptedIOException;
import java.security.KeyPair;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncServiceTag
implements Runnable {
    private RegClient client;
    private KeyPair keyPair;
    private String clientId;
    private String proxyHost;
    private int domainId;
    private int proxyPort;
    private List<ServiceTag> serviceTags;
    private int actualCnt;
    private int expectedCnt;
    private int loopCnt;
    private Timer timer;

    public SyncServiceTag(RegClient client, String proxyHost, int proxyPort, KeyPair keyPair, String clientId, int domainId) {
        this.client = client;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.keyPair = keyPair;
        this.clientId = clientId;
        this.domainId = domainId;
    }

    public void setServiceTags(List<ServiceTag> serviceTags) {
        this.serviceTags = serviceTags;
    }

    @Override
    public void run() {
        this.expectedCnt = 0;
        this.actualCnt = 0;
        this.loopCnt = 0;
        Runnable syncListener = new Runnable(){

            public void run() {
                SyncServiceTag.this.expectedCnt = SyncServiceTag.this.serviceTags.size();
                SyncServiceTag.this.handleComm();
            }
        };
        Thread syncListenerThread = new Thread(syncListener, "syncListenerThread");
        syncListenerThread.start();
        try {
            syncListenerThread.join();
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException || t instanceof InterruptedIOException || Thread.currentThread().isInterrupted()) {
                if (syncListenerThread != null) {
                    syncListenerThread.interrupt();
                }
            }
            throw new RuntimeException(t);
        }
        AbstractAction updateAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SyncServiceTag.this.actualCnt == SyncServiceTag.this.expectedCnt || SyncServiceTag.this.loopCnt++ > 100) {
                    SyncServiceTag.this.client.reconcileFinished();
                    SyncServiceTag.this.timer.stop();
                }
            }
        };
        this.timer = new Timer(500, updateAction);
        this.timer.start();
    }

    private synchronized void updateActualCount() {
        ++this.actualCnt;
    }

    private void handleComm() {
        Runnable commRunner = new Runnable(){

            public void run() {
                for (ServiceTag tag : SyncServiceTag.this.serviceTags) {
                    try {
                        SvcTag st = RegSender.getSvcTag("svctag/" + tag.getSvcTag().getInstanceURN(), SyncServiceTag.this.proxyHost, SyncServiceTag.this.proxyPort, SyncServiceTag.this.keyPair, SyncServiceTag.this.clientId, SyncServiceTag.this.domainId);
                        if (st != null) {
                            SyncServiceTag.this.mergeVersion(st, tag.getSvcTag());
                            tag.setSvcTag(st);
                        } else {
                            tag.getSvcTag().setStatus("UNREGISTERED");
                        }
                    }
                    catch (SvcTagException ste) {
                        if (ste.getMinorCode() == 6) {
                            tag.getSvcTag().setStatus("UNREGISTERED");
                        }
                        if (ste.getCode() >= 12) {
                            SyncServiceTag.this.timer.stop();
                            SyncServiceTag.this.client.handleException(ste);
                            return;
                        }
                        tag.getSvcTag().setStatus("UNKNOWN");
                        SyncServiceTag.this.timer.stop();
                        SyncServiceTag.this.client.handleException(ste);
                        return;
                    }
                    SyncServiceTag.this.updateActualCount();
                }
            }
        };
        Thread commThread = new Thread(commRunner, "commThread");
        commThread.start();
    }

    public void mergeVersion(SvcTag newVal, SvcTag oldVal) {
        if ((newVal.getVersion() == null || newVal.getVersion().trim().length() == 0) && oldVal.getVersion() != null && oldVal.getVersion().trim().length() > 0) {
            newVal.setVersion(oldVal.getVersion());
        }
    }
}

