/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.comm;

import com.sun.scn.client.comm.Communicator;
import com.sun.scn.client.ui.Client;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPProbe
implements Runnable {
    private static Logger log = Logger.getLogger(UDPProbe.class.getName());
    public static final int DEFAULT_PORT = 6481;
    public static final String LOCAL_HOST = "127.0.0.1";
    public static final Set<String> DEFAULT_PROBE_ADDRS = new HashSet<String>();
    public static final Set<String> LOCAL_HOST_ADDR = new HashSet<String>();
    private int port;
    private Set<String> probeAddrs;
    private Client client;
    private String targetProductURN;

    public UDPProbe(Client client) {
        this.client = client;
        this.port = 6481;
        this.probeAddrs = new HashSet<String>();
        this.targetProductURN = null;
    }

    public UDPProbe(Client client, String targetProductURN) {
        this.client = client;
        this.port = 6481;
        this.probeAddrs = LOCAL_HOST_ADDR;
        this.targetProductURN = targetProductURN;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProbeAddrs(Set<String> probeAddrs) {
        this.probeAddrs = probeAddrs;
    }

    @Override
    public void run() {
        block10: {
            DatagramSocket udpSocket;
            try {
                udpSocket = new DatagramSocket();
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
            Runnable udpListener = new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                DatagramPacket p = new DatagramPacket(new byte[1024], 1024);
                                udpSocket.receive(p);
                                String resp = new String(p.getData(), p.getOffset(), p.getLength());
                                StringTokenizer st = new StringTokenizer(resp.trim());
                                String agentUrn = null;
                                String agentPort = null;
                                if (st.countTokens() == 2) {
                                    agentUrn = st.nextToken();
                                    agentPort = st.nextToken();
                                } else if (st.countTokens() == 1) {
                                    agentPort = st.nextToken();
                                }
                                String logMsg = "from " + p.getAddress() + ": " + resp.trim();
                                if (log.isLoggable(Level.FINER)) {
                                    log.log(Level.FINER, logMsg);
                                }
                                int port = 6481;
                                try {
                                    port = Integer.parseInt(agentPort);
                                }
                                catch (NumberFormatException nfe) {
                                    System.err.println("Error parsing port number: " + nfe.getMessage());
                                }
                                Communicator.handleComm(UDPProbe.this.client, p.getAddress(), port, UDPProbe.this.targetProductURN);
                            }
                        }
                        catch (Throwable t) {
                            if (!(t instanceof InterruptedException || t instanceof InterruptedIOException || Thread.currentThread().isInterrupted())) {
                                if (!log.isLoggable(Level.FINE)) continue;
                                log.log(Level.FINE, "Exception", t);
                                continue;
                            }
                            return;
                        }
                        break;
                    }
                }
            };
            Thread udpListenerThread = new Thread(udpListener, "udpListenerThread");
            udpListenerThread.start();
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "sending udp message to: " + this.probeAddrs);
                }
                UDPProbe.sendUdpMessage(this.probeAddrs, this.port, udpSocket, "[PROBE]");
                udpListenerThread.join();
            }
            finally {
                Throwable t;
                if (t instanceof InterruptedException || t instanceof InterruptedIOException || Thread.currentThread().isInterrupted()) {
                    if (udpListenerThread != null) {
                        udpListenerThread.interrupt();
                    }
                    break block10;
                }
                if (t instanceof UnknownHostException) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Unknown Host: " + this.probeAddrs, t);
                    }
                    this.client.reportError(16);
                    break block10;
                }
                throw new RuntimeException(t);
            }
        }
    }

    private static void sendUdpMessage(Set<String> probeAddrs, int port, DatagramSocket udpSocket, String msg) throws SocketException, UnknownHostException, IOException {
        byte[] buf = (msg + " " + UUID.randomUUID().toString()).getBytes();
        for (String probeAddr : probeAddrs) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "sending message to: " + probeAddr);
            }
            try {
                InetAddress addr = InetAddress.getByName(probeAddr);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "addr: " + addr);
                    log.log(Level.FINEST, "buf: " + new String(buf));
                }
                DatagramPacket packet = new DatagramPacket(buf, buf.length, addr, port);
                udpSocket.send(packet);
            }
            catch (BindException be) {
                System.out.println(be.getMessage());
            }
        }
    }

    static {
        DEFAULT_PROBE_ADDRS.add("172.20.28.69");
        DEFAULT_PROBE_ADDRS.add("172.20.28.67");
        DEFAULT_PROBE_ADDRS.add("172.20.28.46");
        DEFAULT_PROBE_ADDRS.add("172.20.28.39");
        DEFAULT_PROBE_ADDRS.add("172.20.28.148");
        LOCAL_HOST_ADDR.add(LOCAL_HOST);
    }
}

