/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.util;

import java.io.File;
import java.util.HashMap;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public class ExampleFileFilter
extends FileFilter {
    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";
    private HashMap<String, FileFilter> filters = new HashMap();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public ExampleFileFilter() {
    }

    public ExampleFileFilter(String extension) {
        this(extension, null);
    }

    public ExampleFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public ExampleFileFilter(String[] filters) {
        this(filters, null);
    }

    public ExampleFileFilter(String[] filters, String description) {
        this();
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.filters.get(this.getExtension(f)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new HashMap();
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Set<String> keys = this.filters.keySet();
                if (keys != null) {
                    int cnt = 0;
                    for (String s : keys) {
                        if (cnt++ == 0) {
                            this.fullDescription = this.fullDescription + "." + s;
                            continue;
                        }
                        this.fullDescription = this.fullDescription + ", ." + s;
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

