/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.util;

import com.sun.scn.client.util.Subnet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;

class IPAddr {
    int octal1;
    int octal2;
    int octal3;
    int octal4;

    public IPAddr(String addr) {
        Matcher matcher = Subnet.dotPattern.matcher(addr);
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            if (!matcher.find(index)) continue;
            String s = addr.substring(matcher.start(), matcher.end());
            int val = Integer.parseInt(s);
            switch (i) {
                case 0: {
                    this.octal1 = val;
                    break;
                }
                case 1: {
                    this.octal2 = val;
                    break;
                }
                case 2: {
                    this.octal3 = val;
                    break;
                }
                case 3: {
                    this.octal4 = val;
                }
            }
            index = matcher.end();
        }
    }

    public IPAddr(int octal1, int octal2, int octal3, int octal4) {
        this.octal1 = octal1;
        this.octal2 = octal2;
        this.octal3 = octal3;
        this.octal4 = octal4;
    }

    public InetAddress toInetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.octal1 + "." + this.octal2 + "." + this.octal3 + "." + this.octal4);
    }

    public IPAddr next() {
        int o1 = this.octal1;
        int o2 = this.octal2;
        int o3 = this.octal3;
        int o4 = this.octal4;
        if (++o4 > 255) {
            o4 = 0;
            if (++o3 > 255) {
                o3 = 0;
                if (++o2 > 255) {
                    o2 = 0;
                    if (++o1 > 255) {
                        return null;
                    }
                }
            }
        }
        return new IPAddr(o1, o2, o3, o4);
    }

    public String toString() {
        return "" + this.octal1 + "." + this.octal2 + "." + this.octal3 + "." + this.octal4;
    }

    public int compareTo(IPAddr ia) {
        if (this.octal1 > ia.octal1) {
            return 1;
        }
        if (this.octal1 < ia.octal1) {
            return -1;
        }
        if (this.octal2 > ia.octal2) {
            return 2;
        }
        if (this.octal2 < ia.octal2) {
            return -2;
        }
        if (this.octal3 > ia.octal3) {
            return 3;
        }
        if (this.octal3 < ia.octal3) {
            return -3;
        }
        if (this.octal4 > ia.octal4) {
            return 4;
        }
        if (this.octal4 < ia.octal4) {
            return -4;
        }
        return 0;
    }

    public boolean equals(IPAddr ipaddr) {
        if (ipaddr == null) {
            return false;
        }
        return this.octal1 == ipaddr.octal1 && this.octal2 == ipaddr.octal2 && this.octal3 == ipaddr.octal3 && this.octal4 == ipaddr.octal4;
    }
}

