/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.util;

import com.sun.scn.client.util.KeyGenerator;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;

public class SCRKClientHelper {
    private static Logger log = Logger.getLogger(SCRKClientHelper.class.getName());
    public static final String URL_PROPERTY_KEY = SCRKClientHelper.class.getName() + ".crsUrl";
    private static final String SCRK_SIG_ALG = "SHA1withRSA";
    private static final String DEFAULT_URL = "https://cns-services.sun.com/";
    private static final String DEFAULT_URI = "SCRK/ClientRegistrationV1_1_0";
    private final String NAME_CLIENT_REG_ID = "SC_CLIENT_REG_ID";
    private final String NAME_ASSET_ID = "ASSET_ID";
    private final String NAME_PUB_KEY = "PUBLIC_KEY";
    private final String NAME_SOA_ID = "SOA_ID";
    private final String NAME_SOA_PW = "SOA_PW";

    public String getClientRegId(KeyPair keyPair, String soaUsername, String soaPassword, String proxyHost, int proxyPort) throws Exception {
        return this.registerClient(keyPair, soaUsername, soaPassword, proxyHost, proxyPort);
    }

    public String getClientRegId(KeyPair keyPair, String soaUsername, String soaPassword) throws Exception {
        return this.registerClient(keyPair, soaUsername, soaPassword, null, -1);
    }

    public KeyPair getKeyPair() {
        try {
            return KeyGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Error Generating KeyPair for communication with SCRK: ", nsae);
        }
    }

    public static byte[] signPayload(String payload, PrivateKey privateKey) {
        try {
            Signature sig = Signature.getInstance(SCRK_SIG_ALG);
            sig.initSign(privateKey);
            byte[] bytes = payload.getBytes();
            sig.update(bytes, 0, bytes.length);
            return Base64.encodeBase64((byte[])sig.sign());
        }
        catch (NoSuchAlgorithmException nsax) {
            throw new RuntimeException("Failed to construct Signature", nsax);
        }
        catch (InvalidKeyException ikx) {
            throw new RuntimeException("Failed to init Signature with PrivateKey", ikx);
        }
        catch (SignatureException sx) {
            throw new RuntimeException("Failed to generate Signature", sx);
        }
    }

    private static String getBaseUrl() {
        String baseUrl;
        try {
            ResourceBundle resources = ResourceBundle.getBundle("com.sun.scn.client.resources.Connection");
            String target = resources.getString("target");
            baseUrl = resources.getString(target + ".scrk.url");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseUrl = DEFAULT_URL;
        }
        String tmp = System.getProperty(URL_PROPERTY_KEY);
        if (tmp != null) {
            baseUrl = tmp;
        }
        if (!baseUrl.endsWith(DEFAULT_URI)) {
            baseUrl = baseUrl.endsWith("/") ? baseUrl + DEFAULT_URI : baseUrl + "/SCRK/ClientRegistrationV1_1_0";
        }
        return baseUrl;
    }

    private String registerClient(KeyPair keyPair, String soaUser, String soaPass, String proxyHost, int proxyPort) throws Exception {
        log.log(Level.FINER, "Registering client with scrk");
        HttpClient crsClient = new HttpClient();
        if (proxyHost != null && !proxyHost.equals("") && proxyPort != -1) {
            log.log(Level.FINER, "Setting proxy to " + proxyHost + ":" + proxyPort);
            crsClient.getHostConfiguration().setProxy(proxyHost, proxyPort);
        }
        String crsUrl = SCRKClientHelper.getBaseUrl();
        log.log(Level.FINER, "Sending to: " + crsUrl);
        PostMethod crsPost = new PostMethod(crsUrl);
        String uuid = UUID.randomUUID().toString();
        Part[] parts = new Part[]{new StringPart("SOA_ID", soaUser), new StringPart("SOA_PW", soaPass), new StringPart("ASSET_ID", uuid), new StringPart("DESCRIPTION", "SvcTag Registration"), new StringPart("PUBLIC_KEY", this.getPublicKeyAsX509String(keyPair.getPublic()))};
        crsPost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, crsPost.getParams()));
        String body = null;
        int statusCode = crsClient.executeMethod((HttpMethod)crsPost);
        log.log(Level.FINER, "crs response code: " + statusCode);
        if (statusCode != 200) {
            throw new Exception("HTTP Post failure: " + statusCode);
        }
        body = crsPost.getResponseBodyAsString();
        crsPost.releaseConnection();
        String clientRegId = null;
        String[] crsResponseBody = body.split("\n");
        log.log(Level.FINEST, "CRS Body: " + body);
        for (int i = 0; i < crsResponseBody.length; ++i) {
            if (!crsResponseBody[i].startsWith("SC_CLIENT_REG_ID=")) continue;
            String[] clientReg = crsResponseBody[i].split("=", 2);
            clientRegId = clientReg[1];
            break;
        }
        log.log(Level.FINE, "client reg id: " + clientRegId);
        if (clientRegId == null) {
            throw new Exception("Unable to register with SCRK, check username & password");
        }
        return clientRegId;
    }

    private String getPublicKeyAsX509String(PublicKey publicKey) {
        String PEM_PUBKEY_HEADER = "-----BEGIN PUBLIC KEY-----\n";
        String PEM_PUBKEY_FOOTER = "\n-----END PUBLIC KEY-----\n";
        StringBuilder sb = new StringBuilder("-----BEGIN PUBLIC KEY-----\n");
        sb.append(new String(Base64.encodeBase64((byte[])publicKey.getEncoded())));
        sb.append("\n-----END PUBLIC KEY-----\n");
        return sb.toString();
    }
}

