/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.util;

import com.sun.scn.client.util.IPAddr;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subnet {
    private static Subnet INSTANCE = new Subnet();
    public static Pattern dotPattern = Pattern.compile("[0-9]{1,3}+");
    private static Pattern rangePattern = Pattern.compile("[0-9]{1,3}+\\.[0-9]{1,3}+\\.[0-9]{1,3}+\\.[0-9]{1,3}+-[0-9]{1,3}+\\.[0-9]{1,3}+\\.[0-9]{1,3}+\\.[0-9]{1,3}+");

    public static Subnet getInstance() {
        return INSTANCE;
    }

    public List<InetAddress> getInetAddressesByRange(String range) throws Exception {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        if (range == null || range.trim().equals("")) {
            return list;
        }
        Matcher matcher = rangePattern.matcher(range);
        if (!matcher.matches()) {
            throw new Exception("Range not formatted properly: " + range);
        }
        int index = range.indexOf("-");
        if (index == -1) {
            throw new Exception("Invalid range format");
        }
        String lower = range.substring(0, index);
        String upper = range.substring(index + 1);
        matcher = dotPattern.matcher(range);
        index = 0;
        while (matcher.find(index)) {
            String s = range.substring(matcher.start(), matcher.end());
            int val = Integer.parseInt(s);
            if (val > 255) {
                throw new Exception("Value is outside of 0-255 range: " + range);
            }
            index = matcher.end();
        }
        IPAddr la = new IPAddr(lower);
        IPAddr ua = new IPAddr(upper);
        if (la.compareTo(ua) > 0) {
            IPAddr tmpAddr = ua;
            ua = la;
            la = tmpAddr;
        }
        list.add(la.toInetAddress());
        boolean cnt = false;
        while (la != null && !la.equals(ua)) {
            IPAddr na = la.next();
            list.add(na.toInetAddress());
            la = na;
        }
        return list;
    }

    public static void main(String[] args) {
        Subnet s = Subnet.getInstance();
        String[] ranges = new String[]{"123.123.124.102-123.123.124.97", "123.123.124.97-123.123.124.100", "123.123.124.230-123.123.125.1", "123.123.124.97-123.123.124.99"};
        for (int i = 0; i < ranges.length; ++i) {
            try {
                List<InetAddress> list = s.getInetAddressesByRange(ranges[i]);
                System.out.println("List ------------------");
                for (InetAddress ia : list) {
                    System.out.println(ia);
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

