/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.cacao;

import com.sun.cns.basicreg.cacao.CacaoAdapterException;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.scn.client.MSCConnection;
import com.sun.scn.jmx.SCNBaseServiceFactoryMBean;
import com.sun.scn.util.Utils;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class CacaoAdapter {
    private static MBeanServerConnection mBeanServerConnection = null;
    private static SCNBaseServiceFactoryMBean scnBaseServiceFactoryMBean = null;
    private static final String OBJECT_NAME_KEY = "name";
    private static final String OBJECT_HOST_KEY = "host";
    private static final String OBJECT_VENDOR_KEY = "Vendor";
    private static final String OBJECT_SCN_TYPE_KEY = "scnType";
    private static final String OBJECT_ASSET_PROFILE_KEY = "assetProfile";
    private static final String OBJECT_ASSET_SUB_PROFILE_KEY = "assetSubProfile";
    private static final String OBJECT_SUN_VALUE = "Sun Microsystems Inc";
    private static final String OBJECT_SERVICE_FACTORY_VALUE = "ServiceFactory";
    private static final String OBJECT_FACTORY_VALUE = "Factory";
    private static final Logger LOG = Logger.getLogger(CacaoAdapter.class.getName());

    protected static MBeanServerConnection getMBeanServerConnection() throws CacaoAdapterException {
        if (mBeanServerConnection == null) {
            try {
                mBeanServerConnection = MSCConnection.mscConnectWithKeystorePassword((String)CommonUtil.getMscPassword());
            }
            catch (IOException ioEx) {
                LOG.severe("Error: unable to obtain MBeanServerConnection");
                LOG.severe(ioEx.getMessage());
                LOG.severe(CommonUtil.getStackTrace(ioEx));
                throw new CacaoAdapterException("Error: unable to obtain MBeanServerConnection", ioEx);
            }
        }
        return mBeanServerConnection;
    }

    protected static SCNBaseServiceFactoryMBean getSCNBaseServiceFactoryMBean() throws CacaoAdapterException {
        if (scnBaseServiceFactoryMBean == null) {
            Hashtable<String, String> map = new Hashtable<String, String>();
            map.put(OBJECT_NAME_KEY, "SCNBaseServiceFactory");
            map.put(OBJECT_HOST_KEY, Utils.getLocalHostNames()[0]);
            map.put(OBJECT_VENDOR_KEY, OBJECT_SUN_VALUE);
            map.put(OBJECT_SCN_TYPE_KEY, OBJECT_SERVICE_FACTORY_VALUE);
            map.put(OBJECT_ASSET_PROFILE_KEY, OBJECT_FACTORY_VALUE);
            map.put(OBJECT_ASSET_SUB_PROFILE_KEY, OBJECT_FACTORY_VALUE);
            ObjectName objectName = null;
            try {
                objectName = new ObjectName("com.sun.scn", map);
            }
            catch (MalformedObjectNameException monEx) {
                LOG.severe("Error: unable to obtain SCNBaseServiceFactoryMBean");
                LOG.severe(CommonUtil.getStackTrace(monEx));
                LOG.severe(monEx.getMessage());
                throw new CacaoAdapterException("Error: unable to obtain SCNBaseServiceFactoryMBean", monEx);
            }
            scnBaseServiceFactoryMBean = MBeanServerInvocationHandler.newProxyInstance(CacaoAdapter.getMBeanServerConnection(), objectName, SCNBaseServiceFactoryMBean.class, false);
        }
        return scnBaseServiceFactoryMBean;
    }
}

