/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.cacao;

import com.sun.cns.basicreg.cacao.CacaoAdapter;
import com.sun.cns.basicreg.cacao.CacaoAdapterException;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.scn.client.SCNClientSession;
import com.sun.scn.common.CreateSCAccountCallback;
import com.sun.scn.common.CreateSCAccountCallbackHandler;
import com.sun.scn.common.SCAccountCallback;
import com.sun.scn.common.SCAccountCallbackHandler;
import com.sun.scn.common.SCAccountInformation;
import com.sun.scn.jmx.SCNClientLoginMBean;
import java.util.logging.Logger;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public abstract class ClientLoginCacaoAdapter
extends CacaoAdapter {
    private static String BR_APP_ID = "c9631ed7-0a87-11da-99bc-080020a9ed93";
    public static final int NO_LOGIN_RESULT = -1;
    public static final int OK_LOGIN_RESULT = 0;
    public static final int VALIDATION_FAULT_LOGIN_RESULT = 1;
    public static final int DUPLICATE_FAULT_LOGIN_RESULT = 2;
    public static final int REMOTE_FAULT_LOGIN_RESULT = 3;
    private static SCNClientLoginMBean scnClientLoginMBean = null;
    private static SCNClientSession session = null;
    private static String username;
    private static String password;
    private static String groupId;
    private static String firstName;
    private static String middleName;
    private static String lastName;
    private static String securityQuestion;
    private static String securityAnswer;
    private static String company;
    private static String address1;
    private static String address2;
    private static String address3;
    private static String city;
    private static String state;
    private static String zip;
    private static String phone;
    private static String email;
    private static String job;
    private static String countryCode;
    private static String languageCode;
    private static final Logger LOG;

    private static SCNClientSession getSCNClientSession(boolean doCreate) throws CacaoAdapterException {
        if (doCreate && session == null) {
            LOG.info("CREATING SCNClientSession");
            session = new SCNClientSession(ClientLoginCacaoAdapter.getMBeanServerConnection());
        }
        return session;
    }

    private static void preLogin() throws CacaoAdapterException {
        if (ClientLoginCacaoAdapter.getSCNClientSession(false) != null && ClientLoginCacaoAdapter.getSCNClientLoginMBean().getAuthToken() != null) {
            LOG.info("Hmm - trying to relogin; will terminate previous login");
            ClientLoginCacaoAdapter.logout();
        }
    }

    public static boolean logout() throws CacaoAdapterException {
        boolean logoutResult = false;
        if (ClientLoginCacaoAdapter.getSCNClientSession(false) == null || ClientLoginCacaoAdapter.getSCNClientLoginMBean().getAuthToken() == null) {
            LOG.info("No SCN session from which to logout");
            return false;
        }
        try {
            logoutResult = ClientLoginCacaoAdapter.getSCNClientSession(false).logout();
        }
        catch (LoginException lEx) {
            LOG.severe("Error: logout exception: " + lEx.getMessage());
            LOG.severe(CommonUtil.getStackTrace(lEx));
            throw new CacaoAdapterException("Error: exception during logout attempt", lEx);
        }
        if (logoutResult) {
            LOG.info("LOGOUT of the SCN SESSION: succeeded");
            session = null;
        } else {
            LOG.severe("Error: SCN logout failure");
        }
        return logoutResult;
    }

    private static SCNClientLoginMBean getSCNClientLoginMBean() throws CacaoAdapterException {
        if (scnClientLoginMBean == null) {
            ObjectName objectName = ClientLoginCacaoAdapter.getSCNBaseServiceFactoryMBean().getInstanceName("SCNClientLogin");
            scnClientLoginMBean = MBeanServerInvocationHandler.newProxyInstance(ClientLoginCacaoAdapter.getMBeanServerConnection(), objectName, SCNClientLoginMBean.class, false);
        }
        return scnClientLoginMBean;
    }

    public static int loginAccount(String username, String password) throws CacaoAdapterException {
        ClientLoginCacaoAdapter.username = username;
        ClientLoginCacaoAdapter.password = password;
        ClientLoginCacaoAdapter.preLogin();
        boolean loginResult = false;
        try {
            loginResult = ClientLoginCacaoAdapter.getSCNClientSession(true).login((CallbackHandler)((Object)new LoginAccountCallbackHandler()));
        }
        catch (LoginException lEx) {
            LOG.severe("Error: login account exception: " + lEx.getMessage());
            LOG.severe(CommonUtil.getStackTrace(lEx));
            session = null;
            return ClientLoginCacaoAdapter.getLoginResult(lEx.getMessage());
        }
        LOG.info("SCNClientSession.login(LoginAccountCallbackHandler) = " + loginResult);
        if (loginResult) {
            LOG.info("\nSCNClientLoginMBean.getAuthToken() =\n\t" + ClientLoginCacaoAdapter.getAuthenticationToken());
            return 0;
        }
        session = null;
        return -1;
    }

    public static int createAccount(String username, String password, String firstName, String middleName, String lastName, String securityQuestion, String securityAnswer, String company, String address1, String address2, String address3, String city, String state, String zip, String countryCode, String phone, String email, String languageCode, String job) throws CacaoAdapterException {
        ClientLoginCacaoAdapter.username = username;
        ClientLoginCacaoAdapter.password = password;
        ClientLoginCacaoAdapter.firstName = firstName;
        ClientLoginCacaoAdapter.middleName = middleName;
        ClientLoginCacaoAdapter.lastName = lastName;
        ClientLoginCacaoAdapter.securityQuestion = securityQuestion;
        ClientLoginCacaoAdapter.securityAnswer = securityAnswer;
        ClientLoginCacaoAdapter.company = company;
        ClientLoginCacaoAdapter.address1 = address1;
        ClientLoginCacaoAdapter.address2 = address2;
        ClientLoginCacaoAdapter.address3 = address3;
        ClientLoginCacaoAdapter.city = city;
        ClientLoginCacaoAdapter.state = state;
        ClientLoginCacaoAdapter.zip = zip;
        ClientLoginCacaoAdapter.countryCode = countryCode;
        ClientLoginCacaoAdapter.phone = phone;
        ClientLoginCacaoAdapter.email = email;
        ClientLoginCacaoAdapter.languageCode = languageCode;
        ClientLoginCacaoAdapter.job = job;
        ClientLoginCacaoAdapter.getSCNClientLoginMBean().setUserName(ClientLoginCacaoAdapter.username);
        ClientLoginCacaoAdapter.getSCNClientLoginMBean().setPassWord(ClientLoginCacaoAdapter.password);
        ClientLoginCacaoAdapter.preLogin();
        boolean loginResult = false;
        try {
            loginResult = ClientLoginCacaoAdapter.getSCNClientSession(true).login((CallbackHandler)((Object)new CreateAccountCallbackHandler()));
        }
        catch (LoginException lEx) {
            LOG.severe("Error: create account exception: " + lEx.getMessage());
            LOG.severe(CommonUtil.getStackTrace(lEx));
            session = null;
            return ClientLoginCacaoAdapter.getLoginResult(lEx.getMessage());
        }
        LOG.info("SCNClientSession.login(CreateAccountCallbackHandler) = " + loginResult);
        if (loginResult) {
            LOG.info("\nSCNClientLoginMBean.getAuthToken() =\n\t" + ClientLoginCacaoAdapter.getAuthenticationToken());
            return 0;
        }
        session = null;
        return -1;
    }

    public static String getAuthenticationToken() throws CacaoAdapterException {
        if (ClientLoginCacaoAdapter.getSCNClientSession(false) == null) {
            LOG.info("No auth token - no SCN session currently exists");
            return null;
        }
        return ClientLoginCacaoAdapter.getSCNClientLoginMBean().getAuthToken();
    }

    public static String getRegistrationToken() throws CacaoAdapterException {
        if (ClientLoginCacaoAdapter.getSCNClientSession(false) == null) {
            LOG.info("No registration token - no SCN session currently exists");
            return null;
        }
        return ClientLoginCacaoAdapter.getSCNClientLoginMBean().getRegistrationToken();
    }

    public static boolean setRegistrationToken(String tok) throws CacaoAdapterException {
        if (ClientLoginCacaoAdapter.getSCNClientSession(true) == null) {
            LOG.info("cannot create an SCN session for auto-reg");
            return false;
        }
        ClientLoginCacaoAdapter.getSCNClientLoginMBean().setRegistrationToken(tok);
        ClientLoginCacaoAdapter.clearSession();
        return true;
    }

    public static void clearSession() {
        LOG.info("Clear (null) the session");
        session = null;
    }

    public static boolean updateContact(boolean contactOk) throws CacaoAdapterException {
        boolean updateContactResult;
        if (ClientLoginCacaoAdapter.getSCNClientSession(false) == null || username == null) {
            LOG.severe("Error in updateContact(): no session or login account");
            return false;
        }
        try {
            SCAccountInformation scAccountInfo = ClientLoginCacaoAdapter.getSCNClientSession(false).getAccountInformation(username);
            scAccountInfo.setMaySunContact(contactOk);
            updateContactResult = ClientLoginCacaoAdapter.getSCNClientSession(false).setAccountInformation(scAccountInfo);
        }
        catch (LoginException lEx) {
            LOG.severe("Error: updateContact: " + lEx.getMessage());
            LOG.severe(CommonUtil.getStackTrace(lEx));
            return false;
        }
        return updateContactResult;
    }

    public static boolean updateLicense(boolean licenseOk) throws CacaoAdapterException {
        boolean updateLicenseResult;
        if (ClientLoginCacaoAdapter.getSCNClientSession(false) == null || username == null) {
            LOG.severe("Error in updateLicense(): no session or login account");
            return false;
        }
        try {
            SCAccountInformation scAccountInfo = ClientLoginCacaoAdapter.getSCNClientSession(false).getAccountInformation(username);
            scAccountInfo.setApplication(BR_APP_ID);
            scAccountInfo.setLicenseAccepted(licenseOk);
            updateLicenseResult = ClientLoginCacaoAdapter.getSCNClientSession(false).setAccountInformation(scAccountInfo);
        }
        catch (LoginException lEx) {
            LOG.severe("Error: updateLicense: " + lEx.getMessage());
            LOG.severe(CommonUtil.getStackTrace(lEx));
            return false;
        }
        return updateLicenseResult;
    }

    private static int getLoginResult(String scnFault) {
        LOG.info("SCN Fault: " + scnFault);
        if (scnFault == null) {
            return -1;
        }
        if (scnFault.indexOf("DuplicateFault") >= 0) {
            return 2;
        }
        if (scnFault.indexOf("RemoteException") >= 0) {
            return 3;
        }
        return -1;
    }

    static {
        LOG = Logger.getLogger(ClientLoginCacaoAdapter.class.getName());
    }

    protected static class CreateAccountCallbackHandler
    implements CreateSCAccountCallbackHandler {
        protected CreateAccountCallbackHandler() {
        }

        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof CreateSCAccountCallback)) {
                    throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
                }
                CreateSCAccountCallback callback = (CreateSCAccountCallback)callbacks[i];
                LOG.info("create callback setting username: " + username);
                LOG.info("create callback setting company: " + company);
                callback.setApplication(BR_APP_ID);
                callback.setAccount(username);
                callback.setPassword(password);
                callback.setFirstName(firstName);
                callback.setMiddleName(middleName);
                callback.setLastName(lastName);
                callback.setSecurityQuestion(securityQuestion);
                callback.setSecurityAnswer(securityAnswer);
                callback.setCompany(company);
                callback.setAddress1(address1);
                callback.setAddress2(address2);
                callback.setAddress3(address3);
                callback.setCity(city);
                callback.setState(state);
                callback.setPostalCode(zip);
                callback.setCountry(countryCode);
                callback.setJobTitle(job);
                callback.setTelephone(phone);
                callback.setEmail(email);
                callback.setMaySunContact(false);
                callback.setTOUAccepted(false);
                callback.setLicenseAccepted(false);
            }
        }
    }

    protected static class LoginAccountCallbackHandler
    implements SCAccountCallbackHandler {
        protected LoginAccountCallbackHandler() {
        }

        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                SCAccountCallback callback;
                if (callbacks[i] instanceof SCAccountCallback) {
                    callback = (SCAccountCallback)callbacks[i];
                    LOG.info("account callback setting username: " + username);
                    try {
                        ClientLoginCacaoAdapter.getSCNClientLoginMBean().setUserName(username);
                        ClientLoginCacaoAdapter.getSCNClientLoginMBean().setPassWord(password);
                    }
                    catch (CacaoAdapterException cae) {
                        LOG.info("Unexpected error detected in Cacao Adapter  while trying to save the last registered user. " + cae.getMessage());
                    }
                } else {
                    throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
                }
                callback.setAccount(username);
                callback.setPassword(password);
            }
        }
    }
}

