/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.cacao;

import com.sun.cns.basicreg.cacao.CacaoAdapter;
import com.sun.cns.basicreg.cacao.CacaoAdapterException;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.scn.offering.prom.AssetRegistrationException;
import com.sun.scn.offering.prom.ProductRegOfferingFactoryMBean;
import com.sun.scn.offering.prom.ProductRegOfferingInstanceMBean;
import com.sun.scn.util.Utils;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jdom.Document;

public abstract class PROMCacaoAdapter
extends CacaoAdapter {
    public static final int FULL_SYSTEM_INFORMATION = 1;
    public static final int LIMITED_SYSTEM_INFORMATION = 2;
    public static final int SOLARIS_SYSTEM_INFORMATION = 3;
    public static final int NO_REGISTER_RESULT = -1;
    public static final int OK_REGISTER_RESULT = 0;
    public static final int ENTITLEMENT_INVALID_REGISTER_RESULT = 1;
    public static final int ENTITLEMENT_IN_USE_REGISTER_RESULT = 2;
    public static final int REMOTE_FAULT_REGISTER_RESULT = 3;
    private static final Logger LOG = Logger.getLogger(PROMCacaoAdapter.class.getName());
    private static ProductRegOfferingFactoryMBean productRegOfferingFactoryMBean = null;
    private static ProductRegOfferingInstanceMBean productRegOfferingInstanceMBean = null;
    private static String subscriptionKey = "";
    private static String systemDisplayName = "";
    private static boolean isSWUPPortalEnabled = false;
    private static String assetId = "";

    protected static ProductRegOfferingFactoryMBean getProductRegOfferingFactoryMBean() throws CacaoAdapterException {
        if (productRegOfferingFactoryMBean == null) {
            Hashtable<String, String> map = new Hashtable<String, String>();
            map.put("name", "ProductRegOfferingFactory");
            map.put("host", Utils.getLocalHostNames()[0]);
            map.put("Vendor", "Sun Microsystems Inc");
            map.put("scnType", "OfferingFactory");
            map.put("assetProfile", "OperatingSystem");
            map.put("assetSubProfile", "TODO");
            ObjectName objectName = null;
            try {
                objectName = new ObjectName("com.sun.scn", map);
            }
            catch (MalformedObjectNameException monEx) {
                LOG.severe("Error: unable to obtain ProductRegOfferingFactoryMBean");
                LOG.severe(CommonUtil.getStackTrace(monEx));
                LOG.severe(monEx.getMessage());
                throw new CacaoAdapterException("Error: unable to obtain ProductRegOfferingFactoryMBean", monEx);
            }
            LOG.info("\nProductRegOfferingFactory ObjectName =\n\t" + objectName.getCanonicalName());
            productRegOfferingFactoryMBean = MBeanServerInvocationHandler.newProxyInstance(PROMCacaoAdapter.getMBeanServerConnection(), objectName, ProductRegOfferingFactoryMBean.class, false);
        }
        return productRegOfferingFactoryMBean;
    }

    private static ProductRegOfferingInstanceMBean getProductRegOfferingInstanceMBean() throws CacaoAdapterException {
        if (productRegOfferingInstanceMBean == null) {
            ObjectName workaroundObjectName = PROMCacaoAdapter.getProductRegOfferingFactoryMBean().getOfferingInstanceName("ProductRegOfferingInstance");
            productRegOfferingInstanceMBean = MBeanServerInvocationHandler.newProxyInstance(PROMCacaoAdapter.getMBeanServerConnection(), workaroundObjectName, ProductRegOfferingInstanceMBean.class, false);
        }
        return productRegOfferingInstanceMBean;
    }

    public static Document getSystemInformation(int whichInfo) throws CacaoAdapterException {
        String info;
        Document document = null;
        switch (whichInfo) {
            case 1: {
                info = "full";
                break;
            }
            case 2: {
                info = "limited";
                break;
            }
            case 3: {
                info = "solaris";
                break;
            }
            default: {
                LOG.severe("Error: unknown information type: " + whichInfo);
                info = "full";
            }
        }
        LOG.info("CALL ProductRegOfferingInstanceMBean.getSystemInformation(): " + info);
        document = PROMCacaoAdapter.getProductRegOfferingInstanceMBean().getSystemInformation(info);
        return document;
    }

    public static int registerSystem() throws CacaoAdapterException {
        LOG.info("CALL ProductRegOfferingInstanceMBean.register()");
        try {
            PROMCacaoAdapter.getProductRegOfferingInstanceMBean().register();
        }
        catch (AssetRegistrationException ex) {
            LOG.severe("Error: PROM register() exception: " + ex.getMessage());
            LOG.severe(CommonUtil.getStackTrace(ex));
            return PROMCacaoAdapter.getRegisterResult(ex.getMessage());
        }
        return 0;
    }

    public static String getHostName() throws CacaoAdapterException {
        String hostName = "";
        LOG.info("CALL ProductRegOfferingInstanceMBean.getHostName()");
        hostName = PROMCacaoAdapter.getProductRegOfferingInstanceMBean().getHostname();
        return hostName;
    }

    public static String getAssetId() throws CacaoAdapterException {
        String assetId = "";
        assetId = PROMCacaoAdapter.getProductRegOfferingInstanceMBean().getAssetId();
        return assetId;
    }

    private static int getRegisterResult(String promFault) {
        LOG.info("PROM Fault: " + promFault);
        if (promFault == null) {
            return -1;
        }
        if (promFault.indexOf("InvalidEntitlementCodeException") >= 0) {
            return 1;
        }
        if (promFault.indexOf("EntitlementCodeAlreadyInUseException") >= 0) {
            return 2;
        }
        if (promFault.indexOf("RemoteException") > 0) {
            return 3;
        }
        return -1;
    }
}

